/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.ICancel;
import org.gerhardb.lib.util.startup.AppStarter;

public class ModalProgress
extends Dialog {
    private JLabel myCurrentLbl = new JLabel("  ");
    private ICancel myCancel;
    private JProgressBar myProgressBar;

    public ModalProgress(Frame parent, String title, BoundedRangeModel range) {
        super(parent);
        super.setTitle(title);
        super.setResizable(false);
        super.setModal(false);
        this.myProgressBar = new JProgressBar(range);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ModalProgress.this.cancel();
            }
        });
        try {
            this.initLayout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.pack();
        SwingUtils.centerOnScreen(this);
        super.setVisible(true);
    }

    public void start(Runnable run) {
        if (run == null) {
            this.dispose();
            throw new IllegalArgumentException("Task required");
        }
        Thread thread = new Thread(run);
        thread.start();
        super.setModal(true);
    }

    public synchronized void setCancel(ICancel cancel) {
        this.myCancel = cancel;
    }

    public void setMessage(String msg) {
        this.myCurrentLbl.setText(msg);
    }

    private synchronized void cancel() {
        if (this.myCancel != null) {
            this.myCancel.cancel();
        } else {
            System.exit(0);
        }
    }

    private void initLayout() throws Exception {
        Dimension size = new Dimension(630, 15);
        this.myCurrentLbl.setMinimumSize(size);
        this.myCurrentLbl.setPreferredSize(size);
        JButton cancelBtn = new JButton(AppStarter.getString("cancel"));
        cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ModalProgress.this.cancel();
            }
        });
        JPanelRows basePanel = new JPanelRows(0);
        JPanel row = basePanel.topRow(1);
        row.add(this.myCurrentLbl);
        row = basePanel.nextRow(1);
        row.add(this.myProgressBar);
        row = basePanel.nextRow(1);
        row.add(cancelBtn);
        this.add((Component)basePanel, null);
    }

    public static void main(String[] args) {
        int rotationCount = 69;
        final DefaultBoundedRangeModel range = new DefaultBoundedRangeModel();
        range.setMaximum(68);
        range.setMinimum(0);
        range.setExtent(1);
        JFrame parent = new JFrame();
        parent.setTitle("Sample Title");
        parent.getContentPane().add(new JLabel("hi hi hi hi hi hi hi hi hi hi hi hi hi hi hi hi hi hi hi hi "));
        parent.pack();
        parent.setVisible(true);
        String test = "test";
        final ModalProgress mp = new ModalProgress((Frame)parent, "title", range);
        mp.setMessage(test);
        Runnable runThis = new Runnable(){

            public void run() {
                int count = 0;
                while (count < 69) {
                    try {
                        Thread.sleep(600L);
                        range.setValue(++count);
                        System.out.println(count);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                mp.dispose();
                System.exit(0);
            }
        };
        mp.start(runThis);
    }
}

