/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.Icons;
import org.gerhardb.lib.util.ModalProgressDialogFlex;
import org.gerhardb.lib.util.startup.ILoadingMessage;

public class ModalProgressDialogFlex
implements ILoadingMessage {
    private final String FINISHED_SYNC = "sync";
    static final long DEFAULT_THRESHOLD = 2000L;
    private long myThreshold = 2000L;
    private Window myTopWindow;
    public static final Icon WAIT_ICON = Icons.icon(23);
    BoundedRangeModel myRange;
    Thread myTaskThread;
    private JDialog myDialog;
    private JOptionPane myOptionPane;
    KeyboardFocusManager myKeyboardFocusManager;
    private int myIncrement = 1;
    private Date myShowTime;
    boolean iAmFinished = false;
    private final Component mouseBlocker = new JPanel(){
        {
            this.setOpaque(false);
            this.enableEvents(16L);
        }

        protected void processMouseEvent(MouseEvent event) {
            event.consume();
        }
    };
    private final ComponentListener mouseBlockerSynchronizer = new ComponentAdapter(){

        public void componentResized(ComponentEvent event) {
            ModalProgressDialogFlex.this.mouseBlocker.setSize(event.getComponent().getSize());
        }
    };
    private final VetoableChangeListener windowFocusPreventer = new VetoableChangeListener(){
        private final Runnable refocuser = new Runnable(){

            public void run() {
                ModalProgressDialogFlex.this.myDialog.requestFocus();
            }
        };

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void vetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
            String property = event.getPropertyName();
            if (!property.equals("focusedWindow") || event.getNewValue() != ModalProgressDialogFlex.this.myTopWindow) return;
            EventQueue.invokeLater(this.refocuser);
            String string = "sync";
            synchronized ("sync") {
                if (ModalProgressDialogFlex.this.iAmFinished) return;
                throw new PropertyVetoException("Window may not take focus while it has a modal dialog showing", event);
            }
        }
    };

    public static void popUp(Window topWindow, String titleBar, String explanation, String cancelBtnText, BoundedRangeModel range, Runnable runMe, long thresholdMilliSeconds) {
        if (topWindow == null) {
            System.out.println("ModalProgressDialog got null topWindow");
            return;
        }
        ModalProgressDialogFlex flex = new ModalProgressDialogFlex(topWindow, titleBar, explanation, cancelBtnText, range, thresholdMilliSeconds);
        flex.run(runMe);
    }

    public ModalProgressDialogFlex(Window topWindow, String title, String message, String cancelBtnText, BoundedRangeModel range, long thresholdMilliSeconds) {
        if (topWindow == null) {
            System.out.println("ModalProgressDialog got null topWindow");
            return;
        }
        this.myTopWindow = topWindow;
        this.myRange = range;
        this.myThreshold = thresholdMilliSeconds;
        JProgressBar progressBar = null;
        if (this.myRange == null) {
            this.myRange = new DefaultBoundedRangeModel();
            progressBar = new JProgressBar(this.myRange);
            progressBar.setIndeterminate(true);
        } else {
            progressBar = new JProgressBar(this.myRange);
        }
        AbstractAction cancelAction = new AbstractAction(UIManager.getString("OptionPane.cancelButtonText")){

            public void actionPerformed(ActionEvent event) {
                ModalProgressDialogFlex.this.interrupt();
            }
        };
        JPanel option = new JPanel(new BorderLayout());
        option.add((Component)progressBar, "North");
        if (cancelBtnText != null) {
            JButton cancelButton = new JButton(cancelAction);
            cancelButton.setText(cancelBtnText);
            cancelButton.setDefaultCapable(true);
            String actionID = "cancel";
            cancelButton.getActionMap().put(actionID, cancelAction);
            InputMap inputMap = cancelButton.getInputMap(2);
            inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), actionID);
            inputMap.put(KeyStroke.getKeyStroke("CANCEL"), actionID);
            inputMap.put(KeyStroke.getKeyStroke("STOP"), actionID);
            option.add((Component)cancelButton, "South");
            this.myOptionPane = new JOptionPane(" ", -1, -1, WAIT_ICON, new Object[]{option}, cancelButton);
        } else {
            this.myOptionPane = new JOptionPane(" ", -1, -1, WAIT_ICON, new Object[]{option});
        }
        this.myOptionPane.setMessage(message);
        this.myDialog = this.myOptionPane.createDialog(this.myTopWindow, title);
        this.myDialog.setModal(false);
        this.myDialog.setDefaultCloseOperation(2);
        this.myDialog.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent event) {
                long flags = event.getChangeFlags();
                Component component = event.getComponent();
                if ((flags & 4L) != 0L && !component.isShowing()) {
                    ModalProgressDialogFlex.this.interrupt();
                }
            }
        });
    }

    public void run(Runnable runMe) {
        this.myTaskThread = new Thread(runMe);
        Thread dialogThread = null;
        dialogThread = new Thread(){

            public void run() {
                try {
                    if (ModalProgressDialogFlex.this.myThreshold != 0L) {
                        Thread.sleep(ModalProgressDialogFlex.this.myThreshold);
                    }
                    if (ModalProgressDialogFlex.this.myTaskThread.isAlive()) {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                ModalProgressDialogFlex.this.activate();
                            }
                        });
                    }
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
            }
        };
        Thread waitThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    ModalProgressDialogFlex.this.myTaskThread.join();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                String e = "sync";
                synchronized ("sync") {
                    ModalProgressDialogFlex.this.iAmFinished = true;
                    // ** MonitorExit[e] (shouldn't be in output)
                    try {
                        ModalProgressDialogFlex.this.uninstall();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    ModalProgressDialogFlex.this.deactivate();
                    return;
                }
            }
        };
        this.install();
        this.myTaskThread.start();
        dialogThread.start();
        waitThread.start();
    }

    public void interrupt() {
        if (this.myTaskThread != null) {
            this.myTaskThread.interrupt();
        }
    }

    public void setText(String msg) {
        this.myOptionPane.setMessage(msg);
    }

    public void setMessage(String msg) {
        this.myOptionPane.setMessage(msg);
    }

    public int getNextIncrement() {
        return this.myIncrement++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void activate() {
        String string = this.FINISHED_SYNC;
        synchronized (string) {
            if (this.iAmFinished) {
                return;
            }
        }
        this.myDialog.setVisible(true);
        this.myShowTime = new Date();
    }

    private synchronized void deactivate() {
        if (this.myShowTime == null) {
            return;
        }
        long time = new Date().getTime() - this.myShowTime.getTime();
        if (time < 1000L) {
            try {
                Thread.sleep(1000L);
                if (this.myTaskThread != null && this.myTaskThread.isAlive()) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            ModalProgressDialogFlex.this.activate();
                        }
                    });
                }
            }
            catch (InterruptedException e) {
                this.interrupt();
            }
        }
        this.myDialog.setVisible(false);
        this.myDialog.dispose();
    }

    private void install() {
        this.myTopWindow.requestFocus();
        this.myKeyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.myTopWindow.setCursor(Cursor.getPredefinedCursor(3));
        this.myTopWindow.addComponentListener(this.mouseBlockerSynchronizer);
        if (this.myTopWindow instanceof RootPaneContainer) {
            JLayeredPane l = ((RootPaneContainer)((Object)this.myTopWindow)).getLayeredPane();
            this.mouseBlocker.setSize(l.getSize());
            l.add(this.mouseBlocker, new Integer(Integer.MAX_VALUE));
        } else {
            this.myTopWindow.setEnabled(false);
        }
    }

    private synchronized void uninstall() {
        this.myKeyboardFocusManager.removeVetoableChangeListener("focusedWindow", this.windowFocusPreventer);
        this.myTopWindow.removeComponentListener(this.mouseBlockerSynchronizer);
        if (this.myTopWindow instanceof RootPaneContainer) {
            JLayeredPane l = ((RootPaneContainer)((Object)this.myTopWindow)).getLayeredPane();
            l.remove(this.mouseBlocker);
        } else {
            this.myTopWindow.setEnabled(true);
        }
        this.myTopWindow.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static void main(String[] args) {
        final DefaultBoundedRangeModel range = new DefaultBoundedRangeModel();
        range.setMaximum(10);
        JButton hitMe = new JButton("Hit Me!");
        final JLabel wacked = new JLabel("Not Wacked Yet");
        JButton start = new JButton("Start");
        final JLabel countLbl = new JLabel("Inactive at moment");
        JPanelRows contents = new JPanelRows();
        JPanel row = contents.topRow();
        row.add(hitMe);
        row.add(wacked);
        row = contents.nextRow();
        row.add(start);
        row.add(countLbl);
        final JFrame testFrame = new JFrame("File Tree Test");
        testFrame.getContentPane().add(new JScrollPane(contents));
        testFrame.setSize(300, 300);
        testFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        SwingUtils.centerOnScreen(testFrame);
        hitMe.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (wacked.getBackground().equals(Color.GREEN)) {
                    wacked.setBackground(Color.RED);
                    wacked.setOpaque(true);
                    wacked.setForeground(Color.YELLOW);
                    wacked.setText("WACKED");
                } else {
                    wacked.setBackground(Color.GREEN);
                    wacked.setOpaque(true);
                    wacked.setForeground(Color.BLUE);
                    wacked.setText("unwacked at moment");
                }
            }
        });
        start.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                class TestMoveIt
                implements Runnable {
                    private final /* synthetic */ BoundedRangeModel val$range;
                    private final /* synthetic */ JLabel val$countLbl;

                    TestMoveIt(BoundedRangeModel boundedRangeModel, JLabel jLabel) {
                        this.val$range = boundedRangeModel;
                        this.val$countLbl = jLabel;
                    }

                    public void run() {
                        class ShowProgress {
                            private final /* synthetic */ JLabel val$countLbl;

                            ShowProgress(String msg, JLabel jLabel) {
                                this.val$countLbl = jLabel;
                                SwingUtilities.invokeLater(new Runnable(this, msg){
                                    private final /* synthetic */ String val$msg;
                                    private final /* synthetic */ ShowProgress this$0;
                                    {
                                        this.this$0 = showProgress;
                                        this.val$msg = string;
                                    }

                                    public void run() {
                                        ShowProgress.access$900(this.this$0).setText(this.val$msg);
                                    }
                                });
                            }

                            static /* synthetic */ JLabel access$900(ShowProgress x0) {
                                return x0.val$countLbl;
                            }
                        }
                        int length = this.val$range.getMaximum() + 1;
                        for (int i = 0; i < length; ++i) {
                            this.val$range.setValue(i);
                            new ShowProgress("Doing: " + i, this.val$countLbl);
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                break;
                            }
                            if (Thread.currentThread().isInterrupted()) break;
                        }
                        new ShowProgress("All Done!", this.val$countLbl);
                    }
                }
                TestMoveIt moveIt = new TestMoveIt(range, countLbl);
                Thread runMe = new Thread(moveIt);
                ModalProgressDialogFlex flex = new ModalProgressDialogFlex(testFrame, "Moving Files", "The files are being moved...", "Stop Move", range, 2000L);
                flex.run(runMe);
            }
        });
        testFrame.setVisible(true);
    }
}

