/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.jka;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifDirectory;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import fi.iki.jka.JPhotoCollection;
import fi.iki.jka.JPhotoExif;
import fi.iki.jka.JPhotoStatus;
import fi.iki.jka.Utils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class JPhoto
extends Observable
implements Transferable,
Serializable {
    public static final DataFlavor PHOTO_FLAVOR;
    protected DataFlavor[] myFlavors = new DataFlavor[]{PHOTO_FLAVOR};
    protected int width = 0;
    protected int height = 0;
    protected int fullWidth = -1;
    protected int fullHeight = -1;
    protected String name = "";
    protected String category = "";
    protected String text = "";
    protected String status = "";
    protected String albumlink = null;
    protected File original = null;
    protected JPhotoExif exif = null;
    protected boolean badFile = false;
    protected static Dimension limits;
    protected static Dimension thumbLimits;
    protected transient ExifDirectory directory = null;
    protected transient SoftReference thumbImage = null;
    protected static transient JPhoto fullImagePhoto;
    protected static transient SoftReference fullImage;
    protected transient JPhotoCollection owner = null;
    protected static transient JPhotoCollection defaultOwner;
    transient Font font = null;
    transient Font waterFont = null;
    static transient ThumbLoader loader;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("fi.iki.jka.JPhoto");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PHOTO_FLAVOR = new DataFlavor(clazz, "Single JPG Photograph");
        limits = new Dimension(640, 640);
        thumbLimits = new Dimension(160, 160);
        fullImagePhoto = null;
        fullImage = null;
        defaultOwner = null;
        loader = null;
    }

    public JPhoto() {
        this(defaultOwner, null);
    }

    public JPhoto(JPhotoCollection owner) {
        this(owner, null);
    }

    public JPhoto(File original) {
        this(defaultOwner, original);
    }

    public JPhoto(JPhotoCollection owner, File original) {
        this.owner = owner;
        this.original = original;
        if (original != null) {
            this.name = original.getName();
        }
    }

    public static void setDefaultOwner(JPhotoCollection owner) {
        defaultOwner = owner;
    }

    public void setOwner(JPhotoCollection owner) {
        this.owner = owner;
    }

    public BufferedImage getThumbImage() {
        BufferedImage thumb = null;
        if (this.thumbImage != null) {
            thumb = (BufferedImage)this.thumbImage.get();
        }
        if (thumb == null) {
            try {
                byte[] thumbData;
                this.getExifDirectory();
                if (this.directory != null && (thumbData = this.directory.getThumbnailData()) != null) {
                    Iterator<ImageReader> readers = ImageIO.getImageReadersBySuffix("jpg");
                    ImageReader jpgReader = readers.next();
                    jpgReader.setInput(new MemoryCacheImageInputStream(new ByteArrayInputStream(thumbData)));
                    thumb = jpgReader.read(0);
                    jpgReader.dispose();
                    this.thumbImage = new SoftReference<BufferedImage>(thumb);
                }
            }
            catch (Exception e) {
                JPhotoStatus.showStatus(null, "JPhoto " + this.getOriginalFile() + " cannot read thumb " + e);
            }
        }
        return thumb;
    }

    public BufferedImage getCachedThumb() {
        if (this.thumbImage == null) {
            return null;
        }
        return (BufferedImage)this.thumbImage.get();
    }

    public BufferedImage getThumbImageAsync() {
        if (loader == null) {
            loader = new ThumbLoader();
            loader.start();
        }
        if (this.getCachedThumb() == null) {
            loader.startLoading(this);
        }
        return this.getCachedThumb();
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String stat) {
        this.status = stat;
        this.setChanged();
        this.notifyObservers(stat);
    }

    public BufferedImage getFullImage() {
        if (this.getOriginalFile() == null) {
            return null;
        }
        BufferedImage im = null;
        if (fullImage != null && fullImagePhoto == this) {
            im = (BufferedImage)fullImage.get();
        }
        ImageReader imageReader = null;
        if (im == null) {
            try {
                long ticks = System.currentTimeMillis();
                System.out.println("Loading " + this.getOriginalFile() + "...");
                String suffix = Utils.getFileExt(this.getOriginalFile().getName(), "jpg");
                Iterator<ImageReader> readers = ImageIO.getImageReadersBySuffix(suffix);
                imageReader = readers.next();
                imageReader.setInput(new FileImageInputStream(this.getOriginalFile()));
                im = imageReader.read(0);
                imageReader.dispose();
                JPhotoStatus.showStatus(null, this.getOriginalFile() + " loaded in " + (System.currentTimeMillis() - ticks) + "ms. ");
                if (this.getCachedThumb() == null && (this.getExifDirectory() == null || this.getExifDirectory().getThumbnailData() == null)) {
                    try {
                        ticks = System.currentTimeMillis();
                        this.fullWidth = im.getWidth();
                        this.fullHeight = im.getHeight();
                        Dimension dim = Utils.getAnyScaledSize(thumbLimits, this.fullWidth, this.fullHeight);
                        BufferedImage bit = new BufferedImage(dim.width, dim.height, 1);
                        Graphics2D g2 = bit.createGraphics();
                        g2.drawImage(im, 0, 0, bit.getWidth(null), bit.getHeight(null), null, null);
                        g2.dispose();
                        this.thumbImage = new SoftReference<BufferedImage>(bit);
                        System.out.println("Generated display thumb for " + this.getOriginalFile() + " in " + (System.currentTimeMillis() - ticks) + "ms.");
                    }
                    catch (Exception e) {
                        this.setStatus(e.toString());
                        JPhotoStatus.showStatus(null, "Cannot generate thumbnail:" + e);
                    }
                }
                fullImage = new SoftReference<BufferedImage>(im);
                fullImagePhoto = this;
            }
            catch (Throwable e) {
                if (imageReader != null) {
                    imageReader.dispose();
                }
                this.setStatus(e.toString());
                this.badFile = true;
                JPhotoStatus.showStatus(null, "Cannot load " + this.getOriginalFile() + ":" + e);
                im = null;
            }
        } else {
            System.out.println("Found " + this.getOriginalFile() + " from cache");
        }
        return im;
    }

    public ExifDirectory getExifDirectory() {
        if (this.directory == null && this.getOriginalFile() != null) {
            try {
                Metadata metadata = JpegMetadataReader.readMetadata(this.getOriginalFile());
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("com.drew.metadata.exif.ExifDirectory");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.directory = (ExifDirectory)metadata.getDirectory(clazz);
            }
            catch (Exception e) {
                this.setStatus(e.toString());
                JPhotoStatus.showStatus(null, this.getOriginalFile() + ": cannot read exif " + e);
            }
        }
        return this.directory;
    }

    public int getWidth() {
        if (this.width <= 0) {
            this.setWebSize();
        }
        return this.width;
    }

    public void setWidth(int w) {
        this.width = w;
    }

    public int getHeight() {
        if (this.height <= 0) {
            this.setWebSize();
        }
        return this.height;
    }

    public void setHeight(int h) {
        this.height = h;
    }

    public String getImageName() {
        return this.name;
    }

    public void setImageName(String n) {
        this.badFile = false;
        this.name = n;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String n) {
        this.category = n;
    }

    public String getAlbumLink() {
        return this.makeRelative(this.albumlink);
    }

    public void setAlbumLink(String n) {
        this.albumlink = this.makeCanonical(n);
    }

    public String getFullAlbumLink() {
        if (this.albumlink == null) {
            return null;
        }
        return new File(this.albumlink).getAbsolutePath();
    }

    public File getOriginalFile() {
        return this.original;
    }

    public String getOriginalName() {
        return this.makeRelative(this.getOriginalFile());
    }

    public String getFullOriginalName() {
        if (this.original == null) {
            return null;
        }
        return this.getOriginalFile().getAbsolutePath();
    }

    public void setOriginalName(String n) {
        this.setOriginalName(new File(n));
    }

    public void setOriginalName(File f) {
        this.original = this.makeCanonical(f);
        this.setImageName(this.original.getName());
        this.clearCaches();
    }

    public String makeCanonical(String n) {
        return this.makeCanonical(new File(n)).getPath();
    }

    public File makeCanonical(File f) {
        File abs = f;
        if (!abs.isAbsolute() && this.getTargetDir() != null) {
            abs = new File(this.getTargetDir(), abs.getPath());
        }
        try {
            abs = abs.getCanonicalFile();
        }
        catch (Exception e) {
            System.out.println("makeCanonical:" + e);
        }
        return abs;
    }

    public String makeRelative(String name) {
        if (name == null) {
            return null;
        }
        return this.makeRelative(new File(name));
    }

    public String makeRelative(File name) {
        if (name == null) {
            return null;
        }
        String result = this.getTargetDir() != null ? Utils.getRelativePath(name, this.getTargetDir()) : Utils.getRelativePath(name, new File("."));
        return result;
    }

    public File getTargetDir() {
        if (this.owner == null) {
            return null;
        }
        return this.owner.getTargetDir();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String t) {
        this.text = t.replaceAll("\\s\\s+", " ").trim();
    }

    public JPhotoExif getExif() {
        if (this.exif == null) {
            this.getExifDirectory();
            this.exif = this.directory != null ? new JPhotoExif(this.directory) : new JPhotoExif(this.directory);
        }
        return this.exif;
    }

    public void setExif(JPhotoExif e) {
        this.exif = e;
    }

    public Font getFont() {
        if (this.font == null) {
            this.font = new Font("SansSerif", 1, 16);
        }
        return this.font;
    }

    public Font getWatermarkFont() {
        if (this.waterFont == null) {
            this.waterFont = new Font("SansSerif", 1, 10);
        }
        return this.waterFont;
    }

    public Object getTransferData(DataFlavor flavor) {
        return this;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.myFlavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(this.myFlavors[0]);
    }

    public String toString() {
        return "src='" + this.getImageName() + "' w=" + this.getWidth() + " h=" + this.getHeight() + " text='" + this.getText() + "'";
    }

    public void setWebSize() {
        ExifDirectory exif;
        if ((this.fullWidth < 0 || this.fullHeight < 0) && (exif = this.getExifDirectory()) != null && exif.containsTag(40962)) {
            try {
                this.fullWidth = exif.getInt(40962);
                this.fullHeight = exif.getInt(40963);
            }
            catch (Exception e) {
                System.out.println("setWebSize from exif failed" + e);
            }
        }
        if (this.fullWidth > 0 && this.fullHeight > 0) {
            Dimension dim = Utils.getAnyScaledSize(limits, this.fullWidth, this.fullHeight);
            this.width = dim.width;
            this.height = dim.height;
        } else {
            System.out.println("setWebSize: failed to get full width and height for '" + this.getImageName() + "', " + this.exif);
        }
    }

    public boolean saveThumb(File target) {
        try {
            byte[] thumbData = this.directory.getThumbnailData();
            if (thumbData == null) {
                return false;
            }
            FileOutputStream out = new FileOutputStream(target);
            out.write(thumbData);
            out.close();
            return true;
        }
        catch (Exception e) {
            JPhotoStatus.showStatus(null, "saveThumb " + target + " error " + e);
            return false;
        }
    }

    public boolean saveWebImages(File target, File thumbTarget, String watermark) {
        if (!target.exists() || thumbTarget != null && !thumbTarget.exists()) {
            long ticks;
            BufferedImage fullImg = this.getFullImage();
            if (fullImg == null) {
                return false;
            }
            BufferedImage thumbImg = null;
            if (!target.exists()) {
                ticks = System.currentTimeMillis();
                Image img = fullImg.getScaledInstance(this.getWidth(), this.getHeight(), 4);
                BufferedImage bi = new BufferedImage(img.getWidth(null), img.getHeight(null), 1);
                Graphics2D g2 = bi.createGraphics();
                g2.drawImage(img, null, null);
                thumbImg = this.generateThumb(bi);
                if (watermark != null) {
                    g2.setFont(this.getWatermarkFont());
                    Utils.drawWrappedText(g2, 1.0f, -(this.getHeight() - 1), this.getWidth(), watermark);
                }
                g2.dispose();
                if (!this.saveJpg(target, bi, 0.8f)) {
                    return false;
                }
                JPhotoStatus.showStatus(null, target + " scaled and saved" + " in " + (System.currentTimeMillis() - ticks) + "ms. ");
                Thread.yield();
            }
            if (thumbTarget != null && !thumbTarget.exists()) {
                ticks = System.currentTimeMillis();
                if (thumbImg == null) {
                    thumbImg = this.generateThumb(fullImg);
                }
                if (!this.saveJpg(thumbTarget, thumbImg, 0.7f)) {
                    return false;
                }
                JPhotoStatus.showStatus(null, thumbTarget + " scaled and saved" + " in " + (System.currentTimeMillis() - ticks) + "ms. ");
                Thread.yield();
            }
        }
        return true;
    }

    public boolean saveTransformedImage(File target, String watermark) {
        BufferedImage fullImg = this.getFullImage();
        if (fullImg == null) {
            return false;
        }
        long ticks = System.currentTimeMillis();
        BufferedImage bi = new BufferedImage(fullImg.getWidth(), fullImg.getHeight(), 1);
        Graphics2D g2 = bi.createGraphics();
        g2.drawImage(fullImg, null, null);
        if (watermark != null) {
            int fontSize = 2 * (fullImg.getHeight() / 160);
            g2.setFont(new Font("SansSerif", 1, fontSize));
            System.out.println("font:" + fontSize);
            Utils.drawWrappedText(g2, 1.0f, -(fullImg.getHeight() - 1), fullImg.getWidth(), watermark);
        }
        g2.dispose();
        if (!this.saveJpg(target, bi, 0.8f)) {
            return false;
        }
        JPhotoStatus.showStatus(null, target + " transformed and saved" + " in " + (System.currentTimeMillis() - ticks) + "ms. ");
        return true;
    }

    public BufferedImage generateThumb(BufferedImage img) {
        long ticks = System.currentTimeMillis();
        Dimension dim = Utils.getScaledSize(thumbLimits, img.getWidth(), img.getHeight());
        BufferedImage thumbImg = new BufferedImage(dim.width, dim.height, 1);
        Image scaledImg = img.getScaledInstance(dim.width, dim.height, 4);
        Graphics2D g2 = thumbImg.createGraphics();
        g2.drawImage(scaledImg, null, null);
        g2.dispose();
        System.out.println("Scaled thumb to " + dim + " in " + (System.currentTimeMillis() - ticks) + "ms. ");
        return thumbImg;
    }

    public boolean saveSubtitledImage(File target, String subtitle) {
        BufferedImage fullImg = this.getFullImage();
        long ticks = System.currentTimeMillis();
        int x = 0;
        boolean y = false;
        int w = this.getWidth();
        int h = this.getHeight();
        if (h > w) {
            w = 480 * this.getWidth() / 640;
            h = 480 * this.getHeight() / 640;
            x = 20;
        }
        BufferedImage bi = new BufferedImage(640, 480, 1);
        Graphics2D g2 = bi.createGraphics();
        if (fullImg != null) {
            Image img = fullImg.getScaledInstance(w, h, 4);
            g2.drawImage(img, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x, (float)y), null);
        }
        if (subtitle != null) {
            g2.setFont(this.getFont());
            if (h > w) {
                Utils.drawWrappedText(g2, w + x + 4, -480.0f, 640 - x - w - 8, subtitle);
            } else {
                Utils.drawWrappedText(g2, 25.0f, -480.0f, 605.0f, subtitle);
            }
        }
        g2.dispose();
        if (!this.saveJpg(target, bi, 0.9f)) {
            return false;
        }
        JPhotoStatus.showStatus(null, target + " subtitled, scaled and saved" + " in " + (System.currentTimeMillis() - ticks) + "ms. ");
        Thread.yield();
        return true;
    }

    /*
     * Loose catch block
     */
    public boolean saveJpg(File target, BufferedImage bi, float quality) {
        FileOutputStream out = null;
        out = new FileOutputStream(target);
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
        JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(bi);
        param.setQuality(quality, false);
        encoder.setJPEGEncodeParam(param);
        encoder.encode(bi);
        bi.flush();
        Object var7_8 = null;
        try {
            out.close();
        }
        catch (Exception e2) {
            JPhotoStatus.showStatus(null, "saveWebImage " + target + " close error " + e2);
        }
        return true;
        catch (Exception e) {
            JPhotoStatus.showStatus(null, "saveWebImage " + target + " error " + e);
            Object var7_9 = null;
            {
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    try {
                        out.close();
                    }
                    catch (Exception e2) {
                        JPhotoStatus.showStatus(null, "saveWebImage " + target + " close error " + e2);
                    }
                    throw throwable;
                }
            }
            try {
                out.close();
            }
            catch (Exception e2) {
                JPhotoStatus.showStatus(null, "saveWebImage " + target + " close error " + e2);
            }
            return false;
        }
    }

    public void clearCaches() {
        this.badFile = false;
        this.exif = null;
        this.directory = null;
        this.thumbImage = null;
        fullImage = null;
        this.width = -1;
        this.height = -1;
        this.fullWidth = -1;
        this.fullHeight = -1;
    }

    protected class ThumbLoader
    extends Thread {
        List list = Collections.synchronizedList(new LinkedList());

        public void startLoading(JPhoto photo) {
            if (photo.badFile || photo.getOriginalFile() == null) {
                return;
            }
            List list = this.list;
            synchronized (list) {
                if (this.list.indexOf(photo) < 0) {
                    photo.setStatus("Loading...");
                    this.list.add(0, photo);
                    this.list.notify();
                }
            }
        }

        public void run() {
            System.out.println("ThumbLoader started");
            while (true) {
                JPhoto photo = null;
                try {
                    while (this.list.size() > 0) {
                        photo = (JPhoto)this.list.remove(0);
                        photo.getThumbImage();
                        if (photo.getCachedThumb() == null) {
                            photo.getFullImage();
                        }
                        if (photo.getCachedThumb() != null) {
                            photo.setStatus("Loaded.");
                        }
                        photo = null;
                    }
                    List list = this.list;
                    synchronized (list) {
                        this.list.wait();
                        continue;
                    }
                }
                catch (Exception e) {
                    if (photo != null) {
                        photo.setStatus(e.toString());
                    }
                    System.out.println("ThumbLoader:" + e);
                    continue;
                }
                break;
            }
        }
    }
}

