/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.jka;

import fi.iki.jka.JPhoto;
import fi.iki.jka.JPhotoCollection;
import fi.iki.jka.JPhotoFrame;
import fi.iki.jka.Utils;
import java.io.File;
import java.util.Observable;
import java.util.Observer;

public class JPhotoAlbumLink
extends JPhoto
implements Observer {
    protected String albumLink = null;
    protected JPhotoCollection albumPhotos = null;
    protected JPhoto cover = null;

    public JPhotoAlbumLink() {
        this(JPhoto.defaultOwner, (String)null);
    }

    public JPhotoAlbumLink(JPhotoCollection owner, String targetAlbum) {
        super(owner);
        if (targetAlbum != null) {
            this.setAlbumLink(targetAlbum);
            this.albumPhotos = new JPhotoCollection(this.getFullAlbumLink());
            this.setText(this.albumPhotos.getTitle());
        }
    }

    public File getOriginalFile() {
        JPhoto newCover;
        if (this.albumPhotos == null) {
            this.albumPhotos = new JPhotoCollection(this.getFullAlbumLink());
        }
        if ((newCover = this.albumPhotos.getCoverPhoto()) != this.cover) {
            if (this.cover != null) {
                this.cover.deleteObserver(this);
            }
            if (newCover != null) {
                newCover.addObserver(this);
                this.name = newCover.getImageName();
            }
            this.cover = newCover;
            this.clearCaches();
        }
        if (this.cover != null) {
            return this.cover.getOriginalFile();
        }
        return null;
    }

    public String getAlbumLink() {
        String link = this.makeRelative(this.albumlink);
        if (link != null) {
            link = Utils.getFileBase(link, JPhotoFrame.FILE_EXT);
        }
        return link;
    }

    public void setAlbumLink(String n) {
        this.albumlink = this.makeCanonical(n);
    }

    public String getFullAlbumLink() {
        if (this.albumlink == null) {
            return null;
        }
        String link = new File(this.albumlink).getAbsolutePath();
        if (!link.toLowerCase().endsWith(JPhotoFrame.FILE_EXT)) {
            link = String.valueOf(link) + JPhotoFrame.FILE_EXT;
        }
        return link;
    }

    public void update(Observable o, Object arg) {
        this.setStatus(this.cover.getStatus());
    }

    public String toString() {
        return "link='" + this.getAlbumLink() + "' w=" + this.getWidth() + " h=" + this.getHeight() + " text='" + this.getText() + "'";
    }

    public void clearCaches() {
        super.clearCaches();
    }
}

