/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.jka;

import fi.iki.jka.JPhoto;
import fi.iki.jka.JPhotoAlbumLink;
import fi.iki.jka.JPhotoDirectory;
import fi.iki.jka.JPhotoFrame;
import fi.iki.jka.JPhotoMenu;
import fi.iki.jka.JPhotoPageInfo;
import fi.iki.jka.JPhotoStatus;
import fi.iki.jka.Utils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractListModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.xslt.Process;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class JPhotoCollection
extends AbstractListModel
implements Transferable,
Serializable,
Observer {
    public static String THUMBS_DIRECTORY = "thumbs/";
    public static String PICTURES_DIRECTORY = "pictures/";
    public static final String MAPPING_FILE = "jphoto.mapping.xml";
    public static final DataFlavor PHOTOCOLLECTION_FLAVOR;
    protected DataFlavor[] myFlavors = new DataFlavor[]{PHOTOCOLLECTION_FLAVOR};
    boolean haveGui = true;
    boolean dirty = false;
    File targetDir = null;
    JPhotoPageInfo pageInfo = new JPhotoPageInfo();
    ArrayList photos = new ArrayList();
    ArrayList categoryNames = new ArrayList();
    static HashMap allCollections;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("fi.iki.jka.JPhotoCollection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PHOTOCOLLECTION_FLAVOR = new DataFlavor(clazz, "List of JPG Photographs");
        allCollections = new HashMap();
    }

    public JPhotoCollection() {
    }

    public JPhotoCollection(String xmlName) {
        System.out.println("JPhotoCollection(" + xmlName + ")");
        this.load(xmlName);
    }

    public JPhotoCollection(String[] names) {
        this.addAll(0, names);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean v) {
        this.dirty = v;
    }

    public ArrayList getPhotos() {
        return this.photos;
    }

    public void setPhotos(ArrayList photos) {
        this.photos = photos;
        Iterator i = photos.iterator();
        while (i.hasNext()) {
            JPhoto p = (JPhoto)i.next();
            p.addObserver(this);
            p.setOwner(this);
        }
        this.setDirty(true);
        this.fireIntervalAdded(this, 0, photos.size());
    }

    public ArrayList getCategoryNames() {
        return this.categoryNames;
    }

    public void setCategoryNames(ArrayList categoryNames) {
        this.categoryNames = categoryNames;
        this.setDirty(true);
    }

    public String getTitle() {
        return this.getPageInfo().title;
    }

    public void setTitle(String title) {
        this.pageInfo.title = title;
        this.setDirty(true);
    }

    public String getDescription() {
        return this.getPageInfo().description;
    }

    public void setDescription(String description) {
        this.pageInfo.description = description;
        this.setDirty(true);
    }

    public String getKeywords() {
        return this.getPageInfo().keywords;
    }

    public void setKeywords(String s) {
        this.pageInfo.keywords = s;
        this.setDirty(true);
    }

    public String getWatermark() {
        return this.getPageInfo().watermark;
    }

    public void setWatermark(String s) {
        this.pageInfo.watermark = s;
        this.setDirty(true);
    }

    public Color getForegroundColor() {
        try {
            return Utils.convertValueToColor(this.getPageInfo().foreground);
        }
        catch (Exception e) {
            System.out.println("Invalid foreground color:" + this.getPageInfo().foreground);
            this.setForegroundColor(Color.black);
            return Color.white;
        }
    }

    public void setForegroundColor(Color color) {
        this.pageInfo.foreground = Utils.convertColorToValue(color);
        this.setDirty(true);
    }

    public Color getBackgroundColor() {
        try {
            return Utils.convertValueToColor(this.getPageInfo().background);
        }
        catch (Exception e) {
            System.out.println("Invalid background color:" + this.getPageInfo().background);
            this.setBackgroundColor(Color.white);
            return Color.black;
        }
    }

    public void setBackgroundColor(Color color) {
        this.pageInfo.background = Utils.convertColorToValue(color);
        this.setDirty(true);
    }

    public String getOutputDirectory() {
        return this.getPageInfo().outputDirectory;
    }

    public void setOutputDirectory(String s) {
        this.pageInfo.outputDirectory = s;
    }

    public JPhotoPageInfo getPageInfo() {
        return this.pageInfo;
    }

    public void setPageInfo(JPhotoPageInfo info) {
        this.pageInfo = info;
        this.setDirty(true);
    }

    public void setCoverPhoto(JPhoto photo) {
        this.pageInfo.coverPhotoName = photo.getImageName();
        this.setDirty(true);
    }

    public JPhoto getCoverPhoto() {
        if (this.photos.size() > 0) {
            Iterator iter = this.photos.iterator();
            while (iter.hasNext()) {
                JPhoto p = (JPhoto)iter.next();
                String name = p.getImageName();
                if (!name.equals("") && this.pageInfo.coverPhotoName.equals("")) {
                    return p;
                }
                if (!name.equals(this.pageInfo.coverPhotoName)) continue;
                return p;
            }
            System.out.println("getCoverPhoto: cover photo " + this.pageInfo.coverPhotoName + " not found");
        }
        return null;
    }

    public BufferedImage getCoverIcon() {
        BufferedImage icon;
        JPhoto coverPhoto = this.getCoverPhoto();
        if (coverPhoto != null && (icon = coverPhoto.getThumbImage()) != null) {
            Dimension limits = new Dimension(64, 64);
            limits = Utils.getScaledSize(limits, icon.getWidth(), icon.getHeight());
            BufferedImage bi = new BufferedImage(64, 64, 1);
            Graphics2D g2 = bi.createGraphics();
            g2.drawImage(icon, (64 - limits.width) / 2, (64 - limits.height) / 2, limits.width, limits.height, null, null);
            g2.dispose();
            return bi;
        }
        return null;
    }

    public Iterator iterator() {
        return this.photos.iterator();
    }

    public void add(int index, JPhoto photo) {
        if (index < this.photos.size()) {
            this.photos.add(index, photo);
        } else {
            this.photos.add(photo);
        }
        photo.addObserver(this);
        photo.setOwner(this);
        this.setDirty(true);
        this.fireIntervalAdded(this, index, index);
    }

    public void addAll(int index, String[] files) {
        int i = 0;
        while (i < files.length) {
            JPhoto photo = null;
            File file = new File(files[i]);
            photo = file.isDirectory() ? new JPhotoDirectory(this, file) : new JPhoto(this, file);
            this.add(index, photo);
            ++index;
            ++i;
        }
    }

    public boolean remove(JPhoto photo) {
        int index = this.photos.indexOf(photo);
        if (index < 0) {
            return false;
        }
        this.photos.remove(index);
        photo.deleteObserver(this);
        this.setDirty(true);
        this.fireIntervalRemoved(this, index, index);
        return true;
    }

    public void removeAll(String filename) {
        int total = this.photos.size() - 1;
        if (total < 0) {
            return;
        }
        this.photos.clear();
        this.pageInfo = new JPhotoPageInfo();
        this.setDirty(false);
        this.fireIntervalRemoved(this, 0, total);
        if (filename != null) {
            allCollections.remove(filename);
        }
    }

    public int indexOf(JPhoto photo) {
        return this.photos.indexOf(photo);
    }

    public JPhoto get(int index) {
        return (JPhoto)this.photos.get(index);
    }

    public void findOriginals(String[] files) {
        int i = 0;
        while (i < files.length) {
            File file = new File(files[i]);
            String targetName = file.getName().toLowerCase();
            Iterator iter = this.photos.iterator();
            while (iter.hasNext()) {
                JPhoto p = (JPhoto)iter.next();
                if (!p.getImageName().toLowerCase().equals(targetName)) continue;
                System.out.println("Found " + file);
                p.setOriginalName(file);
            }
            ++i;
        }
    }

    public int size() {
        return this.photos.size();
    }

    public void update(Observable o, Object arg) {
        JPhoto photo = null;
        photo = arg instanceof JPhoto ? (JPhoto)arg : (JPhoto)o;
        final int index = this.photos.indexOf(photo);
        if (index < 0) {
            System.out.println("JPhotoCollection.update:" + photo + " not found from collection?");
        } else {
            try {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        JPhotoCollection.this.fireContentsChanged(this, index, index);
                    }
                });
            }
            catch (Exception e) {
                System.out.println("JPhotoCollection.update:" + e);
            }
        }
    }

    public Object getElementAt(int index) {
        if (index < this.photos.size()) {
            return this.photos.get(index);
        }
        return null;
    }

    public int getSize() {
        return this.photos.size();
    }

    public Object getTransferData(DataFlavor flavor) {
        return this;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.myFlavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(this.myFlavors[0]);
    }

    public void setTargetDir(String filepath) {
        this.pageInfo.albumName = Utils.getFileName(new File(filepath).getName());
        try {
            this.targetDir = new File(filepath).getCanonicalFile();
            if (!this.targetDir.isDirectory()) {
                this.targetDir = this.targetDir.getParentFile();
            }
        }
        catch (Exception e) {
            System.out.println("setTargetDir:" + e);
            this.targetDir = null;
        }
    }

    public File getTargetDir() {
        return this.targetDir;
    }

    public boolean load(String filename) {
        try {
            JPhotoCollection collection = (JPhotoCollection)allCollections.get(filename);
            if (allCollections.get(filename) == null) {
                JPhotoStatus.showStatus(null, "Loading " + filename);
                JPhoto.setDefaultOwner(this);
                this.setTargetDir(filename);
                Mapping mapping = this.getMapping();
                Unmarshaller unmarshaller = new Unmarshaller(mapping);
                collection = (JPhotoCollection)unmarshaller.unmarshal(new InputSource(new FileInputStream(filename)));
                allCollections.put(filename, collection);
                JPhotoStatus.showStatus(null, "Loaded from " + filename);
            } else {
                System.out.println("Using cached " + filename);
            }
            this.setPhotos(collection.getPhotos());
            this.setPageInfo(collection.getPageInfo());
            this.setCategoryNames(collection.getCategoryNames());
            this.setTargetDir(filename);
            this.setDirty(false);
            allCollections.put(filename, this);
            return true;
        }
        catch (Exception e) {
            JPhotoStatus.showStatus(null, "Load error:" + e);
            return false;
        }
    }

    public boolean save(String filename) {
        allCollections.values().remove(this);
        JPhoto.setDefaultOwner(this);
        this.setTargetDir(filename);
        boolean bl = this.dirty = !this.save(new File(filename), null);
        if (!this.dirty) {
            allCollections.put(filename, this);
            JPhotoStatus.showStatus(null, "Saved to " + filename);
        }
        return !this.dirty;
    }

    /*
     * Loose catch block
     */
    public boolean save(File target, String stylesheet) {
        Transformer trans;
        System.out.println("Start saving to " + target + " with style " + stylesheet);
        OutputStream outs = null;
        this.setOutputDirectory(target.getParent());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document photoDoc = builder.newDocument();
        Mapping mapping = this.getMapping();
        Marshaller marshaller = new Marshaller(photoDoc);
        marshaller.setMapping(mapping);
        marshaller.marshal(this);
        DOMSource src = new DOMSource(photoDoc);
        outs = new FileOutputStream(target);
        StreamResult res = new StreamResult(outs);
        if (stylesheet == null) {
            trans = TransformerFactory.newInstance().newTransformer();
            trans.setOutputProperty("indent", "yes");
        } else {
            trans = this.getTransformer(target, stylesheet);
        }
        trans.transform(src, res);
        System.out.println("Saved using " + stylesheet);
        JPhotoStatus.showStatus(null, "Wrote " + target + (stylesheet != null ? " using template " + stylesheet : ""));
        Object var12_13 = null;
        try {
            if (outs != null) {
                outs.close();
            }
        }
        catch (Exception e2) {
            JPhotoStatus.showStatus(null, "Save failed close:" + e2);
        }
        return true;
        catch (Exception e) {
            JPhotoStatus.showStatus(null, "Save error:" + e);
            Object var12_14 = null;
            {
                catch (Throwable throwable) {
                    Object var12_15 = null;
                    try {
                        if (outs != null) {
                            outs.close();
                        }
                    }
                    catch (Exception e2) {
                        JPhotoStatus.showStatus(null, "Save failed close:" + e2);
                    }
                    throw throwable;
                }
            }
            try {
                if (outs != null) {
                    outs.close();
                }
            }
            catch (Exception e2) {
                JPhotoStatus.showStatus(null, "Save failed close:" + e2);
            }
            return false;
        }
    }

    /*
     * Loose catch block
     */
    public boolean exportTree(File target, String stylesheet) {
        System.out.println("Start exportTree to " + target + " with style " + stylesheet);
        OutputStream outs = null;
        this.setOutputDirectory(target.getParent());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document collectedDocs = builder.newDocument();
        Element rootElement = collectedDocs.createElement("all");
        Attr a = collectedDocs.createAttribute("root");
        a.setValue(target.getParent());
        rootElement.setAttributeNode(a);
        collectedDocs.appendChild(rootElement);
        this.albumToDocument(this, rootElement, target.getParent());
        DOMSource src = new DOMSource(collectedDocs);
        outs = new FileOutputStream(target);
        StreamResult res = new StreamResult(outs);
        Transformer trans = this.getTransformer(target, stylesheet);
        trans.transform(src, res);
        System.out.println("Saved using " + stylesheet);
        JPhotoStatus.showStatus(null, "Wrote " + target + (stylesheet != null ? " using template " + stylesheet : ""));
        Object var12_13 = null;
        try {
            if (outs != null) {
                outs.close();
            }
        }
        catch (Exception e2) {
            JPhotoStatus.showStatus(null, "Save failed close:" + e2);
        }
        return true;
        catch (Exception e) {
            JPhotoStatus.showStatus(null, "Export error:" + e);
            Object var12_14 = null;
            {
                catch (Throwable throwable) {
                    Object var12_15 = null;
                    try {
                        if (outs != null) {
                            outs.close();
                        }
                    }
                    catch (Exception e2) {
                        JPhotoStatus.showStatus(null, "Save failed close:" + e2);
                    }
                    throw throwable;
                }
            }
            try {
                if (outs != null) {
                    outs.close();
                }
            }
            catch (Exception e2) {
                JPhotoStatus.showStatus(null, "Save failed close:" + e2);
            }
            return false;
        }
    }

    public boolean albumToDocument(JPhotoCollection album, Element root, String basePath) {
        System.out.println("Add " + album.pageInfo.outputDirectory + " " + album.pageInfo.albumName);
        try {
            String path = "";
            String oldpath = album.pageInfo.outputDirectory;
            if (basePath.length() + 1 < oldpath.length()) {
                path = oldpath.substring(basePath.length() + 1);
                if ((path = path.replace('/', '\\')).length() > 0 && !path.endsWith("/")) {
                    path = String.valueOf(path) + "/";
                }
            }
            album.setOutputDirectory(path);
            Mapping mapping = this.getMapping();
            Marshaller marshaller = new Marshaller(root);
            marshaller.setMapping(mapping);
            marshaller.marshal(album);
            Iterator iter = album.photos.iterator();
            while (iter.hasNext()) {
                JPhoto p = (JPhoto)iter.next();
                if (!(p instanceof JPhotoAlbumLink)) continue;
                JPhotoCollection a = new JPhotoCollection(p.getFullAlbumLink());
                System.out.println("Add next...");
                this.albumToDocument(a, root, basePath);
            }
            album.pageInfo.outputDirectory = oldpath;
            return true;
        }
        catch (Exception e) {
            JPhotoStatus.showStatus(null, "error:" + e);
            return false;
        }
    }

    public Mapping getMapping() throws Exception {
        Mapping mapping = new Mapping();
        InputStreamReader mappingReader = null;
        try {
            InputStream res = this.getClass().getClassLoader().getResourceAsStream(MAPPING_FILE);
            mappingReader = new InputStreamReader(res);
        }
        catch (Exception e) {
            System.out.println("Not in resource, trying from jphoto.mapping.xml");
            mappingReader = new FileReader(new File(MAPPING_FILE));
        }
        mapping.loadMapping(new InputSource(mappingReader));
        ((Reader)mappingReader).close();
        return mapping;
    }

    public Transformer getTransformer(File target, String stylesheet) throws Exception {
        InputStream ins = null;
        File f = new File(target.getParentFile(), stylesheet);
        if (!f.exists()) {
            if (target.getParentFile() != null) {
                f = new File(target.getParentFile().getParentFile(), stylesheet);
            }
            if (!f.exists()) {
                f = new File("templates/" + stylesheet);
            }
        }
        if (f.exists()) {
            stylesheet = f.getAbsolutePath();
            JPhotoStatus.showStatus(JPhotoMenu.A_EXPORT, "Using stylesheet " + stylesheet);
            try {
                Transformer trans = TransformerFactory.newInstance().newTransformer(new StreamSource(stylesheet));
                return trans;
            }
            catch (Exception e) {
                JPhotoStatus.showStatus(null, "Cannot read " + stylesheet + ":" + e);
                return null;
            }
        }
        System.out.println("Using templates/" + stylesheet + " from resources.");
        ins = this.getClass().getClassLoader().getResourceAsStream("templates/" + stylesheet);
        StreamSource src = new StreamSource(ins, this.getClass().getClassLoader().getResource("templates/").toString());
        Transformer trans = TransformerFactory.newInstance().newTransformer(src);
        ins.close();
        return trans;
    }

    public boolean exportSubtitledPhotos(String album) {
        JPhotoStatus.showProgress(JPhotoMenu.A_EXPORT_SUBTITLED, "Exporting subtitled photos for " + album, 0);
        return this.exportPhotos(new File(album), "subtitled/", null, true);
    }

    public boolean exportHtmlJari1(String album) {
        String template = "jphotolist.xsl";
        File htmlTarget = new File(String.valueOf(Utils.getFileBase(album, JPhotoFrame.FILE_EXT)) + ".html");
        JPhotoStatus.showProgress(JPhotoMenu.A_EXPORT, "Exporting to " + htmlTarget, 0);
        if (!this.save(htmlTarget, template)) {
            JPhotoStatus.showProgress(JPhotoMenu.A_EXPORT, "Failed", 100);
            return false;
        }
        return this.exportPhotos(htmlTarget, PICTURES_DIRECTORY, THUMBS_DIRECTORY, false);
    }

    public boolean exportTemplateJari1(File target) {
        boolean status = false;
        try {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream("templates/jphotolist.xsl");
            status = Utils.copyStreamToFile(in, new File(target, "jphotolist.xsl"));
            in.close();
        }
        catch (Exception e) {
            JPhotoStatus.showStatus(JPhotoMenu.A_EXPORT_TEMPLATE, "failed:" + e);
        }
        return status;
    }

    public boolean exportHtmlJari2(String album) {
        File htmlTarget = new File(String.valueOf(Utils.getFileBase(album, JPhotoFrame.FILE_EXT)) + "-thumbs.html");
        JPhotoStatus.showProgress(JPhotoMenu.A_EXPORT, "Exporting to " + htmlTarget, 0);
        if (!this.save(htmlTarget, "jphotothumbs.xsl")) {
            JPhotoStatus.showProgress(JPhotoMenu.A_EXPORT, "Failed", 100);
            return false;
        }
        File frameTarget = new File(String.valueOf(Utils.getFileBase(album, JPhotoFrame.FILE_EXT)) + "-frame.html");
        JPhotoStatus.showProgress(JPhotoMenu.A_EXPORT, "Exporting to " + frameTarget, 0);
        if (!this.save(frameTarget, "jphotoframe.xsl")) {
            JPhotoStatus.showProgress(JPhotoMenu.A_EXPORT, "Failed to write frame", 100);
            return false;
        }
        File jsTarget = new File(new File(album).getParent(), "jphoto.js");
        boolean status = false;
        try {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream("templates/jphoto.js");
            status = Utils.copyStreamToFile(in, jsTarget);
            in.close();
        }
        catch (Exception e) {
            JPhotoStatus.showStatus(JPhotoMenu.A_EXPORT_TEMPLATE, "failed:" + e);
            status = false;
        }
        if (!status) {
            JPhotoStatus.showProgress(JPhotoMenu.A_EXPORT, "Failed to write JavaScript", 100);
            return false;
        }
        return this.exportPhotos(htmlTarget, PICTURES_DIRECTORY, THUMBS_DIRECTORY, false);
    }

    public boolean exportTemplateJari2(File target) {
        boolean status = false;
        try {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream("templates/jphotolist.xsl");
            status = Utils.copyStreamToFile(in, new File(target, "jphotolist.xsl"));
            in.close();
            in = this.getClass().getClassLoader().getResourceAsStream("templates/jphotothumbs.xsl");
            status = Utils.copyStreamToFile(in, new File(target, "jphotothumbs.xsl"));
            in.close();
            in = this.getClass().getClassLoader().getResourceAsStream("templates/jphotoframe.xsl");
            status = Utils.copyStreamToFile(in, new File(target, "jphotoframe.xsl"));
            in.close();
        }
        catch (Exception e) {
            JPhotoStatus.showStatus(JPhotoMenu.A_EXPORT_TEMPLATE, "failed:" + e);
        }
        return status;
    }

    public boolean exportHtmlJari3(String album) {
        String template = "jphotoindexall.xsl";
        File htmlTarget = new File(String.valueOf(Utils.getFileBase(album, JPhotoFrame.FILE_EXT)) + "-all.html");
        JPhotoStatus.showStatus(JPhotoMenu.A_EXPORT, "Exporting to " + htmlTarget + "...");
        if (!this.exportTree(htmlTarget, template)) {
            return false;
        }
        JPhotoStatus.showStatus(JPhotoMenu.A_EXPORT, "Exported to " + htmlTarget);
        return true;
    }

    public boolean exportTemplateJari3(File target) {
        boolean status = false;
        try {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream("templates/jphotoindexall.xsl");
            status = Utils.copyStreamToFile(in, new File(target, "jphotoindexall.xsl"));
            in.close();
        }
        catch (Exception e) {
            JPhotoStatus.showStatus(JPhotoMenu.A_EXPORT_TEMPLATE, "failed:" + e);
        }
        return status;
    }

    public boolean exportHtmlTarja2(String albumFileName) {
        System.out.println("Start Tarjas HTML export from album " + albumFileName);
        JPhoto.setDefaultOwner(this);
        this.setTargetDir(albumFileName);
        JPhotoStatus.showProgress(JPhotoMenu.A_EXPORT, "Generating HTML to " + albumFileName, 0);
        if (this.photos.size() == 0) {
            System.out.println("No photos in the album.");
            return true;
        }
        String[] argv = new String[]{"-in", albumFileName, "-xsl", "templates/JPhotoChooser.xsl"};
        try {
            Process.main((String[])argv);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        this.exportPhotos(this.getTargetDir(), "pictures", "thumbs", true);
        JPhotoStatus.showStatus(null, "Wrote " + this.getTargetDir() + "/index.html");
        return true;
    }

    public boolean exportHtmlJuha(File target) {
        return false;
    }

    public ArrayList getPhotos(String category) {
        ArrayList<JPhoto> result = new ArrayList<JPhoto>();
        int i = 0;
        while (i < this.photos.size()) {
            JPhoto photo = (JPhoto)this.photos.get(i);
            if (photo.getCategory() != null && photo.getCategory().equals(category)) {
                result.add(photo);
            }
            ++i;
        }
        return result;
    }

    public void disableGui() {
        this.haveGui = false;
    }

    public boolean exportPhotos(File target, String picPrefix, String thumbPrefix, boolean subtitles) {
        ExportPhotosThread runner = new ExportPhotosThread(target, picPrefix, thumbPrefix, subtitles);
        if (this.haveGui) {
            runner.start();
            return true;
        }
        runner.run();
        return true;
    }

    public boolean copyOriginals(String album, String picPrefix, boolean transfrom) {
        JPhotoStatus.showProgress("Copying and watermarking originals... ", "", 0);
        File target = new File(album).getParentFile();
        CopyThread runner = new CopyThread(target, picPrefix, transfrom);
        runner.start();
        return true;
    }

    public String toString() {
        return "JPhotoCollection: " + this.photos.size() + " photos";
    }

    public static void main(String[] args) throws Exception {
    }

    public class ExportPhotosThread
    extends Thread {
        public boolean status = false;
        protected File dir;
        protected String targetBase;
        protected String picPrefix;
        protected String thumbPrefix;
        protected boolean subtitles;

        public ExportPhotosThread(File target, String picPrefix, String thumbPrefix, boolean subtitles) {
            target = target.getAbsoluteFile();
            this.targetBase = Utils.getFileName(target.getName());
            this.dir = target.getParentFile();
            this.subtitles = subtitles;
            this.dir.mkdirs();
            this.picPrefix = picPrefix;
            if (picPrefix.endsWith("/")) {
                new File(this.dir, picPrefix).mkdir();
            }
            this.thumbPrefix = thumbPrefix;
            if (thumbPrefix != null && thumbPrefix.endsWith("/")) {
                new File(this.dir, thumbPrefix).mkdir();
            }
        }

        public void run() {
            try {
                int count = 1;
                Iterator i = JPhotoCollection.this.photos.iterator();
                while (i.hasNext() && !JPhotoStatus.isCanceled()) {
                    JPhoto p = (JPhoto)i.next();
                    File web = null;
                    web = this.subtitles ? new File(this.dir, String.valueOf(this.picPrefix) + this.targetBase + (count < 10 ? "0" : "") + (count < 100 ? "0" : "") + Integer.toString(count) + "." + Utils.getFileExt(p.getImageName(), "jpg")) : new File(this.dir, String.valueOf(this.picPrefix) + p.getImageName());
                    File thumb = null;
                    if (this.thumbPrefix != null) {
                        thumb = new File(this.dir, String.valueOf(this.thumbPrefix) + p.getImageName());
                    }
                    JPhotoStatus.showProgress(null, "Processing " + p.getImageName() + "...", 5 + count * 95 / JPhotoCollection.this.photos.size() - 1);
                    if (this.subtitles) {
                        p.saveSubtitledImage(web, p.getText());
                    } else {
                        p.saveWebImages(web, thumb, JPhotoCollection.this.pageInfo.watermark);
                    }
                    Thread.yield();
                    ++count;
                }
                if (JPhotoStatus.isCanceled()) {
                    JPhotoStatus.showStatus(JPhotoMenu.A_EXPORT, "Export cancelled.");
                }
                this.status = true;
            }
            catch (Exception e) {
                JPhotoStatus.showStatus(JPhotoMenu.A_EXPORT, "exportPhotos failed:" + e);
                e.printStackTrace();
                this.status = false;
            }
            JPhotoStatus.showProgress(null, "Done", 100);
        }
    }

    public class CopyThread
    extends Thread {
        public boolean status = false;
        protected File dir;
        protected String picPrefix;
        protected boolean transform;

        public CopyThread(File target, String picPrefix, boolean trans) {
            this.dir = new File(target.getAbsoluteFile(), picPrefix);
            this.dir.mkdirs();
            this.transform = trans;
        }

        public void run() {
            try {
                int count = 1;
                Iterator i = JPhotoCollection.this.photos.iterator();
                while (i.hasNext() && !JPhotoStatus.isCanceled()) {
                    JPhoto p = (JPhoto)i.next();
                    File target = new File(this.dir, p.getImageName());
                    JPhotoStatus.showProgress(null, "Processing " + p.getImageName() + "...", 5 + count * 95 / JPhotoCollection.this.photos.size() - 1);
                    if (this.transform) {
                        p.saveTransformedImage(target, JPhotoCollection.this.pageInfo.watermark);
                    } else {
                        p.saveTransformedImage(target, null);
                    }
                    Thread.yield();
                    ++count;
                }
                if (JPhotoStatus.isCanceled()) {
                    JPhotoStatus.showStatus(JPhotoMenu.A_EXPORT, "Export cancelled.");
                }
                this.status = true;
            }
            catch (Exception e) {
                JPhotoStatus.showStatus(JPhotoMenu.A_EXPORT, "exportPhotos failed:" + e);
                e.printStackTrace();
                this.status = false;
            }
            JPhotoStatus.showProgress(null, "Done", 100);
        }
    }
}

