/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.text.ParseException;
import java.util.Enumeration;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.types.Time;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public final class XSTime
extends XSType {
    private static final JType jType = new JClass("org.exolab.castor.types.Time");
    private Time _maxInclusive;
    private Time _maxExclusive;
    private Time _minInclusive;
    private Time _minExclusive;

    public XSTime() {
        super((short)4);
    }

    public String newInstanceCode() {
        return "new " + this.getJType().getName() + "();";
    }

    public JType getJType() {
        return jType;
    }

    public Time getMaxExclusive() {
        return this._maxExclusive;
    }

    public Time getMaxInclusive() {
        return this._maxInclusive;
    }

    public Time getMinExclusive() {
        return this._minExclusive;
    }

    public Time getMinInclusive() {
        return this._minInclusive;
    }

    public void setMaxExclusive(Time time) {
        this._maxExclusive = time;
        this._maxInclusive = null;
    }

    public void setMaxInclusive(Time time) {
        this._maxInclusive = time;
        this._maxExclusive = null;
    }

    public void setMinExclusive(Time time) {
        this._minExclusive = time;
        this._minInclusive = null;
    }

    public void setMinInclusive(Time time) {
        this._minInclusive = time;
        this._minExclusive = null;
    }

    public boolean hasMinimum() {
        return this._minInclusive != null || this._minExclusive != null;
    }

    public boolean hasMaximum() {
        return this._maxInclusive != null || this._maxExclusive != null;
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSType.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String string = facet.getName();
            try {
                if ("maxExclusive".equals(string)) {
                    this.setMaxExclusive(Time.parseTime(facet.getValue()));
                    continue;
                }
                if ("maxInclusive".equals(string)) {
                    this.setMaxInclusive(Time.parseTime(facet.getValue()));
                    continue;
                }
                if ("minExclusive".equals(string)) {
                    this.setMinExclusive(Time.parseTime(facet.getValue()));
                    continue;
                }
                if ("minInclusive".equals(string)) {
                    this.setMinInclusive(Time.parseTime(facet.getValue()));
                    continue;
                }
                if (!"pattern".equals(string)) continue;
                System.out.println("Warning: The facet 'pattern' is not currently supported for XSTime.");
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
                return;
            }
        }
    }

    public void validationCode(JSourceCode jSourceCode, String string, String string2) {
        Time time;
        if (jSourceCode == null) {
            jSourceCode = new JSourceCode();
        }
        jSourceCode.add("DateTimeValidator typeValidator = new DateTimeValidator();");
        if (this.hasMinimum()) {
            jSourceCode.add("try {");
            jSourceCode.indent();
            time = this.getMinExclusive();
            if (time != null) {
                jSourceCode.add("org.exolab.castor.types.Time min =org.exolab.castor.types.Time.parseTime(\"" + time.toString() + "\");");
                jSourceCode.add("typeValidator.setMinExclusive(");
            } else {
                time = this.getMinInclusive();
                jSourceCode.add("org.exolab.castor.types.Time min =org.exolab.castor.types.Time.parseTime(\"" + time.toString() + "\");");
                jSourceCode.add("typeValidator.setMinInclusive(");
            }
            jSourceCode.append("min");
            jSourceCode.append(");");
            jSourceCode.unindent();
            jSourceCode.add("} catch (java.text.ParseException e) {");
            jSourceCode.indent();
            jSourceCode.add("System.out.println(e);");
            jSourceCode.add("e.printStackTrace();");
            jSourceCode.add("return;");
            jSourceCode.unindent();
            jSourceCode.add("}");
        }
        if (this.hasMaximum()) {
            jSourceCode.add("try {");
            jSourceCode.indent();
            time = this.getMaxExclusive();
            if (time != null) {
                jSourceCode.add("org.exolab.castor.types.Time max =org.exolab.castor.types.Time.parseTime(\"" + time.toString() + "\");");
                jSourceCode.add("typeValidator.setMaxExclusive(");
            } else {
                time = this.getMaxInclusive();
                jSourceCode.add("org.exolab.castor.types.Time max =org.exolab.castor.types.Time.parseTime(\"" + time.toString() + "\");");
                jSourceCode.add("typeValidator.setMaxInclusive(");
            }
            jSourceCode.append("max");
            jSourceCode.append(");");
            jSourceCode.unindent();
            jSourceCode.add("} catch (java.text.ParseException e) {");
            jSourceCode.indent();
            jSourceCode.add("System.out.println(e);");
            jSourceCode.add("e.printStackTrace();");
            jSourceCode.add("return;");
            jSourceCode.unindent();
            jSourceCode.add("}");
        }
        jSourceCode.add(string2 + ".setValidator(typeValidator);");
    }
}

