/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import org.exolab.castor.gui.QueryHistory;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.JDO;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.QueryResults;
import org.exolab.castor.jdo.engine.OQLQueryImpl;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;

public class QueryAnalyser {
    boolean packFrame = false;

    public QueryAnalyser(String string, String string2) {
        MainFrame mainFrame = new MainFrame(string, string2);
        if (this.packFrame) {
            mainFrame.pack();
        } else {
            mainFrame.validate();
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = mainFrame.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        ((Component)mainFrame).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        ((Component)mainFrame).setVisible(true);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.out.println("Usage: org.exolab.castor.tools.QueryAnalyser <Databasename> <Databaseconfig>");
            System.out.println("Example: org.exolab.castor.tools.QueryAnalyser testdb database.xml");
            System.exit(1);
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        new QueryAnalyser(stringArray[0], stringArray[1]);
    }

    private class MainFrame
    extends JFrame {
        QueryHistory qhistory = new QueryHistory();
        Mapping mapping = new Mapping();
        JPanel contentPane;
        BorderLayout borderLayout1 = new BorderLayout();
        DefaultTableModel model;
        JDO jdo;
        String databasename;
        String dbconfig;
        JTabbedPane TabbedPane = new JTabbedPane();
        JToolBar toolbar = new JToolBar();
        JButton btnNext = new JButton();
        JButton btnExit = new JButton();
        JPanel sqlresult = new JPanel();
        JTextPane SQLPane = new JTextPane();
        BorderLayout borderLayout3 = new BorderLayout();
        JTextPane oqlquery = new JTextPane();
        JPanel QueryPanel = new JPanel();
        BorderLayout borderLayout2 = new BorderLayout();
        JScrollPane ResultScrollpane = new JScrollPane();
        JTable ResultTable = new JTable();
        JButton execute = new JButton();
        JScrollPane ErrorScrollPane = new JScrollPane();
        JPanel ErrorPanel = new JPanel();
        JTextPane oqlerror = new JTextPane();
        BorderLayout borderLayout4 = new BorderLayout();
        JButton btnPrevious = new JButton();
        JLabel statusBar = new JLabel();

        public MainFrame(String string, String string2) {
            this.databasename = string;
            this.dbconfig = string2;
            this.enableEvents(64L);
            try {
                this.jbInit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private void jbInit() throws Exception {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            this.contentPane = (JPanel)this.getContentPane();
            this.contentPane.setLayout(this.borderLayout1);
            ((Component)this).setSize(new Dimension(600, 400));
            this.setTitle("Castor OQL-Ouery Analyser");
            this.sqlresult.setLayout(this.borderLayout3);
            this.oqlquery.setFont(new Font("Dialog", 0, 12));
            this.oqlquery.setToolTipText("create Query here");
            this.QueryPanel.setLayout(this.borderLayout2);
            this.ResultScrollpane.setToolTipText("");
            this.ResultTable.setAutoResizeMode(0);
            this.btnExit.setMaximumSize(new Dimension(50, 39));
            this.btnExit.setMinimumSize(new Dimension(50, 39));
            this.btnExit.setActionCommand("");
            this.btnExit.setIcon(new ImageIcon(classLoader.getResource("org/exolab/castor/gui/images/exit.gif")));
            this.btnExit.setMnemonic('0');
            this.btnExit.addActionListener(new ActionListener(this){
                private final /* synthetic */ MainFrame this$1;
                {
                    this.this$1 = mainFrame;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.exit();
                }
            });
            this.execute.setMaximumSize(new Dimension(50, 39));
            this.execute.setMinimumSize(new Dimension(50, 39));
            this.execute.setActionCommand("");
            this.execute.setIcon(new ImageIcon(classLoader.getResource("org/exolab/castor/gui/images/fire.gif")));
            this.execute.setMnemonic('0');
            this.execute.addActionListener(new ActionListener(this){
                private final /* synthetic */ MainFrame this$1;
                {
                    this.this$1 = mainFrame;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.execute_actionPerformed(actionEvent);
                }
            });
            this.ErrorPanel.setLayout(this.borderLayout4);
            this.btnPrevious.addActionListener(new ActionListener(this){
                private final /* synthetic */ MainFrame this$1;
                {
                    this.this$1 = mainFrame;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.btnPrevious_actionPerformed(actionEvent);
                }
            });
            this.btnNext.setMaximumSize(new Dimension(50, 39));
            this.btnNext.setMinimumSize(new Dimension(50, 39));
            this.btnNext.setActionCommand("");
            this.btnNext.setIcon(new ImageIcon(classLoader.getResource("org/exolab/castor/gui/images/arrw04e.gif")));
            this.btnNext.setMnemonic('0');
            this.btnNext.addActionListener(new ActionListener(this){
                private final /* synthetic */ MainFrame this$1;
                {
                    this.this$1 = mainFrame;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.btnNext_actionPerformed(actionEvent);
                }
            });
            this.btnPrevious.setMaximumSize(new Dimension(50, 39));
            this.btnPrevious.setMinimumSize(new Dimension(50, 39));
            this.btnPrevious.setToolTipText("Goto previous Query");
            this.btnPrevious.setIcon(new ImageIcon(classLoader.getResource("org/exolab/castor/gui/images/arrw04d.gif")));
            this.btnPrevious.setMnemonic('0');
            this.contentPane.add((Component)this.TabbedPane, "Center");
            this.contentPane.add((Component)this.toolbar, "North");
            this.toolbar.add((Component)this.btnExit, null);
            this.toolbar.add((Component)this.execute, null);
            this.toolbar.add((Component)this.btnPrevious, null);
            this.toolbar.add((Component)this.btnNext, null);
            this.contentPane.add((Component)this.statusBar, "South");
            this.TabbedPane.add((Component)this.QueryPanel, "OQL Query");
            this.QueryPanel.add((Component)this.oqlquery, "Center");
            this.TabbedPane.add((Component)this.ResultScrollpane, "Resultset");
            this.TabbedPane.add((Component)this.ErrorScrollPane, "Stacktrace");
            this.ErrorScrollPane.getViewport().add((Component)this.ErrorPanel, null);
            this.ErrorPanel.add((Component)this.oqlerror, "Center");
            this.TabbedPane.add((Component)this.sqlresult, "SQL");
            this.sqlresult.add((Component)this.SQLPane, "Center");
            this.ResultScrollpane.getViewport().add((Component)this.ResultTable, null);
            this.openDB();
            this.statusBar.setText("Database " + this.jdo.getDatabaseName() + " waiting for Queries");
            this.loadHistory();
            this.oqlquery.setText(this.qhistory.GetCurrentQuery());
        }

        protected void processWindowEvent(WindowEvent windowEvent) {
            super.processWindowEvent(windowEvent);
            if (windowEvent.getID() == 201) {
                this.exit();
            }
        }

        void execute_actionPerformed(ActionEvent actionEvent) {
            this.performQuery();
        }

        public void performQuery() {
            boolean bl = true;
            Vector vector = null;
            this.model = new DefaultTableModel();
            try {
                this.statusBar.setText("performing Query");
                this.clearTabs();
                Database database = this.jdo.getDatabase();
                database.begin();
                this.qhistory.addQuery(this.oqlquery.getText());
                OQLQuery oQLQuery = database.getOQLQuery(this.oqlquery.getText());
                Date date = new Date();
                QueryResults queryResults = oQLQuery.execute((short)0);
                Date date2 = new Date();
                this.statusBar.setText("Query successful, Time: " + (date2.getTime() - date.getTime()) + " ms");
                this.SQLPane.setText(((OQLQueryImpl)oQLQuery).getSQL());
                while (queryResults.hasMore()) {
                    Object object = queryResults.next();
                    if (bl) {
                        vector = this.getProperties(object);
                        this.FillTableHeader(vector, this.model);
                        bl = false;
                    }
                    this.model.addRow(this.fillRow(vector, object));
                }
                database.commit();
                this.ResultTable.setModel(this.model);
                this.ResultTable.repaint();
                this.TabbedPane.setSelectedComponent(this.ResultScrollpane);
            }
            catch (Exception exception) {
                StringWriter stringWriter = new StringWriter();
                exception.printStackTrace(new PrintWriter(stringWriter));
                this.oqlerror.setText(stringWriter.getBuffer().toString());
                this.statusBar.setText(exception.getMessage());
            }
        }

        private Vector getProperties(Object object) {
            Vector<Method> vector = new Vector<Method>();
            Method[] methodArray = object.getClass().getMethods();
            int n = 0;
            while (n < methodArray.length) {
                Method method = methodArray[n];
                if (method.getName().startsWith("get") && method.getParameterTypes().length == 0) {
                    vector.add(method);
                }
                ++n;
            }
            return vector;
        }

        private void FillTableHeader(Vector vector, DefaultTableModel defaultTableModel) {
            Iterator iterator = ((AbstractList)vector).iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                Method method = (Method)iterator.next();
                defaultTableModel.addColumn(method.getName().substring(3));
            }
        }

        private Vector fillRow(Vector vector, Object object) {
            Vector<Object> vector2 = new Vector<Object>();
            Iterator iterator = ((AbstractList)vector).iterator();
            while (iterator.hasNext()) {
                Object object2 = null;
                Method method = (Method)iterator.next();
                try {
                    object2 = method.invoke(object, null);
                }
                catch (Exception exception) {
                    object2 = null;
                }
                vector2.add(object2);
            }
            return vector2;
        }

        private void openDB() {
            try {
                this.jdo = new JDO();
                this.jdo.setDatabaseName(this.databasename);
                this.jdo.setConfiguration(this.dbconfig);
                this.jdo.setClassLoader(ClassLoader.getSystemClassLoader());
                Database database = this.jdo.getDatabase();
            }
            catch (PersistenceException persistenceException) {
                persistenceException.printStackTrace();
                System.exit(1);
            }
        }

        private void clearTabs() {
            this.oqlerror.setText("");
            this.SQLPane.setText("");
            this.ResultTable.setModel(new DefaultTableModel());
        }

        void btnPrevious_actionPerformed(ActionEvent actionEvent) {
            this.clearTabs();
            this.oqlquery.setText(this.qhistory.getPreviousQuery());
            this.TabbedPane.setSelectedComponent(this.QueryPanel);
        }

        void btnNext_actionPerformed(ActionEvent actionEvent) {
            this.clearTabs();
            this.oqlquery.setText(this.qhistory.getNextQuery());
            this.TabbedPane.setSelectedComponent(this.QueryPanel);
        }

        public void saveHistory() {
            try {
                FileWriter fileWriter = new FileWriter("queryhistory.xml");
                Marshaller marshaller = new Marshaller(fileWriter);
                marshaller.setMapping(this.mapping);
                marshaller.marshal(this.qhistory);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private void loadHistory() {
            try {
                Unmarshaller unmarshaller = new Unmarshaller(Class.forName("org.exolab.castor.gui.QueryHistory"));
                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                this.mapping.loadMapping(classLoader.getResource("org/exolab/castor/gui/Queryanlyser.xml"));
                unmarshaller.setMapping(this.mapping);
                FileReader fileReader = new FileReader("queryhistory.xml");
                this.qhistory = (QueryHistory)unmarshaller.unmarshal(fileReader);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        void exit() {
            this.saveHistory();
            System.exit(0);
        }
    }
}

