/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.TransactionAbortedException;
import org.exolab.castor.jdo.engine.DatabaseRegistry;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.TransactionContext;
import org.exolab.castor.util.Messages;

final class TransactionContextImpl
extends TransactionContext {
    private Hashtable _conns = new Hashtable();
    private boolean _globalTx;

    public TransactionContextImpl(Database database, boolean bl) {
        super(database);
        this._globalTx = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void commitConnections() throws TransactionAbortedException {
        Enumeration enumeration;
        if (this._globalTx) {
            this._conns.clear();
            return;
        }
        try {
            Enumeration enumeration2;
            try {
                enumeration2 = this._conns.elements();
                while (enumeration2.hasMoreElements()) {
                    Connection connection = (Connection)enumeration2.nextElement();
                    connection.commit();
                }
            }
            catch (SQLException sQLException) {
                throw new TransactionAbortedException(Messages.format("persist.nested", sQLException), sQLException);
            }
            Object var5_4 = null;
            enumeration2 = this._conns.elements();
            while (true) {
                if (!enumeration2.hasMoreElements()) break;
                try {
                    ((Connection)enumeration2.nextElement()).close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this._conns.clear();
            return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            enumeration = this._conns.elements();
        }
        while (true) {
            if (!enumeration.hasMoreElements()) {
                this._conns.clear();
                throw throwable;
            }
            try {}
            catch (SQLException sQLException) {
                // empty catch block
                continue;
            }
            ((Connection)enumeration.nextElement()).close();
            continue;
            break;
        }
    }

    protected void closeConnections() throws TransactionAbortedException {
        SQLException sQLException = null;
        if (!this._globalTx) {
            return;
        }
        Enumeration enumeration = this._conns.elements();
        while (enumeration.hasMoreElements()) {
            Connection connection = (Connection)enumeration.nextElement();
            try {
                connection.close();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
        }
        this._conns.clear();
        if (sQLException != null) {
            throw new TransactionAbortedException(Messages.format("persist.nested", sQLException), sQLException);
        }
    }

    protected void rollbackConnections() {
        Enumeration enumeration = this._conns.elements();
        while (enumeration.hasMoreElements()) {
            Connection connection = (Connection)enumeration.nextElement();
            try {
                if (!this._globalTx) {
                    connection.rollback();
                }
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this._conns.clear();
    }

    public Object getConnection(LockEngine lockEngine) throws PersistenceException {
        Connection connection = (Connection)this._conns.get(lockEngine);
        if (connection == null) {
            try {
                connection = DatabaseRegistry.createConnection(lockEngine);
                if (!this._globalTx) {
                    connection.setAutoCommit(false);
                }
                this._conns.put(lockEngine, connection);
            }
            catch (SQLException sQLException) {
                throw new PersistenceException(Messages.format("persist.nested", sQLException), sQLException);
            }
        }
        return connection;
    }
}

