/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import java.util.Enumeration;
import java.util.Vector;
import org.xml.sax.helpers.AttributeListImpl;

public final class Namespaces {
    private Namespace _first = null;
    private Namespace _last = null;
    private Namespaces _parent = null;
    private static final String CDATA = "CDATA";
    private static final String XMLNS = "xmlns";

    public Namespaces() {
    }

    public Namespaces(Namespaces namespaces) {
        this._parent = namespaces;
    }

    public void addNamespace(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("Namespace URI must not be null");
        }
        if (string == null) {
            string = "";
        }
        if (this._first == null) {
            this._last = this._first = new Namespace(string, string2);
        } else {
            boolean bl = false;
            Namespace namespace = this._first;
            while (namespace != null) {
                if (namespace.prefix.equals(string)) {
                    bl = true;
                    namespace.uri = string2;
                    break;
                }
                namespace = namespace.next;
            }
            if (!bl) {
                this._last = this._last.next = new Namespace(string, string2);
            }
        }
    }

    public Namespaces createNamespaces() {
        return new Namespaces(this);
    }

    public Enumeration getLocalNamespaces() {
        return new NamespaceEnumerator(this._first);
    }

    public String getNamespaceURI(String string) {
        if (string == null) {
            string = "";
        }
        Namespace namespace = this._first;
        while (namespace != null) {
            if (namespace.prefix.equals(string)) {
                return namespace.uri;
            }
            namespace = namespace.next;
        }
        if (this._parent != null) {
            return this._parent.getNamespaceURI(string);
        }
        return null;
    }

    public String getNamespacePrefix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Namespace URI must not be null.");
        }
        Namespace namespace = this._first;
        while (namespace != null) {
            if (namespace.uri.equals(string)) {
                return namespace.prefix;
            }
            namespace = namespace.next;
        }
        if (this._parent != null) {
            return this._parent.getNamespacePrefix(string);
        }
        return null;
    }

    public String[] getNamespacePrefixes(String string) {
        return this.getNamespacePrefixes(string, false);
    }

    public String[] getNamespacePrefixes(String string, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("Namespace URI must not be null.");
        }
        Vector vector = new Vector(3);
        this.getNamespacePrefixes(string, bl, vector);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String getNonDefaultNamespacePrefix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Namespace URI must not be null.");
        }
        Namespace namespace = this._first;
        while (namespace != null) {
            if (namespace.uri.equals(string) && namespace.prefix.length() > 0) {
                return namespace.prefix;
            }
            namespace = namespace.next;
        }
        if (this._parent != null) {
            return this._parent.getNonDefaultNamespacePrefix(string);
        }
        return null;
    }

    public Namespaces getParent() {
        return this._parent;
    }

    public void setParent(Namespaces namespaces) {
        this._parent = namespaces;
    }

    public void declareAsAttributes(AttributeListImpl attributeListImpl, boolean bl) {
        Namespace namespace = this._first;
        String string = null;
        while (namespace != null) {
            if (namespace.prefix != null) {
                int n = namespace.prefix.length();
                if (n > 0) {
                    StringBuffer stringBuffer = new StringBuffer(6 + n);
                    stringBuffer.append(XMLNS);
                    stringBuffer.append(':');
                    stringBuffer.append(namespace.prefix);
                    string = stringBuffer.toString();
                    attributeListImpl.addAttribute(string, CDATA, namespace.uri);
                } else {
                    attributeListImpl.addAttribute(XMLNS, CDATA, namespace.uri);
                }
            } else {
                attributeListImpl.addAttribute(XMLNS, CDATA, namespace.uri);
            }
            namespace = namespace.next;
        }
        if (!bl && this._parent != null) {
            this._parent.declareAsAttributes(attributeListImpl, false);
        }
    }

    private void getNamespacePrefixes(String string, boolean bl, Vector vector) {
        Namespace namespace = this._first;
        while (namespace != null) {
            if (namespace.uri.equals(string)) {
                vector.addElement(namespace.prefix);
            }
            namespace = namespace.next;
        }
        if (this._parent != null && bl) {
            this._parent.getNamespacePrefixes(string, bl, vector);
        }
    }

    class NamespaceEnumerator
    implements Enumeration {
        private Namespace _namespace = null;

        NamespaceEnumerator(Namespace namespace) {
            this._namespace = namespace;
        }

        public boolean hasMoreElements() {
            return this._namespace != null;
        }

        public Object nextElement() {
            String string = null;
            if (this._namespace != null) {
                string = this._namespace.uri;
                this._namespace = this._namespace.next;
            }
            return string;
        }
    }

    class Namespace {
        String prefix = null;
        String uri = null;
        Namespace next = null;

        Namespace() {
        }

        Namespace(String string, String string2) {
            this.prefix = string;
            this.uri = string2;
        }
    }
}

