/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.Form;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.SimpleTypeReference;
import org.exolab.castor.xml.schema.Structure;

public final class AttributeDecl
extends Annotated {
    public static final String USE_OPTIONAL = "optional";
    public static final String USE_PROHIBITED = "prohibited";
    public static final String USE_REQUIRED = "required";
    private static final short OPTIONAL = 3;
    private static final short PROHIBITED = 4;
    private static final short REQUIRED = 5;
    private static String NULL_ARGUMENT = "A null argument was passed to the constructor of " + (class$org$exolab$castor$xml$schema$AttributeDecl == null ? (class$org$exolab$castor$xml$schema$AttributeDecl = AttributeDecl.class$("org.exolab.castor.xml.schema.AttributeDecl")) : class$org$exolab$castor$xml$schema$AttributeDecl).getName();
    private Form _form = null;
    private String _id = null;
    private String _name = null;
    private Structure _parent = null;
    private Schema _schema = null;
    private SimpleType _simpleType = null;
    private short _useFlag = (short)3;
    private String _fixed = null;
    private String _default = null;
    private String _attributeRef = null;
    static /* synthetic */ Class class$org$exolab$castor$xml$schema$AttributeDecl;

    public AttributeDecl(Schema schema, String string) {
        if (schema == null) {
            String string2 = NULL_ARGUMENT + "; 'schema' must not be null.";
            throw new IllegalArgumentException(string2);
        }
        this._schema = schema;
        this.setName(string);
    }

    public AttributeDecl(Schema schema) {
        if (schema == null) {
            String string = NULL_ARGUMENT + "; 'schema' must not be null.";
            throw new IllegalArgumentException(string);
        }
        this._schema = schema;
    }

    public Form getForm() {
        return this._form;
    }

    public String getId() {
        return this._id;
    }

    public String getName() {
        return this.getName(false);
    }

    public String getName(boolean bl) {
        if (this.isReference() && !bl) {
            return this._attributeRef;
        }
        return this._name;
    }

    public Structure getParent() {
        return this._parent;
    }

    public SimpleType getSimpleType() {
        if (this.isReference()) {
            AttributeDecl attributeDecl = this.getReference();
            if (attributeDecl != null) {
                return attributeDecl.getSimpleType();
            }
            return null;
        }
        if (this._simpleType == null) {
            return null;
        }
        return (SimpleType)this._simpleType.getType();
    }

    public AttributeDecl getReference() {
        AttributeDecl attributeDecl = null;
        if (this._attributeRef != null && (attributeDecl = this._schema.getAttribute(this._attributeRef)) == null) {
            String string = "Unable to find attribute referenced :\" ";
            string = string + this.getName();
            string = string + "\"";
            throw new IllegalStateException(string);
        }
        return attributeDecl;
    }

    public Schema getSchema() {
        return this._schema;
    }

    public String getUse() {
        if (this.isReference()) {
            AttributeDecl attributeDecl = this.getReference();
            if (attributeDecl != null) {
                return attributeDecl.getUse();
            }
            return null;
        }
        switch (this._useFlag) {
            case 4: {
                return USE_PROHIBITED;
            }
            case 5: {
                return USE_REQUIRED;
            }
        }
        return USE_OPTIONAL;
    }

    public String getDefaultValue() {
        return this._default;
    }

    public String getFixedValue() {
        return this._fixed;
    }

    public boolean isDefault() {
        return this._default != null && this._default.length() > 0;
    }

    public boolean isFixed() {
        return this._fixed != null && this._fixed.length() > 0;
    }

    public boolean isOptional() {
        String string = this.getUse();
        return string.equals(USE_OPTIONAL);
    }

    public boolean isProhibited() {
        String string = this.getUse();
        return string.equals(USE_PROHIBITED);
    }

    public boolean isRequired() {
        String string = this.getUse();
        return string.equals(USE_REQUIRED);
    }

    public boolean isReference() {
        return this._attributeRef != null;
    }

    public void setForm(Form form) {
        this._form = form;
    }

    public void setId(String string) {
        this._id = string;
    }

    public void setName(String string) {
        String string2;
        if (string == null) {
            String string3 = "AttributeDecl#setName: 'name' must not be null.";
            throw new IllegalArgumentException(string3);
        }
        int n = string.indexOf(58);
        if (n >= 0) {
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
        }
        if (string.length() == 0) {
            string2 = "AttributeDecl#setName: 'name' must not be zero-length.";
            throw new IllegalArgumentException(string2);
        }
        this._name = string;
    }

    protected void setParent(Structure structure) {
        if (structure != null) {
            switch (structure.getStructureType()) {
                case 4: 
                case 6: 
                case 19: {
                    break;
                }
                default: {
                    String string = "Invalid parent for group";
                    throw new IllegalArgumentException(string);
                }
            }
        }
        this._parent = structure;
    }

    public void setReference(AttributeDecl attributeDecl) {
        this._attributeRef = attributeDecl == null ? null : attributeDecl.getName();
    }

    public void setReference(String string) {
        this._attributeRef = string;
    }

    public void setSimpleType(SimpleType simpleType) {
        this._simpleType = simpleType;
        if (simpleType != null) {
            simpleType.setParent(this);
        }
    }

    public void setSimpleTypeReference(String string) {
        SimpleTypeReference simpleTypeReference = new SimpleTypeReference(this._schema, string);
        this.setSimpleType(simpleTypeReference);
    }

    public void setUse(String string) {
        if (string == null) {
            this._useFlag = (short)3;
            return;
        }
        if (string.equals(USE_REQUIRED)) {
            this._useFlag = (short)5;
        } else if (string.equals(USE_OPTIONAL)) {
            this._useFlag = (short)3;
        } else if (string.equals(USE_PROHIBITED)) {
            this._useFlag = (short)4;
        } else {
            throw new IllegalArgumentException("Invalid value for 'use': " + string);
        }
    }

    public void setDefaultValue(String string) {
        if (this._fixed != null && this._fixed.length() > 0) {
            throw new IllegalStateException("'default' and 'fixed' must not be both present.");
        }
        this._default = string;
    }

    public void setFixedValue(String string) {
        if (this._default != null && this._default.length() > 0) {
            throw new IllegalStateException("'default' and 'fixed' must not be both present.");
        }
        this._fixed = string;
    }

    public short getStructureType() {
        return 3;
    }

    public void validate() throws ValidationException {
        if (this._attributeRef == null && this._name == null) {
            String string = "<attribute> is missing required 'name' attribute.";
            throw new ValidationException(string);
        }
        if (this._attributeRef != null) {
            if (this._schema.getAttribute(this._attributeRef) == null) {
                String string = "<attribute ref=\"" + this._attributeRef + "\"> " + "is not resolvable.";
                throw new ValidationException(string);
            }
            return;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

