/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import java.io.IOException;
import java.io.Reader;
import org.exolab.castor.net.URIResolver;
import org.exolab.castor.util.Configuration;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.util.NestedIOException;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.reader.Sax2ComponentReader;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshaller;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshallerState;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SchemaReader {
    private Configuration _config = LocalConfiguration.getInstance();
    private Parser _parser = null;
    private InputSource _source = null;
    private EntityResolver _resolver = null;
    private URIResolver _uriResolver;
    private Schema _schema = null;
    private boolean _validate = true;

    private SchemaReader() throws IOException {
        Parser parser = null;
        parser = this._config.getParser();
        if (parser == null) {
            throw new IOException("fatal error: unable to create SAX parser.");
        }
        this._parser = parser;
    }

    public SchemaReader(InputSource inputSource) throws IOException {
        this();
        if (inputSource == null) {
            throw new IllegalArgumentException("InputSource cannot be null");
        }
        this._source = inputSource;
    }

    public SchemaReader(Reader reader, String string) throws IOException {
        this();
        if (reader == null) {
            String string2 = "The argument 'reader' must not be null.";
            throw new IllegalArgumentException(string2);
        }
        this._source = new InputSource(reader);
        if (string == null) {
            string = reader.toString();
        }
        this._source.setPublicId(string);
    }

    public SchemaReader(String string) throws IOException {
        this();
        if (string == null) {
            String string2 = "The argument 'url' must not be null.";
            throw new IllegalArgumentException(string2);
        }
        this._source = new InputSource(string);
    }

    public Schema read() throws IOException {
        if (this._schema != null) {
            return this._schema;
        }
        SchemaUnmarshaller schemaUnmarshaller = null;
        try {
            SchemaUnmarshallerState schemaUnmarshallerState = new SchemaUnmarshallerState();
            schemaUnmarshallerState.setConfiguration(this._config);
            schemaUnmarshaller = new SchemaUnmarshaller(schemaUnmarshallerState);
            if (this._uriResolver != null) {
                schemaUnmarshaller.setURIResolver(this._uriResolver);
            }
            Sax2ComponentReader sax2ComponentReader = new Sax2ComponentReader(schemaUnmarshaller);
            this._parser.setDocumentHandler(sax2ComponentReader);
            this._parser.setErrorHandler(sax2ComponentReader);
            if (this._resolver != null) {
                this._parser.setEntityResolver(this._resolver);
            }
            this._parser.parse(this._source);
        }
        catch (XMLException xMLException) {
            this.handleException(xMLException);
        }
        catch (SAXException sAXException) {
            this.handleException(sAXException);
        }
        this._schema = schemaUnmarshaller.getSchema();
        if (this._validate) {
            try {
                this._schema.validate();
            }
            catch (ValidationException validationException) {
                throw new NestedIOException(validationException);
            }
        }
        return this._schema;
    }

    public void setValidation(boolean bl) {
        this._validate = bl;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this._resolver = entityResolver;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this._uriResolver = uRIResolver;
    }

    private void handleException(XMLException xMLException) throws IOException {
        Exception exception = xMLException.getException();
        if (exception == null) {
            exception = xMLException;
        } else if (exception instanceof SAXException) {
            this.handleException((SAXException)exception);
        } else if (exception instanceof XMLException) {
            this.handleException((XMLException)exception);
        }
        throw new NestedIOException(exception);
    }

    private void handleException(SAXException sAXException) throws IOException {
        Exception exception = sAXException.getException();
        if (exception == null) {
            exception = sAXException;
        } else {
            if (exception instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)exception;
                String string = sAXParseException.getSystemId();
                if (string == null) {
                    string = sAXParseException.getPublicId();
                }
                if (string == null) {
                    string = "<filename unavailable>";
                }
                String string2 = sAXParseException.getMessage();
                string2 = string2 + "; " + string + " [ line: " + sAXParseException.getLineNumber();
                string2 = string2 + ", column: " + sAXParseException.getColumnNumber() + ']';
                throw new NestedIOException(string2, exception);
            }
            if (exception instanceof XMLException) {
                this.handleException((XMLException)exception);
            }
        }
        throw new NestedIOException(exception);
    }
}

