/*
 * Decompiled with CFR 0.152.
 */
package pm.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import pm.utilities.PM_UtilsGrafik;

public class PM_Cut
extends JPanel
implements MouseListener,
MouseMotionListener {
    private Rectangle2D rectangleResize = new Rectangle2D.Double();
    private Point pointPressed = new Point();
    private Cursor cursor = new Cursor(0);
    private Rectangle2D recNW = null;
    private Rectangle2D recNE = null;
    private Rectangle2D recSW = null;
    private Rectangle2D recSE = null;
    private Rectangle2D recN = null;
    private Rectangle2D recE = null;
    private Rectangle2D recS = null;
    private Rectangle2D recW = null;
    private Point correct = new Point();

    protected PM_Cut() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    protected void setRectangleResized(Rectangle2D rectangle2D, AffineTransform affineTransform) {
        this.rectangleResize = rectangle2D;
    }

    protected boolean move() {
        return true;
    }

    protected boolean resizeDiagonal() {
        return true;
    }

    protected boolean resizeDiagonalSymmetrich() {
        return false;
    }

    protected boolean resizeVertiHorizontal() {
        return false;
    }

    protected boolean resizeVertiHoriSymmetrich() {
        return false;
    }

    protected Rectangle2D getRectangleResize() {
        return null;
    }

    protected Rectangle2D getRectangleResizeOtherSize() {
        return null;
    }

    protected Rectangle2D getRectangleMax() {
        return null;
    }

    protected void drawRectangleResize(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.YELLOW);
        graphics2D.draw(this.getRectangleResize());
    }

    protected void drawRectangleResize(Graphics graphics, Point point) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.correct = point;
        Rectangle rectangle = PM_UtilsGrafik.rectangle2DToRectangle(this.getRectangleResize());
        if (rectangle == null) {
            return;
        }
        if (rectangle.getWidth() == 0.0 || rectangle.getHeight() == 0.0) {
            return;
        }
        this.drawRectangleResize(graphics);
        if (!this.resizeOrMove()) {
            return;
        }
        this.recNW = null;
        this.recNE = null;
        this.recSW = null;
        this.recSE = null;
        this.recN = null;
        this.recE = null;
        this.recS = null;
        this.recW = null;
        if (this.resizeDiagonal()) {
            this.recNW = this.getAndDrawAnfasser(this.getPointAnfasser(rectangle, 6), graphics2D);
            this.recNE = this.getAndDrawAnfasser(this.getPointAnfasser(rectangle, 7), graphics2D);
            this.recSW = this.getAndDrawAnfasser(this.getPointAnfasser(rectangle, 4), graphics2D);
            this.recSE = this.getAndDrawAnfasser(this.getPointAnfasser(rectangle, 5), graphics2D);
        }
        if (this.resizeVertiHorizontal()) {
            this.recN = this.getAndDrawAnfasser(this.getPointAnfasser(rectangle, 8), graphics2D);
            this.recE = this.getAndDrawAnfasser(this.getPointAnfasser(rectangle, 11), graphics2D);
            this.recS = this.getAndDrawAnfasser(this.getPointAnfasser(rectangle, 9), graphics2D);
            this.recW = this.getAndDrawAnfasser(this.getPointAnfasser(rectangle, 10), graphics2D);
        }
    }

    private Point2D getPointAnfasser(Rectangle2D rectangle2D, int n) {
        switch (n) {
            case 6: {
                return new Point2D.Double(rectangle2D.getX(), rectangle2D.getY());
            }
            case 7: {
                return new Point2D.Double(rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY());
            }
            case 5: {
                return new Point2D.Double(rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY() + rectangle2D.getHeight());
            }
            case 4: {
                return new Point2D.Double(rectangle2D.getX(), rectangle2D.getY() + rectangle2D.getHeight());
            }
            case 8: {
                return new Point2D.Double(rectangle2D.getX() + rectangle2D.getWidth() / 2.0, rectangle2D.getY());
            }
            case 11: {
                return new Point2D.Double(rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY() + rectangle2D.getHeight() / 2.0);
            }
            case 9: {
                return new Point2D.Double(rectangle2D.getX() + rectangle2D.getWidth() / 2.0, rectangle2D.getY() + rectangle2D.getHeight());
            }
            case 10: {
                return new Point2D.Double(rectangle2D.getX(), rectangle2D.getY() + rectangle2D.getHeight() / 2.0);
            }
        }
        return new Point();
    }

    private Point2D getTranslationPoint(Rectangle2D rectangle2D, int n) {
        switch (n) {
            case 6: {
                return this.getPointAnfasser(rectangle2D, 5);
            }
            case 7: {
                return this.getPointAnfasser(rectangle2D, 4);
            }
            case 5: {
                return this.getPointAnfasser(rectangle2D, 6);
            }
            case 4: {
                return this.getPointAnfasser(rectangle2D, 7);
            }
            case 8: {
                return this.getPointAnfasser(rectangle2D, 9);
            }
            case 11: {
                return this.getPointAnfasser(rectangle2D, 10);
            }
            case 9: {
                return this.getPointAnfasser(rectangle2D, 8);
            }
            case 10: {
                return this.getPointAnfasser(rectangle2D, 11);
            }
        }
        return new Point();
    }

    private Rectangle2D getAndDrawAnfasser(Point2D point2D, Graphics2D graphics2D) {
        Rectangle2D rectangle2D = new Rectangle2D.Double(point2D.getX(), point2D.getY(), 0.0, 0.0);
        int n = 4;
        rectangle2D = PM_UtilsGrafik.grow(rectangle2D, new Point2D.Double(n, n));
        graphics2D.fill(rectangle2D);
        graphics2D.draw(rectangle2D);
        return rectangle2D;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.resizeOrMove()) {
            return;
        }
        Point point = this.getCursorPoint(mouseEvent);
        this.pointPressed.setLocation(point);
        this.rectangleResize = this.getRectangleResize();
        this.cursor = this.getCursor();
        if (this.recNW != null && this.recNW.contains(point)) {
            this.setCursor(new Cursor(6));
            return;
        }
        if (this.recNE != null && this.recNE.contains(point)) {
            this.setCursor(new Cursor(7));
            return;
        }
        if (this.recSW != null && this.recSW.contains(point)) {
            this.setCursor(new Cursor(4));
            return;
        }
        if (this.recSE != null && this.recSE.contains(point)) {
            this.setCursor(new Cursor(5));
            return;
        }
        if (this.recN != null && this.recN.contains(point)) {
            this.setCursor(new Cursor(8));
            return;
        }
        if (this.recE != null && this.recE.contains(point)) {
            this.setCursor(new Cursor(11));
            return;
        }
        if (this.recS != null && this.recS.contains(point)) {
            this.setCursor(new Cursor(9));
            return;
        }
        if (this.recW != null && this.recW.contains(point)) {
            this.setCursor(new Cursor(10));
            return;
        }
        this.setCursor(new Cursor(13));
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.resizeOrMove()) {
            return;
        }
        this.setCursor(this.cursor);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.resizeOrMove()) {
            return;
        }
        int n = this.getCursor().getType();
        Point point = new Point(this.pointPressed);
        this.pointPressed.setLocation(this.getCursorPoint(mouseEvent));
        AffineTransform affineTransform = new AffineTransform();
        Point2D point2D = null;
        Point2D point2D2 = this.getTranslationPoint(this.rectangleResize, n);
        if (n == 13) {
            double d = this.pointPressed.getX() - point.getX();
            double d2 = this.pointPressed.getY() - point.getY();
            affineTransform.translate(d, d2);
        } else {
            point2D = this.getScaling(this.rectangleResize, point2D2, this.pointPressed, n);
            affineTransform.translate(point2D2.getX(), point2D2.getY());
            affineTransform.scale(point2D.getX(), point2D.getY());
            affineTransform.translate(-point2D2.getX(), -point2D2.getY());
        }
        this.rectangleResize = affineTransform.createTransformedShape(this.rectangleResize).getBounds2D();
        this.setRectangleResized(this.rectangleResize, affineTransform);
        this.repaint();
    }

    private Point2D getScaling(Rectangle2D rectangle2D, Point2D point2D, Point2D point2D2, int n) {
        double d = point2D2.getX() - point2D.getX();
        double d2 = point2D2.getY() - point2D.getY();
        double d3 = 1.0;
        double d4 = 1.0;
        Point2D.Double double_ = new Point2D.Double(1.0, 1.0);
        switch (n) {
            case 6: 
            case 7: {
                d2 = Math.abs(d2);
                if (d2 < 20.0) {
                    d2 = 20.0;
                }
                d4 = d2 / rectangle2D.getHeight();
                return new Point2D.Double(d4, d4);
            }
            case 4: 
            case 5: {
                d2 = Math.abs(d2);
                if (d2 < 20.0) {
                    d2 = 20.0;
                }
                d4 = d2 / rectangle2D.getHeight();
                return new Point2D.Double(d4, d4);
            }
            case 8: {
                d2 = Math.abs(d2);
                if (d2 < 20.0) {
                    d2 = 20.0;
                }
                d4 = d2 / rectangle2D.getHeight();
                return new Point2D.Double(1.0, d4);
            }
            case 11: {
                if (d < 20.0) {
                    d = 20.0;
                }
                d3 = d / rectangle2D.getWidth();
                return new Point2D.Double(d3, 1.0);
            }
            case 9: {
                if (d2 < 20.0) {
                    d2 = 20.0;
                }
                d4 = d2 / rectangle2D.getHeight();
                return new Point2D.Double(1.0, d4);
            }
            case 10: {
                d = Math.abs(d);
                if (d < 20.0) {
                    d = 20.0;
                }
                d3 = d / rectangle2D.getWidth();
                return new Point2D.Double(d3, 1.0);
            }
        }
        return double_;
    }

    private boolean resizeOrMove() {
        return this.resizeDiagonal() || this.resizeVertiHorizontal() || this.move();
    }

    private Point getCursorPoint(MouseEvent mouseEvent) {
        return new Point(mouseEvent.getX() - this.correct.x, mouseEvent.getY() - this.correct.y);
    }
}

