/*
 * Decompiled with CFR 0.152.
 */
package pm.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pm.gui.PM_WindowExtern;
import pm.inout.PM_All_ExternalPrograms;
import pm.inout.PM_ExternalProgram;
import pm.utilities.PM_Action;
import pm.utilities.PM_Listener;
import pm.utilities.PM_MSG;

public class PM_WindowExternalSetup
extends PM_WindowExtern {
    private JList liste = null;
    private JTextField pfadListe = null;
    private JTextField pfadName = null;
    private JTextField progName = null;
    private int lastSelected = -1;
    private Border border;
    private Vector<PM_Listener> listenerExterneProgramme = new Vector();
    private JLabel labelProgramPath;
    private JLabel labelShortName;
    private JButton buttonUebernehmen;
    private TitledBorder titleSetup;
    private JButton buttonTestenOben;
    private TitledBorder titleAllPrograms;
    private JLabel labelAllNames;
    private JButton buttonLoeschen;

    public PM_WindowExternalSetup() {
        this.border = BorderFactory.createLineBorder(Color.GRAY, 3);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        jPanel.add(Box.createVerticalStrut(20));
        jPanel.add(this.getPanelEinrichtenOben());
        jPanel.add(Box.createVerticalStrut(30));
        jPanel.add(this.getPanelEinrichtenUnten());
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.setzenProgrammNamen(null);
        PM_Listener pM_Listener = new PM_Listener(){

            public void actionPerformed(PM_Action pM_Action) {
                PM_WindowExternalSetup.this.setMsg();
            }
        };
        PM_MSG.addChangeListener(pM_Listener);
        this.setMsg();
    }

    private void setMsg() {
        this.labelShortName.setText(PM_MSG.getMsg("modExtShortName"));
        this.labelProgramPath.setText(PM_MSG.getMsg("modExtProgramPath"));
        this.buttonUebernehmen.setText(PM_MSG.getMsg("apply"));
        this.buttonTestenOben.setText(PM_MSG.getMsg("modExtButtonTest"));
        this.titleSetup.setTitle(PM_MSG.getMsg("modExtTitleSetup"));
        this.titleAllPrograms.setTitle(PM_MSG.getMsg("modExtTitleAllProgs"));
        this.labelAllNames.setText(PM_MSG.getMsg("modExtListNames"));
        this.buttonLoeschen.setText(PM_MSG.getMsg("modExtButtonDelete"));
    }

    public void addChangeListenerExterneProgramme(PM_Listener pM_Listener) {
        if (!this.listenerExterneProgramme.contains(pM_Listener)) {
            this.listenerExterneProgramme.add(pM_Listener);
        }
    }

    public JPanel getPanelEinrichtenOben() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        this.labelProgramPath = new JLabel(PM_MSG.getMsg("modExtProgramPath"));
        jPanel2.add(this.labelProgramPath);
        this.pfadName = new JTextField(PM_MSG.getMsg("modExtProgramPath"));
        this.pfadName.setColumns(30);
        jPanel2.add(this.pfadName);
        JButton jButton = new JButton("...");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowExternalSetup.this.pfadName.setText(PM_WindowExternalSetup.this.doFileChooser(PM_WindowExternalSetup.this.pfadName.getText()));
            }
        };
        jButton.addActionListener(actionListener);
        jPanel2.add(jButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        this.labelShortName = new JLabel("Programm-Kurzname:");
        jPanel3.add(this.labelShortName);
        this.progName = new JTextField("Kurzname");
        this.progName.setColumns(10);
        jPanel3.add(this.progName);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0));
        this.buttonUebernehmen = new JButton("\u00fcbernehmen");
        jPanel4.add(this.buttonUebernehmen);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowExternalSetup.this.doUebernehmenNeuesProgramm();
            }
        };
        this.buttonUebernehmen.addActionListener(actionListener2);
        this.buttonTestenOben = new JButton("Testen");
        jPanel4.add(this.buttonTestenOben);
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PM_WindowExternalSetup.this.waitForProcessEnde()) {
                    return;
                }
                PM_WindowExternalSetup.this.startenProgramm(PM_WindowExternalSetup.this.pfadName.getText(), "");
            }
        };
        this.buttonTestenOben.addActionListener(actionListener3);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jPanel, "North");
        this.titleSetup = BorderFactory.createTitledBorder(this.border, "Ein neues Programm aufnehmen", 2, 2);
        jPanel5.setBorder(this.titleSetup);
        return jPanel5;
    }

    public JPanel getPanelEinrichtenUnten() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        this.labelAllNames = new JLabel("Liste alle Kurznamen:");
        jPanel2.add(this.labelAllNames);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        this.liste = new JList();
        this.liste.setSelectionMode(0);
        this.liste.setPreferredSize(new Dimension(100, 0));
        this.liste.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Object e = PM_WindowExternalSetup.this.liste.getSelectedValue();
                if (e == null) {
                    return;
                }
                if (PM_WindowExternalSetup.this.lastSelected == -1) {
                    PM_ExternalProgram pM_ExternalProgram = (PM_ExternalProgram)PM_WindowExternalSetup.this.liste.getSelectedValue();
                    PM_WindowExternalSetup.this.pfadListe.setText(pM_ExternalProgram.getPath());
                    PM_WindowExternalSetup.this.lastSelected = PM_WindowExternalSetup.this.liste.getSelectedIndex();
                    PM_WindowExternalSetup.this.fireListenerExterneProgramme(pM_ExternalProgram);
                } else {
                    PM_WindowExternalSetup.this.lastSelected = -1;
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.liste);
        jPanel3.add(jScrollPane);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0));
        this.pfadListe = new JTextField();
        this.pfadListe.setColumns(30);
        jPanel4.add(this.pfadListe);
        JButton jButton = new JButton("...");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowExternalSetup.this.pfadListe.setText(PM_WindowExternalSetup.this.doFileChooser(PM_WindowExternalSetup.this.pfadListe.getText()));
                PM_ExternalProgram pM_ExternalProgram = (PM_ExternalProgram)PM_WindowExternalSetup.this.liste.getSelectedValue();
                pM_ExternalProgram.setPath(PM_WindowExternalSetup.this.pfadListe.getText());
                PM_WindowExternalSetup.this.fireListenerExterneProgramme(pM_ExternalProgram);
            }
        };
        jButton.addActionListener(actionListener);
        jPanel4.add(jButton);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(0));
        this.buttonLoeschen = new JButton("Eintrag l\u00f6schen");
        jPanel5.add(this.buttonLoeschen);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PM_WindowExternalSetup.this.waitForProcessEnde()) {
                    return;
                }
                PM_WindowExternalSetup.this.doLoeschen();
            }
        };
        this.buttonLoeschen.addActionListener(actionListener2);
        JButton jButton2 = new JButton("Testen");
        jPanel5.add(jButton2);
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PM_WindowExternalSetup.this.waitForProcessEnde()) {
                    return;
                }
                PM_WindowExternalSetup.this.startenProgramm(PM_WindowExternalSetup.this.pfadListe.getText(), "");
            }
        };
        jButton2.addActionListener(actionListener3);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        jPanel.add(jPanel5);
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.add((Component)jPanel, "North");
        this.titleAllPrograms = BorderFactory.createTitledBorder(this.border, "Alle Bearbeitungsprogramme", 2, 2);
        jPanel6.setBorder(this.titleAllPrograms);
        return jPanel6;
    }

    private void setzenProgrammNamen(PM_ExternalProgram pM_ExternalProgram) {
        Vector vector = PM_All_ExternalPrograms.getInstance().getAlleExternenProgramme();
        this.liste.setListData(vector);
        if (vector.size() == 0) {
            return;
        }
        if (pM_ExternalProgram == null) {
            this.liste.setSelectedIndex(0);
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (!vector.elementAt(i).equals(pM_ExternalProgram)) continue;
            this.liste.setSelectedIndex(i);
            return;
        }
    }

    private void fireListenerExterneProgramme(PM_ExternalProgram pM_ExternalProgram) {
        for (int i = 0; i < this.listenerExterneProgramme.size(); ++i) {
            PM_Listener pM_Listener = this.listenerExterneProgramme.elementAt(i);
            pM_Listener.actionPerformed(new PM_Action(pM_ExternalProgram));
        }
    }

    private void doUebernehmenNeuesProgramm() {
        PM_All_ExternalPrograms pM_All_ExternalPrograms = PM_All_ExternalPrograms.getInstance();
        String string = this.pfadName.getText().trim();
        String string2 = this.progName.getText().trim();
        PM_ExternalProgram pM_ExternalProgram = pM_All_ExternalPrograms.getExternesProgramm(string2);
        if (string2.length() == 0 || pM_ExternalProgram != null) {
            String string3 = PM_MSG.getMsg("modExtMsgNoValid");
            JOptionPane.showConfirmDialog(this, string3, "Name falsch", -1, 0);
            return;
        }
        pM_ExternalProgram = new PM_ExternalProgram(string2, string, false);
        pM_All_ExternalPrograms.addExternalProgram(pM_ExternalProgram);
        this.setzenProgrammNamen(pM_ExternalProgram);
        this.fireListenerExterneProgramme(pM_ExternalProgram);
    }

    private void doLoeschen() {
        int n = JOptionPane.showConfirmDialog(this, PM_MSG.getMsg("modExtMsgDeleteLine"), " ", 0, 3);
        if (n == 1) {
            return;
        }
        PM_ExternalProgram pM_ExternalProgram = (PM_ExternalProgram)this.liste.getSelectedValue();
        PM_All_ExternalPrograms.getInstance().removeExternalProgram(pM_ExternalProgram);
        this.setzenProgrammNamen(null);
        this.fireListenerExterneProgramme(null);
    }

    private String doFileChooser(String string) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setSelectedFile(new File(string));
        int n = jFileChooser.showOpenDialog(null);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            return file.getPath();
        }
        return "";
    }

    protected void processEnde() {
    }
}

