/*
 * Decompiled with CFR 0.152.
 */
package pm.gui;

import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import pm.gui.PM_IndexView;
import pm.picture.PM_Picture;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_WindowGroupData
implements PM_Interface {
    private final PM_IndexView indexView;
    private SortedSet gleicheIndizes1 = new TreeSet();
    private SortedSet gleicheIndizes2 = new TreeSet();
    private boolean ungleicheIndizes1 = false;
    private boolean ungleicheIndizes2 = false;
    private final int INDEX_1 = 1;
    private final int INDEX_2 = 2;
    private int qs = 0;

    public PM_WindowGroupData(PM_IndexView pM_IndexView) {
        this.indexView = pM_IndexView;
    }

    public void setValues() {
        RetSortedSet retSortedSet = this.getAllEqualsIndices(1);
        this.gleicheIndizes1 = retSortedSet.sortedSet;
        this.ungleicheIndizes1 = retSortedSet.ungleiche;
        retSortedSet = this.getAllEqualsIndices(2);
        this.gleicheIndizes2 = retSortedSet.sortedSet;
        this.ungleicheIndizes2 = retSortedSet.ungleiche;
        this.qs = this.getQSFromAll();
    }

    protected SortedSet getGleicheIndizes1() {
        return this.gleicheIndizes1;
    }

    protected SortedSet getGleicheIndizes2() {
        return this.gleicheIndizes2;
    }

    protected boolean hasUngleicheIndizes1() {
        return this.ungleicheIndizes1;
    }

    protected boolean hasUngleicheIndizes2() {
        return this.ungleicheIndizes2;
    }

    protected int getQs() {
        return this.qs;
    }

    protected boolean hasThumbs() {
        return this.indexView.sizeDargestellt() != 0;
    }

    private RetSortedSet getAllEqualsIndices(int n) {
        boolean bl = false;
        SortedSet<Object> sortedSet = new TreeSet();
        boolean bl2 = true;
        List<PM_Picture> list = this.indexView.getPictureListDarstellen();
        for (PM_Picture pM_Picture : list) {
            if (bl2) {
                bl2 = false;
                sortedSet = this.getSortedSetIndex(n, pM_Picture);
                continue;
            }
            int n2 = sortedSet.size();
            SortedSet<String> sortedSet2 = this.getSortedSetIndex(n, pM_Picture);
            sortedSet.retainAll(sortedSet2);
            if (sortedSet2.size() == sortedSet.size() && n2 == sortedSet2.size()) continue;
            bl = true;
        }
        return new RetSortedSet(sortedSet, bl);
    }

    private SortedSet<String> getSortedSetIndex(int n, PM_Picture pM_Picture) {
        if (n == 1) {
            return PM_Utils.getSortedSet(pM_Picture.meta.getIndex1());
        }
        return PM_Utils.getSortedSet(pM_Picture.meta.getIndex1());
    }

    private int getQSFromAll() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        List<PM_Picture> list = this.indexView.getPictureListDarstellen();
        for (PM_Picture pM_Picture : list) {
            switch (pM_Picture.meta.getCategory()) {
                case 1: {
                    bl = true;
                    break;
                }
                case 2: {
                    bl2 = true;
                    break;
                }
                case 3: {
                    bl3 = true;
                    break;
                }
                case 4: {
                    bl4 = true;
                }
            }
        }
        if (bl && (bl2 || bl3 || bl4)) {
            return 0;
        }
        if (bl2 && (bl3 || bl4)) {
            return 0;
        }
        if (bl3 && bl4) {
            return 0;
        }
        if (bl) {
            return 1;
        }
        if (bl2) {
            return 2;
        }
        if (bl3) {
            return 3;
        }
        if (bl4) {
            return 4;
        }
        return 0;
    }

    private class RetSortedSet {
        public SortedSet sortedSet;
        public boolean ungleiche;

        public RetSortedSet(SortedSet sortedSet, boolean bl) {
            this.sortedSet = sortedSet;
            this.ungleiche = bl;
        }
    }
}

