/*
 * Decompiled with CFR 0.152.
 */
package pm.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import pm.gui.PM_FocusPanel;
import pm.gui.PM_IndexView;
import pm.gui.PM_WindowBase;
import pm.gui.PM_WindowMain;
import pm.inout.PM_All_InitValues;
import pm.picture.PM_Picture;
import pm.picture.PM_PictureDirectory;
import pm.picture.PM_Pictures;
import pm.search.PM_LuceneLists;
import pm.search.PM_Search;
import pm.search.PM_SearchExpr;
import pm.sequence.PM_Sequence;
import pm.sequence.PM_SequenceAlbum;
import pm.sequence.PM_SequenceOriginal;
import pm.sequence.PM_TreeModel;
import pm.sequence.PM_TreeModelBase;
import pm.sequence.PM_TreeModelExtended;
import pm.sequence.PM_TreeModelOriginal;
import pm.sequence.PM_TreeWindow;
import pm.sequence.PM_TreeWindowAlbum;
import pm.sequence.PM_TreeWindowBase;
import pm.sequence.PM_TreeWindowExtended;
import pm.sequence.PM_TreeWindowOriginal;
import pm.utilities.PM_Action;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Listener;
import pm.utilities.PM_MSG;
import pm.utilities.PM_Transferable;
import pm.utilities.PM_Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_WindowSearch
extends PM_WindowBase
implements PM_Interface {
    private PM_FocusPanel upperPanel = null;
    private PM_TreeWindowAlbum treeAlbum;
    private JPanel panelLeftTreeLabel;
    private PM_TreeWindow treeSerienB;
    private PM_TreeWindow treeSerienX;
    private PM_TreeWindow treeHardDisk;
    private TreeSelectionListener treeSelectionListener;
    private JButton buttonDarstellen = null;
    private JButton buttonAppend = null;
    private JButton buttonDiaShow = null;
    private JButton clearButtonHits = null;
    private JTextField hitsUpperPanel = null;
    private JTextField index = null;
    private JTextField ort = null;
    private PM_Search luceneSuchen = null;
    private int anzahlHits = 0;
    private JCheckBox q1 = null;
    private JCheckBox q2 = null;
    private JCheckBox q3 = null;
    private JCheckBox q4 = null;
    private JComboBox comboBoxSequenzen = null;
    private JComboBox vonJahr = null;
    private JComboBox vonMonat = null;
    private JComboBox vonTag = null;
    private JComboBox bisJahr = null;
    private JComboBox bisMonat = null;
    private JComboBox bisTag = null;
    private JList indexListe = null;
    private JList ortListe = null;
    private PM_LuceneLists luceneIndexInstance;
    private Vector<PM_Listener> changeAnzahlListener = new Vector();
    private JSplitPane splitPaneBottom = null;
    private JTabbedPane tabbedPaneRight;
    private JTabbedPane tabbedPaneLeft;
    private Vector<SortOrder> sortOrder_deprecated = new Vector();
    private JSplitPane splitPaneLeftRight = null;
    private JPanel albumLeft;
    private JPanel scTreeSerienX;
    private JPanel scTreeSerienB;
    private JPanel scTreeHardDisk;
    private final PM_IndexView indexViewThumbnails;
    private JTextField hitsBaseTree;
    private JButton seriesBup;
    private JButton bDiashow;
    private JTextField hitsExtendedTree;
    private JButton seriesXup;
    private JButton xDiashow;
    private JTextField hitsHardDiskTree;
    private JButton hdDiashow;
    private JTextField hitsAlbumTree;
    private JButton albumDown;
    private JButton albumUp;
    private JButton albumLeftDiashow;
    private JButton clearButtonIndex = null;
    private JButton clearButtonOrt = null;
    private JButton clearButtonQS = null;
    private JButton clearButtonSequ = null;
    private JButton clearButtonDatum = null;
    private JPanel panelIndex = null;
    private JPanel panelOrt = null;
    private JPanel panelQualitaet = null;
    private JPanel panelDatum = null;
    private JPanel qPanel = null;
    private JPanel datPanel = null;
    private JPanel belowPanel = null;
    private List<PM_Sequence> listeGeschlSequenzen = null;
    private PM_Interface.SearchSortType sortOrder = PM_Interface.SearchSortType.NOTHING;
    private JLabel datLabelVon;
    private JLabel datLabelTo;
    private JLabel qLabel;
    private JLabel sLabel;
    private JSplitPane splitListenPane;
    private int lastSelected = -1;
    private JButton neueSerie;
    private JLabel labelNew;
    private JLabel labelDnD;

    public PM_WindowSearch(PM_WindowMain pM_WindowMain, int n) {
        super(pM_WindowMain, n, false);
        this.luceneIndexInstance = PM_LuceneLists.getInstance();
        this.indexViewThumbnails = pM_WindowMain.getIndexViewThumbnails();
        this.sortOrder_deprecated.add(new SortOrder(PM_Interface.SearchSortType.NOTHING, " "));
        this.sortOrder_deprecated.add(new SortOrder(PM_Interface.SearchSortType.TIME, "Bild Datum"));
        this.sortOrder_deprecated.add(new SortOrder(PM_Interface.SearchSortType.SEQ, "Serie"));
        this.sortOrder_deprecated.add(new SortOrder(PM_Interface.SearchSortType.FILE_NAME, "Datei Name"));
        this.sortOrder_deprecated.add(new SortOrder(PM_Interface.SearchSortType.FILE_PATH, "Datei Pfad"));
        this.treeSelectionListener = new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                Object object = treeSelectionEvent.getSource();
                if (!(object instanceof PM_TreeWindow)) {
                    return;
                }
                PM_TreeWindow pM_TreeWindow = (PM_TreeWindow)object;
                if (pM_TreeWindow.isSelectionEmpty()) {
                    return;
                }
                TreePath treePath = treeSelectionEvent.getPath();
                Object object2 = treePath.getLastPathComponent();
                if (object2 instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object2;
                    PM_WindowSearch.this.selectSequence(defaultMutableTreeNode, pM_TreeWindow);
                }
            }
        };
        this.initWindow();
        this.initKeyBindigs();
        int n2 = PM_All_InitValues.getInstance().getValueInt(this, "vertical-devider");
        if (n2 == 0) {
            n2 = 150;
        }
        this.splitPaneLeftRight.setDividerLocation(n2);
        PM_Listener pM_Listener = new PM_Listener(){

            public void actionPerformed(PM_Action pM_Action) {
                PM_WindowSearch.this.setMsg();
            }
        };
        PM_MSG.addChangeListener(pM_Listener);
        this.setMsg();
    }

    private void setMsg() {
        this.bDiashow.setText(PM_MSG.getMsg("diashow"));
        this.xDiashow.setText(PM_MSG.getMsg("diashow"));
        this.hdDiashow.setText(PM_MSG.getMsg("diashow"));
        this.albumLeftDiashow.setText(PM_MSG.getMsg("diashow"));
        this.buttonDiaShow.setText(PM_MSG.getMsg("diashow"));
        this.datLabelVon.setText(PM_MSG.getMsg("winSrcDatFrom"));
        this.labelNew.setText(PM_MSG.getMsg("winSrcNew"));
        this.labelDnD.setText(PM_MSG.getMsg("winSrcDnD"));
        this.qLabel.setText(PM_MSG.getMsg("category14"));
        this.sLabel.setText(PM_MSG.getMsg("winSrcSeq"));
        this.datLabelTo.setText(PM_MSG.getMsg("winSrcDatTo"));
        this.tabbedPaneRight.setTitleAt(0, PM_MSG.getMsg("winSrcSeqB"));
        this.tabbedPaneRight.setTitleAt(1, PM_MSG.getMsg("winSrcSeqX"));
        this.tabbedPaneRight.setTitleAt(2, PM_MSG.getMsg("winSrcDisc"));
        this.tabbedPaneLeft.setTitleAt(0, PM_MSG.getMsg("photalbum"));
        this.tabbedPaneLeft.setTitleAt(1, PM_MSG.getMsg("indices"));
    }

    @Override
    public void close() {
        int n = this.splitListenPane.getDividerLocation();
        PM_All_InitValues.getInstance().putValueInt(this, "index-list-divider", n);
        PM_All_InitValues.getInstance().putValueInt(this, "vertical-devider", this.splitPaneLeftRight.getDividerLocation());
    }

    @Override
    public void closeAlbum() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.treeAlbum.getRootNode();
        if (defaultMutableTreeNode == null) {
            return;
        }
        defaultMutableTreeNode.removeAllChildren();
        this.treeAlbum.getTreeModel().nodeStructureChanged(defaultMutableTreeNode);
    }

    @Override
    public boolean flush() {
        this.doClearHits();
        this.treeAlbum.clearSelection(true);
        this.hitsAlbumTree.setText("");
        return true;
    }

    private void selectSequence(DefaultMutableTreeNode defaultMutableTreeNode, PM_TreeWindow pM_TreeWindow) {
        Object object;
        PM_Sequence pM_Sequence = null;
        Object object2 = defaultMutableTreeNode.getUserObject();
        if (object2 instanceof PM_Sequence) {
            pM_Sequence = (PM_Sequence)object2;
        }
        if (object2 instanceof PM_PictureDirectory) {
            PM_PictureDirectory pM_PictureDirectory = (PM_PictureDirectory)object2;
            this.hitsHardDiskTree.setText(String.valueOf(pM_PictureDirectory.getPictureSizeValid()));
            return;
        }
        int n = 0;
        if (pM_Sequence != null) {
            object = new PM_SearchExpr(PM_Interface.SearchType.SEQ);
            ((PM_SearchExpr)object).setSequenz(pM_Sequence);
            PM_Search pM_Search = new PM_Search((PM_SearchExpr)object);
            n = pM_Search.search();
        }
        object = String.valueOf(n);
        if (pM_TreeWindow == this.treeAlbum) {
            this.hitsAlbumTree.setText((String)object);
            if (n > 0) {
                this.albumUp.setEnabled(true);
            } else {
                this.albumUp.setEnabled(false);
            }
        } else if (pM_TreeWindow == this.treeSerienB) {
            this.hitsBaseTree.setText((String)object);
            if (n > 0) {
                this.seriesBup.setEnabled(true);
            } else {
                this.seriesBup.setEnabled(false);
            }
        } else if (pM_TreeWindow == this.treeSerienX) {
            this.hitsExtendedTree.setText((String)object);
            if (n > 0) {
                this.seriesXup.setEnabled(true);
            } else {
                this.seriesXup.setEnabled(false);
            }
        } else if (pM_TreeWindow == this.treeHardDisk) {
            this.hitsHardDiskTree.setText((String)object);
        }
    }

    public List<PM_Picture> getPictureList(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null) {
            return new ArrayList<PM_Picture>();
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof PM_PictureDirectory) {
            PM_PictureDirectory pM_PictureDirectory = (PM_PictureDirectory)object;
            List<File> list = pM_PictureDirectory.getOrigFiles();
            List<PM_Picture> list2 = PM_Pictures.getPictureList(list);
            Collections.sort(list2, PM_Utils.SORT_TIME_ORDER);
            return list2;
        }
        PM_Sequence pM_Sequence = null;
        if (object instanceof PM_Sequence) {
            pM_Sequence = (PM_Sequence)object;
        }
        if (pM_Sequence == null) {
            return new ArrayList<PM_Picture>();
        }
        PM_SearchExpr pM_SearchExpr = new PM_SearchExpr(PM_Interface.SearchType.SEQ);
        pM_SearchExpr.setSequenz(pM_Sequence);
        PM_Search pM_Search = new PM_Search(pM_SearchExpr);
        int n = pM_Search.search();
        if (n == 0) {
            return new ArrayList<PM_Picture>();
        }
        if (pM_Sequence instanceof PM_SequenceOriginal) {
            return pM_Search.getPictureList(PM_Interface.SearchSortType.FILE_PATH);
        }
        if (pM_Sequence instanceof PM_SequenceAlbum && ((PM_SequenceAlbum)pM_Sequence).getSeqClosed() == null) {
            return pM_Search.getPictureList(PM_Interface.SearchSortType.TIME);
        }
        return pM_Search.getPictureList(PM_Interface.SearchSortType.SEQ);
    }

    @Override
    public void doubleClickOnTree(DefaultMutableTreeNode defaultMutableTreeNode, PM_TreeWindow pM_TreeWindow) {
        List<PM_Picture> list = this.getPictureList(defaultMutableTreeNode);
        if (list.size() == 0) {
            return;
        }
        this.indexViewThumbnails.setAndPaintPictureList(list);
    }

    private void initWindow() {
        this.setLayout(new BorderLayout());
        this.upperPanel = this.getSearchPanel();
        JScrollPane jScrollPane = new JScrollPane(this.upperPanel);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        this.tabbedPaneRight = this.getTabbedPaneRight();
        this.tabbedPaneLeft = this.getTabbedPaneLeft();
        this.splitPaneLeftRight = new JSplitPane(1, this.tabbedPaneLeft, this.tabbedPaneRight);
        this.splitPaneLeftRight.setDividerLocation(500);
        this.splitPaneLeftRight.setOneTouchExpandable(true);
        this.add((Component)jScrollPane, "North");
        this.add((Component)this.splitPaneLeftRight, "Center");
    }

    private void initKeyBindigs() {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSearch.this.keyPressedKategorie(1);
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSearch.this.keyPressedKategorie(2);
            }
        };
        AbstractAction abstractAction3 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSearch.this.keyPressedKategorie(3);
            }
        };
        AbstractAction abstractAction4 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSearch.this.keyPressedKategorie(4);
            }
        };
        InputMap inputMap = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(49, 2), "VK_1");
        inputMap.put(KeyStroke.getKeyStroke(50, 2), "VK_2");
        inputMap.put(KeyStroke.getKeyStroke(51, 2), "VK_3");
        inputMap.put(KeyStroke.getKeyStroke(52, 2), "VK_4");
        actionMap.put("VK_1", abstractAction);
        actionMap.put("VK_2", abstractAction2);
        actionMap.put("VK_3", abstractAction3);
        actionMap.put("VK_4", abstractAction4);
        this.setAktiverFocus(this.treeSerienB);
        this.addFocusPanel(this.upperPanel);
        this.addFocusPanel(new PM_FocusPanel(null, this.indexListe, this.indexListe));
        this.addFocusPanel(new PM_FocusPanel(null, this.ortListe, this.ortListe));
        this.setBackgroundUpperPanel(COLOR_BG_PANEL);
    }

    private JTabbedPane getTabbedPaneRight() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.scTreeSerienB = this.getSeriesB();
        this.scTreeSerienX = this.getSeriesX();
        this.scTreeHardDisk = this.getHardDisk();
        jTabbedPane.insertTab("B-Serien", null, this.scTreeSerienB, "", 0);
        jTabbedPane.insertTab("X-Serien", null, this.scTreeSerienX, "", 1);
        jTabbedPane.insertTab("Festplatte", null, this.scTreeHardDisk, "", 2);
        return jTabbedPane;
    }

    private JTabbedPane getTabbedPaneLeft() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.getIndex12();
        this.albumLeft = this.getAlbum();
        jTabbedPane.insertTab("Fotoalbum", null, this.albumLeft, "", 0);
        jTabbedPane.insertTab("Indizes", null, this.getIndex12(), "", 1);
        return jTabbedPane;
    }

    private JPanel getSeriesB() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        JButton jButton = PM_Utils.getJButon("1leftarrow.png");
        jPanel.add(jButton);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                List<PM_Picture> list = PM_WindowSearch.this.getPictureList(PM_WindowSearch.this.treeSerienB.getSelectedNode());
                if (list.size() == 0) {
                    return;
                }
                PM_WindowSearch.this.indexViewThumbnails.setAndPaintPictureList(list);
            }
        };
        jButton.addActionListener(actionListener);
        JButton jButton2 = PM_Utils.getJButon("2leftarrow.png");
        jPanel.add(jButton2);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                List<PM_Picture> list = PM_WindowSearch.this.getPictureList(PM_WindowSearch.this.treeSerienB.getSelectedNode());
                if (list.size() == 0) {
                    return;
                }
                PM_WindowSearch.this.indexViewThumbnails.appendPictureList(list);
            }
        };
        jButton2.addActionListener(actionListener2);
        this.hitsBaseTree = new JTextField("");
        this.hitsBaseTree.setForeground(Color.BLACK);
        this.hitsBaseTree.setEditable(false);
        this.hitsBaseTree.setFocusable(false);
        this.hitsBaseTree.setColumns(4);
        jPanel.add(this.hitsBaseTree);
        Font font = this.hitsBaseTree.getFont();
        Font font2 = new Font(font.getName(), 1, font.getSize());
        this.hitsBaseTree.setFont(font2);
        this.bDiashow = new JButton("?Diashow");
        jPanel.add(this.bDiashow);
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSearch.this.startDiashowFromTreeWindow(PM_WindowSearch.this.treeSerienB.getSelectedNode());
            }
        };
        this.bDiashow.addActionListener(actionListener3);
        this.seriesBup = PM_Utils.getJButon("1uparrow.png");
        this.seriesBup.setEnabled(false);
        jPanel.add(this.seriesBup);
        ActionListener actionListener4 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = PM_WindowSearch.this.treeSerienB.getSelectedNode();
                Object object = defaultMutableTreeNode.getUserObject();
                PM_Sequence pM_Sequence = object instanceof PM_Sequence ? (PM_Sequence)object : null;
                PM_WindowSearch.this.darstellungSequenz(pM_Sequence, null);
            }
        };
        this.seriesBup.addActionListener(actionListener4);
        JPanel jPanel2 = new JPanel();
        jPanel2.setAlignmentX(0.0f);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(jPanel);
        JScrollPane jScrollPane = new JScrollPane(jPanel2);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        this.treeSerienB = new PM_TreeWindowBase(this);
        this.treeSerienB.addTreeSelectionListener(this.treeSelectionListener);
        JScrollPane jScrollPane2 = new JScrollPane(this.treeSerienB);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jScrollPane, "North");
        jPanel3.add((Component)jScrollPane2, "Center");
        return jPanel3;
    }

    private JPanel getSeriesX() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        JButton jButton = PM_Utils.getJButon("1leftarrow.png");
        jPanel.add(jButton);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                List<PM_Picture> list = PM_WindowSearch.this.getPictureList(PM_WindowSearch.this.treeSerienX.getSelectedNode());
                if (list.size() == 0) {
                    return;
                }
                PM_WindowSearch.this.indexViewThumbnails.setAndPaintPictureList(list);
            }
        };
        jButton.addActionListener(actionListener);
        JButton jButton2 = PM_Utils.getJButon("2leftarrow.png");
        jPanel.add(jButton2);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                List<PM_Picture> list = PM_WindowSearch.this.getPictureList(PM_WindowSearch.this.treeSerienX.getSelectedNode());
                if (list.size() == 0) {
                    return;
                }
                PM_WindowSearch.this.indexViewThumbnails.appendPictureList(list);
            }
        };
        jButton2.addActionListener(actionListener2);
        this.hitsExtendedTree = new JTextField("");
        this.hitsExtendedTree.setForeground(Color.BLACK);
        this.hitsExtendedTree.setEditable(false);
        this.hitsExtendedTree.setFocusable(false);
        this.hitsExtendedTree.setColumns(4);
        jPanel.add(this.hitsExtendedTree);
        Font font = this.hitsExtendedTree.getFont();
        Font font2 = new Font(font.getName(), 1, font.getSize());
        this.hitsExtendedTree.setFont(font2);
        this.xDiashow = new JButton("?Diashow");
        jPanel.add(this.xDiashow);
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSearch.this.startDiashowFromTreeWindow(PM_WindowSearch.this.treeSerienX.getSelectedNode());
            }
        };
        this.xDiashow.addActionListener(actionListener3);
        this.seriesXup = PM_Utils.getJButon("1uparrow.png");
        this.seriesXup.setEnabled(false);
        jPanel.add(this.seriesXup);
        ActionListener actionListener4 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = PM_WindowSearch.this.treeSerienX.getSelectedNode();
                Object object = defaultMutableTreeNode.getUserObject();
                PM_Sequence pM_Sequence = object instanceof PM_Sequence ? (PM_Sequence)object : null;
                PM_WindowSearch.this.darstellungSequenz(pM_Sequence, null);
            }
        };
        this.seriesXup.addActionListener(actionListener4);
        JPanel jPanel2 = new JPanel();
        jPanel2.setAlignmentX(0.0f);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(jPanel);
        JScrollPane jScrollPane = new JScrollPane(jPanel2);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        this.treeSerienX = new PM_TreeWindowExtended(this);
        this.treeSerienX.addTreeSelectionListener(this.treeSelectionListener);
        JScrollPane jScrollPane2 = new JScrollPane(this.treeSerienX);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jScrollPane, "North");
        jPanel3.add((Component)jScrollPane2, "Center");
        return jPanel3;
    }

    private JPanel getHardDisk() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        JButton jButton = PM_Utils.getJButon("1leftarrow.png");
        jPanel.add(jButton);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                List<PM_Picture> list = PM_WindowSearch.this.getPictureList(PM_WindowSearch.this.treeHardDisk.getSelectedNode());
                if (list.size() == 0) {
                    return;
                }
                PM_WindowSearch.this.indexViewThumbnails.setAndPaintPictureList(list);
            }
        };
        jButton.addActionListener(actionListener);
        JButton jButton2 = PM_Utils.getJButon("2leftarrow.png");
        jPanel.add(jButton2);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                List<PM_Picture> list = PM_WindowSearch.this.getPictureList(PM_WindowSearch.this.treeHardDisk.getSelectedNode());
                if (list.size() == 0) {
                    return;
                }
                PM_WindowSearch.this.indexViewThumbnails.appendPictureList(list);
            }
        };
        jButton2.addActionListener(actionListener2);
        this.hitsHardDiskTree = new JTextField("");
        this.hitsHardDiskTree.setForeground(Color.BLACK);
        this.hitsHardDiskTree.setEditable(false);
        this.hitsHardDiskTree.setFocusable(false);
        this.hitsHardDiskTree.setColumns(4);
        jPanel.add(this.hitsHardDiskTree);
        Font font = this.hitsHardDiskTree.getFont();
        Font font2 = new Font(font.getName(), 1, font.getSize());
        this.hitsHardDiskTree.setFont(font2);
        this.hdDiashow = new JButton("?Diashow");
        jPanel.add(this.hdDiashow);
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSearch.this.startDiashowFromTreeWindow(PM_WindowSearch.this.treeHardDisk.getSelectedNode());
            }
        };
        this.hdDiashow.addActionListener(actionListener3);
        JPanel jPanel2 = new JPanel();
        jPanel2.setAlignmentX(0.0f);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(jPanel);
        JScrollPane jScrollPane = new JScrollPane(jPanel2);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        this.treeHardDisk = new PM_TreeWindowOriginal(this);
        this.treeHardDisk.addTreeSelectionListener(this.treeSelectionListener);
        JScrollPane jScrollPane2 = new JScrollPane(this.treeHardDisk);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jScrollPane, "North");
        jPanel3.add((Component)jScrollPane2, "Center");
        return jPanel3;
    }

    private JPanel getAlbum() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        JButton jButton = PM_Utils.getJButon("1leftarrow.png");
        jPanel.add(jButton);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                List<PM_Picture> list = PM_WindowSearch.this.getPictureList(PM_WindowSearch.this.treeAlbum.getSelectedNode());
                if (list.size() == 0) {
                    return;
                }
                PM_WindowSearch.this.indexViewThumbnails.setAndPaintPictureList(list);
            }
        };
        jButton.addActionListener(actionListener);
        JButton jButton2 = PM_Utils.getJButon("2leftarrow.png");
        jPanel.add(jButton2);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                List<PM_Picture> list = PM_WindowSearch.this.getPictureList(PM_WindowSearch.this.treeAlbum.getSelectedNode());
                if (list.size() == 0) {
                    return;
                }
                PM_WindowSearch.this.indexViewThumbnails.appendPictureList(list);
            }
        };
        jButton2.addActionListener(actionListener2);
        this.hitsAlbumTree = new JTextField("");
        this.hitsAlbumTree.setForeground(Color.BLACK);
        this.hitsAlbumTree.setEditable(false);
        this.hitsAlbumTree.setFocusable(false);
        this.hitsAlbumTree.setColumns(4);
        jPanel.add(this.hitsAlbumTree);
        Font font = this.hitsAlbumTree.getFont();
        Font font2 = new Font(font.getName(), 1, font.getSize());
        this.hitsAlbumTree.setFont(font2);
        this.albumLeftDiashow = new JButton("?Diashow");
        jPanel.add(this.albumLeftDiashow);
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSearch.this.startDiashowFromTreeWindow(PM_WindowSearch.this.treeAlbum.getSelectedNode());
            }
        };
        this.albumLeftDiashow.addActionListener(actionListener3);
        this.albumDown = PM_Utils.getJButon("1downarrow.png");
        this.albumDown.setEnabled(false);
        jPanel.add(this.albumDown);
        ActionListener actionListener4 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = PM_WindowSearch.this.treeAlbum.getSelectedNode();
                if (defaultMutableTreeNode == null) {
                    return;
                }
                PM_SequenceAlbum pM_SequenceAlbum = null;
                Object object = defaultMutableTreeNode.getUserObject();
                if (object instanceof PM_SequenceAlbum) {
                    pM_SequenceAlbum = (PM_SequenceAlbum)object;
                    PM_WindowSearch.this.aendernAlbum(pM_SequenceAlbum, defaultMutableTreeNode, PM_WindowSearch.this.treeAlbum);
                }
            }
        };
        this.albumDown.addActionListener(actionListener4);
        this.albumUp = PM_Utils.getJButon("1uparrow.png");
        this.albumUp.setEnabled(false);
        jPanel.add(this.albumUp);
        ActionListener actionListener5 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = PM_WindowSearch.this.treeAlbum.getSelectedNode();
                Object object = defaultMutableTreeNode.getUserObject();
                PM_Sequence pM_Sequence = object instanceof PM_Sequence ? (PM_Sequence)object : null;
                PM_WindowSearch.this.darstellungSequenz(pM_Sequence, null);
            }
        };
        this.albumUp.addActionListener(actionListener5);
        JPanel jPanel2 = new JPanel();
        jPanel2.setAlignmentX(0.0f);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(jPanel);
        this.panelLeftTreeLabel = new JPanel(new FlowLayout(0));
        JLabel jLabel = new JLabel("keine Bilder selektiert");
        this.panelLeftTreeLabel.add(jLabel);
        JScrollPane jScrollPane = new JScrollPane(jPanel2);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        this.treeAlbum = new PM_TreeWindowAlbum(this);
        this.treeAlbum.addTreeSelectionListener(this.treeSelectionListener);
        this.treeAlbum.setMarkSelectedSequence(true);
        JScrollPane jScrollPane2 = new JScrollPane(this.treeAlbum);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jScrollPane, "North");
        jPanel3.add((Component)jScrollPane2, "Center");
        return jPanel3;
    }

    public Component initRequestFocus() {
        PM_TreeWindow pM_TreeWindow = this.treeSerienX;
        pM_TreeWindow.setBackground(COLOR_BG_PANEL_SEL);
        pM_TreeWindow.requestFocusInWindow();
        pM_TreeWindow.setSelectionRow(0);
        return pM_TreeWindow;
    }

    public void addChangeAnzahlListener(PM_Listener pM_Listener) {
        if (!this.changeAnzahlListener.contains(pM_Listener)) {
            this.changeAnzahlListener.add(pM_Listener);
        }
    }

    public void initTreeOriginal() {
        PM_TreeModel pM_TreeModel = this.treeHardDisk.getTreeModel();
        PM_TreeModelOriginal pM_TreeModelOriginal = (PM_TreeModelOriginal)pM_TreeModel;
        pM_TreeModelOriginal.init();
    }

    public PM_TreeWindow getTreeWindowOriginal() {
        return this.treeHardDisk;
    }

    public void initSelectTree() {
        if (this.treeSerienB.getRowCount() > 1) {
            this.tabbedPaneRight.setSelectedComponent(this.scTreeSerienB);
        } else if (this.treeSerienX.getRowCount() > 1) {
            this.tabbedPaneRight.setSelectedComponent(this.scTreeSerienX);
        } else {
            this.tabbedPaneRight.setSelectedComponent(this.scTreeHardDisk);
        }
    }

    @Override
    public boolean requestToChange() {
        return true;
    }

    public void startDiashow(int n) {
        if (this.anzahlHits == 0) {
            return;
        }
        this.doHitsDiashowDarstellen(n);
    }

    public void luceneIndexChanged(PM_Action pM_Action) {
        this.indexListe.setListData(this.luceneIndexInstance.getSortedIndex());
        this.ortListe.setListData(this.luceneIndexInstance.getSortedOrt());
    }

    public int getListBreite() {
        return this.splitPaneBottom.getDividerLocation();
    }

    private void keyPressedKategorie(int n) {
        if (n == 1) {
            this.q1.setSelected(!this.q1.isSelected());
        }
        if (n == 2) {
            this.q2.setSelected(!this.q2.isSelected());
        }
        if (n == 3) {
            this.q3.setSelected(!this.q3.isSelected());
        }
        if (n == 4) {
            this.q4.setSelected(!this.q4.isSelected());
        }
        this.setQsEnable();
        this.doSuchen();
    }

    private void fireAnzahlListener() {
        for (int i = 0; i < this.changeAnzahlListener.size(); ++i) {
            PM_Listener pM_Listener = this.changeAnzahlListener.elementAt(i);
            pM_Listener.actionPerformed(new PM_Action(this));
        }
    }

    private void setBackgroundUpperPanel(Color color) {
        this.qPanel.setBackground(color);
        this.panelQualitaet.setBackground(color);
        this.panelIndex.setBackground(color);
        this.panelOrt.setBackground(color);
        this.panelDatum.setBackground(color);
        this.datPanel.setBackground(color);
        this.belowPanel.setBackground(color);
        this.comboBoxSequenzen.setBackground(COLOR_ENABLED);
        this.index.setBackground(COLOR_ENABLED);
        this.ort.setBackground(COLOR_ENABLED);
        this.vonJahr.setBackground(COLOR_ENABLED);
        this.vonMonat.setBackground(COLOR_ENABLED);
        this.vonTag.setBackground(COLOR_ENABLED);
        this.bisJahr.setBackground(COLOR_ENABLED);
        this.bisMonat.setBackground(COLOR_ENABLED);
        this.bisTag.setBackground(COLOR_ENABLED);
        this.buttonDarstellen.setBackground(COLOR_ENABLED);
        this.buttonDiaShow.setBackground(COLOR_ENABLED);
        this.q1.setBackground(COLOR_ENABLED);
        this.q2.setBackground(COLOR_ENABLED);
        this.q3.setBackground(COLOR_ENABLED);
        this.q4.setBackground(COLOR_ENABLED);
    }

    private Vector<String> getListeGeschlSeqenzen() {
        PM_TreeModelBase pM_TreeModelBase = PM_TreeModelBase.getInstance();
        PM_TreeModelExtended pM_TreeModelExtended = PM_TreeModelExtended.getInstance();
        this.listeGeschlSequenzen = ((PM_TreeModel)pM_TreeModelBase).getSequenceList();
        this.listeGeschlSequenzen.addAll(((PM_TreeModel)pM_TreeModelExtended).getSequenceList());
        Collections.sort(this.listeGeschlSequenzen, PM_Utils.SORT_SEQUENZ_PATH);
        return PM_Utils.getComboBoxVector(this.listeGeschlSequenzen);
    }

    protected void doClearAlle() {
        this.doClearIndex();
        this.doClearOrt();
        this.doClearDatum();
        this.doClearQS();
        this.doClearSequ();
        this.clearButtonDatum.setBackground(COLOR_BG_PANEL);
    }

    private void doClearIndex() {
        this.index.setText(" ");
        this.setIndexEnable();
        this.indexListe.clearSelection();
    }

    private void setIndexEnable() {
        String string = this.index.getText().trim();
        boolean bl = false;
        bl = string != null && string.length() != 0;
        if (bl) {
            this.clearButtonIndex.setBackground(Color.RED);
        } else {
            this.clearButtonIndex.setBackground(COLOR_BG_PANEL);
        }
    }

    private void doClearOrt() {
        this.ort.setText(" ");
        this.setOrtEnable();
        this.ortListe.clearSelection();
    }

    private void setOrtEnable() {
        String string = this.ort.getText().trim();
        if (string == null || string.length() == 0) {
            this.clearButtonOrt.setBackground(COLOR_BG_PANEL);
        } else {
            this.clearButtonOrt.setBackground(Color.RED);
        }
    }

    private void setQsEnable() {
        boolean bl = false;
        if (this.q1.isSelected()) {
            bl = true;
        }
        if (this.q2.isSelected()) {
            bl = true;
        }
        if (this.q3.isSelected()) {
            bl = true;
        }
        if (this.q4.isSelected()) {
            bl = true;
        }
        if (bl) {
            this.clearButtonQS.setBackground(Color.RED);
        } else {
            this.clearButtonQS.setBackground(COLOR_BG_PANEL);
        }
    }

    private void setDatumEnable() {
        boolean bl = true;
        String string = ((String)this.vonJahr.getSelectedItem()).trim();
        String string2 = ((String)this.vonMonat.getSelectedItem()).trim();
        String string3 = ((String)this.vonTag.getSelectedItem()).trim();
        String string4 = ((String)this.bisJahr.getSelectedItem()).trim();
        String string5 = ((String)this.bisMonat.getSelectedItem()).trim();
        String string6 = ((String)this.bisTag.getSelectedItem()).trim();
        if (string.length() == 0 && string2.length() == 0 && string3.length() == 0 && string4.length() == 0 && string5.length() == 0 && string6.length() == 0) {
            bl = false;
        }
        if (bl) {
            this.clearButtonDatum.setBackground(Color.RED);
        } else {
            this.clearButtonDatum.setBackground(COLOR_BG_PANEL);
        }
    }

    private void setEnableClearButtons() {
        this.setDatumEnable();
        this.setQsEnable();
    }

    private void doClearQS() {
        this.q1.setSelected(false);
        this.q2.setSelected(false);
        this.q3.setSelected(false);
        this.q4.setSelected(false);
        this.setQsEnable();
    }

    private void doClearSequ() {
        this.comboBoxSequenzen.setSelectedIndex(0);
    }

    private void doClearHits() {
        this.doClearAlle();
        this.anzahlHits = 0;
        this.setAnzahlHits();
    }

    private void setSortOrder(PM_Interface.SearchSortType searchSortType) {
        this.sortOrder = searchSortType;
    }

    private PM_Interface.SearchSortType getSortOrder() {
        return this.sortOrder;
    }

    private void doSuchen() {
        this.anzahlHits = 0;
        PM_SearchExpr pM_SearchExpr = new PM_SearchExpr(PM_Interface.SearchType.SEQ);
        pM_SearchExpr.setSequenz(this.getTempOpenSequenz());
        this.luceneSuchen = new PM_Search(pM_SearchExpr);
        this.anzahlHits = this.luceneSuchen.search();
        this.setAnzahlHits();
        if (this.anzahlHits == 0) {
            return;
        }
        if (this.comboBoxSequenzen.getSelectedIndex() > 0) {
            this.setSortOrder(PM_Interface.SearchSortType.SEQ);
        } else {
            this.setSortOrder(PM_Interface.SearchSortType.TIME);
        }
    }

    private void doSuchen(PM_Sequence pM_Sequence, PM_Interface.SearchSortType searchSortType) {
        PM_SearchExpr pM_SearchExpr = new PM_SearchExpr(PM_Interface.SearchType.SEQ);
        pM_SearchExpr.setSequenz(pM_Sequence);
        this.luceneSuchen = new PM_Search(pM_SearchExpr);
        this.anzahlHits = this.luceneSuchen.search();
        this.setAnzahlHits();
        if (this.anzahlHits == 0) {
            return;
        }
        this.setSortOrder(searchSortType);
    }

    private PM_Sequence getTempOpenSequenz() {
        PM_SequenceAlbum pM_SequenceAlbum = new PM_SequenceAlbum();
        this.setSequenzFromGUI(pM_SequenceAlbum);
        return pM_SequenceAlbum;
    }

    private String getDatum(String string, String string2, String string3) {
        if (string.length() != 4) {
            return "";
        }
        if (string2.length() != 2) {
            return string;
        }
        if (string3.length() != 2) {
            return string + "." + string2;
        }
        return string + "." + string2 + "." + string3;
    }

    private List<PM_Picture> getSortedPictureResultList() {
        if (this.luceneSuchen == null) {
            return new ArrayList<PM_Picture>();
        }
        return this.luceneSuchen.getPictureList(this.getSortOrder());
    }

    private void setAnzahlHits() {
        this.hitsUpperPanel.setText(Integer.toString(this.anzahlHits));
        if (this.anzahlHits == 0) {
            this.setSortOrder(PM_Interface.SearchSortType.NOTHING);
            this.hitsUpperPanel.setBackground(COLOR_BG_PANEL);
            this.clearButtonHits.setBackground(COLOR_BG_PANEL);
            this.albumDown.setEnabled(false);
            this.neueSerie.setEnabled(false);
        } else {
            this.hitsUpperPanel.setBackground(Color.RED);
            this.clearButtonHits.setBackground(Color.RED);
            this.albumDown.setEnabled(true);
            this.neueSerie.setEnabled(true);
        }
        this.fireAnzahlListener();
    }

    private void suchenGeaendert() {
        this.doSuchen();
    }

    private void startDiashowFromTreeWindow(DefaultMutableTreeNode defaultMutableTreeNode) {
        List<PM_Picture> list = this.getPictureList(defaultMutableTreeNode);
        if (list.size() == 0) {
            return;
        }
        this.windowMain.doDiaShow(list.get(0), list, 1);
    }

    private void doHitsDiashowDarstellen(int n) {
        if (this.anzahlHits == 0) {
            return;
        }
        List<PM_Picture> list = this.getSortedPictureResultList();
        if (list.size() == 0) {
            return;
        }
        this.windowMain.doDiaShow(list.get(0), list, n);
    }

    public void doHitsLinksDarstellen() {
        if (this.anzahlHits == 0) {
            return;
        }
        this.indexViewThumbnails.setAndPaintPictureList(this.getSortedPictureResultList());
    }

    private void doClearDatum() {
        this.vonJahr.getModel().setSelectedItem("");
        this.vonMonat.getModel().setSelectedItem("");
        this.vonTag.getModel().setSelectedItem("");
        this.bisJahr.getModel().setSelectedItem("");
        this.bisMonat.getModel().setSelectedItem("");
        this.bisTag.getModel().setSelectedItem("");
    }

    private void setSequenzFromGUI(PM_SequenceAlbum pM_SequenceAlbum) {
        pM_SequenceAlbum.setIndex(this.index.getText());
        pM_SequenceAlbum.setOrt(this.ort.getText());
        String string = ((String)this.vonJahr.getSelectedItem()).trim();
        String string2 = ((String)this.vonMonat.getSelectedItem()).trim();
        String string3 = ((String)this.vonTag.getSelectedItem()).trim();
        pM_SequenceAlbum.setVon(this.getDatum(string, string2, string3));
        String string4 = ((String)this.bisJahr.getSelectedItem()).trim();
        String string5 = ((String)this.bisMonat.getSelectedItem()).trim();
        String string6 = ((String)this.bisTag.getSelectedItem()).trim();
        pM_SequenceAlbum.setBis(this.getDatum(string4, string5, string6));
        String string7 = "";
        if (this.q1.isSelected()) {
            string7 = string7 + "1";
        }
        if (this.q2.isSelected()) {
            string7 = string7 + "2";
        }
        if (this.q3.isSelected()) {
            string7 = string7 + "3";
        }
        if (this.q4.isSelected()) {
            string7 = string7 + "4";
        }
        pM_SequenceAlbum.setQual(string7);
        int n = this.comboBoxSequenzen.getSelectedIndex() - 1;
        PM_Sequence pM_Sequence = PM_Utils.getSelectedSequenz(n, this.listeGeschlSequenzen);
        if (pM_Sequence instanceof PM_Sequence) {
            PM_Sequence pM_Sequence2 = pM_Sequence;
            pM_SequenceAlbum.setSeqClosed(pM_Sequence2);
        } else {
            pM_SequenceAlbum.setSeqClosed(null);
        }
    }

    @Override
    public void darstellungSequenz(PM_Sequence pM_Sequence, DefaultMutableTreeNode defaultMutableTreeNode) {
        this.doClearAlle();
        this.anzahlHits = 0;
        this.setAnzahlHits();
        if (pM_Sequence == null) {
            return;
        }
        switch (pM_Sequence.getType()) {
            case ORIGINAL: {
                this.doSuchen(pM_Sequence, PM_Interface.SearchSortType.FILE_PATH);
                return;
            }
            case BASE: 
            case EXTENDED: {
                this.comboBoxSequenzen.setSelectedIndex(PM_Utils.getSelectedIndex(pM_Sequence, this.listeGeschlSequenzen));
                this.setEnableClearButtons();
                this.doSuchen();
                return;
            }
            case NEW: {
                this.doSuchen(pM_Sequence, PM_Interface.SearchSortType.TIME);
                return;
            }
            case ALBUM: {
                this.darstellungAlbum(pM_Sequence);
                this.setEnableClearButtons();
                this.doSuchen();
                return;
            }
        }
    }

    public void aendernAlbum(PM_SequenceAlbum pM_SequenceAlbum, DefaultMutableTreeNode defaultMutableTreeNode, PM_TreeWindow pM_TreeWindow) {
        String string;
        int n;
        PM_SequenceAlbum pM_SequenceAlbum2 = new PM_SequenceAlbum();
        this.setSequenzFromGUI(pM_SequenceAlbum2);
        pM_SequenceAlbum2.setLongName(pM_SequenceAlbum.getLongName());
        if (pM_SequenceAlbum.getSeqClosed() != pM_SequenceAlbum2.getSeqClosed() && (n = JOptionPane.showConfirmDialog(null, string = "Sequenzen ungleich. \u00c4nderung durchf\u00fchren?", "Sicherheitsabfrage", 0, 3)) == 1) {
            return;
        }
        defaultMutableTreeNode.setUserObject(pM_SequenceAlbum2);
        pM_TreeWindow.getTreeModel().nodeChanged(defaultMutableTreeNode);
        this.hitsAlbumTree.setText(this.hitsUpperPanel.getText());
        this.albumUp.setEnabled(false);
    }

    private void darstellungAlbum(PM_Sequence pM_Sequence) {
        if (!(pM_Sequence instanceof PM_SequenceAlbum)) {
            return;
        }
        PM_SequenceAlbum pM_SequenceAlbum = (PM_SequenceAlbum)pM_Sequence;
        PM_Sequence pM_Sequence2 = pM_SequenceAlbum.getSeqClosed();
        if (pM_Sequence2 != null) {
            this.comboBoxSequenzen.setSelectedIndex(PM_Utils.getSelectedIndex(pM_Sequence2, this.listeGeschlSequenzen));
        } else {
            this.setSortOrder(PM_Interface.SearchSortType.NOTHING);
        }
        String string = pM_SequenceAlbum.getVon();
        String string2 = pM_SequenceAlbum.getBis();
        this.vonJahr.getModel().setSelectedItem(this.getJJ(string));
        this.vonMonat.getModel().setSelectedItem(this.getMM(string));
        this.vonTag.getModel().setSelectedItem(this.getTT(string));
        this.bisJahr.getModel().setSelectedItem(this.getJJ(string2));
        this.bisMonat.getModel().setSelectedItem(this.getMM(string2));
        this.bisTag.getModel().setSelectedItem(this.getTT(string2));
        this.index.setText(pM_SequenceAlbum.getIndex());
        this.setIndexEnable();
        this.ort.setText(pM_SequenceAlbum.getOrt());
        this.setOrtEnable();
        this.setQS(pM_SequenceAlbum.getQual());
    }

    private String getJJ(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length >= 1) {
            return stringArray[0];
        }
        return "";
    }

    private String getMM(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length >= 2) {
            return stringArray[1];
        }
        return "";
    }

    private String getTT(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length >= 3) {
            return stringArray[2];
        }
        return "";
    }

    private void setQS(String string) {
        if (string.indexOf("1") >= 0) {
            this.q1.setSelected(true);
        }
        if (string.indexOf("2") >= 0) {
            this.q2.setSelected(true);
        }
        if (string.indexOf("3") >= 0) {
            this.q3.setSelected(true);
        }
        if (string.indexOf("4") >= 0) {
            this.q4.setSelected(true);
        }
        this.setQsEnable();
    }

    private PM_FocusPanel getSearchPanel() {
        PM_FocusPanel pM_FocusPanel = new PM_FocusPanel(){

            public void setBackgroundColor(Color color) {
                PM_WindowSearch.this.setBackgroundUpperPanel(color);
            }
        };
        pM_FocusPanel.setAlignmentX(0.0f);
        pM_FocusPanel.setLayout(new BoxLayout(pM_FocusPanel, 1));
        this.panelIndex = new JPanel(new FlowLayout(0));
        this.panelOrt = new JPanel(new FlowLayout(0));
        this.panelQualitaet = new JPanel(new FlowLayout(0));
        this.panelDatum = new JPanel(new FlowLayout(0));
        PopupMenuListener popupMenuListener = new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                PM_WindowSearch.this.suchenGeaendert();
                PM_WindowSearch.this.setEnableClearButtons();
            }

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        };
        MouseListener mouseListener = new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                PM_WindowSearch.this.suchenGeaendert();
                PM_WindowSearch.this.setEnableClearButtons();
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }
        };
        this.clearButtonIndex = PM_Utils.getJButon("button_cancel.png");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSearch.this.doClearIndex();
                PM_WindowSearch.this.suchenGeaendert();
            }
        };
        this.clearButtonIndex.addActionListener(actionListener);
        this.panelIndex.add(this.clearButtonIndex);
        JLabel jLabel = new JLabel("Index 1:");
        this.panelIndex.add(jLabel);
        this.index = new JTextField("    ");
        this.index.setColumns(39);
        this.panelIndex.add(this.index);
        KeyListener keyListener = new KeyListener(){

            public void keyReleased(KeyEvent keyEvent) {
                PM_WindowSearch.this.windowMain.keyTextFieldPressed(keyEvent);
                if ((keyEvent.getModifiers() & 2) != 0) {
                    return;
                }
                PM_WindowSearch.this.setIndexEnable();
                PM_WindowSearch.this.suchenGeaendert();
            }

            public void keyTyped(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
            }
        };
        this.index.addKeyListener(keyListener);
        this.clearButtonOrt = PM_Utils.getJButon("button_cancel.png");
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSearch.this.doClearOrt();
                PM_WindowSearch.this.suchenGeaendert();
            }
        };
        this.clearButtonOrt.addActionListener(actionListener2);
        this.panelOrt.add(this.clearButtonOrt);
        JLabel jLabel2 = new JLabel("Index 2:");
        this.panelOrt.add(jLabel2);
        this.ort = new JTextField("    ");
        this.ort.setColumns(39);
        this.panelOrt.add(this.ort);
        KeyListener keyListener2 = new KeyListener(){

            public void keyReleased(KeyEvent keyEvent) {
                PM_WindowSearch.this.windowMain.keyTextFieldPressed(keyEvent);
                if ((keyEvent.getModifiers() & 2) != 0) {
                    return;
                }
                PM_WindowSearch.this.setOrtEnable();
                PM_WindowSearch.this.suchenGeaendert();
            }

            public void keyTyped(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
            }
        };
        this.ort.addKeyListener(keyListener2);
        this.clearButtonQS = PM_Utils.getJButon("button_cancel.png");
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSearch.this.doClearQS();
                PM_WindowSearch.this.suchenGeaendert();
            }
        };
        this.clearButtonQS.addActionListener(actionListener3);
        this.panelQualitaet.add(this.clearButtonQS);
        this.qPanel = new JPanel();
        this.qLabel = new JLabel("Kategorie 1..4:");
        this.qPanel.add(this.qLabel);
        this.q1 = new JCheckBox();
        this.q2 = new JCheckBox();
        this.q3 = new JCheckBox();
        this.q4 = new JCheckBox();
        this.qPanel.add(this.q1);
        this.qPanel.add(this.q2);
        this.qPanel.add(this.q3);
        this.qPanel.add(this.q4);
        this.panelQualitaet.add(this.qPanel);
        this.q1.addMouseListener(mouseListener);
        this.q2.addMouseListener(mouseListener);
        this.q3.addMouseListener(mouseListener);
        this.q4.addMouseListener(mouseListener);
        this.clearButtonSequ = PM_Utils.getJButon("button_cancel.png");
        ActionListener actionListener4 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSearch.this.doClearSequ();
                PM_WindowSearch.this.suchenGeaendert();
            }
        };
        this.clearButtonSequ.addActionListener(actionListener4);
        this.panelQualitaet.add(this.clearButtonSequ);
        this.sLabel = new JLabel("Serien:");
        this.panelQualitaet.add(this.sLabel);
        this.comboBoxSequenzen = new JComboBox<Object>(this.getListeGeschlSeqenzen().toArray());
        this.comboBoxSequenzen.addPopupMenuListener(popupMenuListener);
        PM_Listener pM_Listener = new PM_Listener(){

            public void actionPerformed(PM_Action pM_Action) {
                PM_WindowSearch.this.updateComboBoxSequences();
            }
        };
        PM_TreeModelBase.getInstance().addChangeListener(pM_Listener);
        PM_TreeModelExtended.getInstance().addChangeListener(pM_Listener);
        ActionListener actionListener5 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PM_WindowSearch.this.comboBoxSequenzen.getSelectedIndex() == 0) {
                    PM_WindowSearch.this.clearButtonSequ.setBackground(PM_WindowBase.COLOR_BG_PANEL);
                } else {
                    PM_WindowSearch.this.clearButtonSequ.setBackground(Color.RED);
                }
            }
        };
        this.comboBoxSequenzen.addActionListener(actionListener5);
        this.panelQualitaet.add(this.comboBoxSequenzen);
        this.datPanel = new JPanel();
        this.clearButtonDatum = PM_Utils.getJButon("button_cancel.png");
        ActionListener actionListener6 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSearch.this.doClearDatum();
                PM_WindowSearch.this.setEnableClearButtons();
                PM_WindowSearch.this.suchenGeaendert();
            }
        };
        this.clearButtonDatum.addActionListener(actionListener6);
        this.panelDatum.add(this.clearButtonDatum);
        this.datLabelVon = new JLabel("%Datum von%");
        this.datPanel.add(this.datLabelVon);
        this.vonJahr = new JComboBox<String>(PM_Utils.getJahre(true));
        this.vonJahr.addPopupMenuListener(popupMenuListener);
        this.datPanel.add(this.vonJahr);
        this.vonMonat = new JComboBox(PM_Utils.getMonate(true));
        this.vonMonat.addPopupMenuListener(popupMenuListener);
        this.datPanel.add(this.vonMonat);
        this.vonTag = new JComboBox(PM_Utils.getTage(true));
        this.vonTag.addPopupMenuListener(popupMenuListener);
        this.datPanel.add(this.vonTag);
        this.datLabelTo = new JLabel(" bis ");
        this.datPanel.add(this.datLabelTo);
        this.bisJahr = new JComboBox<String>(PM_Utils.getJahre(true));
        this.bisJahr.addPopupMenuListener(popupMenuListener);
        this.datPanel.add(this.bisJahr);
        this.bisMonat = new JComboBox(PM_Utils.getMonate(true));
        this.bisMonat.addPopupMenuListener(popupMenuListener);
        this.datPanel.add(this.bisMonat);
        this.bisTag = new JComboBox(PM_Utils.getTage(true));
        this.bisTag.addPopupMenuListener(popupMenuListener);
        this.datPanel.add(this.bisTag);
        this.panelDatum.add(this.datPanel);
        this.belowPanel = this.getSearchResultPanel();
        JScrollPane jScrollPane = new JScrollPane(this.belowPanel);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        pM_FocusPanel.add(jScrollPane);
        pM_FocusPanel.add(this.panelDatum);
        pM_FocusPanel.add(this.panelQualitaet);
        pM_FocusPanel.add(this.panelIndex);
        pM_FocusPanel.add(this.panelOrt);
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        arrayList.add(this.clearButtonDatum);
        arrayList.add(this.vonJahr);
        arrayList.add(this.vonMonat);
        arrayList.add(this.vonTag);
        arrayList.add(this.bisJahr);
        arrayList.add(this.bisMonat);
        arrayList.add(this.bisTag);
        ArrayList<JComponent> arrayList2 = new ArrayList<JComponent>();
        arrayList2.add(this.clearButtonQS);
        arrayList2.add(this.q1);
        arrayList2.add(this.q2);
        arrayList2.add(this.q3);
        arrayList2.add(this.q4);
        arrayList2.add(this.clearButtonSequ);
        arrayList2.add(this.comboBoxSequenzen);
        ArrayList<JComponent> arrayList3 = new ArrayList<JComponent>();
        arrayList3.add(this.clearButtonIndex);
        arrayList3.add(this.index);
        ArrayList<JComponent> arrayList4 = new ArrayList<JComponent>();
        arrayList4.add(this.clearButtonOrt);
        arrayList4.add(this.ort);
        ArrayList<JButton> arrayList5 = new ArrayList<JButton>();
        arrayList5.add(this.buttonDarstellen);
        arrayList5.add(this.buttonDiaShow);
        ArrayList<ArrayList<JComponent>> arrayList6 = new ArrayList<ArrayList<JComponent>>();
        arrayList6.add(arrayList);
        arrayList6.add(arrayList2);
        arrayList6.add(arrayList3);
        arrayList6.add(arrayList4);
        arrayList6.add(arrayList5);
        pM_FocusPanel.setFocusListe(arrayList6);
        pM_FocusPanel.setLastFocus(this.index);
        pM_FocusPanel.setContainer(pM_FocusPanel);
        return pM_FocusPanel;
    }

    private void updateComboBoxSequences() {
        this.comboBoxSequenzen.removeAllItems();
        Vector<String> vector = this.getListeGeschlSeqenzen();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            this.comboBoxSequenzen.addItem(iterator.next());
        }
    }

    private JSplitPane getIndex12() {
        this.indexListe = new JList();
        this.indexListe.setFont(this.luceneIndexInstance.getFont(this.indexListe.getFont()));
        this.indexListe.setSelectionMode(0);
        this.indexListe.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Object e = PM_WindowSearch.this.indexListe.getSelectedValue();
                if (e == null) {
                    return;
                }
                if (PM_WindowSearch.this.lastSelected == -1) {
                    String string = (String)e;
                    PM_WindowSearch.this.index.setText(PM_WindowSearch.this.index.getText() + " " + string);
                    PM_WindowSearch.this.setIndexEnable();
                    PM_WindowSearch.this.lastSelected = PM_WindowSearch.this.indexListe.getSelectedIndex();
                    PM_WindowSearch.this.doSuchen();
                } else {
                    PM_WindowSearch.this.lastSelected = -1;
                }
            }
        });
        PM_Listener pM_Listener = new PM_Listener(){

            public void actionPerformed(PM_Action pM_Action) {
                PM_WindowSearch.this.luceneIndexChanged(pM_Action);
            }
        };
        this.luceneIndexInstance.addListener(pM_Listener);
        this.ortListe = new JList();
        this.ortListe.setFont(this.luceneIndexInstance.getFont(this.ortListe.getFont()));
        this.ortListe.setSelectionMode(0);
        this.ortListe.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Object e = PM_WindowSearch.this.ortListe.getSelectedValue();
                if (e == null) {
                    return;
                }
                if (PM_WindowSearch.this.lastSelected == -1) {
                    String string = (String)e;
                    PM_WindowSearch.this.ort.setText(PM_WindowSearch.this.ort.getText() + " " + string);
                    PM_WindowSearch.this.setOrtEnable();
                    PM_WindowSearch.this.lastSelected = PM_WindowSearch.this.ortListe.getSelectedIndex();
                    PM_WindowSearch.this.doSuchen();
                } else {
                    PM_WindowSearch.this.lastSelected = -1;
                }
            }
        });
        PM_Listener pM_Listener2 = new PM_Listener(){

            public void actionPerformed(PM_Action pM_Action) {
                PM_WindowSearch.this.luceneIndexChanged(pM_Action);
            }
        };
        this.luceneIndexInstance.addListener(pM_Listener2);
        JScrollPane jScrollPane = new JScrollPane(this.indexListe);
        JScrollPane jScrollPane2 = new JScrollPane(this.ortListe);
        this.splitListenPane = new JSplitPane(0, jScrollPane, jScrollPane2);
        int n = PM_All_InitValues.getInstance().getValueInt(this, "index-list-divider");
        if (n == 0) {
            n = 150;
        }
        this.splitListenPane.setDividerLocation(n);
        return this.splitListenPane;
    }

    private JPanel getSearchResultPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(200, 40));
        jPanel.setLayout(new FlowLayout(0));
        this.buttonDarstellen = PM_Utils.getJButon("1leftarrow.png");
        jPanel.add(this.buttonDarstellen);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PM_WindowSearch.this.anzahlHits == 0) {
                    return;
                }
                PM_WindowSearch.this.indexViewThumbnails.setAndPaintPictureList(PM_WindowSearch.this.getSortedPictureResultList());
            }
        };
        this.buttonDarstellen.addActionListener(actionListener);
        this.buttonAppend = PM_Utils.getJButon("2leftarrow.png");
        jPanel.add(this.buttonAppend);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PM_WindowSearch.this.anzahlHits == 0) {
                    return;
                }
                PM_WindowSearch.this.indexViewThumbnails.appendPictureList(PM_WindowSearch.this.getSortedPictureResultList());
            }
        };
        this.buttonAppend.addActionListener(actionListener2);
        this.hitsUpperPanel = new JTextField("");
        this.hitsUpperPanel.setForeground(Color.BLACK);
        this.hitsUpperPanel.setEnabled(true);
        this.hitsUpperPanel.setEditable(false);
        this.hitsUpperPanel.setFocusable(false);
        this.hitsUpperPanel.setColumns(4);
        jPanel.add(this.hitsUpperPanel);
        Font font = this.hitsUpperPanel.getFont();
        Font font2 = new Font(font.getName(), 1, font.getSize());
        this.hitsUpperPanel.setFont(font2);
        this.clearButtonHits = PM_Utils.getJButon("button_cancel.png");
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSearch.this.doClearHits();
            }
        };
        this.clearButtonHits.addActionListener(actionListener3);
        jPanel.add(this.clearButtonHits);
        this.buttonDiaShow = new JButton("?Diashow");
        jPanel.add(this.buttonDiaShow);
        ActionListener actionListener4 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSearch.this.doHitsDiashowDarstellen(1);
            }
        };
        this.buttonDiaShow.addActionListener(actionListener4);
        this.neueSerie = PM_Utils.getJButon("new.gif");
        this.neueSerie.setEnabled(false);
        this.labelNew = new JLabel("Neu: ");
        jPanel.add(this.labelNew);
        jPanel.add(this.neueSerie);
        new DragSourceNew(this.neueSerie);
        this.labelDnD = new JLabel("(mit Drag & Drop ins Fotoalbum)");
        jPanel.add(this.labelDnD);
        return jPanel;
    }

    private PM_Sequence getSequenceNew() {
        PM_SequenceAlbum pM_SequenceAlbum = new PM_SequenceAlbum();
        this.setSequenzFromGUI(pM_SequenceAlbum);
        return pM_SequenceAlbum;
    }

    class DragSourceNew
    implements DragSourceListener,
    DragGestureListener {
        private DragSource dragSource = new DragSource();

        public DragSourceNew(Component component) {
            this.dragSource.createDefaultDragGestureRecognizer(component, 3, this);
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
            DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
            dragSourceContext.setCursor(DragSource.DefaultMoveDrop);
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
            DragSourceContext dragSourceContext = dragSourceEvent.getDragSourceContext();
            dragSourceContext.setCursor(DragSource.DefaultMoveNoDrop);
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            Component component = dragGestureEvent.getComponent();
            if (!(component instanceof JButton)) {
                return;
            }
            JButton jButton = (JButton)component;
            if (!jButton.isEnabled()) {
                return;
            }
            PM_Sequence pM_Sequence = PM_WindowSearch.this.getSequenceNew();
            if (pM_Sequence == null) {
                return;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add((Object)PM_Interface.DragAndDropType.NEW_SEQUENCE_ALBUM);
            arrayList.add(pM_Sequence);
            PM_Transferable pM_Transferable = new PM_Transferable(arrayList);
            this.dragSource.startDrag(dragGestureEvent, DragSource.DefaultMoveNoDrop, pM_Transferable, this);
        }
    }

    class SortOrder {
        public PM_Interface.SearchSortType sortType;
        public String text;

        public SortOrder(PM_Interface.SearchSortType searchSortType, String string) {
            this.sortType = searchSortType;
            this.text = string;
        }

        public String toString() {
            return this.text;
        }
    }
}

