/*
 * Decompiled with CFR 0.152.
 */
package pm.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import pm.gui.PM_FocusPanel;
import pm.gui.PM_IndexView;
import pm.gui.PM_PictureView;
import pm.gui.PM_WindowBase;
import pm.gui.PM_WindowMain;
import pm.inout.PM_All_InitValues;
import pm.picture.PM_Picture;
import pm.sequence.PM_Sequence;
import pm.sequence.PM_SequenceBase;
import pm.sequence.PM_SequenceExtended;
import pm.sequence.PM_TreeModel;
import pm.sequence.PM_TreeModelAlbum;
import pm.sequence.PM_TreeModelBase;
import pm.sequence.PM_TreeModelExtended;
import pm.sequence.PM_TreeWindow;
import pm.sequence.PM_TreeWindowBase;
import pm.sequence.PM_TreeWindowExtended;
import pm.utilities.PM_Action;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Listener;
import pm.utilities.PM_MSG;
import pm.utilities.PM_Transferable;
import pm.utilities.PM_Utils;
import pm.utilities.PM_UtilsGrafik;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_WindowSequence
extends PM_WindowBase
implements PM_Interface {
    private final PM_IndexView indexViewBase;
    private final PM_IndexView indexViewExtended;
    private final JScrollPane indexViewBaseScrollPane;
    private final JScrollPane indexViewExtendedScrollPane;
    private static boolean baseSelected = true;
    private final PM_IndexView indexViewThumbnails;
    int sliderValue = 100;
    private List<PM_Picture> sequencePictureListBase = new ArrayList<PM_Picture>();
    private List<PM_Picture> sequencePictureListExtended = new ArrayList<PM_Picture>();
    private PM_Sequence sequenceDargestelltBase = null;
    private PM_Sequence sequenceDargestelltExtended = null;
    private DefaultMutableTreeNode nodeDargestelltBase = null;
    private DefaultMutableTreeNode nodeDargestelltExtended = null;
    private TreeSelectionListener treeSelectionListener;
    private PM_Listener treeChangeListener;
    private PM_Sequence seqOneClick = null;
    private DefaultMutableTreeNode nodeOneClick = null;
    private PM_Sequence newCreatedSequence = null;
    private JTabbedPane tabPaneTreeWindows;
    private int tabIndexBase = 0;
    private int tabIndexExtended = 1;
    private JSplitPane treeBase = null;
    private JSplitPane treeExtended = null;
    private JLabel labelSequenceNameBase = new JLabel();
    private JLabel labelSequenceNameExtended = new JLabel();
    private JButton buttonAenBase = new JButton();
    private JButton buttonAenExtended = new JButton();
    private JButton buttonLoeBase = new JButton();
    private JButton buttonLoeExtended = new JButton();
    private JLabel upperLabel;
    private JPanel panelButtonBase = new JPanel(new FlowLayout(0));
    private JPanel panelButtonExtended = new JPanel(new FlowLayout(0));
    private JLabel panelButtonBaseNew1 = new JLabel("Neue B-Serie: ");
    private JLabel panelButtonBaseNew2 = new JLabel("(mit Drag & Drop in den rechten Baum ziehen)");
    private JLabel panelButtonExtendedNew1 = new JLabel("Neue X-Serie: ");
    private JLabel panelButtonExtendedNew2 = new JLabel("(mit Drag & Drop in den rechten Baum ziehen)");
    private JButton buttonNeuBase = PM_Utils.getJButon("new.gif");
    private JButton buttonNeuExtended = PM_Utils.getJButon("new.gif");

    public PM_WindowSequence(PM_WindowMain pM_WindowMain, int n) {
        super(pM_WindowMain, n, false);
        this.indexViewBase = new PM_IndexView(pM_WindowMain, this);
        this.indexViewBaseScrollPane = this.indexViewBase.getScrollPane();
        this.indexViewExtended = new PM_IndexView(pM_WindowMain, this);
        this.indexViewExtendedScrollPane = this.indexViewExtended.getScrollPane();
        this.indexViewThumbnails = pM_WindowMain.getIndexViewThumbnails();
        this.treeSelectionListener = new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                Object object = treeSelectionEvent.getSource();
                if (!(object instanceof PM_TreeWindow)) {
                    return;
                }
                PM_TreeWindow pM_TreeWindow = (PM_TreeWindow)object;
                if (pM_TreeWindow.isSelectionEmpty()) {
                    return;
                }
                PM_WindowSequence.this.selectSequence(treeSelectionEvent, pM_TreeWindow);
            }
        };
        this.createGUI();
        this.treeChangeListener = new PM_Listener(){

            public void actionPerformed(PM_Action pM_Action) {
                PM_WindowSequence.this.doChangeTree(pM_Action);
            }
        };
        PM_TreeModelBase.getInstance().addChangeListener(this.treeChangeListener);
        PM_TreeModelExtended.getInstance().addChangeListener(this.treeChangeListener);
        PM_Listener pM_Listener = new PM_Listener(){

            public void actionPerformed(PM_Action pM_Action) {
                PM_WindowSequence.this.setMsg();
            }
        };
        PM_MSG.addChangeListener(pM_Listener);
        this.setMsg();
    }

    private void setMsg() {
        this.tabPaneTreeWindows.setTitleAt(this.tabIndexBase, PM_MSG.getMsg("winSeqTabBase"));
        this.tabPaneTreeWindows.setTitleAt(this.tabIndexExtended, PM_MSG.getMsg("winSeqTabExt"));
        if (this.tabPaneTreeWindows.getSelectedIndex() == this.tabIndexBase) {
            this.upperLabel.setText(PM_MSG.getMsg("winSeqHeaderB"));
        } else {
            this.upperLabel.setText(PM_MSG.getMsg("winSeqHeaderX"));
        }
        this.labelSequenceNameBase.setText(PM_MSG.getMsg("winSeqNoDisplayesB"));
        this.labelSequenceNameExtended.setText(PM_MSG.getMsg("winSeqNoDisplayesX"));
        this.buttonAenBase.setText(PM_MSG.getMsg("modifiy"));
        this.buttonAenExtended.setText(PM_MSG.getMsg("modifiy"));
        this.buttonLoeBase.setText(PM_MSG.getMsg("delete"));
        this.buttonLoeExtended.setText(PM_MSG.getMsg("delete"));
        this.panelButtonBaseNew1.setText(PM_MSG.getMsg("winSeqNewB"));
        this.panelButtonBaseNew2.setText(PM_MSG.getMsg("winSeqNewBdnd"));
        this.panelButtonExtendedNew1.setText(PM_MSG.getMsg("winSeqNewX"));
        this.panelButtonExtendedNew2.setText(PM_MSG.getMsg("winSeqNewXdnd"));
    }

    public void doChangeTree(PM_Action pM_Action) {
        this.setLabelSequenceName(this.getNameForSequenceLabel(this.getSequenceDargestellt()));
    }

    @Override
    public void getAllThumbs(PM_IndexView pM_IndexView) {
        this.loeschenDarstellungSequenz();
        super.getAllThumbs(pM_IndexView);
        this.setButtons();
    }

    @Override
    public boolean appendAllThumbs(PM_IndexView pM_IndexView) {
        if (!super.appendAllThumbs(pM_IndexView)) {
            return false;
        }
        this.setButtons();
        return true;
    }

    @Override
    public boolean appendPicture(PM_PictureView pM_PictureView) {
        if (!super.appendPicture(pM_PictureView)) {
            return false;
        }
        this.setButtons();
        return true;
    }

    @Override
    public void removeAllThumbs() {
        this.darstellungLoeschen();
    }

    @Override
    public void rereadAllThumbs() {
        this.indexViewBase.rereadAllThumbs();
        this.indexViewExtended.rereadAllThumbs();
        this.setButtons();
    }

    @Override
    public void openPicture(PM_Picture pM_Picture) {
        super.openPicture(pM_Picture);
        this.setButtons();
    }

    @Override
    public void closePicture(PM_Picture pM_Picture) {
        super.closePicture(pM_Picture);
        this.setButtons();
    }

    @Override
    public boolean movePicture(PM_Picture pM_Picture, PM_Picture pM_Picture2) {
        if (!super.movePicture(pM_Picture, pM_Picture2)) {
            return false;
        }
        this.setButtons();
        return true;
    }

    @Override
    public boolean insertPicture(PM_Picture pM_Picture, PM_Picture pM_Picture2) {
        if (!super.insertPicture(pM_Picture, pM_Picture2)) {
            return false;
        }
        this.setButtons();
        return true;
    }

    @Override
    public void close() {
        PM_All_InitValues.getInstance().putValueInt(this, "devider-base", this.treeBase.getDividerLocation());
        PM_All_InitValues.getInstance().putValueInt(this, "devider-extended", this.treeExtended.getDividerLocation());
    }

    @Override
    public void doubleClickOnTree(DefaultMutableTreeNode defaultMutableTreeNode, PM_TreeWindow pM_TreeWindow) {
        this.displaySequence();
    }

    private void displaySequence() {
        int n;
        if (this.getSequenceDargestellt() == null && this.getIndexView().getPictureSize() > 0 && (n = JOptionPane.showConfirmDialog(this, PM_MSG.getMsg("winSeqNoSeqDispl"), "Sicherheitsabfrage", 0, 3)) == 1) {
            return;
        }
        if (this.darstellungGeaendert() && (n = JOptionPane.showConfirmDialog(this, PM_MSG.getMsg("winSeqSeqOverwrite"), "Sicherheitsabfrage", 0, 3)) == 1) {
            return;
        }
        if (this.seqOneClick == null) {
            this.loeschenDarstellungSequenz();
            return;
        }
        this.setSequenceNodeDargestellt(this.seqOneClick, this.nodeOneClick);
        this.setSequencePictureList(this.seqOneClick.getAlleBilder());
        this.getIndexView().setAndPaintPictureList(this.getSequencePictureList());
        this.indexViewThumbnails.repaintViewport();
        this.setLabelSequenceName(this.getNameForSequenceLabel(this.seqOneClick));
        this.setButtons();
    }

    private void selectSequence(TreeSelectionEvent treeSelectionEvent, PM_TreeWindow pM_TreeWindow) {
        TreePath treePath = treeSelectionEvent.getPath();
        Object object = treePath.getLastPathComponent();
        if (object instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof PM_Sequence) {
                PM_Sequence pM_Sequence = (PM_Sequence)object2;
                this.darstellungSequenz(pM_Sequence, defaultMutableTreeNode);
            } else {
                this.darstellungSequenz(null, null);
            }
        }
    }

    @Override
    public void rereadPictureViewThumbnail(PM_Picture pM_Picture) {
        this.indexViewBase.rereadPictureViewThumbnail(pM_Picture);
        this.indexViewExtended.rereadPictureViewThumbnail(pM_Picture);
    }

    @Override
    public boolean requestToClose() {
        boolean bl;
        if (this.sequenceDargestelltBase == null && this.sequenceDargestelltExtended == null) {
            return true;
        }
        boolean bl2 = !this.indexViewBase.isEqual(this.sequencePictureListBase);
        boolean bl3 = bl = !this.indexViewExtended.isEqual(this.sequencePictureListExtended);
        if (!bl2 && !bl) {
            return true;
        }
        String string = "";
        if (bl2 || bl) {
            string = bl2 ? String.format(PM_MSG.getMsg("winSeqClose1"), PM_MSG.getMsg("sequB")) : String.format(PM_MSG.getMsg("winSeqClose1"), PM_MSG.getMsg("sequX"));
        }
        if (bl2 && bl) {
            string = PM_MSG.getMsg("winSeqClose2");
        }
        JOptionPane.showConfirmDialog(this, string, "Close ERROR", -1, 0);
        return false;
    }

    @Override
    public boolean flush() {
        if (!this.requestToClose()) {
            return false;
        }
        this.indexViewBase.removeAllThumbs();
        this.indexViewBase.repaintViewport();
        this.indexViewExtended.removeAllThumbs();
        this.indexViewExtended.repaintViewport();
        return true;
    }

    @Override
    public boolean requestToChange() {
        return true;
    }

    private void setBackgroundUpperPanel(Color color) {
    }

    private void setBackgroundUpperIndexPanel(Color color) {
    }

    public static boolean isBaseSelected() {
        return baseSelected;
    }

    public boolean isInBaseSequence(PM_Picture pM_Picture) {
        if (!PM_WindowSequence.isBaseSelected()) {
            return false;
        }
        PM_Sequence pM_Sequence = this.getSequenceDargestellt();
        if (pM_Sequence != null) {
            if (!pM_Picture.meta.hasBaseSequence()) {
                return false;
            }
            return !pM_Sequence.getShortName().equals(pM_Picture.meta.getBaseSequenceName());
        }
        return pM_Picture.meta.hasBaseSequence();
    }

    private void doLoeschenSequenz(PM_Sequence pM_Sequence) {
        Map<PM_Sequence, Set<DefaultMutableTreeNode>> map = PM_TreeModelAlbum.getInstance().getSequenceDictionary();
        if (map.containsKey(pM_Sequence)) {
            JOptionPane.showConfirmDialog(this, PM_MSG.getMsg("winSeqDeleteAlbum"), "Message", -1, 0);
            return;
        }
        if (pM_Sequence == null) {
            return;
        }
        int n = JOptionPane.showConfirmDialog(this, PM_MSG.getMsg("winSeqDeleteSeq"), "delete ?", 0, 3);
        if (n == 1) {
            return;
        }
        pM_Sequence.loeschenSequenz();
        JOptionPane.showConfirmDialog(this, PM_MSG.getMsg("winSeqDeleteEnd"), "gel\u00f6scht", -1, 1);
        DefaultMutableTreeNode defaultMutableTreeNode = this.getNodeDargestellt();
        if (defaultMutableTreeNode != null) {
            PM_TreeModel pM_TreeModel = baseSelected ? PM_TreeModelBase.getInstance() : PM_TreeModelExtended.getInstance();
            pM_TreeModel.removeNodeFromParent(defaultMutableTreeNode);
            pM_TreeModel.nodeChanged(pM_TreeModel.getRootNode());
        }
        this.setSequenceNodeDargestellt(null, null);
        this.setButtons();
        this.setLabelSequenceName(" ");
        this.darstellungLoeschen();
    }

    private void darstellungLoeschen() {
        int n;
        if (this.getSequenceDargestellt() == null) {
            this.loeschenDarstellungSequenz();
            return;
        }
        if (this.darstellungGeaendert() && (n = JOptionPane.showConfirmDialog(this, PM_MSG.getMsg("winSeqChangeSeq"), "", 0, 3)) == 1) {
            return;
        }
        this.loeschenDarstellungSequenz();
        this.setSequenceNodeDargestellt(null, null);
        this.setButtons();
    }

    private void loeschenDarstellungSequenz() {
        this.getIndexView().removeAllThumbs();
        if (baseSelected) {
            this.setLabelSequenceName(PM_MSG.getMsg("winSeqNoDisplayesB"));
        } else {
            this.setLabelSequenceName(PM_MSG.getMsg("winSeqNoDisplayesX"));
        }
        this.setSequenceNodeDargestellt(null, null);
        this.setSequencePictureList(null);
        this.setButtons();
    }

    @Override
    public void darstellungSequenz(PM_Sequence pM_Sequence, DefaultMutableTreeNode defaultMutableTreeNode) {
        this.seqOneClick = pM_Sequence;
        this.nodeOneClick = defaultMutableTreeNode;
    }

    private String getNameForSequenceLabel(PM_Sequence pM_Sequence) {
        if (pM_Sequence == null) {
            return " ";
        }
        return pM_Sequence.getShortName() + ":" + pM_Sequence.getLongName();
    }

    private PM_Sequence getSequenceNew() {
        if (this.getSequenceDargestellt() != null) {
            int n = JOptionPane.showConfirmDialog(this, PM_MSG.getMsg("winSeqCopy"), "", 0, 3);
            if (n == 1) {
                return null;
            }
            this.loeschenDarstellungSequenz();
        }
        if (this.getIndexView().sizeDargestellt() == 0) {
            JOptionPane.showConfirmDialog(this, PM_MSG.getMsg("winSeqNoPics"), " ", -1, 0);
            return null;
        }
        List<PM_Picture> list = this.getIndexView().getPictureListDarstellen();
        PM_Sequence pM_Sequence = baseSelected ? new PM_SequenceBase("????????", list) : new PM_SequenceExtended("????????", list);
        return pM_Sequence;
    }

    private void dragDropDone() {
        if (this.newCreatedSequence == null) {
            return;
        }
        int n = JOptionPane.showConfirmDialog(null, String.format(PM_MSG.getMsg("winSeqNewEnd"), this.newCreatedSequence.getShortName()), " ", 0, 3);
        if (n == 0) {
            List<PM_Picture> list = this.getIndexView().getPictureListDarstellen();
            this.indexViewThumbnails.removePictureList(list);
        }
        this.loeschenDarstellungSequenz();
    }

    private void doAendernSequenz() {
        String string;
        int n;
        String string2;
        int n2;
        if (this.getIndexView().sizeDargestellt() == 0) {
            JOptionPane.showConfirmDialog(this, PM_MSG.getMsg("winSeqNoPicsMod"), " ", -1, 0);
            return;
        }
        if (this.getSequenceDargestellt() == null) {
            JOptionPane.showConfirmDialog(this, PM_MSG.getMsg("winSeqNoSeqDisplayed"), " ", -1, 0);
            return;
        }
        if (!this.darstellungGeaendert()) {
            JOptionPane.showConfirmDialog(this, PM_MSG.getMsg("winSeqNoPicsModified"), "Keine \u00c4nderung", -1, 0);
            return;
        }
        List<PM_Picture> list = this.getIndexView().getPictureListDarstellen();
        int n3 = 0;
        Iterator<PM_Picture> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (!this.isInBaseSequence(iterator.next())) continue;
            ++n3;
        }
        if (n3 > 0 ? (n2 = JOptionPane.showConfirmDialog(this, string2 = String.format(PM_MSG.getMsg("winSeqPicsPresent"), this.getSequenceDargestellt().getShortName(), n3), "Sicherheitsabfrage", 0, 3)) == 1 : (n = JOptionPane.showConfirmDialog(this, string = String.format(PM_MSG.getMsg("winSeqCanModify"), this.getSequenceDargestellt().getShortName()), " ", 0, 3)) == 1) {
            return;
        }
        this.getSequenceDargestellt().aendernSequenz(list);
        JOptionPane.showConfirmDialog(this, PM_MSG.getMsg("winSeqModified"), "O.K.", -1, 1);
        this.setSequencePictureList(this.getSequenceDargestellt().getAlleBilder());
        this.getIndexView().setAndPaintPictureList(this.getSequencePictureList());
        this.setLabelSequenceName(this.getNameForSequenceLabel(this.getSequenceDargestellt()));
        this.setButtons();
    }

    private boolean darstellungGeaendert() {
        return !this.getIndexView().isEqual(this.getSequencePictureList());
    }

    @Override
    public PM_IndexView getIndexView() {
        if (baseSelected) {
            return this.indexViewBase;
        }
        return this.indexViewExtended;
    }

    private void setSequencePictureList(List<PM_Picture> list) {
        if (baseSelected) {
            this.sequencePictureListBase = list == null ? new ArrayList<PM_Picture>() : list;
        } else {
            this.sequencePictureListExtended = list == null ? new ArrayList<PM_Picture>() : list;
        }
    }

    private List<PM_Picture> getSequencePictureList() {
        if (baseSelected) {
            return this.sequencePictureListBase;
        }
        return this.sequencePictureListExtended;
    }

    private void setSequenceNodeDargestellt(PM_Sequence pM_Sequence, DefaultMutableTreeNode defaultMutableTreeNode) {
        if (baseSelected) {
            this.sequenceDargestelltBase = pM_Sequence;
            this.nodeDargestelltBase = defaultMutableTreeNode;
        } else {
            this.sequenceDargestelltExtended = pM_Sequence;
            this.nodeDargestelltExtended = defaultMutableTreeNode;
        }
    }

    public PM_Sequence getSequenceDargestellt() {
        if (baseSelected) {
            return this.sequenceDargestelltBase;
        }
        return this.sequenceDargestelltExtended;
    }

    private DefaultMutableTreeNode getNodeDargestellt() {
        if (baseSelected) {
            return this.nodeDargestelltBase;
        }
        return this.nodeDargestelltExtended;
    }

    private void setButtons() {
        if (this.getSequenceDargestellt() != null) {
            this.getButtonNeu().setEnabled(false);
            this.getButtonLoe().setEnabled(true);
            if (this.darstellungGeaendert()) {
                this.getButtonAen().setEnabled(true);
            } else {
                this.getButtonAen().setEnabled(false);
            }
        } else {
            this.getButtonAen().setEnabled(false);
            this.getButtonLoe().setEnabled(false);
            if (this.getIndexView().getPictureSize() == 0) {
                this.getButtonNeu().setEnabled(false);
            } else {
                this.getButtonNeu().setEnabled(true);
            }
        }
    }

    private void createGUI() {
        PM_FocusPanel pM_FocusPanel = this.getUpperAllPanel();
        JScrollPane jScrollPane = new JScrollPane(pM_FocusPanel);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        int n = PM_All_InitValues.getInstance().getValueInt(this, "devider-base");
        int n2 = PM_All_InitValues.getInstance().getValueInt(this, "devider-extended");
        if (n == 0) {
            n = 100;
        }
        if (n2 == 0) {
            n2 = 100;
        }
        this.treeBase = this.getGuiForTab(this.indexViewBase, this.indexViewBaseScrollPane, new PM_TreeWindowBase(this));
        this.treeBase.setDividerLocation(n);
        this.treeExtended = this.getGuiForTab(this.indexViewExtended, this.indexViewExtendedScrollPane, new PM_TreeWindowExtended(this));
        this.treeExtended.setDividerLocation(n2);
        this.tabPaneTreeWindows = new JTabbedPane();
        this.tabPaneTreeWindows.insertTab("?B-Serien", null, this.treeBase, "", this.tabIndexBase);
        this.tabPaneTreeWindows.insertTab("?X-Serien", null, this.treeExtended, "", this.tabIndexExtended);
        this.tabPaneTreeWindows.setSelectedIndex(this.tabIndexBase);
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = PM_WindowSequence.this.tabPaneTreeWindows.getSelectedIndex();
                if (n == PM_WindowSequence.this.tabIndexBase) {
                    PM_WindowSequence.this.upperLabel.setText(PM_MSG.getMsg("winSeqHeaderB"));
                    baseSelected = true;
                } else {
                    PM_WindowSequence.this.upperLabel.setText(PM_MSG.getMsg("winSeqHeaderX"));
                    baseSelected = false;
                }
                PM_WindowSequence.this.indexViewThumbnails.repaintViewport();
            }
        };
        this.tabPaneTreeWindows.addChangeListener(changeListener);
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "North");
        this.add((Component)this.tabPaneTreeWindows, "Center");
    }

    private void setLabelSequenceName(String string) {
        if (baseSelected) {
            this.labelSequenceNameBase.setText(string);
        } else {
            this.labelSequenceNameExtended.setText(string);
        }
    }

    private JButton getButtonAen() {
        if (baseSelected) {
            return this.buttonAenBase;
        }
        return this.buttonAenExtended;
    }

    private JButton getButtonLoe() {
        if (baseSelected) {
            return this.buttonLoeBase;
        }
        return this.buttonLoeExtended;
    }

    private JSplitPane getGuiForTab(PM_IndexView pM_IndexView, JScrollPane jScrollPane, PM_TreeWindow pM_TreeWindow) {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        pM_TreeWindow.addTreeSelectionListener(this.treeSelectionListener);
        JPanel jPanel3 = this.getUpperIndexPanel(pM_TreeWindow);
        this.setBackgroundUpperIndexPanel(COLOR_BG_PANEL);
        JLabel jLabel = pM_TreeWindow instanceof PM_TreeWindowBase ? this.labelSequenceNameBase : this.labelSequenceNameExtended;
        Font font = jLabel.getFont();
        Font font2 = new Font(font.getName(), 1, 20);
        jLabel.setFont(font2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0));
        jPanel4.add(jLabel);
        if (pM_TreeWindow instanceof PM_TreeWindowBase) {
            this.panelButtonBase.add(this.panelButtonBaseNew1);
            this.panelButtonBase.add(this.buttonNeuBase);
            this.panelButtonBase.add(this.panelButtonBaseNew2);
            this.buttonNeuBase.setEnabled(false);
            new DragSourceNew(this.buttonNeuBase);
        } else {
            this.panelButtonExtended.add(this.panelButtonExtendedNew1);
            this.panelButtonExtended.add(this.buttonNeuExtended);
            this.panelButtonExtended.add(this.panelButtonExtendedNew2);
            this.buttonNeuExtended.setEnabled(false);
            new DragSourceNew(this.buttonNeuExtended);
        }
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.add(jPanel3);
        if (pM_TreeWindow instanceof PM_TreeWindowBase) {
            jPanel5.add(this.panelButtonBase);
        } else {
            jPanel5.add(this.panelButtonExtended);
        }
        jPanel5.add(jPanel4);
        JScrollPane jScrollPane2 = new JScrollPane(jPanel5);
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.setVerticalScrollBarPolicy(21);
        pM_IndexView.setAllowGetFromRight(true);
        pM_IndexView.setAllowCrossing(true);
        pM_IndexView.setPopUpAendern(true);
        pM_IndexView.setPopUpDiaShow(true);
        pM_IndexView.setPopUpLoeschen(true);
        pM_IndexView.setPopUpLoeschenAufheben(true);
        JSlider jSlider = pM_IndexView.getSlider();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jScrollPane2, "North");
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)jSlider, "South");
        JScrollPane jScrollPane3 = new JScrollPane(pM_TreeWindow);
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.getUpperTreePanel(pM_TreeWindow), "North");
        jPanel2.add((Component)jScrollPane3, "Center");
        JSplitPane jSplitPane = new JSplitPane(1, jPanel, jPanel2);
        jSplitPane.setDividerLocation(300);
        return jSplitPane;
    }

    private JPanel getUpperIndexPanel(PM_TreeWindow pM_TreeWindow) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        JPanel jPanel2 = new JPanel();
        jPanel.add(jPanel2);
        PM_UtilsGrafik.getRightPanelOverThumbs(jPanel2);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSequence.this.doAendernSequenz();
            }
        };
        if (pM_TreeWindow instanceof PM_TreeWindowBase) {
            jPanel2.add(this.buttonAenBase);
            this.buttonAenBase.addActionListener(actionListener);
            this.buttonAenBase.setEnabled(false);
        } else {
            jPanel2.add(this.buttonAenExtended);
            this.buttonAenExtended.addActionListener(actionListener);
            this.buttonAenExtended.setEnabled(false);
        }
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSequence.this.doLoeschenSequenz(PM_WindowSequence.this.getSequenceDargestellt());
            }
        };
        if (pM_TreeWindow instanceof PM_TreeWindowBase) {
            jPanel2.add(this.buttonLoeBase);
            this.buttonLoeBase.addActionListener(actionListener2);
            this.buttonLoeBase.setEnabled(false);
        } else {
            jPanel2.add(this.buttonLoeExtended);
            this.buttonLoeExtended.addActionListener(actionListener2);
            this.buttonLoeExtended.setEnabled(false);
        }
        return jPanel;
    }

    private PM_FocusPanel getUpperAllPanel() {
        PM_FocusPanel pM_FocusPanel = new PM_FocusPanel(){

            public void setBackgroundColor(Color color) {
                PM_WindowSequence.this.setBackgroundUpperPanel(color);
            }
        };
        pM_FocusPanel.setLayout(new BoxLayout(pM_FocusPanel, 1));
        this.upperLabel = new JLabel("");
        baseSelected = true;
        Font font = this.upperLabel.getFont();
        Font font2 = new Font(font.getName(), 1, 30);
        this.upperLabel.setFont(font2);
        pM_FocusPanel.add(this.upperLabel);
        return pM_FocusPanel;
    }

    private JButton getButtonNeu() {
        if (baseSelected) {
            return this.buttonNeuBase;
        }
        return this.buttonNeuExtended;
    }

    private JScrollPane getUpperTreePanel(PM_TreeWindow pM_TreeWindow) {
        PM_FocusPanel pM_FocusPanel = new PM_FocusPanel(){

            public void setBackgroundColor(Color color) {
                PM_WindowSequence.this.setBackgroundUpperPanel(color);
            }
        };
        pM_FocusPanel.setLayout(new BoxLayout(pM_FocusPanel, 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        JButton jButton = PM_Utils.getJButon("1leftarrow.png");
        jPanel.add(jButton);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSequence.this.displaySequence();
            }
        };
        jButton.addActionListener(actionListener);
        JButton jButton2 = PM_Utils.getJButon("2leftarrow.png");
        jButton2.setEnabled(false);
        jPanel.add(jButton2);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        jButton2.addActionListener(actionListener2);
        JTextField jTextField = new JTextField("");
        jTextField.setForeground(Color.BLACK);
        jTextField.setEditable(false);
        jTextField.setFocusable(false);
        jTextField.setColumns(4);
        jPanel.add(jTextField);
        Font font = jTextField.getFont();
        Font font2 = new Font(font.getName(), 1, font.getSize());
        jTextField.setFont(font2);
        JButton jButton3 = new JButton("Slideshow");
        jPanel.add(jButton3);
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        jButton3.addActionListener(actionListener3);
        pM_FocusPanel.add(jPanel);
        JScrollPane jScrollPane = new JScrollPane(pM_FocusPanel);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        return jScrollPane;
    }

    class DragSourceNew
    implements DragSourceListener,
    DragGestureListener {
        private DragSource dragSource = new DragSource();

        public DragSourceNew(Component component) {
            this.dragSource.createDefaultDragGestureRecognizer(component, 3, this);
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            if (dragSourceDropEvent.getDropSuccess()) {
                PM_WindowSequence.this.dragDropDone();
            }
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
            DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
            dragSourceContext.setCursor(DragSource.DefaultMoveDrop);
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
            DragSourceContext dragSourceContext = dragSourceEvent.getDragSourceContext();
            dragSourceContext.setCursor(DragSource.DefaultMoveNoDrop);
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            Component component = dragGestureEvent.getComponent();
            if (!(component instanceof JButton)) {
                return;
            }
            JButton jButton = (JButton)component;
            if (!jButton.isEnabled()) {
                return;
            }
            PM_WindowSequence.this.newCreatedSequence = PM_WindowSequence.this.getSequenceNew();
            if (PM_WindowSequence.this.newCreatedSequence == null) {
                return;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add((Object)PM_Interface.DragAndDropType.NEW_SEQUENCE_B_X);
            arrayList.add(PM_WindowSequence.this.newCreatedSequence);
            PM_Transferable pM_Transferable = new PM_Transferable(arrayList);
            this.dragSource.startDrag(dragGestureEvent, DragSource.DefaultMoveNoDrop, pM_Transferable, this);
        }
    }
}

