/*
 * Decompiled with CFR 0.152.
 */
package pm.inout;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import pm.gui.PM_WindowExport;
import pm.gui.PM_WindowMain;
import pm.gui.PM_WindowStatusPanel;
import pm.inout.PM_IndexFileXML;
import pm.picture.PM_IndexFile;
import pm.picture.PM_Picture;
import pm.utilities.PM_Action;
import pm.utilities.PM_Configuration;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Listener;
import pm.utilities.PM_MSG;
import pm.utilities.PM_Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_Export
implements PM_Interface {
    protected PM_WindowMain windowMain;
    protected File tempPictureDirectory = null;
    private JProgressBar progressBar;
    protected boolean neuerBildName = false;
    protected String baseName = "";
    protected int pictureNumber = 1;
    int pictureCount = 0;
    private File dirThumbnails = null;
    private PM_IndexFile xmlIndexFile = null;
    protected PM_WindowExport windowExport;
    protected boolean withMetadata = false;
    private static Set<PM_Listener> deleteListeners = new HashSet<PM_Listener>();
    private JDialog dialog = null;

    public PM_Export(PM_WindowMain pM_WindowMain, PM_WindowExport pM_WindowExport) {
        this.windowMain = pM_WindowMain;
        this.windowExport = pM_WindowExport;
    }

    public static void addDeleteListener(PM_Listener pM_Listener) {
        deleteListeners.add(pM_Listener);
    }

    public void fireDeleteListener(PM_Picture pM_Picture) {
        for (PM_Listener pM_Listener : deleteListeners) {
            pM_Listener.actionPerformed(new PM_Action(pM_Picture));
        }
    }

    public void setBildName(String string) {
        this.baseName = string;
        this.neuerBildName = true;
    }

    public void setStartLfdBildNummer(int n) {
        this.pictureNumber = n;
        this.neuerBildName = true;
    }

    public void setMitMetadaten(boolean bl) {
        this.withMetadata = bl;
    }

    public void schreibenBilder(List<PM_Picture> list) {
        this.dialogDarstellen(list);
        if (this.pictureCount > 0) {
            this.abschlussMeldung();
        }
    }

    private int getAnzahlZuExportieren() {
        if (this.windowExport.getIndexView() == null) {
            return 0;
        }
        return this.windowExport.getIndexView().sizeDargestellt();
    }

    protected File getTempDirFile() {
        PM_Configuration pM_Configuration = PM_Configuration.getInstance();
        File file = pM_Configuration.getFileHomeTemp();
        File file2 = new File(file.getPath() + File.separator + "PhotoManager");
        file2.mkdirs();
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        File file3 = new File(file.getPath() + File.separator + "PhotoManager" + File.separator + "pm_" + simpleDateFormat.format(date));
        file3.mkdir();
        return file3;
    }

    protected int schreibenAlleBilder(final List<PM_Picture> list) {
        this.tempPictureDirectory = this.getTempDirFile();
        this.open();
        if (this.withMetadata) {
            this.openMetadaten();
        }
        PM_WindowStatusPanel.getInstance().progressionBarInit(this, this.windowExport.getIndexView().getPictureSize());
        Thread thread = new Thread(){

            public void run() {
                PM_Export.this.schreibenAlleBilderImThread(list);
                PM_WindowStatusPanel.getInstance().progressionBarSetValue(this, 0);
                PM_WindowStatusPanel.getInstance().progressionBarStop(this);
            }
        };
        thread.start();
        PM_WindowStatusPanel.getInstance().progressionBarStart();
        this.close();
        if (this.withMetadata) {
            this.closeMetadaten();
        }
        return this.pictureCount;
    }

    private void schreibenAlleBilderImThread(List<PM_Picture> list) {
        int n = -1;
        for (PM_Picture pM_Picture : list) {
            ++n;
            if (this.progressBar != null) {
                PM_WindowStatusPanel.getInstance().progressionBarSetValue(this, n + 1);
            }
            File file = this.getFileOriginalOut(pM_Picture);
            this.schreibenBild(pM_Picture, file, n + 1, list.size());
            if (this.withMetadata) {
                this.schreibenMetadaten(pM_Picture, file, n + 1, list.size());
            }
            if (this.progressBar != null) {
                this.progressBar.setValue(this.pictureNumber);
            }
            ++this.pictureNumber;
        }
    }

    protected void open() {
    }

    protected void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean copyFile(File file, File file2) {
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream filterOutputStream = null;
        long l = file.lastModified();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            filterOutputStream = new BufferedOutputStream(fileOutputStream);
            byte[] byArray = new byte[1024];
            while (bufferedInputStream.available() != 0) {
                int n = bufferedInputStream.read(byArray);
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                    file2.setLastModified(l);
                }
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return true;
    }

    protected boolean schreibenBild(PM_Picture pM_Picture, File file, int n, int n2) {
        return false;
    }

    protected File getFileOriginalOut(PM_Picture pM_Picture) {
        String string = this.tempPictureDirectory.getPath() + File.separator;
        string = this.neuerBildName ? string + this.getNeueBildId(pM_Picture.getFileOriginal().getName()) : string + pM_Picture.getFileOriginal().getName();
        File file = new File(string);
        while (file.canRead()) {
            String string2 = file.getPath();
            String string3 = PM_Utils.getExtension(string2);
            String string4 = PM_Utils.getWithoutExtension(string2);
            string2 = string4.indexOf("_x") > 0 ? string4 + "x" : string4 + "_x";
            file = new File(string2 + "." + string3);
        }
        return file;
    }

    private String getNeueBildId(String string) {
        String string2 = PM_Utils.stringToString("000" + Integer.toString(this.pictureNumber), 3);
        if (this.pictureNumber > 999) {
            string2 = Integer.toString(this.pictureNumber);
        }
        String string3 = this.baseName + string2 + "." + PM_Utils.getExtension(string);
        return string3;
    }

    protected void abschlussMeldung() {
        String string = String.format(PM_MSG.getMsg("expEnd"), this.pictureCount, this.tempPictureDirectory.getPath());
        JOptionPane.showConfirmDialog(null, string, "Export", -1, 1);
    }

    protected void getAddOnDialogPanel(JPanel jPanel) {
        jPanel.add(new JLabel("must be override"));
    }

    private void dialogDarstellen(List<PM_Picture> list) {
        JPanel jPanel = this.getDialogPanel(list);
        JPanel jPanel2 = new JPanel();
        jPanel2.add((Component)jPanel, "North");
        this.dialog.getContentPane().add(jPanel2);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    private JPanel getDialogPanel(final List<PM_Picture> list) {
        JPanel jPanel = new JPanel();
        this.dialog = new JDialog((Frame)this.windowMain, true);
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setUndecorated(true);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        String string = String.format(PM_MSG.getMsg("expDialogToExprt"), this.getAnzahlZuExportieren());
        JLabel jLabel = new JLabel(string);
        Font font = jLabel.getFont();
        Font font2 = new Font(font.getName(), 1, font.getSize() + 3);
        jLabel.setFont(font2);
        jPanel.add(jLabel);
        this.getAddOnDialogPanel(jPanel);
        this.progressBar = new JProgressBar(0, this.getAnzahlZuExportieren());
        jPanel.add(this.progressBar);
        this.progressBar.setValue(0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        JButton jButton = new JButton(PM_MSG.getMsg("continue"));
        jPanel2.add(jButton);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_Export.this.dialog.dispose();
                PM_Export.this.schreibenAlleBilder(list);
            }
        };
        jButton.addActionListener(actionListener);
        JButton jButton2 = new JButton(PM_MSG.getMsg("exit"));
        jPanel2.add(jButton2);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_Export.this.dialog.dispose();
            }
        };
        jButton2.addActionListener(actionListener2);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private void openMetadaten() {
        File file = new File(this.tempPictureDirectory.getPath() + File.separator + "pm.metadaten");
        file.mkdirs();
        this.dirThumbnails = new File(file.getPath() + File.separator + "pm.thumbnails");
        this.dirThumbnails.mkdirs();
        File file2 = new File(file.getPath() + File.separator + "pm_index.xml");
        this.xmlIndexFile = new PM_IndexFileXML(file2);
    }

    private void closeMetadaten() {
        this.xmlIndexFile.writeDocument();
        this.xmlIndexFile = null;
    }

    protected boolean schreibenMetadaten(PM_Picture pM_Picture, File file, int n, int n2) {
        ++this.pictureCount;
        File file2 = pM_Picture.getFileOriginal();
        File file3 = PM_Utils.getFileThumbnail(file2);
        File file4 = PM_Utils.getFileThumbnail(file);
        this.copyFile(file3, file4);
        File[] fileArray = PM_Utils.getFilesBearbeitet(pM_Picture.getFileOriginal());
        if (fileArray.length > 0) {
            File file5 = new File(this.tempPictureDirectory.getPath() + File.separator + "pm.metadaten" + File.separator + "pm.bilder_bearbeiten");
            file5.mkdirs();
            for (int i = 0; i < fileArray.length; ++i) {
                File file6 = fileArray[i];
                File file7 = new File(file5.getPath() + File.separator + file6.getName());
                this.copyFile(file6, file7);
            }
        }
        this.xmlIndexFile.update(pM_Picture, file.getName());
        return true;
    }
}

