/*
 * Decompiled with CFR 0.152.
 */
package pm.inout;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;
import pm.inout.PM_XML;
import pm.picture.PM_IndexFile;
import pm.picture.PM_MetadataContainer;
import pm.picture.PM_Picture;
import pm.search.PM_DatabaseLucene;
import pm.search.PM_LuceneLists;
import pm.sequence.PM_Sequence;
import pm.utilities.PM_Action;
import pm.utilities.PM_Interface;
import pm.utilities.PM_ListenerX;
import pm.utilities.PM_Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_IndexFileXML
extends PM_XML
implements PM_Interface,
PM_IndexFile {
    private static final int version = 1;
    private static final String XML_BILDER = "bilder";
    private static final String XML_BILD = "bild";
    private static final String XML_ID = "id";
    private static final String XML_VALID = "valid";
    private static final String XML_DATUM = "d";
    private static final String XML_DATUM_IMPORT = "import";
    private static final String XML_QS = "qs";
    private static final String XML_HOEHE = "h";
    private static final String XML_BREITE = "b";
    private static final String XML_ROTATE = "drehen";
    private static final String XML_SPIEGELN = "spiegeln";
    private static final String XML_INDEX = "index";
    private static final String XML_ORT = "index2";
    private static final String XML_BEMERKUNGEN = "bemerkungen";
    private static final String XML_BEARBEITET = "bearbeitet";
    private static final String XML_SEQUENZ = "seq";
    private static final String XML_CUT = "cut";
    private static final String XML_CUT_X = "x";
    private static final String XML_CUT_Y = "y";
    private static final String XML_CUT_B = "b";
    private static final String XML_CUT_H = "h";
    private Map<String, Element> pictureValid = new HashMap<String, Element>();
    private Map<String, Element> pictureInvalid = new HashMap<String, Element>();
    private String DATE_FORMAT = "dd.MM.yyyy HH:mm:ss";

    public PM_IndexFileXML(File file) {
        this.xmlFile = file;
        this.rootTagName = XML_BILDER;
        this.openDoc();
    }

    @Override
    public int deletePictureInvalid(File file) {
        int n = this.pictureInvalid.size();
        if (n == 0) {
            return 0;
        }
        Element element = this.document.getRootElement();
        for (String string : this.pictureInvalid.keySet()) {
            File file2 = new File(file, string);
            PM_Utils.getFileThumbnail(file2).delete();
            for (File file3 : PM_Utils.getFilesBearbeitet(file2)) {
                file3.delete();
            }
            file2.delete();
            element.remove(this.pictureInvalid.get(string));
        }
        this.pictureInvalid.clear();
        if (n != 0) {
            this.writeDocument();
        }
        return n;
    }

    @Override
    public boolean getMetadaten(PM_Picture pM_Picture) {
        Element element = this.getElementById(pM_Picture.meta.getId());
        if (element == null) {
            return false;
        }
        this.getMetadaten(pM_Picture, element);
        return true;
    }

    private Element getElementById(String string) {
        if (this.pictureValid.containsKey(string)) {
            return this.pictureValid.get(string);
        }
        if (this.pictureInvalid.containsKey(string)) {
            return this.pictureInvalid.get(string);
        }
        return null;
    }

    @Override
    public void update(PM_Picture pM_Picture, String string) {
        Element element = this.getElementById(string);
        if (element == null) {
            element = new DefaultElement(XML_BILD);
            this.pictureValid.put(string, element);
            Element element2 = this.document.getRootElement();
            element2.add(element);
        }
        this.updateAttribute(element, XML_ID, string);
        if (pM_Picture.meta.isInvalid()) {
            this.updateAttribute(element, XML_VALID, "no");
        } else {
            this.updateAttribute(element, XML_VALID, null);
        }
        this.setElementInList(element, pM_Picture.meta.isInvalid(), string);
        this.updateDate(element, pM_Picture);
        int n = pM_Picture.meta.getCategory();
        if (n < 1 || n > 4) {
            n = 3;
        }
        this.updateAttribute(element, XML_QS, String.valueOf(n));
        this.updateImageSize(element, pM_Picture);
        this.updateRotation(element, pM_Picture);
        if (pM_Picture.meta.getMirror()) {
            this.updateAttribute(element, XML_SPIEGELN, "S");
        } else {
            this.updateAttribute(element, XML_SPIEGELN, null);
        }
        String string2 = "";
        if (pM_Picture.meta.getModified()) {
            string2 = "ja";
        }
        this.updateAttribute(element, XML_BEARBEITET, string2);
        this.addTag(element, XML_INDEX, pM_Picture.meta.getIndex1());
        this.addTag(element, XML_BEMERKUNGEN, pM_Picture.meta.getRemarks());
        this.addTag(element, XML_ORT, pM_Picture.meta.getIndex2());
        this.addTag(element, XML_SEQUENZ, pM_Picture.meta.getSequence());
        List list = element.elements(XML_CUT);
        Element element3 = null;
        if (list.size() != 0) {
            element3 = (Element)list.get(0);
        }
        if (pM_Picture.meta.hasCutRectangle() && element3 == null) {
            element3 = new DefaultElement(XML_CUT);
            list.add(element3);
        }
        if (pM_Picture.meta.hasCutRectangle() && element3 != null) {
            this.updateCutRectangle(element3, pM_Picture);
        }
    }

    private void updateDate(Element element, PM_Picture pM_Picture) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.DATE_FORMAT);
        this.updateAttribute(element, XML_DATUM, simpleDateFormat.format(pM_Picture.meta.getDateCurrent()));
        this.updateAttribute(element, XML_DATUM_IMPORT, simpleDateFormat.format(pM_Picture.meta.getDateImport()));
    }

    private void updateImageSize(Element element, PM_Picture pM_Picture) {
        Dimension dimension = pM_Picture.meta.getImageSize();
        this.updateAttribute(element, "b", String.valueOf(dimension.width));
        this.updateAttribute(element, "h", String.valueOf(dimension.height));
    }

    private void updateRotation(Element element, PM_Picture pM_Picture) {
        String string = "";
        switch (pM_Picture.meta.getRotation()) {
            case 90: {
                string = "R";
                break;
            }
            case 180: {
                string = "U";
                break;
            }
            case 270: {
                string = "L";
            }
        }
        this.updateAttribute(element, XML_ROTATE, string);
    }

    private void updateCutRectangle(Element element, PM_Picture pM_Picture) {
        Rectangle rectangle = pM_Picture.meta.getCutRectangle();
        this.updateAttribute(element, XML_CUT_X, Integer.toString(rectangle.x));
        this.updateAttribute(element, XML_CUT_Y, Integer.toString(rectangle.y));
        this.updateAttribute(element, "b", Integer.toString(rectangle.width));
        this.updateAttribute(element, "h", Integer.toString(rectangle.height));
    }

    @Override
    public int getPictureSizeValid() {
        return this.pictureValid.size();
    }

    @Override
    public int getPictureSizeInvalid() {
        return this.pictureInvalid.size();
    }

    @Override
    public void initComplete() {
        PM_LuceneLists pM_LuceneLists = PM_LuceneLists.getInstance();
        for (Element element : this.pictureValid.values()) {
            pM_LuceneLists.addIndex(this.getTagValue(element, XML_INDEX));
            pM_LuceneLists.addOrt(this.getTagValue(element, XML_ORT));
            PM_MetadataContainer.getInstance().addInitSequence(this.getTagValue(element, XML_SEQUENZ));
        }
    }

    @Override
    public Set<String> getValidFileNames() {
        return new HashSet<String>(this.pictureValid.keySet());
    }

    @Override
    public Set<String> getInvalidFileNames() {
        return new HashSet<String>(this.pictureInvalid.keySet());
    }

    @Override
    public void loeschenIndex1() {
        for (Element element : this.pictureValid.values()) {
            this.addTag(element, XML_INDEX, "");
        }
        for (Element element : this.pictureInvalid.values()) {
            this.addTag(element, XML_INDEX, "");
        }
        this.writeDocument();
    }

    @Override
    public void loeschenIndex2() {
        for (Element element : this.pictureValid.values()) {
            this.addTag(element, XML_ORT, "");
        }
        for (Element element : this.pictureInvalid.values()) {
            this.addTag(element, XML_ORT, "");
        }
        this.writeDocument();
    }

    @Override
    public void alleSequenzenLoeschen() {
        for (Element element : this.pictureValid.values()) {
            this.addTag(element, XML_SEQUENZ, "");
        }
        for (Element element : this.pictureInvalid.values()) {
            this.addTag(element, XML_SEQUENZ, "");
        }
        this.writeDocument();
    }

    @Override
    public void removeID(String string) {
        Element element = this.getElementById(string);
        if (element == null) {
            return;
        }
        this.pictureValid.remove(string);
        this.pictureInvalid.remove(string);
        ArrayList<Element> arrayList = new ArrayList<Element>(this.pictureValid.values());
        arrayList.addAll(this.pictureInvalid.values());
        DefaultElement defaultElement = new DefaultElement(XML_BILDER);
        defaultElement.setContent(arrayList);
        this.document.setRootElement(defaultElement);
    }

    @Override
    public void alleLuceneEintraegeNeuErstellen(PM_ListenerX pM_ListenerX) {
        this.openDoc();
        for (Element element : this.pictureValid.values()) {
            String string = element.attributeValue(XML_ID);
            File file = PM_Utils.xmlIdToFileOriginal(this.xmlFile, string);
            PM_Picture pM_Picture = PM_Picture.getPicture(file);
            if (pM_Picture == null) continue;
            this.getMetadaten(pM_Picture, element);
            PM_DatabaseLucene pM_DatabaseLucene = PM_DatabaseLucene.getInstance();
            pM_DatabaseLucene.createEintrag(pM_Picture);
            if (pM_ListenerX == null) continue;
            pM_ListenerX.actionPerformed(new PM_Action(null, 1));
        }
    }

    @Override
    public List<PM_Picture> bilderOhneSequenzen() {
        boolean bl = true;
        this.openDoc();
        ArrayList<PM_Picture> arrayList = new ArrayList<PM_Picture>();
        block0: for (Element element : this.pictureValid.values()) {
            File file;
            Object object;
            String[] stringArray;
            String string = this.getTagValue(element, XML_SEQUENZ);
            if (string != null && string.length() != 0) {
                stringArray = string.split(" ");
                for (int i = 0; i < stringArray.length; ++i) {
                    object = stringArray[i];
                    if (bl ? ((String)object).startsWith("b") : ((String)object).startsWith("b") || ((String)object).startsWith("s")) continue block0;
                }
            }
            if ((object = PM_Picture.getPicture(file = PM_Utils.xmlIdToFileOriginal(this.xmlFile, (String)(stringArray = element.attributeValue(XML_ID))))) == null) continue;
            arrayList.add((PM_Picture)object);
        }
        return arrayList;
    }

    @Override
    public List<PM_Picture> bilderDoppelteSequenzen() {
        this.openDoc();
        ArrayList<PM_Picture> arrayList = new ArrayList<PM_Picture>();
        for (Element element : this.pictureValid.values()) {
            String string;
            PM_Picture pM_Picture;
            Object object;
            String string2 = this.getTagValue(element, XML_SEQUENZ);
            if (string2 == null || string2.length() == 0) continue;
            String[] stringArray = string2.split(" ");
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                object = stringArray[i];
                if (!((String)object).startsWith("b") && !((String)object).startsWith("s")) continue;
                ++n;
            }
            if (n <= 1 || (pM_Picture = PM_Picture.getPicture((File)(object = PM_Utils.xmlIdToFileOriginal(this.xmlFile, string = element.attributeValue(XML_ID))))) == null) continue;
            arrayList.add(pM_Picture);
        }
        return arrayList;
    }

    @Override
    public List<File> bilderNichtInSerien(List list, boolean bl) {
        this.openDoc();
        ArrayList<File> arrayList = new ArrayList<File>();
        for (Element element : this.pictureValid.values()) {
            String string = this.getTagValue(element, XML_SEQUENZ);
            if (bl ? !this.mehrfach(string, list) : this.istInSeq(string, list)) continue;
            String string2 = element.attributeValue(XML_ID);
            File file = PM_Utils.xmlIdToFileOriginal(this.xmlFile, string2);
            arrayList.add(file);
        }
        return arrayList;
    }

    private boolean istInSeq(String string, List list) {
        if (string == null || string.length() == 0) {
            return false;
        }
        String[] stringArray = string.split(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = PM_Sequence.getSequenzKurzName(stringArray[i]);
            for (Object e : list) {
                String string3;
                if (!(e instanceof String) || !(string3 = (String)e).equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean mehrfach(String string, List list) {
        if (string == null || string.length() == 0) {
            return false;
        }
        String[] stringArray = string.split(" ");
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = PM_Sequence.getSequenzKurzName(stringArray[i]);
            for (Object e : list) {
                String string3;
                if (!(e instanceof String) || !(string3 = (String)e).equals(string2)) continue;
                ++n;
            }
        }
        return n > 1;
    }

    private void getMetadaten(PM_Picture pM_Picture, Element element) {
        pM_Picture.meta.setInit(true);
        if (this.getAttribute(element, XML_VALID).equals("no")) {
            pM_Picture.meta.setInvalid(true);
        } else {
            pM_Picture.meta.setInvalid(false);
        }
        this.setDate(pM_Picture, element);
        pM_Picture.meta.setCategory(this.getAttribute(element, XML_QS));
        this.setImageSize(pM_Picture, element);
        this.setRotation(pM_Picture, element);
        String string = this.getAttribute(element, XML_SPIEGELN);
        pM_Picture.meta.setMirror(string.equalsIgnoreCase("S"));
        if (this.getAttribute(element, XML_BEARBEITET).equals("ja")) {
            pM_Picture.meta.setModified(true);
        } else {
            pM_Picture.meta.setModified(false);
        }
        pM_Picture.meta.setIndex1(this.getTagValue(element, XML_INDEX));
        pM_Picture.meta.setRemarks(this.getTagValue(element, XML_BEMERKUNGEN));
        pM_Picture.meta.setIndex2(this.getTagValue(element, XML_ORT));
        pM_Picture.meta.setSequenz(this.getTagValue(element, XML_SEQUENZ));
        List list = element.elements(XML_CUT);
        Element element2 = null;
        if (list.size() != 0) {
            element2 = (Element)list.get(0);
        }
        this.setCutRectangle(pM_Picture, element2);
        pM_Picture.meta.setInit(false);
    }

    private void setImageSize(PM_Picture pM_Picture, Element element) {
        int n = PM_Utils.stringToInt(this.getAttribute(element, "b"));
        int n2 = PM_Utils.stringToInt(this.getAttribute(element, "h"));
        pM_Picture.meta.setImageSize(new Dimension(n, n2));
    }

    private void setDate(PM_Picture pM_Picture, Element element) {
        Date date;
        Date date2;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.DATE_FORMAT);
        try {
            date2 = simpleDateFormat.parse(this.getAttribute(element, XML_DATUM));
        }
        catch (ParseException parseException) {
            System.out.println("<<<<<<<<<< ERROR set Date : current date. file " + pM_Picture.getFileOriginal().getPath());
            date2 = new Date(System.currentTimeMillis());
        }
        pM_Picture.meta.setDateCurrent(date2);
        String string = this.getAttribute(element, XML_DATUM_IMPORT);
        if (string.length() == 0) {
            pM_Picture.meta.setDateImport(new Date(date2.getTime()));
            return;
        }
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            System.out.println("<<<<<<<<<< ERROR set Date : IMPORT date. file " + pM_Picture.getFileOriginal().getPath());
            date = new Date(System.currentTimeMillis());
        }
        pM_Picture.meta.setDateImport(date);
    }

    private void setRotation(PM_Picture pM_Picture, Element element) {
        String string = this.getAttribute(element, XML_ROTATE);
        int n = 0;
        if (string.equals("R")) {
            n = 90;
        } else if (string.equals("U")) {
            n = 180;
        } else if (string.equals("L")) {
            n = 270;
        }
        pM_Picture.meta.setRotation(n);
    }

    private void setCutRectangle(PM_Picture pM_Picture, Element element) {
        String string = this.getAttribute(element, XML_CUT_X);
        String string2 = this.getAttribute(element, XML_CUT_Y);
        String string3 = this.getAttribute(element, "b");
        String string4 = this.getAttribute(element, "h");
        Rectangle rectangle = new Rectangle(PM_Utils.stringToInt(string), PM_Utils.stringToInt(string2), PM_Utils.stringToInt(string3), PM_Utils.stringToInt(string4));
        pM_Picture.meta.setCutRectangle(rectangle);
    }

    private void setElementInList(Element element, boolean bl, String string) {
        if (bl) {
            if (this.pictureInvalid.containsValue(element)) {
                return;
            }
            this.pictureInvalid.put(string, this.pictureValid.remove(string));
        } else {
            if (this.pictureValid.containsValue(element)) {
                return;
            }
            this.pictureValid.put(string, this.pictureInvalid.remove(string));
        }
    }

    @Override
    public void writeDocument() {
        super.writeDocument();
    }

    private void openDoc() {
        Object object;
        Element element;
        Object object2;
        if (this.document != null) {
            return;
        }
        this.openDocument(4);
        this.setVersionWrite(1);
        if (!PM_Utils.isLinux()) {
            boolean bl = false;
            object2 = this.xmlFile.getParentFile().getParentFile();
            String[] stringArray = ((File)object2).list();
            element = this.document.getRootElement();
            object = element.elements();
            for (int i = 0; i < object.size(); ++i) {
                Element element2 = (Element)object.get(i);
                String string = this.getAttribute(element2, XML_ID);
                if (string == null || string.length() == 0) continue;
                for (String string2 : stringArray) {
                    if (string2.equals(string)) break;
                    if (!string2.equalsIgnoreCase(string)) continue;
                    this.updateAttribute(element2, XML_ID, string2);
                    bl = true;
                }
            }
            if (bl) {
                this.writeDocument();
            }
        }
        Element element3 = this.document.getRootElement();
        object2 = element3.elements();
        for (int i = 0; i < object2.size(); ++i) {
            element = (Element)object2.get(i);
            object = this.getAttribute(element, XML_ID);
            if (object == null || ((String)object).length() == 0) continue;
            if (this.getAttribute(element, XML_VALID).equals("no")) {
                this.pictureInvalid.put((String)object, element);
                continue;
            }
            this.pictureValid.put((String)object, element);
        }
    }
}

