/*
 * Decompiled with CFR 0.152.
 */
package pm.inout;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Utils;

public class PM_LogFile
implements PM_Interface {
    private static PM_LogFile instance = null;
    private PrintWriter out = null;

    public static PM_LogFile getInstance() {
        if (instance == null) {
            instance = new PM_LogFile();
        }
        return instance;
    }

    private PM_LogFile() {
        this.open();
    }

    public void open() {
        if (this.out != null) {
            return;
        }
        File file = new File(PM_Utils.getConfigDir() + File.separator + "pm_log.txt");
        if (!file.isFile()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                PM_Utils.writeErrorExit("PM wird beendet, da keine pm_log.txt angelegt werden kann");
            }
        }
        try {
            this.out = new PrintWriter(new BufferedWriter(new FileWriter(file, true)));
        }
        catch (IOException iOException) {
            PM_Utils.writeErrorExit("PM wird beendet, da keine pm_log.txt angelegt werden kann");
        }
    }

    public void start() {
        this.write("pm ------ START ------ ");
    }

    public void write(String string) {
        this.open();
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        String string2 = simpleDateFormat.format(date);
        String string3 = string2 + " " + string;
        this.out.println(string3);
        this.out.flush();
    }

    public void close() {
        if (this.out == null) {
            return;
        }
        this.write("pm ------ ENDE ------ ");
        this.out.close();
        this.out = null;
    }
}

