/*
 * Decompiled with CFR 0.152.
 */
package pm.inout;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import pm.inout.PM_SequencesInoutXML;
import pm.picture.PM_MetadataContainer;
import pm.sequence.PM_Sequence;
import pm.sequence.PM_SequenceAlbum;
import pm.sequence.PM_SequenceBase;
import pm.sequence.PM_SequenceExtended;
import pm.sequence.PM_SequenceNew;
import pm.sequence.PM_TreeModelAlbum;
import pm.sequence.PM_TreeModelBase;
import pm.sequence.PM_TreeModelExtended;
import pm.sequence.PM_TreeModelNew;
import pm.utilities.PM_Action;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_SequencesInout
extends PM_SequencesInoutXML
implements PM_Interface {
    private static PM_SequencesInout instance = null;
    private boolean readDone = false;
    private boolean setChangeListenerDone = false;
    private PM_Sequence neueBilder = null;

    public static PM_SequencesInout getInstance() {
        if (instance == null) {
            instance = new PM_SequencesInout();
        }
        return instance;
    }

    protected PM_SequencesInout() {
    }

    @Override
    public void open() {
        super.open();
    }

    public void flush() {
        this.close();
    }

    public void close() {
        if (!changed) {
            return;
        }
        changed = false;
        ArrayList<PM_Sequence> arrayList = PM_TreeModelBase.getInstance().getSequenceListWrite();
        arrayList.addAll(PM_TreeModelAlbum.getInstance().getSequenceListWrite());
        arrayList.addAll(PM_TreeModelExtended.getInstance().getSequenceListWrite());
        arrayList.addAll(PM_TreeModelNew.getInstance().getSequenceListWrite());
        super.close(arrayList);
    }

    public List<PM_Sequence> getList(PM_Interface.SequenceType sequenceType) {
        if (!this.readDone) {
            this.readDone = true;
            this.readAllSequences();
        }
        switch (sequenceType) {
            case ALBUM: {
                return this.listAlbum;
            }
            case BASE: {
                return this.listBase;
            }
            case EXTENDED: {
                return this.listExtended;
            }
            case NEW: {
                return this.listNew;
            }
        }
        return new ArrayList<PM_Sequence>();
    }

    public void setChangeListener() {
        if (this.setChangeListenerDone) {
            return;
        }
        this.setChangeListenerDone = true;
        PM_Listener pM_Listener = new PM_Listener(){

            public void actionPerformed(PM_Action pM_Action) {
                PM_SequencesInout.getInstance().setChanged(true);
            }
        };
        PM_TreeModelBase.getInstance().addChangeListener(pM_Listener);
        PM_TreeModelExtended.getInstance().addChangeListener(pM_Listener);
        PM_TreeModelAlbum.getInstance().addChangeListener(pM_Listener);
        PM_TreeModelNew.getInstance().addChangeListener(pM_Listener);
    }

    @Override
    protected void readAllSequences() {
        Object object;
        PM_MetadataContainer pM_MetadataContainer = PM_MetadataContainer.getInstance();
        super.readAllSequences();
        Enumeration<String> enumeration = pM_MetadataContainer.getInitSequences().keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            int n = pM_MetadataContainer.getInitSequences().get(string);
            if (string.startsWith("b")) {
                object = new PM_SequenceBase("????????", string);
                ((PM_Sequence)object).setAnzahlBilder(n);
                this.listBase.add(object);
                changed = true;
                continue;
            }
            if (string.startsWith("s")) {
                object = new PM_SequenceExtended("????????", string);
                ((PM_Sequence)object).setAnzahlBilder(n);
                this.listExtended.add(object);
                changed = true;
                continue;
            }
            if (!string.startsWith("n")) continue;
            object = new PM_SequenceNew("????????", string);
            ((PM_Sequence)object).setAnzahlBilder(n);
            this.listNew.add(object);
            changed = true;
        }
        for (PM_SequenceAlbum pM_SequenceAlbum : this.listAlbum) {
            if (pM_SequenceAlbum.getStringLeaf() || ((String)(object = pM_SequenceAlbum.getSeqClosedName())).length() == 0) continue;
            PM_Sequence pM_Sequence = this.getSequence((String)object, this.listBase);
            if (pM_Sequence != null) {
                pM_SequenceAlbum.setSeqClosed(pM_Sequence);
                continue;
            }
            PM_Sequence pM_Sequence2 = this.getSequence((String)object, this.listExtended);
            if (pM_Sequence2 != null) {
                pM_SequenceAlbum.setSeqClosed(pM_Sequence2);
                continue;
            }
            pM_SequenceAlbum.setSeqClosedName("");
            changed = true;
        }
    }

    public PM_Sequence getNeueBilder() {
        return this.neueBilder;
    }

    public void setChanged(boolean bl) {
        changed = bl;
    }

    private PM_Sequence getSequence(String string, List<PM_Sequence> list) {
        for (PM_Sequence pM_Sequence : list) {
            if (!string.equals(pM_Sequence.getShortName())) continue;
            return pM_Sequence;
        }
        return null;
    }
}

