/*
 * Decompiled with CFR 0.152.
 */
package pm.inout;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.dom4j.tree.DefaultElement;
import pm.inout.PM_XML;
import pm.picture.PM_MetadataContainer;
import pm.picture.PM_PictureDirectory;
import pm.utilities.PM_Configuration;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Utils;
import pm.utilities.PM_XML_Utils;

public class PM_XML_File_Session
extends PM_XML
implements PM_Interface {
    private static PM_Configuration einstellungen = null;
    private static PM_XML_File_Session instance = null;
    private final String TAG_SESSION = "pm-session";
    private final String TAG_INDEX_FILES = "pm-index-files";
    private final String TAG_INDEX_FILE = "pm-index-file";
    private final String ATR_INDEX_FILE_LG = "laenge";
    private final String ATR_INDEX_FILE_NAME = "name";

    public static PM_XML_File_Session getInstance() {
        if (instance == null) {
            instance = new PM_XML_File_Session();
        }
        return instance;
    }

    public void open() {
        this.readXMLFile();
    }

    public boolean indexFilesGeaendert() {
        PM_MetadataContainer pM_MetadataContainer = PM_MetadataContainer.getInstance();
        HashMap<String, File> hashMap = new HashMap<String, File>();
        for (PM_PictureDirectory object22 : pM_MetadataContainer.getPictureDirectories()) {
            File file = object22.getPmIndexFile();
            hashMap.put(file.getPath(), file);
        }
        XPath xPath = DocumentHelper.createXPath("//pm-index-file");
        List list = xPath.selectNodes(this.document);
        for (Element element : list) {
            long l;
            String string = PM_XML_Utils.getAttribute(element, "laenge");
            String string2 = PM_XML_Utils.getAttribute(element, "name");
            if (!hashMap.containsKey(string2)) {
                return true;
            }
            File file = (File)hashMap.get(string2);
            long l2 = file.length();
            if (l2 != (l = PM_Utils.stringToLong(string))) {
                return true;
            }
            hashMap.remove(string2);
        }
        return !hashMap.isEmpty();
    }

    public void close() {
        Element element = this.deleteTagIndexFiles();
        PM_MetadataContainer pM_MetadataContainer = PM_MetadataContainer.getInstance();
        for (PM_PictureDirectory pM_PictureDirectory : pM_MetadataContainer.getPictureDirectories()) {
            File file = pM_PictureDirectory.getPmIndexFile();
            DefaultElement defaultElement = new DefaultElement("pm-index-file");
            this.updateAttribute(defaultElement, "laenge", Long.toString(file.length()));
            this.updateAttribute(defaultElement, "name", file.getPath());
            element.add(defaultElement);
        }
        this.writeDocument();
        this.xmlFile = null;
    }

    private PM_XML_File_Session() {
        einstellungen = PM_Configuration.getInstance();
    }

    private void readXMLFile() {
        if (this.xmlFile != null) {
            return;
        }
        File file = einstellungen.getTopLevelPictureDirectory();
        String string = file.getAbsolutePath() + File.separator + "pm_metadaten_root" + File.separator + "pm_session.xml";
        this.xmlFile = new File(string);
        this.rootTagName = "pm-session";
        this.openDocument(4);
    }

    private Element deleteTagIndexFiles() {
        Element element = this.document.getRootElement();
        List list = element.elements();
        for (int i = 0; i < list.size(); ++i) {
            Element element2 = (Element)list.get(i);
            if (!element2.getName().equals("pm-index-files")) continue;
            list.remove(i);
            break;
        }
        DefaultElement defaultElement = new DefaultElement("pm-index-files");
        element.add(defaultElement);
        return defaultElement;
    }
}

