/*
 * Decompiled with CFR 0.152.
 */
package pm.picture;

import java.awt.Container;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pm.picture.PM_Picture;
import pm.picture.PM_ReadImageOriginalThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_ReadImageOriginal {
    private static final PM_ReadImageOriginal INSTANCE = new PM_ReadImageOriginal();
    private List<PM_Picture> picturesRead = new ArrayList<PM_Picture>();
    private List<PM_Picture> picturesPrefetch = new ArrayList<PM_Picture>();
    private PM_Picture justReadAsynchron = null;
    private final PM_ReadImageOriginalThread imageOriginalReadThread = new PM_ReadImageOriginalThread(this);

    public static PM_ReadImageOriginal getInstance() {
        return INSTANCE;
    }

    private PM_ReadImageOriginal() {
        this.imageOriginalReadThread.start();
    }

    public synchronized void readImages(List<PM_Picture> list, List<PM_Picture> list2) {
        for (PM_Picture pM_Picture : list) {
            if (!list2.contains(pM_Picture)) continue;
            list2.remove(pM_Picture);
        }
        if (this.justReadAsynchron != null && list.contains(this.justReadAsynchron)) {
            this.waitUntilRead();
        }
        Iterator<PM_Picture> iterator = this.picturesRead.iterator();
        while (iterator.hasNext()) {
            PM_Picture pM_Picture;
            pM_Picture = iterator.next();
            if (list.contains(pM_Picture) || list2.contains(pM_Picture)) continue;
            this.removeImage(pM_Picture);
            iterator.remove();
        }
        this.picturesRead.clear();
        this.picturesRead.addAll(list);
        this.picturesPrefetch.clear();
        this.picturesPrefetch.addAll(list2);
        for (PM_Picture pM_Picture : this.picturesRead) {
            if (pM_Picture.hasImageOriginal()) continue;
            this.readSynchron(pM_Picture);
        }
        this.imageOriginalReadThread.startToRead();
    }

    public synchronized void getNextToRead() {
        if (this.justReadAsynchron != null) {
            if (!this.picturesRead.contains(this.justReadAsynchron)) {
                this.picturesRead.add(this.justReadAsynchron);
            }
            this.justReadAsynchron = null;
        }
        Iterator<PM_Picture> iterator = this.picturesPrefetch.iterator();
        while (iterator.hasNext()) {
            PM_Picture pM_Picture = iterator.next();
            if (pM_Picture.hasImageOriginal()) {
                this.picturesRead.add(pM_Picture);
                iterator.remove();
                continue;
            }
            this.justReadAsynchron = pM_Picture;
            this.imageOriginalReadThread.setPicture(pM_Picture);
            iterator.remove();
            return;
        }
    }

    private void removeImage(PM_Picture pM_Picture) {
        if (pM_Picture.hasImageOriginal()) {
            pM_Picture.getImageOriginal().flush();
            pM_Picture.setImageOriginal(null);
        }
    }

    private void waitUntilRead() {
        int n = 0;
        while (this.imageOriginalReadThread.isAktiv()) {
            ++n;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.picturesRead.contains(this.justReadAsynchron)) {
            this.picturesRead.add(this.justReadAsynchron);
        }
        this.justReadAsynchron = null;
    }

    private void readSynchron(PM_Picture pM_Picture) {
        try {
            Image image = Toolkit.getDefaultToolkit().getImage(pM_Picture.getFileOriginal().getPath());
            pM_Picture.setImageOriginal(image);
            MediaTracker mediaTracker = new MediaTracker(new Container());
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            pM_Picture.setImageOriginal(null);
        }
    }
}

