/*
 * Decompiled with CFR 0.152.
 */
package pm.print;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Vector;
import javax.print.PrintService;
import pm.print.PM_PaperFormat;
import pm.print.PM_PmPrinter;

public class PM_SystemPrinter {
    private final String systemName;
    private final Point2D aufloesung;
    private final Rectangle2D papierBereichGeamt;
    private PrinterJob printerJob = PrinterJob.getPrinterJob();
    private PM_PmPrinter[] allePmDrucker = null;
    private boolean eingestellt = false;

    public PM_SystemPrinter(PrintService printService) {
        try {
            this.printerJob.setPrintService(printService);
        }
        catch (PrinterException printerException) {
            // empty catch block
        }
        this.systemName = printService.getName();
        this.aufloesung = new Point2D.Double(72.0, 72.0);
        double d = 210.0 * this.aufloesung.getX() / 25.4;
        double d2 = 297.0 * this.aufloesung.getY() / 25.4;
        this.papierBereichGeamt = new Rectangle2D.Double(0.0, 0.0, d, d2);
        this.allePmDrucker = new PM_PmPrinter[1];
        this.allePmDrucker[0] = new PM_PmPrinter(this, "default");
    }

    public PrinterJob getPrinterJob() {
        return this.printerJob;
    }

    public Rectangle2D getPapierBereichGesamt() {
        return this.papierBereichGeamt;
    }

    public PM_PmPrinter[] getAllePmDrucker() {
        return this.allePmDrucker;
    }

    public Point2D getAufloesung() {
        return this.aufloesung;
    }

    public double getPixelBreiteMillimeter() {
        return 25.4 / this.getAufloesung().getX();
    }

    public double getPixelHoeheMillimeter() {
        return 25.4 / this.getAufloesung().getY();
    }

    public void init(PM_PmPrinter pM_PmPrinter, PM_PaperFormat pM_PaperFormat) {
        for (PM_PmPrinter pM_PmPrinter2 : this.allePmDrucker) {
            pM_PmPrinter2.init(pM_PmPrinter, pM_PaperFormat);
        }
    }

    public String getName() {
        return this.systemName;
    }

    public void setEingestellt(boolean bl) {
        this.eingestellt = bl;
    }

    public boolean getEingestellt() {
        return this.eingestellt;
    }

    public void addPmDrucker(PM_PmPrinter pM_PmPrinter) {
        Vector<PM_PmPrinter> vector = new Vector<PM_PmPrinter>();
        for (int i = 0; i < this.allePmDrucker.length; ++i) {
            vector.add(this.allePmDrucker[i]);
        }
        vector.add(pM_PmPrinter);
        this.allePmDrucker = vector.toArray(new PM_PmPrinter[vector.size()]);
    }

    public String toString() {
        return this.systemName;
    }
}

