/*
 * Decompiled with CFR 0.152.
 */
package pm.search;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import pm.picture.PM_Picture;
import pm.picture.PM_Pictures;
import pm.search.PM_DatabaseLucene;
import pm.search.PM_SearchExpr;
import pm.sequence.PM_Sequence;
import pm.utilities.PM_Configuration;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_Search
implements PM_Interface {
    private File fileLuceneDB = null;
    private Hits hits = null;
    private int anzahlHits = 0;
    private Searcher searcher = null;
    private List<Result> resultList = null;
    private PM_SearchExpr searchExpression = null;
    private PM_Interface.SearchType searchType = PM_Interface.SearchType.NOTHING;
    private PM_Sequence sequenz = null;
    private PM_Sequence sortSequenz = null;
    private static final Comparator<Result> ORDER_TIME = new Comparator<Result>(){

        @Override
        public int compare(Result result, Result result2) {
            String string = result.timeMilliseconds;
            String string2 = result2.timeMilliseconds;
            return string.compareTo(string2);
        }
    };
    private static final Comparator<Result> ORDER_SEQ = new Comparator<Result>(){

        @Override
        public int compare(Result result, Result result2) {
            String string = result.sequenzString;
            String string2 = result2.sequenzString;
            return string.compareTo(string2);
        }
    };
    private static final Comparator<Result> ORDER_FILE_NAME = new Comparator<Result>(){

        @Override
        public int compare(Result result, Result result2) {
            String string = result.name;
            String string2 = result2.name;
            return string.compareTo(string2);
        }
    };
    private static final Comparator<Result> ORDER_FILE_PATH = new Comparator<Result>(){

        @Override
        public int compare(Result result, Result result2) {
            String string = result.path;
            String string2 = result2.path;
            return string.compareTo(string2);
        }
    };

    public PM_Search(PM_SearchExpr pM_SearchExpr) {
        this.searchExpression = pM_SearchExpr;
        PM_Configuration pM_Configuration = PM_Configuration.getInstance();
        this.fileLuceneDB = pM_Configuration.getFileHomeLuceneDB();
    }

    public int search() {
        this.searchType = this.searchExpression.getSearchType();
        this.sortSequenz = this.sequenz = this.searchExpression.getSequenz();
        this.resultList = new ArrayList<Result>();
        if (this.searchExpression == null || this.searchType == PM_Interface.SearchType.NOTHING) {
            return 0;
        }
        if (this.searchType == PM_Interface.SearchType.SEQ && this.sequenz == null) {
            return 0;
        }
        return this.searchIntern();
    }

    public List<File> getFileList(PM_Interface.SearchSortType searchSortType) {
        return this.getSortetFileList(searchSortType);
    }

    public List<PM_Picture> getPictureList(PM_Interface.SearchSortType searchSortType) {
        return PM_Pictures.getPictureList(this.getFileList(searchSortType));
    }

    public int getAnzahlHits() {
        return this.anzahlHits;
    }

    private int searchIntern() {
        if (this.searchType == PM_Interface.SearchType.SEQ && this.sequenz.getType() == PM_Interface.SequenceType.ORIGINAL) {
            return this.searchAlleBilder(this.sequenz);
        }
        String string = this.searchExpression.getSearchString();
        System.out.println(string);
        this.sortSequenz = this.searchExpression.getSortSequenz();
        if (string.trim().length() == 0) {
            return 0;
        }
        PM_DatabaseLucene.getInstance().flush();
        this.anzahlHits = 0;
        Query query = this.getQuery(string);
        if (query == null) {
            return 0;
        }
        this.hits = this.searchHits(query);
        if (this.hits == null) {
            return 0;
        }
        this.anzahlHits = this.hits.length();
        try {
            for (int i = 0; i < this.anzahlHits; ++i) {
                Document document = this.hits.doc(i);
                this.addDocumentToErgebnisListe(document);
            }
        }
        catch (Exception exception) {
            return 0;
        }
        if (this.searcher != null) {
            try {
                this.searcher.close();
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return this.anzahlHits;
    }

    private int searchAlleBilder(PM_Sequence pM_Sequence) {
        List list = pM_Sequence.getFileListFromDirectory();
        for (File file : list) {
            if (!file.isFile() || !PM_Utils.isPictureFile(file)) continue;
            this.resultList.add(new Result(file, "", ""));
        }
        return this.resultList.size();
    }

    private List<File> getSortetFileList(PM_Interface.SearchSortType searchSortType) {
        Comparator<Result> comparator = null;
        switch (searchSortType) {
            case TIME: {
                comparator = ORDER_TIME;
                break;
            }
            case SEQ: {
                comparator = ORDER_SEQ;
                break;
            }
            case FILE_PATH: {
                comparator = ORDER_FILE_PATH;
                break;
            }
            case FILE_NAME: {
                comparator = ORDER_FILE_NAME;
            }
        }
        if (comparator != null) {
            Collections.sort(this.resultList, comparator);
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (Result result : this.resultList) {
            arrayList.add(result.file);
        }
        return arrayList;
    }

    private Query getQuery(String string) {
        WhitespaceAnalyzer whitespaceAnalyzer = new WhitespaceAnalyzer();
        Query query = null;
        try {
            QueryParser queryParser = new QueryParser("", whitespaceAnalyzer);
            query = queryParser.parse(string);
        }
        catch (Exception exception) {
            return null;
        }
        return query;
    }

    private Hits searchHits(Query query) {
        this.searcher = null;
        Hits hits = null;
        try {
            this.searcher = new IndexSearcher(this.fileLuceneDB.getPath());
            hits = this.searcher.search(query);
        }
        catch (Exception exception) {
            return null;
        }
        return hits;
    }

    private void addDocumentToErgebnisListe(Document document) {
        String string = "";
        String string2 = "";
        String string3 = "";
        String[] stringArray = document.getValues("id");
        if (stringArray.length < 0) {
            return;
        }
        string2 = stringArray[0];
        String[] stringArray2 = document.getValues("time");
        if (stringArray2.length >= 0) {
            string = stringArray2[0];
        }
        if (this.sequenz != null) {
            String[] stringArray3 = document.getValues("s");
            String string4 = this.sortSequenz.getShortName();
            if (stringArray3 != null && string4 != null) {
                for (int i = 0; i < stringArray3.length; ++i) {
                    String string5 = stringArray3[i].trim();
                    if (string5.indexOf(string4 + "_") != 0) continue;
                    string3 = stringArray3[i];
                    break;
                }
            }
        }
        this.resultList.add(new Result(new File(string2), string, string3));
    }

    class Result {
        public File file;
        public String path;
        public String name;
        public String timeMilliseconds;
        public String sequenzString;

        public Result(File file, String string, String string2) {
            this.file = file;
            this.timeMilliseconds = string;
            this.sequenzString = string2;
            this.path = file.getPath();
            this.name = file.getName();
        }
    }
}

