/*
 * Decompiled with CFR 0.152.
 */
package pm.sequence;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import pm.sequence.PM_Sequence;
import pm.sequence.PM_TreeModelAlbum;
import pm.sequence.PM_TreeModelBase;
import pm.sequence.PM_TreeModelExtended;
import pm.utilities.PM_Action;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PM_TreeModel
extends DefaultTreeModel
implements PM_Interface {
    public DefaultMutableTreeNode rootNode;
    private Set<PM_Listener> changeListener = new HashSet<PM_Listener>();
    protected Set<DefaultMutableTreeNode> nodesNotInAlbum = new HashSet<DefaultMutableTreeNode>();

    public PM_TreeModel() {
        super(new DefaultMutableTreeNode());
        this.rootNode = (DefaultMutableTreeNode)this.getRoot();
    }

    public void addChangeListener(PM_Listener pM_Listener) {
        this.changeListener.add(pM_Listener);
    }

    public void fireChangeListener(DefaultMutableTreeNode defaultMutableTreeNode, PM_Interface.TreeModelChangedType treeModelChangedType) {
        for (PM_Listener pM_Listener : this.changeListener) {
            pM_Listener.actionPerformed(new PM_Action((Object)treeModelChangedType));
        }
    }

    public void fireNameChanged(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.fireChangeListener(defaultMutableTreeNode, PM_Interface.TreeModelChangedType.NAME);
    }

    protected void initDone() {
        TreeModelListener treeModelListener = new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            }

            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                PM_TreeModel.this.fireChangeListener(null, PM_Interface.TreeModelChangedType.INSERT);
            }

            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                PM_TreeModel.this.fireChangeListener(null, PM_Interface.TreeModelChangedType.REMOVE);
            }

            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            }
        };
        this.addTreeModelListener(treeModelListener);
    }

    public DefaultMutableTreeNode getRootNode() {
        return this.rootNode;
    }

    public void removeSequence(PM_Sequence pM_Sequence) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Enumeration<TreeNode> enumeration = this.rootNode.preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (pM_Sequence != defaultMutableTreeNode.getUserObject()) continue;
            arrayList.add(defaultMutableTreeNode);
        }
        for (DefaultMutableTreeNode defaultMutableTreeNode : arrayList) {
            this.removeNodeFromParent(defaultMutableTreeNode);
            this.nodeChanged(this.rootNode);
        }
    }

    public ArrayList<PM_Sequence> getSequenceList() {
        return new ArrayList<PM_Sequence>();
    }

    public ArrayList<PM_Sequence> getSequenceListWrite() {
        return new ArrayList<PM_Sequence>();
    }

    protected ArrayList<PM_Sequence> _getSequenceList(boolean bl) {
        ArrayList<PM_Sequence> arrayList = new ArrayList<PM_Sequence>();
        if (this.rootNode.getChildCount() == 0) {
            return arrayList;
        }
        Enumeration<TreeNode> enumeration = this.rootNode.preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            PM_Sequence pM_Sequence;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode.isLeaf() && defaultMutableTreeNode.getUserObject() instanceof PM_Sequence) {
                pM_Sequence = (PM_Sequence)defaultMutableTreeNode.getUserObject();
                if (bl) {
                    pM_Sequence.setPath(PM_TreeModel.getPathFromNode(defaultMutableTreeNode));
                }
                arrayList.add(pM_Sequence);
                continue;
            }
            if (!bl || !defaultMutableTreeNode.isLeaf() || !(defaultMutableTreeNode.getUserObject() instanceof String) || (pM_Sequence = this.getSequenceForWrite(defaultMutableTreeNode)) == null) continue;
            arrayList.add(pM_Sequence);
        }
        return arrayList;
    }

    protected PM_Sequence getSequenceForWrite(DefaultMutableTreeNode defaultMutableTreeNode) {
        return null;
    }

    public static String getPathFromNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode.getParent() == null) {
            return "";
        }
        String string = "";
        TreeNode treeNode = defaultMutableTreeNode;
        string = defaultMutableTreeNode.getUserObject() instanceof PM_Sequence ? ((PM_Sequence)defaultMutableTreeNode.getUserObject()).getLongName() : defaultMutableTreeNode.toString();
        for (treeNode = defaultMutableTreeNode.getParent(); treeNode != null && treeNode.getParent() != null; treeNode = treeNode.getParent()) {
            string = treeNode.toString() + "." + string;
        }
        return string;
    }

    protected void initAddSequence(PM_Sequence pM_Sequence) {
        String[] stringArray = pM_Sequence.getPath().split("\\.");
        DefaultMutableTreeNode defaultMutableTreeNode = this.rootNode;
        String string = "";
        if (stringArray.length >= 0) {
            string = stringArray[0].trim();
        }
        for (int i = 0; i < stringArray.length - 1; ++i) {
            String string2 = stringArray[i].trim();
            string = stringArray[i + 1].trim();
            if (string2.length() == 0) continue;
            defaultMutableTreeNode = this.initAddNode(defaultMutableTreeNode, string2);
        }
        defaultMutableTreeNode = pM_Sequence.getStringLeaf() ? this.initAddNode(defaultMutableTreeNode, string) : this.initAddNode(defaultMutableTreeNode, pM_Sequence);
    }

    private DefaultMutableTreeNode initAddNode(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
        Object object2 = defaultMutableTreeNode.children();
        while (object2.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)object2.nextElement();
            if (!defaultMutableTreeNode2.toString().equals(object.toString())) continue;
            return defaultMutableTreeNode2;
        }
        object2 = new DefaultMutableTreeNode(object);
        defaultMutableTreeNode.add((MutableTreeNode)object2);
        return object2;
    }

    protected Set<DefaultMutableTreeNode> getNodesNotInAlbum() {
        return this.nodesNotInAlbum;
    }

    public void createNodesNotInAlbum() {
        PM_TreeModelAlbum pM_TreeModelAlbum = PM_TreeModelAlbum.getInstance();
        pM_TreeModelAlbum.createSequenceDictionary();
        Map<PM_Sequence, Set<DefaultMutableTreeNode>> map = pM_TreeModelAlbum.getSequenceDictionary();
        this.nodesNotInAlbum = new HashSet<DefaultMutableTreeNode>();
        Enumeration<TreeNode> enumeration = this.rootNode.preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            PM_Sequence pM_Sequence;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!defaultMutableTreeNode.isLeaf() || !(defaultMutableTreeNode.getUserObject() instanceof PM_Sequence) || map.containsKey(pM_Sequence = (PM_Sequence)defaultMutableTreeNode.getUserObject())) continue;
            this.nodesNotInAlbum.add(defaultMutableTreeNode);
        }
    }

    public static void nodesNotInAlbum() {
        PM_TreeModelBase pM_TreeModelBase = PM_TreeModelBase.getInstance();
        PM_TreeModelExtended pM_TreeModelExtended = PM_TreeModelExtended.getInstance();
        pM_TreeModelBase.createNodesNotInAlbum();
        pM_TreeModelExtended.createNodesNotInAlbum();
        pM_TreeModelBase.nodeChanged(pM_TreeModelBase.rootNode);
        pM_TreeModelExtended.nodeChanged(pM_TreeModelExtended.rootNode);
    }
}

