/*
 * Decompiled with CFR 0.152.
 */
package pm.utilities;

import gnu.getopt.Getopt;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;
import pm.gui.PM_WindowDialogGetLocale;
import pm.gui.PM_WindowDialogGetTLD;
import pm.inout.PM_XML;
import pm.print.PM_AllSystemPrinter;
import pm.print.PM_PaperFormat;
import pm.print.PM_PictureFormatCollection;
import pm.print.PM_PictureFormatFix;
import pm.print.PM_PmPrinter;
import pm.print.PM_SystemPrinter;
import pm.utilities.PM_Interface;
import pm.utilities.PM_MSG;
import pm.utilities.PM_Utils;
import pm.utilities.PM_XML_Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_Configuration
extends PM_XML
implements PM_Interface {
    private static PM_Configuration instance = null;
    private Locale locale = null;
    private File homeBilder = null;
    private File homeLuceneDB = null;
    private File homeTemp = null;
    private File homeExtProgramme = null;
    private File homeInitValues = null;
    private File homeICCProfiles = null;
    private List<File> importFiles = new ArrayList<File>();
    private boolean nurLesen = false;
    private final PM_AllSystemPrinter systemPrinters = PM_AllSystemPrinter.getInstance();
    private final String TAG_DATUM = "datum";
    private final String ATTR_DATUM_JAHR_VON = "jahr-von";
    private final String ATTR_DATUM_JAHR_BIS = "jahr-bis";
    private int datumJahrVon = 1998;
    private int datumJahrBis = 2010;
    private String slideshowText1 = "kategorie";
    private String slideshowText2 = "datum";
    private String slideshowText3 = "serie";
    private final String TAG_PREFETCH = "prefetch";
    private final String ATTR_PREFETCH_PLUS = "plus";
    private final String ATTR_PREFETCH_MINUS = "minus";
    private int prefetchPlus = 2;
    private int prefetchMinus = 0;
    private String rootTag = "einstellungen";
    private boolean batch = false;
    private boolean daemon = false;
    private final String TAG_BILD_FORMAT = "bild-format";
    private final String ATTR_FORMAT_NAME = "name";
    private final String ATTR_FORMAT_FORMAT = "papier-format";
    private final String ATTR_FORMAT_BREITE = "breite-mm";
    private final String ATTR_FORMAT_HOEHE = "hoehe-mm";
    private final String TAG_DIASHOW = "diashow";
    private final String ATTR_DIASHOW_TEXT1 = "text1";
    private final String ATTR_DIASHOW_TEXT2 = "text2";
    private final String ATTR_DIASHOW_TEXT3 = "text3";
    private final String TAG_BACKUP = "backup";
    private final String TAG_VDR_PLUGIN = "vdr-plugin";
    private final String ATTR_VDR_HOST = "host";
    private final String ATTR_VDR_NAME = "name";
    private final String ATTR_VDR_INDEX = "index";
    private final String ATTR_VDR_MPG = "mpg";
    private final String ATTR_VDR_OV_X = "overscan-x";
    private final String ATTR_VDR_OV_Y = "overscan-y";
    private String vdrPlugHost = "";
    private String vdrPlugName = "";
    private String vdrPlugINDEX = "";
    private String vdrPlugMPG = "";
    private String vdrOverscanX = "0";
    private String vdrOverscanY = "0";
    private boolean vdrPlugin = false;
    private final String TAG_BILDER_BILDER = "bilder";
    private final String ATTR_BILDER_NAME = "name";
    private final String ATTR_BILDER_DIR = "to-dir";
    private final String TAG_DATEN = "daten";
    private final String ATTR_DATEN_NAME = "name";
    private final String ATTR_DATEN_FROM = "from";
    private final String ATTR_DATEN_TO = "to";
    private List<BackUp> backupBilderList = new ArrayList<BackUp>();
    private List<BackUp> backupDatenList = new ArrayList<BackUp>();
    private final String TAG_HOME = "home";
    private final String TAG_BILDER = "bilder";
    private final String TAG_LOCALE = "locale";
    private final String ATTR_LOCALE_LANGUAGE = "language";
    private final String ATTR_LOCALE_COUNTRY = "country";
    private final String ATTR_LOCALE_VARIANT = "variant";
    private final String TAG_SYSTEM_DRUCKER = "system-drucker";
    private final String ATTR_SYSTEM_DRUCKER_NAME = "system-name";
    private final String TAG_PM_DRUCKER = "pm-drucker";
    private final String ATTR_PM_DRUCKER_NAME = "pm-name";
    private final String TAG_DRUCK_BEREICH = "druck-bereich";
    private final String ATTR_DRUCK_BEREICH_OBEN = "oben";
    private final String ATTR_DRUCK_BEREICH_RECHTS = "rechts";
    private final String ATTR_DRUCK_BEREICH_UNTEN = "unten";
    private final String ATTR_DRUCK_BEREICH_LINKS = "links";

    public static PM_Configuration init(String[] stringArray) {
        if (instance == null) {
            instance = new PM_Configuration(stringArray);
        }
        return instance;
    }

    public static PM_Configuration getInstance() {
        return instance;
    }

    private PM_Configuration() {
    }

    private PM_Configuration(String[] stringArray) {
        int n;
        File file = null;
        File file2 = null;
        Getopt getopt = new Getopt("photo-manager", stringArray, "e:b:i:n::d::");
        while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 101: {
                    String string = getopt.getOptarg();
                    file = string == null ? null : new File(string);
                    break;
                }
                case 98: {
                    String string = getopt.getOptarg();
                    file2 = string == null ? null : new File(string);
                    break;
                }
                case 110: {
                    this.batch = true;
                    break;
                }
                case 100: {
                    this.daemon = true;
                    this.batch = true;
                    break;
                }
                case 105: {
                    String string = getopt.getOptarg();
                    if (string == null) break;
                    this.importFiles.add(new File(string));
                }
            }
        }
        for (int i = getopt.getOptind(); i < stringArray.length; ++i) {
            this.importFiles.add(new File(stringArray[i]));
        }
        if (file != null && file.isFile()) {
            this.xmlFile = file;
            this.openDocument(1);
            this.locale = this.getLocale();
            if (this.locale == null) {
                this.locale = new PM_WindowDialogGetLocale().getLocale();
                this.setLocale(this.locale);
                this.writeDocument();
            }
        } else {
            file = new File(PM_Utils.getConfigDir() + File.separator + "pm_einstellungen.xml");
            if (file.isFile()) {
                this.xmlFile = file;
                this.openDocument(1);
                this.locale = this.getLocale();
                if (this.locale == null) {
                    this.locale = new PM_WindowDialogGetLocale().getLocale();
                    this.setLocale(this.locale);
                    this.writeDocument();
                }
            } else {
                this.locale = new PM_WindowDialogGetLocale().getLocale();
                this.xmlFile = file;
                this.rootTagName = this.rootTag;
                this.openDocument(4);
                this.setLocale(this.locale);
                this.writeDocument();
            }
        }
        if (file2 != null && file2.isDirectory()) {
            this.homeBilder = file2;
            this.setHomeBilder(this.homeBilder.getPath());
            this.writeDocument();
        } else {
            this.homeBilder = this.getHomeFile();
            if (this.homeBilder == null || !this.homeBilder.isDirectory()) {
                if (this.batch) {
                    System.out.println("ERROR: batch kein TLPD gefunden");
                    System.out.println("abnormal end");
                    System.exit(0);
                }
                PM_MSG.setResourceBundle(this.locale);
                this.homeBilder = new PM_WindowDialogGetTLD().getTopLevelDirectory();
                if (this.homeBilder == null) {
                    this.setLocale(null);
                    this.writeDocument();
                    System.out.println("abnormal end (no TLPD)");
                    System.exit(0);
                }
                this.setLocale(this.locale);
                this.setHomeBilder(this.homeBilder.getPath());
                this.writeDocument();
            }
        }
        PM_MSG.setResourceBundle(this.locale);
        this.setAllPrinter();
        this.setPrinterFormat();
        this.setDateFromTo();
        this.setPrefetch();
        this.setSlideshow();
        this.setBackup();
        this.setSequences();
        if (this.homeLuceneDB == null) {
            this.homeLuceneDB = new File(this.homeBilder.getPath() + File.separator + "pm_metadaten_root" + File.separator + "pm_lucene.db");
            this.homeLuceneDB.mkdirs();
        }
        if (this.homeTemp == null) {
            this.homeTemp = new File(this.homeBilder.getPath() + File.separator + "pm_temp");
            this.homeTemp.mkdirs();
        }
        if (this.homeExtProgramme == null) {
            this.homeExtProgramme = new File(PM_Utils.getConfigDir() + File.separator + "pm_external_programs.txt");
        }
        if (this.homeInitValues == null) {
            this.homeInitValues = new File(PM_Utils.getConfigDir() + File.separator + "pm_init_values.txt");
        }
    }

    public void close() {
        this.writeDocument();
    }

    public float getMonitorResolution() {
        return 91.3f;
    }

    public float getPrinterResolution() {
        return 72.0f;
    }

    public List<File> getImportFiles() {
        return this.importFiles;
    }

    public boolean getBatch() {
        return this.batch;
    }

    public boolean getDaemon() {
        return this.daemon;
    }

    public boolean isNurLesen() {
        return this.nurLesen;
    }

    public int getDatumJahrVon() {
        return this.datumJahrVon;
    }

    public int getDatumJahrBis() {
        return this.datumJahrBis;
    }

    public File getTopLevelPictureDirectory() {
        return this.homeBilder;
    }

    public File getFileHomeLuceneDB() {
        return this.homeLuceneDB;
    }

    public File getFileHomeTemp() {
        return this.homeTemp;
    }

    public File getFileHomeExtProgramme() {
        return this.homeExtProgramme;
    }

    public File getFileHomeInitValues() {
        return this.homeInitValues;
    }

    public File getFileHomeICCProfiles() {
        return this.homeICCProfiles;
    }

    public File getFileEinstellungen() {
        return this.xmlFile;
    }

    public String getPathMetadatenRoot() {
        File file = new File(this.homeBilder.getPath() + File.separator + "pm_metadaten_root");
        return file.getPath();
    }

    public File getMetaRootDir() {
        return new File(this.homeBilder.getPath() + File.separator + "pm_metadaten_root");
    }

    public int getPrefetchPlus() {
        return this.prefetchPlus;
    }

    public int getPrefetchMinus() {
        return this.prefetchMinus;
    }

    public boolean vdrPlugin() {
        return this.vdrPlugin;
    }

    public String getVdrPluginHost() {
        return this.vdrPlugHost;
    }

    public String getVdrPluginName() {
        return this.vdrPlugName;
    }

    public File getVdrPluginIndexFile() {
        return new File(this.vdrPlugINDEX);
    }

    public File getVdrPluginMpgFile() {
        return new File(this.vdrPlugMPG);
    }

    public String getVdrOverscanX() {
        return this.vdrOverscanX;
    }

    public String getVdrOverscanY() {
        return this.vdrOverscanY;
    }

    public List<BackUp> getBackupBilderList() {
        return this.backupBilderList;
    }

    public List<BackUp> getBackupDatenList() {
        return this.backupDatenList;
    }

    public boolean getSichernBilderZIP() {
        return false;
    }

    public PM_AllSystemPrinter getAllSystemPrinter() {
        return this.systemPrinters;
    }

    public String getSlideshowText1() {
        return this.slideshowText1;
    }

    public String getSlideshowText2() {
        return this.slideshowText2;
    }

    public String getSlideshowText3() {
        return this.slideshowText3;
    }

    private void setPrinterFormat() {
        PM_PictureFormatCollection pM_PictureFormatCollection = PM_PictureFormatCollection.getInstance();
        List list = PM_XML_Utils.getElementListe(this.document, "//bild-format");
        for (Element element : list) {
            String string = PM_XML_Utils.getAttribute(element, "name");
            String string2 = PM_XML_Utils.getAttribute(element, "papier-format");
            int n = PM_XML_Utils.getAttributeInt(element, "breite-mm");
            int n2 = PM_XML_Utils.getAttributeInt(element, "hoehe-mm");
            PM_PaperFormat pM_PaperFormat = PM_PaperFormat.getPaperFormat(string2);
            if (pM_PaperFormat == null || n2 == 0 || n == 0) continue;
            pM_PictureFormatCollection.addBildFormat(new PM_PictureFormatFix(pM_PaperFormat, new Rectangle(n, n2), string));
        }
    }

    private void setDateFromTo() {
        List list = new ArrayList();
        list = PM_XML_Utils.getElementListe(this.document, "//datum");
        if (list.size() == 1) {
            Element element = (Element)list.get(0);
            this.datumJahrVon = PM_XML_Utils.getAttributeInt(element, "jahr-von");
            this.datumJahrBis = PM_XML_Utils.getAttributeInt(element, "jahr-bis");
        }
    }

    private void setPrefetch() {
        List list = new ArrayList();
        list = PM_XML_Utils.getElementListe(this.document, "//prefetch");
        if (list.size() == 1) {
            Element element = (Element)list.get(0);
            this.prefetchPlus = PM_XML_Utils.getAttributeInt(element, "plus");
            this.prefetchMinus = PM_XML_Utils.getAttributeInt(element, "minus");
        }
    }

    private void setSlideshow() {
        List list = new ArrayList();
        list = PM_XML_Utils.getElementListe(this.document, "//diashow");
        if (list.size() == 1) {
            Element element = (Element)list.get(0);
            this.slideshowText1 = PM_XML_Utils.getAttribute(element, "text1");
            this.slideshowText2 = PM_XML_Utils.getAttribute(element, "text2");
            this.slideshowText3 = PM_XML_Utils.getAttribute(element, "text3");
        }
    }

    private void setSequences() {
        this.getSequencesDirNormal();
        this.getSequencesDirBase();
        this.getSequencesDirVirtual();
        this.getSequencesDirNew();
    }

    public File getSequencesDir() {
        File file = new File(this.homeBilder.getPath() + File.separator + "pm_metadaten_root" + File.separator + "pm_sequences");
        file.mkdirs();
        return file;
    }

    public File getSequencesDirNormal() {
        File file = new File(this.homeBilder.getPath() + File.separator + "pm_metadaten_root" + File.separator + "pm_sequences" + File.separator + "normal");
        file.mkdirs();
        return file;
    }

    public File getSequencesDirBase() {
        File file = new File(this.homeBilder.getPath() + File.separator + "pm_metadaten_root" + File.separator + "pm_sequences" + File.separator + "base");
        file.mkdirs();
        return file;
    }

    public File getSequencesDirVirtual() {
        File file = new File(this.homeBilder.getPath() + File.separator + "pm_metadaten_root" + File.separator + "pm_sequences" + File.separator + "virtual");
        file.mkdirs();
        return file;
    }

    public File getSequencesDirNew() {
        File file = new File(this.homeBilder.getPath() + File.separator + "pm_metadaten_root" + File.separator + "pm_sequences" + File.separator + "new");
        file.mkdirs();
        return file;
    }

    private void setBackup() {
        BackUp backUp;
        Element element;
        int n;
        List list = new ArrayList();
        list = PM_XML_Utils.getElementListe(this.document, "//backup/vdr-plugin");
        if (list.size() == 1) {
            this.vdrPlugin = true;
            Element element2 = (Element)list.get(0);
            this.vdrPlugHost = PM_XML_Utils.getAttribute(element2, "host");
            this.vdrPlugName = PM_XML_Utils.getAttribute(element2, "name");
            this.vdrPlugINDEX = PM_XML_Utils.getAttribute(element2, "index");
            this.vdrPlugMPG = PM_XML_Utils.getAttribute(element2, "mpg");
            this.vdrOverscanX = PM_XML_Utils.getAttribute(element2, "overscan-x");
            this.vdrOverscanY = PM_XML_Utils.getAttribute(element2, "overscan-y");
        }
        list = PM_XML_Utils.getElementListe(this.document, "//backup/bilder");
        for (n = 0; n < list.size(); ++n) {
            element = (Element)list.get(n);
            backUp = new BackUp(PM_XML_Utils.getAttribute(element, "name"), this.homeBilder.getPath(), PM_XML_Utils.getAttribute(element, "to-dir"));
            this.backupBilderList.add(backUp);
        }
        list = PM_XML_Utils.getElementListe(this.document, "//backup/daten");
        for (n = 0; n < list.size(); ++n) {
            element = (Element)list.get(n);
            backUp = new BackUp(PM_XML_Utils.getAttribute(element, "name"), PM_XML_Utils.getAttribute(element, "from"), PM_XML_Utils.getAttribute(element, "to"));
            this.backupDatenList.add(backUp);
        }
    }

    private File getHomeFile() {
        File file = null;
        List list = new ArrayList();
        String string = null;
        list = PM_XML_Utils.getElementListe(this.document, "//home/bilder");
        if (list.size() == 1) {
            string = ((Element)list.get(0)).getTextTrim();
            file = new File(string = PM_Utils.removeLastSeparatorChar(string));
            if (!file.isDirectory()) {
                file = null;
            }
        }
        return file;
    }

    private Locale getLocale() {
        List list = new ArrayList();
        String string = "";
        String string2 = "";
        String string3 = "";
        list = PM_XML_Utils.getElementListe(this.document, "//locale");
        if (list.size() == 1) {
            Element element = (Element)list.get(0);
            string = PM_XML_Utils.getAttribute(element, "language");
            string2 = PM_XML_Utils.getAttribute(element, "country");
            string3 = PM_XML_Utils.getAttribute(element, "variant");
        }
        if (string.length() == 0) {
            return null;
        }
        return new Locale(string, string2, string3);
    }

    public void setLocale(Locale locale) {
        Element element = this.document.getRootElement();
        List list = PM_XML_Utils.getElementListe(this.document, "//locale");
        Element element2 = null;
        if (list.isEmpty()) {
            if (locale == null) {
                return;
            }
            element2 = new DefaultElement("locale");
            this.updateAttribute(element2, "language", locale.getLanguage());
            element.add(element2);
        } else {
            element2 = (Element)list.get(0);
            if (locale != null) {
                this.updateAttribute(element2, "language", locale.getLanguage());
            } else {
                this.updateAttribute(element2, "language", null);
            }
        }
    }

    private void setAllPrinter() {
        List list = PM_XML_Utils.getElementListe(this.document, "//system-drucker");
        for (Element element : list) {
            String string = PM_XML_Utils.getAttribute(element, "system-name");
            PM_SystemPrinter pM_SystemPrinter = this.systemPrinters.getSystemPrinter(string);
            if (pM_SystemPrinter == null) continue;
            List list2 = PM_XML_Utils.getElementListe(element, "pm-drucker");
            for (Element element2 : list2) {
                String string2 = PM_XML_Utils.getAttribute(element2, "pm-name");
                PM_PmPrinter pM_PmPrinter = new PM_PmPrinter(pM_SystemPrinter, string2);
                pM_SystemPrinter.addPmDrucker(pM_PmPrinter);
                Element element3 = element2.element("druck-bereich");
                if (element3 == null) continue;
                double d = PM_XML_Utils.getAttributeDouble(element3, "oben");
                double d2 = PM_XML_Utils.getAttributeDouble(element3, "rechts");
                double d3 = PM_XML_Utils.getAttributeDouble(element3, "unten");
                double d4 = PM_XML_Utils.getAttributeDouble(element3, "links");
                pM_PmPrinter.setDruckBereichGesamtRaender(d, d2, d3, d4);
            }
        }
    }

    private void setHomeBilder(String string) {
        Element element = this.document.getRootElement();
        List list = PM_XML_Utils.getElementListe(this.document, "//home");
        Element element2 = null;
        if (list.isEmpty()) {
            element2 = new DefaultElement("home");
            this.addTag(element2, "bilder", string);
            element.add(element2);
        } else {
            element2 = (Element)list.get(0);
            this.addTag(element2, "bilder", string);
        }
    }

    public class BackUp {
        private String name;
        private File fileDirFrom;
        private File fileDirTo;

        public BackUp(String string, String string2, String string3) {
            this.name = string;
            this.fileDirFrom = new File(string2);
            this.fileDirTo = new File(string3);
        }

        public String getName() {
            return this.name;
        }

        public File getFileDirFrom() {
            return this.fileDirFrom;
        }

        public File getFileDirTo() {
            return this.fileDirTo;
        }
    }
}

