/*
 * Decompiled with CFR 0.152.
 */
package pm.utilities;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import pm.picture.PM_MetadataContainer;
import pm.picture.PM_Picture;
import pm.picture.PM_PictureDirectory;
import pm.sequence.PM_Sequence;
import pm.sequence.PM_TreeModelAlbum;
import pm.sequence.PM_TreeModelBase;
import pm.sequence.PM_TreeModelExtended;
import pm.utilities.PM_Configuration;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Utils;

public class PM_RemoteAccess
implements PM_Interface {
    private File topLevelPictureDirectory;
    private List<DefaultMutableTreeNode> rootNodeList = new ArrayList<DefaultMutableTreeNode>();

    public PM_RemoteAccess() {
        this.topLevelPictureDirectory = PM_Configuration.getInstance().getTopLevelPictureDirectory();
        this.rootNodeList.add(PM_TreeModelAlbum.getInstance().getRootNode());
        this.rootNodeList.add(PM_TreeModelBase.getInstance().getRootNode());
        this.rootNodeList.add(PM_TreeModelExtended.getInstance().getRootNode());
    }

    public String invoke(String string, String string2) {
        Object object = null;
        try {
            Method method = this.getClass().getMethod(string, String.class);
            object = method.invoke((Object)this, string2);
        }
        catch (Exception exception) {
            System.out.println("exception e" + exception.getCause());
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public String getPathTLPD(String string) {
        return this.topLevelPictureDirectory.getPath();
    }

    public String getTreeNode(String string) {
        CharSequence charSequence;
        System.out.println("method getTreeNode in = >" + string + "<");
        StringBuffer stringBuffer = new StringBuffer();
        string = string.trim();
        if (string.length() == 0) {
            for (DefaultMutableTreeNode defaultMutableTreeNode : this.rootNodeList) {
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(";");
                }
                stringBuffer.append(defaultMutableTreeNode.getUserObject());
            }
            return "//" + stringBuffer.toString();
        }
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        Object object = string.split("\\.");
        int n = ((String[])object).length;
        for (int i = 0; i < n; ++i) {
            charSequence = object[i];
            int n2 = PM_Utils.stringToInt((String)charSequence);
            if (defaultMutableTreeNode == null) {
                defaultMutableTreeNode = n2 >= this.rootNodeList.size() ? this.rootNodeList.get(0) : this.rootNodeList.get(n2);
                stringBuffer.append(defaultMutableTreeNode.getUserObject());
                continue;
            }
            stringBuffer.append(".");
            int n3 = defaultMutableTreeNode.getChildCount();
            if (n3 == 0) break;
            defaultMutableTreeNode = n2 >= n3 ? (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n3 - 1) : (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
            stringBuffer.append(defaultMutableTreeNode.getUserObject());
        }
        if (defaultMutableTreeNode.isLeaf() && (object = defaultMutableTreeNode.getUserObject()) instanceof PM_Sequence) {
            n = 0;
            PM_Sequence pM_Sequence = (PM_Sequence)object;
            charSequence = new StringBuffer();
            for (PM_Picture pM_Picture : pM_Sequence.getAlleBilder()) {
                if (((StringBuffer)charSequence).length() > 0) {
                    ((StringBuffer)charSequence).append(";");
                }
                ++n;
                ((StringBuffer)charSequence).append(PM_Picture.getPictureKey(pM_Picture.getFileOriginal()));
            }
            String string2 = String.valueOf(n) + "%;";
            return string + "/" + stringBuffer.toString() + "/" + (String)string2 + ((StringBuffer)charSequence).toString();
        }
        object = new StringBuffer();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (((StringBuffer)object).length() != 0) {
                ((StringBuffer)object).append(";");
            }
            ((StringBuffer)object).append(defaultMutableTreeNode2.getUserObject());
            if (!defaultMutableTreeNode2.isLeaf() || defaultMutableTreeNode2.getUserObject() instanceof PM_Sequence) continue;
            ((StringBuffer)object).append("...");
        }
        return string + "/" + stringBuffer.toString() + "/" + ((StringBuffer)object).toString();
    }

    public String getAllIndexDirs(String string) {
        PM_MetadataContainer pM_MetadataContainer = PM_MetadataContainer.getInstance();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (PM_PictureDirectory pM_PictureDirectory : pM_MetadataContainer.getPictureDirectories()) {
            String string2 = pM_PictureDirectory.getRelativePathTLD();
            int n2 = pM_PictureDirectory.getIdNumber();
            n = Math.max(n, n2);
            stringBuffer.append(String.valueOf(n2) + "_" + string2 + ";");
        }
        return String.valueOf(n) + ";" + stringBuffer.toString();
    }

    public String getVideoPath(String string) {
        File file = PM_MetadataContainer.getInstance().getFileOriginal(string);
        return file == null ? "not-found" : file.getAbsolutePath();
    }
}

