/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata;

import com.drew.lang.Rational;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.drew.metadata.TagDescriptor;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public abstract class Directory
implements Serializable {
    protected final HashMap _tagMap = new HashMap();
    protected TagDescriptor _descriptor;
    protected final List _definedTagList = new ArrayList();
    private List _errorList;

    public abstract String getName();

    protected abstract HashMap getTagNameMap();

    public boolean containsTag(int n) {
        return this._tagMap.containsKey(new Integer(n));
    }

    public Iterator getTagIterator() {
        return this._definedTagList.iterator();
    }

    public int getTagCount() {
        return this._definedTagList.size();
    }

    public void setDescriptor(TagDescriptor tagDescriptor) {
        if (tagDescriptor == null) {
            throw new NullPointerException("cannot set a null descriptor");
        }
        this._descriptor = tagDescriptor;
    }

    public void addError(String string) {
        if (this._errorList == null) {
            this._errorList = new ArrayList();
        }
        this._errorList.add(string);
    }

    public boolean hasErrors() {
        return this._errorList != null && this._errorList.size() > 0;
    }

    public Iterator getErrors() {
        return this._errorList.iterator();
    }

    public int getErrorCount() {
        return this._errorList.size();
    }

    public void setInt(int n, int n2) {
        this.setObject(n, new Integer(n2));
    }

    public void setDouble(int n, double d) {
        this.setObject(n, new Double(d));
    }

    public void setFloat(int n, float f) {
        this.setObject(n, new Float(f));
    }

    public void setString(int n, String string) {
        this.setObject(n, string);
    }

    public void setBoolean(int n, boolean bl) {
        this.setObject(n, new Boolean(bl));
    }

    public void setLong(int n, long l) {
        this.setObject(n, new Long(l));
    }

    public void setDate(int n, Date date) {
        this.setObject(n, date);
    }

    public void setRational(int n, Rational rational) {
        this.setObject(n, rational);
    }

    public void setRationalArray(int n, Rational[] rationalArray) {
        this.setObjectArray(n, rationalArray);
    }

    public void setIntArray(int n, int[] nArray) {
        this.setObjectArray(n, nArray);
    }

    public void setByteArray(int n, byte[] byArray) {
        this.setObjectArray(n, byArray);
    }

    public void setStringArray(int n, String[] stringArray) {
        this.setObjectArray(n, stringArray);
    }

    public void setObject(int n, Object object) {
        if (object == null) {
            throw new NullPointerException("cannot set a null object");
        }
        Integer n2 = new Integer(n);
        if (!this._tagMap.containsKey(n2)) {
            this._definedTagList.add(new Tag(n, this));
        }
        this._tagMap.put(n2, object);
    }

    public void setObjectArray(int n, Object object) {
        this.setObject(n, object);
    }

    public int getInt(int n) throws MetadataException {
        Object object = this.getObject(n);
        if (object == null) {
            throw new MetadataException("Tag " + this.getTagName(n) + " has not been set -- check using containsTag() first");
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string = (String)object;
                int n2 = 0;
                for (int i = string.length() - 1; i >= 0; --i) {
                    n2 += string.charAt(i) << i * 8;
                }
                return n2;
            }
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        throw new MetadataException("Requested tag cannot be cast to int");
    }

    public String[] getStringArray(int n) throws MetadataException {
        Object object = this.getObject(n);
        if (object == null) {
            throw new MetadataException("Tag " + this.getTagName(n) + " has not been set -- check using containsTag() first");
        }
        if (object instanceof String[]) {
            return (String[])object;
        }
        if (object instanceof String) {
            String[] stringArray = new String[]{(String)object};
            return stringArray;
        }
        if (object instanceof int[]) {
            int[] nArray = (int[])object;
            String[] stringArray = new String[nArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = Integer.toString(nArray[i]);
            }
            return stringArray;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            String[] stringArray = new String[byArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = Byte.toString(byArray[i]);
            }
            return stringArray;
        }
        if (object instanceof Rational[]) {
            Rational[] rationalArray = (Rational[])object;
            String[] stringArray = new String[rationalArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = rationalArray[i].toSimpleString(false);
            }
            return stringArray;
        }
        throw new MetadataException("Requested tag cannot be cast to String array (" + object.getClass().toString() + ")");
    }

    public int[] getIntArray(int n) throws MetadataException {
        Object object = this.getObject(n);
        if (object == null) {
            throw new MetadataException("Tag " + this.getTagName(n) + " has not been set -- check using containsTag() first");
        }
        if (object instanceof Rational[]) {
            Rational[] rationalArray = (Rational[])object;
            int[] nArray = new int[rationalArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = rationalArray[i].intValue();
            }
            return nArray;
        }
        if (object instanceof int[]) {
            return (int[])object;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            int[] nArray = new int[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                int n2;
                nArray[i] = n2 = byArray[i];
            }
            return nArray;
        }
        if (object instanceof String) {
            String string = (String)object;
            int[] nArray = new int[string.length()];
            for (int i = 0; i < string.length(); ++i) {
                nArray[i] = string.charAt(i);
            }
            return nArray;
        }
        throw new MetadataException("Requested tag cannot be cast to int array (" + object.getClass().toString() + ")");
    }

    public byte[] getByteArray(int n) throws MetadataException {
        Object object = this.getObject(n);
        if (object == null) {
            throw new MetadataException("Tag " + this.getTagName(n) + " has not been set -- check using containsTag() first");
        }
        if (object instanceof Rational[]) {
            Rational[] rationalArray = (Rational[])object;
            byte[] byArray = new byte[rationalArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = rationalArray[i].byteValue();
            }
            return byArray;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof int[]) {
            int[] nArray = (int[])object;
            byte[] byArray = new byte[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                byArray[i] = (byte)nArray[i];
            }
            return byArray;
        }
        if (object instanceof String) {
            String string = (String)object;
            byte[] byArray = new byte[string.length()];
            for (int i = 0; i < string.length(); ++i) {
                byArray[i] = (byte)string.charAt(i);
            }
            return byArray;
        }
        throw new MetadataException("Requested tag cannot be cast to byte array (" + object.getClass().toString() + ")");
    }

    public double getDouble(int n) throws MetadataException {
        Object object = this.getObject(n);
        if (object == null) {
            throw new MetadataException("Tag " + this.getTagName(n) + " has not been set -- check using containsTag() first");
        }
        if (object instanceof String) {
            try {
                return Double.parseDouble((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MetadataException("unable to parse string " + object + " as a double", numberFormatException);
            }
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        throw new MetadataException("Requested tag cannot be cast to double");
    }

    public float getFloat(int n) throws MetadataException {
        Object object = this.getObject(n);
        if (object == null) {
            throw new MetadataException("Tag " + this.getTagName(n) + " has not been set -- check using containsTag() first");
        }
        if (object instanceof String) {
            try {
                return Float.parseFloat((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MetadataException("unable to parse string " + object + " as a float", numberFormatException);
            }
        }
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        throw new MetadataException("Requested tag cannot be cast to float");
    }

    public long getLong(int n) throws MetadataException {
        Object object = this.getObject(n);
        if (object == null) {
            throw new MetadataException("Tag " + this.getTagName(n) + " has not been set -- check using containsTag() first");
        }
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MetadataException("unable to parse string " + object + " as a long", numberFormatException);
            }
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        throw new MetadataException("Requested tag cannot be cast to long");
    }

    public boolean getBoolean(int n) throws MetadataException {
        Object object = this.getObject(n);
        if (object == null) {
            throw new MetadataException("Tag " + this.getTagName(n) + " has not been set -- check using containsTag() first");
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            try {
                return Boolean.getBoolean((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MetadataException("unable to parse string " + object + " as a boolean", numberFormatException);
            }
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue() != 0.0;
        }
        throw new MetadataException("Requested tag cannot be cast to boolean");
    }

    public Date getDate(int n) throws MetadataException {
        Object object = this.getObject(n);
        if (object == null) {
            throw new MetadataException("Tag " + this.getTagName(n) + " has not been set -- check using containsTag() first");
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof String) {
            String[] stringArray = new String[]{"yyyy:MM:dd HH:mm:ss", "yyyy:MM:dd HH:mm", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm"};
            String string = (String)object;
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(stringArray[i]);
                    return simpleDateFormat.parse(string);
                }
                catch (ParseException parseException) {
                    continue;
                }
            }
        }
        throw new MetadataException("Requested tag cannot be cast to java.util.Date");
    }

    public Rational getRational(int n) throws MetadataException {
        Object object = this.getObject(n);
        if (object == null) {
            throw new MetadataException("Tag " + this.getTagName(n) + " has not been set -- check using containsTag() first");
        }
        if (object instanceof Rational) {
            return (Rational)object;
        }
        throw new MetadataException("Requested tag cannot be cast to Rational");
    }

    public Rational[] getRationalArray(int n) throws MetadataException {
        Object object = this.getObject(n);
        if (object == null) {
            throw new MetadataException("Tag " + this.getTagName(n) + " has not been set -- check using containsTag() first");
        }
        if (object instanceof Rational[]) {
            return (Rational[])object;
        }
        throw new MetadataException("Requested tag cannot be cast to Rational array (" + object.getClass().toString() + ")");
    }

    public String getString(int n) {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof Rational) {
            return ((Rational)object).toSimpleString(true);
        }
        if (object.getClass().isArray()) {
            int n2 = Array.getLength(object);
            boolean bl = object.getClass().toString().startsWith("class [L");
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n2; ++i) {
                if (i != 0) {
                    stringBuffer.append(' ');
                }
                if (bl) {
                    stringBuffer.append(Array.get(object, i).toString());
                    continue;
                }
                stringBuffer.append(Array.getInt(object, i));
            }
            return stringBuffer.toString();
        }
        return object.toString();
    }

    public Object getObject(int n) {
        return this._tagMap.get(new Integer(n));
    }

    public String getTagName(int n) {
        Integer n2 = new Integer(n);
        HashMap hashMap = this.getTagNameMap();
        if (!hashMap.containsKey(n2)) {
            String string = Integer.toHexString(n);
            while (string.length() < 4) {
                string = "0" + string;
            }
            return "Unknown tag (0x" + string + ")";
        }
        return (String)hashMap.get(n2);
    }

    public String getDescription(int n) throws MetadataException {
        if (this._descriptor == null) {
            throw new MetadataException("a descriptor must be set using setDescriptor(...) before descriptions can be provided");
        }
        return this._descriptor.getDescription(n);
    }
}

