/*
 * Decompiled with CFR 0.152.
 */
import edu.umd.cs.jazz.ZSceneGraphObject;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;

public class ImageDragSource
implements DragGestureListener,
DragSourceListener {
    PhotoMesa photomesa;
    boolean dropping = false;

    ImageDragSource(PhotoMesa photoMesa) {
        this.photomesa = photoMesa;
        DragSource dragSource = CustomDragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(photoMesa.getImagePane(), 1, this);
    }

    public boolean isDropping() {
        return this.dropping;
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        ImagePane imagePane = this.photomesa.getImagePane();
        if (imagePane.eventHandlers.getEventMode() == 2) {
            ZSceneGraphObject zSceneGraphObject = imagePane.getPressObj();
            if (!imagePane.eventHandlers.isInteracting() && zSceneGraphObject != null) {
                ImageTransferable imageTransferable = new ImageTransferable(this.photomesa, this.photomesa.getImagePane().getSelectionImageItems());
                dragGestureEvent.startDrag(DragSource.DefaultCopyNoDrop, imageTransferable, this);
                this.dropping = true;
            }
        }
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
        int n = dragSourceDragEvent.getDropAction();
        if ((n & 1) != 0) {
            dragSourceContext.setCursor(DragSource.DefaultCopyDrop);
        } else {
            dragSourceContext.setCursor(DragSource.DefaultCopyNoDrop);
        }
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        this.dropping = false;
    }
}

