/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz;

import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZDebug;
import edu.umd.cs.jazz.util.ZFindFilter;
import edu.umd.cs.jazz.util.ZRenderContext;
import edu.umd.cs.jazz.util.ZSceneGraphPath;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.RepaintManager;

public class ZDrawingSurface
implements Printable,
Serializable {
    public static final int RENDER_QUALITY_LOW = 1;
    public static final int RENDER_QUALITY_MEDIUM = 2;
    public static final int RENDER_QUALITY_HIGH = 3;
    public static final int DEFAULT_HALO = 2;
    private transient ZCamera camera = null;
    private transient ZNode cameraNode = null;
    private JComponent component = null;
    private boolean interacting;
    private boolean animating;
    private int currentRenderQuality = 1;
    private int normalRenderQuality = 1;
    private int interactingRenderQuality = 1;
    private Rectangle tmpRepaintRect = new Rectangle();
    private boolean paintingImmediately = false;

    public ZDrawingSurface() {
        this(null, null);
    }

    public ZDrawingSurface(ZCamera camera, ZNode cameraNode) {
        this.setCamera(camera, cameraNode);
    }

    public ZDrawingSurface(ZCamera camera, ZNode cameraNode, JComponent aComponent) {
        this.component = aComponent;
        this.setCamera(camera, cameraNode);
    }

    public void setRenderQuality(int qualityRequested) {
        this.normalRenderQuality = qualityRequested;
        if (!this.isInteracting()) {
            if (qualityRequested > this.currentRenderQuality) {
                this.currentRenderQuality = qualityRequested;
                this.repaint();
            } else {
                this.currentRenderQuality = qualityRequested;
            }
        }
    }

    public int getRenderQuality() {
        return this.normalRenderQuality;
    }

    public void setInteractingRenderQuality(int qualityRequested) {
        this.interactingRenderQuality = qualityRequested;
        if (this.isInteracting()) {
            if (qualityRequested > this.currentRenderQuality) {
                this.currentRenderQuality = qualityRequested;
                this.repaint();
            } else {
                this.currentRenderQuality = qualityRequested;
            }
        }
    }

    public int getInteractingRenderQuality() {
        return this.interactingRenderQuality;
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void setComponent(JComponent aComponent) {
        this.component = aComponent;
    }

    public void setCamera(ZCamera cam, ZNode camNode) {
        if (this.camera != null) {
            this.camera.setDrawingSurface(null);
        }
        this.camera = cam;
        this.cameraNode = camNode;
        if (this.camera != null) {
            this.camera.setDrawingSurface(this);
        }
    }

    public ZCamera getCamera() {
        return this.camera;
    }

    public ZNode getCameraNode() {
        return this.cameraNode;
    }

    public boolean isInteracting() {
        return this.interacting;
    }

    public void setInteracting(boolean v) {
        if (v && !this.interacting) {
            this.interacting = true;
            if (this.interactingRenderQuality > this.currentRenderQuality) {
                this.currentRenderQuality = this.interactingRenderQuality;
                this.repaint();
            } else {
                this.currentRenderQuality = this.interactingRenderQuality;
            }
        } else if (!v && this.interacting) {
            this.interacting = false;
            if (this.normalRenderQuality >= this.currentRenderQuality) {
                this.currentRenderQuality = this.normalRenderQuality;
                this.repaint();
            } else {
                this.currentRenderQuality = this.normalRenderQuality;
            }
        }
    }

    void setAnimating(boolean v) {
        if (v && !this.animating) {
            this.animating = true;
            if (this.interactingRenderQuality > this.currentRenderQuality) {
                this.currentRenderQuality = this.interactingRenderQuality;
                this.repaint();
            } else {
                this.currentRenderQuality = this.interactingRenderQuality;
            }
        } else if (!v && this.animating) {
            this.animating = false;
            if (this.normalRenderQuality > this.currentRenderQuality) {
                this.currentRenderQuality = this.normalRenderQuality;
                this.repaint();
            } else {
                this.currentRenderQuality = this.normalRenderQuality;
            }
        }
    }

    boolean getAnimating() {
        return this.animating;
    }

    public void repaint() {
        if (this.camera != null) {
            this.camera.repaint();
        }
    }

    void repaint(ZBounds repaintBounds) {
        if (ZDebug.debugRepaint) {
            System.out.println("ZDrawingSurface.repaint: repaintBounds = " + repaintBounds);
        }
        if (this.component != null) {
            this.tmpRepaintRect.setRect((int)(repaintBounds.getX() - 1.0), (int)(repaintBounds.getY() - 1.0), (int)(repaintBounds.getWidth() + 3.0), (int)(repaintBounds.getHeight() + 3.0));
            this.component.repaint(this.tmpRepaintRect);
        }
        if (ZDebug.debugRepaint) {
            System.out.println();
        }
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Rectangle rectSrc = g2.getClipBounds();
        ZBounds paintBounds = rectSrc == null ? this.camera.getBounds() : new ZBounds(rectSrc);
        if (ZDebug.debugRender) {
            System.out.println("ZDrawingSurface.paint(ZRenderContext): transform   = " + g2.getTransform());
            System.out.println("ZDrawingSurface.paint(ZRenderContext): clip bounds = " + g2.getClipBounds());
            System.out.println("ZDrawingSurface.paint(ZRenderContext): paint bounds = " + paintBounds);
            ZDebug.clearPaintCount();
        }
        ZRenderContext rc = this.camera.createRenderContext(g2, paintBounds, this, this.currentRenderQuality);
        this.camera.getRoot().setCurrentRenderContext(rc);
        this.camera.render(rc);
        this.camera.getRoot().setCurrentRenderContext(null);
        if (ZDebug.debugRender) {
            System.out.println("ZDrawingSurface.paint: Rendered " + ZDebug.getPaintCount() + " objects this pass");
            System.out.println("");
        }
    }

    public void paintImmediately() {
        if (this.paintingImmediately) {
            return;
        }
        this.paintingImmediately = true;
        if (this.component != null) {
            RepaintManager.currentManager(this.component).paintDirtyRegions();
        }
        this.paintingImmediately = false;
    }

    public ZSceneGraphPath pick(int x, int y) {
        return this.pick(x, y, 2);
    }

    public ZSceneGraphPath pick(int x, int y, int halo) {
        ZSceneGraphPath path = new ZSceneGraphPath();
        if (this.camera != null) {
            long startTime = 0L;
            long pickTime = 0L;
            if (ZDebug.debugTiming) {
                startTime = System.currentTimeMillis();
            }
            ZBounds rect = new ZBounds(x - halo, y - halo, halo + halo, halo + halo);
            path.setRoot(this.camera.getRoot());
            path.setTopCamera(this.camera);
            path.setTopCameraNode(this.cameraNode);
            this.camera.pick(rect, path);
            if (ZDebug.debugTiming) {
                pickTime = System.currentTimeMillis();
                System.out.println("ZDrawingSurface.pick: pickTime = " + (pickTime - startTime));
            }
        }
        if (ZDebug.debugPick) {
            System.out.println("ZDrawingSurface.pick: " + path);
        }
        return path;
    }

    public ArrayList findNodes(ZFindFilter filter) {
        ArrayList nodes = new ArrayList();
        if (this.camera != null) {
            this.camera.findNodes(filter, nodes);
        }
        return nodes;
    }

    public void printSurface() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printJob.defaultPage();
        Book book = new Book();
        book.append(this, pageFormat);
        printJob.setPageable(book);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (Exception e) {
                System.out.println("Error Printing");
                e.printStackTrace();
            }
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (pageIndex != 0) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)graphics;
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        ZBounds cameraBounds = this.camera.getBounds();
        double scaleFactor = pageFormat.getImageableWidth() / cameraBounds.getWidth();
        if (pageFormat.getImageableHeight() / cameraBounds.getHeight() < scaleFactor) {
            scaleFactor = pageFormat.getImageableHeight() / cameraBounds.getHeight();
        }
        g2.scale(scaleFactor, scaleFactor);
        ZRenderContext rc = this.camera.createRenderContext(g2, new ZBounds(cameraBounds), this, 3);
        this.camera.getRoot().setCurrentRenderContext(rc);
        this.camera.render(rc);
        this.camera.getRoot().setCurrentRenderContext(null);
        return 0;
    }

    public String dump() {
        String str = this.toString();
        str = str + "\n Camera: " + this.camera;
        return str;
    }

    static {
        RENDER_QUALITY_LOW = 1;
        RENDER_QUALITY_MEDIUM = 2;
        RENDER_QUALITY_HIGH = 3;
        DEFAULT_HALO = 2;
    }
}

