/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.animation;

import edu.umd.cs.jazz.animation.ZAnimation;
import edu.umd.cs.jazz.component.ZStroke;
import java.awt.BasicStroke;

public class ZStrokeAnimation
extends ZAnimation {
    private BasicStroke fSource;
    private BasicStroke fDestination;
    private ZStroke fTargetStroke;

    public ZStrokeAnimation(BasicStroke aSource, BasicStroke aDestination) {
        this.setSourceStroke(aSource);
        this.setDestinationStroke(aDestination);
    }

    public BasicStroke getSourceStroke() {
        return this.fSource;
    }

    public void setSourceStroke(BasicStroke aStroke) {
        this.fSource = aStroke;
    }

    public BasicStroke getDestinationStroke() {
        return this.fDestination;
    }

    public void setDestinationStroke(BasicStroke aStroke) {
        this.fDestination = aStroke;
    }

    public ZStroke getStrokeTarget() {
        return this.fTargetStroke;
    }

    public void setStrokeTarget(ZStroke aTarget) {
        this.fTargetStroke = aTarget;
    }

    protected void animateFrameForTime(long aTime) {
        super.animateFrameForTime(aTime);
        if (this.fTargetStroke != null) {
            float ratio = this.getAlpha().value(aTime);
            float lineWidth = this.fSource.getLineWidth() + ratio * (this.fDestination.getLineWidth() - this.fSource.getLineWidth());
            this.fTargetStroke.setStroke(new BasicStroke(lineWidth));
        }
    }
}

