/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.component;

import edu.umd.cs.jazz.ZVisualComponent;
import edu.umd.cs.jazz.component.ZPenColor;
import edu.umd.cs.jazz.io.ZObjectOutputStream;
import edu.umd.cs.jazz.util.ZRenderContext;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class ZLabel
extends ZVisualComponent
implements ZPenColor,
Serializable {
    protected static final FontRenderContext LOW_QUALITY_FONT_CONTEXT = new FontRenderContext(null, false, false);
    protected static final FontRenderContext HIGH_QUALITY_FONT_CONTEXT = new FontRenderContext(null, true, true);
    protected static final String DEFAULT_FONT_NAME = "Helvetica";
    protected static final int DEFAULT_FONT_STYLE = 0;
    protected static final int DEFAULT_FONT_SIZE = 12;
    protected static final Font DEFAULT_FONT;
    protected static final Color DEFAULT_PEN_COLOR;
    protected static final Color DEFAULT_BACKGROUND_COLOR;
    protected static final String DEFAULT_TEXT = "";
    protected Color penColor = DEFAULT_PEN_COLOR;
    protected Color backgroundColor = DEFAULT_BACKGROUND_COLOR;
    protected Font font = DEFAULT_FONT;
    protected String line = null;
    protected boolean boundsBug = false;
    protected double translateX = 0.0;
    protected double translateY = 0.0;

    public ZLabel() {
        this(DEFAULT_TEXT, DEFAULT_FONT);
    }

    public ZLabel(String str) {
        this(str, DEFAULT_FONT);
    }

    public ZLabel(String str, Font font) {
        if (System.getProperty("java.version").equals("1.2") || System.getProperty("java.version").equals("1.2.1")) {
            this.boundsBug = true;
        }
        this.setText(str);
        this.font = font;
        this.reshape();
    }

    protected Object duplicateObject() {
        ZLabel newText = (ZLabel)super.duplicateObject();
        newText.line = this.line;
        return newText;
    }

    public Color getPenColor() {
        return this.penColor;
    }

    public void setPenColor(Color color) {
        this.penColor = color;
        this.repaint();
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        this.repaint();
    }

    public Font getFont() {
        return this.font;
    }

    public String getText() {
        return this.line;
    }

    public void setFont(Font aFont) {
        this.font = aFont;
        this.reshape();
    }

    public void setText(String str) {
        this.line = str;
        this.reshape();
    }

    public void setTranslateX(double x) {
        this.setTranslation(x, this.translateY);
    }

    public double getTranslateX() {
        return this.translateX;
    }

    public void setTranslateY(double y) {
        this.setTranslation(this.translateX, y);
    }

    public double getTranslateY() {
        return this.translateY;
    }

    public void setTranslation(double x, double y) {
        this.translateX = x;
        this.translateY = y;
        this.reshape();
    }

    public void setTranslation(Point2D p) {
        this.setTranslation(p.getX(), p.getY());
    }

    public Point2D getTranslation() {
        Point2D.Double p = new Point2D.Double(this.translateX, this.translateY);
        return p;
    }

    public void render(ZRenderContext renderContext) {
        Graphics2D g2 = renderContext.getGraphics2D();
        AffineTransform at = null;
        boolean translated = false;
        if (this.line != null) {
            if (this.translateX != 0.0 || this.translateY != 0.0) {
                at = g2.getTransform();
                g2.translate(this.translateX, this.translateY);
                translated = true;
            }
            if (this.backgroundColor != null) {
                g2.setColor(this.backgroundColor);
                Rectangle2D.Double rect = new Rectangle2D.Double(this.bounds.getX(), this.bounds.getY(), this.bounds.getWidth(), this.bounds.getHeight());
                g2.fill(rect);
            }
            if ((double)this.font.getSize() * renderContext.getCompositeMagnification() >= 0.5) {
                g2.setColor(this.penColor);
                g2.setFont(this.font);
                FontRenderContext frc = g2.getFontRenderContext();
                LineMetrics lm = this.font.getLineMetrics(this.line, frc);
                g2.drawString(this.line, 0.0f, lm.getAscent());
            }
            if (translated) {
                g2.setTransform(at);
            }
        }
    }

    protected void computeBounds() {
        Rectangle2D rect = null;
        Object bugBounds = null;
        double maxWidth = 0.0;
        double maxHeight = 0.0;
        FontRenderContext frc = LOW_QUALITY_FONT_CONTEXT;
        int loop = 0;
        while (loop < 2) {
            double height;
            if (this.line != null && !this.line.equals(DEFAULT_TEXT)) {
                rect = this.font.getStringBounds(this.line, frc);
                double lineWidth = rect.getWidth();
                if (this.boundsBug && this.line.endsWith(" ")) {
                    lineWidth = this.font.getStringBounds(this.line.substring(0, this.line.length() - 1) + 't', frc).getWidth();
                }
                if (lineWidth > maxWidth) {
                    maxWidth = lineWidth;
                }
                LineMetrics lm = this.font.getLineMetrics(this.line, frc);
                height = lm.getAscent() + lm.getDescent();
            } else {
                rect = this.boundsBug ? this.font.getStringBounds("t", frc) : this.font.getStringBounds(" ", frc);
                maxWidth = rect.getWidth();
                height = rect.getHeight();
            }
            if (maxHeight < height) {
                maxHeight = height;
            }
            frc = HIGH_QUALITY_FONT_CONTEXT;
            ++loop;
        }
        this.bounds.setRect(this.translateX, this.translateY, maxWidth, maxHeight);
    }

    public void setState(String fieldType, String fieldName, Object fieldValue) {
        super.setState(fieldType, fieldName, fieldValue);
        if (fieldName.compareTo("penColor") == 0) {
            this.setPenColor((Color)fieldValue);
        } else if (fieldName.compareTo("backgroundColor") == 0) {
            this.setBackgroundColor((Color)fieldValue);
        } else if (fieldName.compareTo("font") == 0) {
            this.setFont((Font)fieldValue);
        } else if (fieldName.compareTo("text") == 0) {
            this.setText((String)fieldValue);
        } else if (fieldName.compareTo("translateX") == 0) {
            this.setTranslateX((Double)fieldValue);
        } else if (fieldName.compareTo("translateY") == 0) {
            this.setTranslateY((Double)fieldValue);
        }
    }

    public void writeObject(ZObjectOutputStream out) throws IOException {
        super.writeObject(out);
        if (this.penColor != null && this.penColor != DEFAULT_PEN_COLOR) {
            out.writeState("java.awt.Color", "penColor", this.penColor);
        }
        if (this.backgroundColor != null && this.backgroundColor != DEFAULT_BACKGROUND_COLOR) {
            out.writeState("java.awt.Color", "backgroundColor", this.backgroundColor);
        }
        if (this.getFont() != DEFAULT_FONT) {
            out.writeState("java.awt.Font", "font", this.getFont());
        }
        if (this.translateX != 0.0) {
            out.writeState("Double", "translateX", new Double(this.translateX));
        }
        if (this.translateY != 0.0) {
            out.writeState("Double", "translateY", new Double(this.translateY));
        }
        if (this.getText() != DEFAULT_TEXT) {
            out.writeState("String", "text", this.getText());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    static {
        DEFAULT_FONT_NAME = DEFAULT_FONT_NAME;
        DEFAULT_FONT_STYLE = 0;
        DEFAULT_FONT_SIZE = 12;
        DEFAULT_FONT = new Font(DEFAULT_FONT_NAME, 0, 12);
        DEFAULT_PEN_COLOR = Color.black;
        DEFAULT_BACKGROUND_COLOR = null;
        DEFAULT_TEXT = DEFAULT_TEXT;
    }
}

