/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.component;

import edu.umd.cs.jazz.component.ZShape;
import edu.umd.cs.jazz.io.ZObjectOutputStream;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class ZRoundedRectangle
extends ZShape {
    protected transient RoundRectangle2D roundedRect;

    public ZRoundedRectangle() {
    }

    public ZRoundedRectangle(double x, double y, double w, double h, double arcWidth, double arcHeight) {
        this.setRoundRect(x, y, w, h, arcWidth, arcHeight);
    }

    public ZRoundedRectangle(RoundRectangle2D aRoundedRectangle) {
        this.setRoundRect(aRoundedRectangle);
    }

    protected Object duplicateObject() {
        ZRoundedRectangle newRoundedRect = (ZRoundedRectangle)super.duplicateObject();
        newRoundedRect.roundedRect = (RoundRectangle2D)this.getRounedRect().clone();
        return newRoundedRect;
    }

    public double getArcHeight() {
        return this.getRounedRect().getArcHeight();
    }

    public double getArcWidth() {
        return this.getRounedRect().getArcWidth();
    }

    public RoundRectangle2D getRounedRect() {
        if (this.roundedRect == null) {
            this.roundedRect = new RoundRectangle2D.Double();
        }
        return this.roundedRect;
    }

    public Shape getShape() {
        return this.getRounedRect();
    }

    public void setFrame(double x, double y, double w, double h) {
        this.setRoundRect(x, y, w, h, this.getArcWidth(), this.getArcHeight());
    }

    public void setRoundRect(double x, double y, double w, double h, double arcWidth, double arcHeight) {
        this.getRounedRect().setRoundRect(x, y, w, h, arcWidth, arcHeight);
        this.reshape();
    }

    public void setRoundRect(RoundRectangle2D rr) {
        this.getRounedRect().setRoundRect(rr);
        this.reshape();
    }

    public void writeObject(ZObjectOutputStream out) throws IOException {
        super.writeObject(out);
        RoundRectangle2D rect = this.getRounedRect();
        Vector<Double> dimensions = new Vector<Double>();
        dimensions.add(new Double(rect.getX()));
        dimensions.add(new Double(rect.getY()));
        dimensions.add(new Double(rect.getWidth()));
        dimensions.add(new Double(rect.getHeight()));
        dimensions.add(new Double(rect.getArcWidth()));
        dimensions.add(new Double(rect.getArcHeight()));
        out.writeState("roundedRectangle", "roundedRect", dimensions);
    }

    public void setState(String fieldType, String fieldName, Object fieldValue) {
        super.setState(fieldType, fieldName, fieldValue);
        if (fieldName.compareTo("roundedRect") == 0) {
            Vector dim = (Vector)fieldValue;
            double x = (Double)dim.get(0);
            double y = (Double)dim.get(1);
            double w = (Double)dim.get(2);
            double h = (Double)dim.get(3);
            double arcWidth = (Double)dim.get(4);
            double arcHeight = (Double)dim.get(5);
            this.setRoundRect(x, y, w, h, arcWidth, arcHeight);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        RoundRectangle2D rect = this.getRounedRect();
        out.writeDouble(rect.getX());
        out.writeDouble(rect.getY());
        out.writeDouble(rect.getWidth());
        out.writeDouble(rect.getHeight());
        out.writeDouble(rect.getArcWidth());
        out.writeDouble(rect.getArcHeight());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        double x = in.readDouble();
        double y = in.readDouble();
        double w = in.readDouble();
        double h = in.readDouble();
        double arcWidth = in.readDouble();
        double arcHeight = in.readDouble();
        this.getRounedRect().setRoundRect(x, y, w, h, arcWidth, arcHeight);
    }
}

