/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.event;

import edu.umd.cs.jazz.ZAnchorGroup;
import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.ZDrawingSurface;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZSelectionManager;
import edu.umd.cs.jazz.event.ZEventHandler;
import edu.umd.cs.jazz.event.ZMouseEvent;
import edu.umd.cs.jazz.event.ZMouseListener;
import edu.umd.cs.jazz.event.ZMouseMotionListener;
import edu.umd.cs.jazz.util.ZCanvas;
import edu.umd.cs.jazz.util.ZSceneGraphEditor;
import edu.umd.cs.jazz.util.ZSceneGraphPath;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;

public class ZLinkEventHandler
implements ZEventHandler,
ZMouseListener,
ZMouseMotionListener,
KeyListener,
Serializable {
    private boolean active = false;
    private ZNode node = null;
    private ZCanvas canvas = null;
    private ZNode currentNode = null;
    private ZAnchorGroup currentLink = null;
    private ZAnchorGroup hiliteLink = null;
    private Vector links = null;
    private int allButton1Mask = 51;

    public ZLinkEventHandler(ZNode node, ZCanvas canvas) {
        this.node = node;
        this.canvas = canvas;
    }

    public void setActive(boolean active) {
        if (this.active && !active) {
            this.active = false;
            this.node.removeMouseListener(this);
            this.node.removeMouseMotionListener(this);
            this.canvas.removeKeyListener(this);
            this.hideVisibleLinksAndHighlight();
            this.links = null;
        } else if (!this.active && active) {
            this.active = true;
            this.node.addMouseListener(this);
            this.node.addMouseMotionListener(this);
            this.canvas.addKeyListener(this);
            this.canvas.requestFocus();
            this.links = new Vector();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void keyPressed(KeyEvent e) {
        ZCamera camera = this.canvas.getCamera();
        if (e.getKeyChar() == ' ' && this.currentLink != null) {
            if (this.currentNode != null) {
                ZSelectionManager.unselect(this.currentNode);
            }
            this.currentLink.setDestBounds(camera.getViewBounds(), camera);
            this.currentNode = null;
            this.currentLink = null;
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void mouseMoved(ZMouseEvent e) {
        this.updateCurrentNode(e);
        if (this.isDefiningLink()) {
            this.updateCurrentLink(e);
        }
    }

    public void mousePressed(ZMouseEvent e) {
        if ((e.getModifiers() & this.allButton1Mask) == 16) {
            if (this.isDefiningLink()) {
                this.finishLink(e);
            } else {
                this.startLink(e);
            }
        }
    }

    public void mouseDragged(ZMouseEvent e) {
        this.updateCurrentNode(e);
        if (this.isDefiningLink()) {
            this.updateCurrentLink(e);
        }
    }

    public void mouseReleased(ZMouseEvent e) {
        if ((e.getModifiers() & this.allButton1Mask) == 16) {
            if (this.isDefiningLink() && this.currentNode == this.currentLink.editor().getNode()) {
                return;
            }
            this.finishLink(e);
        }
    }

    public void mouseEntered(ZMouseEvent e) {
    }

    public void mouseExited(ZMouseEvent e) {
    }

    public void mouseClicked(ZMouseEvent e) {
    }

    protected void finishLink(ZMouseEvent e) {
        ZSceneGraphPath aPath = e.getPath();
        ZCamera aCamera = aPath.getCamera();
        if (this.currentNode == null) {
            this.hideLink(this.currentLink);
        } else if (this.currentLink != null) {
            this.currentLink.setDestNode(this.currentNode, aCamera);
        }
        this.currentNode = null;
        this.currentLink = null;
    }

    protected ZNode getNodeUnderMouse(ZMouseEvent e) {
        ZSceneGraphPath aPath = e.getPath();
        ZCamera aCamera = aPath.getCamera();
        ZDrawingSurface aSurface = aCamera.getDrawingSurface();
        if ((aPath = aSurface.pick(e.getX(), e.getY())).getObject() != null) {
            return aPath.getNode();
        }
        return null;
    }

    protected void hilite(ZNode aNode, ZCamera aCamera) {
        if (aNode == null) {
            return;
        }
        ZSelectionManager.select(aNode);
        if (this.isDefiningLink()) {
            return;
        }
        ZSceneGraphEditor editor = aNode.editor();
        if (editor.hasAnchorGroup()) {
            ZAnchorGroup anchor = editor.getAnchorGroup();
            anchor.setVisible(true, aCamera);
            this.hiliteLink = anchor;
        }
    }

    public boolean isDefiningLink() {
        return this.currentLink != null;
    }

    protected void startLink(ZMouseEvent e) {
        ZSceneGraphPath aPath = e.getPath();
        ZCamera aCamera = aPath.getTopCamera();
        if (this.currentNode != null) {
            this.currentLink = this.currentNode.editor().getAnchorGroup();
            Point2D.Double pt = new Point2D.Double(e.getX(), e.getY());
            aPath.screenToGlobal(pt);
            this.currentLink.setSrcPt(pt);
            this.currentLink.setDestPt(pt);
            this.currentLink.setDestNode(null, aCamera);
            this.currentLink.setDestBounds(null, aCamera);
            this.currentLink.setVisible(true, aCamera);
            this.links.addElement(this.currentLink);
        }
    }

    protected void unhilite(ZNode aNode, ZCamera aCamera) {
        if (aNode == null) {
            return;
        }
        ZSelectionManager.unselect(aNode);
        if (this.isDefiningLink()) {
            return;
        }
        ZSceneGraphEditor editor = aNode.editor();
        if (editor.hasAnchorGroup()) {
            ZAnchorGroup anchor = editor.getAnchorGroup();
            if (anchor.hasDestination()) {
                if (this.links.contains(anchor)) {
                    return;
                }
                anchor.setVisible(false, aCamera);
            } else {
                anchor.setVisible(false, aCamera);
                anchor.extract();
                this.links.remove(anchor);
            }
        }
        this.hiliteLink = null;
    }

    protected void updateCurrentLink(ZMouseEvent e) {
        if (!this.isDefiningLink()) {
            return;
        }
        ZSceneGraphPath path = e.getPath();
        Point2D.Double pt = new Point2D.Double(e.getX(), e.getY());
        path.screenToGlobal(pt);
        this.currentLink.setDestPt(pt);
        this.currentLink.updateLinkComponent(path.getCamera());
    }

    protected void updateCurrentNode(ZMouseEvent e) {
        ZSceneGraphPath path = e.getPath();
        ZCamera camera = path.getTopCamera();
        ZNode nodeUnderMouse = this.getNodeUnderMouse(e);
        if (this.currentNode != nodeUnderMouse) {
            this.unhilite(this.currentNode, camera);
            this.currentNode = nodeUnderMouse;
            this.hilite(this.currentNode, camera);
        }
    }

    protected void hideLink(ZAnchorGroup aLink) {
        if (aLink == null) {
            return;
        }
        aLink.setVisible(false, null);
        if (this.links != null) {
            this.links.remove(this.currentLink);
        }
        if (!aLink.hasDestination()) {
            aLink.extract();
        }
    }

    public void hideVisibleLinksAndHighlight() {
        if (this.currentNode != null) {
            this.currentNode.editor().removeSelectionGroup();
        }
        if (this.links != null) {
            Iterator i = this.links.iterator();
            while (i.hasNext()) {
                ZAnchorGroup each = (ZAnchorGroup)i.next();
                each.setVisible(false, null);
            }
        }
        if (this.hiliteLink != null) {
            this.hideLink(this.hiliteLink);
        }
    }
}

