/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.event;

import edu.umd.cs.jazz.ZGroup;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZSceneGraphObject;
import edu.umd.cs.jazz.ZSelectionManager;
import edu.umd.cs.jazz.ZVisualComponent;
import edu.umd.cs.jazz.ZVisualLeaf;
import edu.umd.cs.jazz.component.ZRectangle;
import edu.umd.cs.jazz.event.ZDragSequenceEventHandler;
import edu.umd.cs.jazz.event.ZMouseEvent;
import edu.umd.cs.jazz.event.ZMouseFilter;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZCanvas;
import edu.umd.cs.jazz.util.ZMagBoundsFindFilter;
import edu.umd.cs.jazz.util.ZSceneGraphPath;
import java.awt.BasicStroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class ZSelectionModifyHandler
extends ZDragSequenceEventHandler {
    private ZGroup fMarqueeLayer;
    private ZVisualLeaf fMarqueeLeaf;
    private ZVisualComponent fMarquee;
    private Collection fLastMarqueeSelection;

    public ZSelectionModifyHandler(ZSceneGraphObject aFilteredMouseEventSource, ZGroup aMarqueeLayer) {
        super(aFilteredMouseEventSource, null);
        this.fMarqueeLayer = aMarqueeLayer;
    }

    public ZSelectionModifyHandler(ZSceneGraphObject aFilteredMouseEventSource, ZCanvas aIgnoredCanvas, ZGroup aMarqueeLayer) {
        super(aFilteredMouseEventSource, null);
        this.fMarqueeLayer = aMarqueeLayer;
    }

    public ZMouseFilter getMouseFilter() {
        if (this.fMouseFilter == null) {
            this.fMouseFilter = new ZMouseFilter(16);
        }
        return this.fMouseFilter;
    }

    protected void filteredMousePressed(ZMouseEvent e) {
        super.filteredMousePressed(e);
        this.makeSelection(this.getNodeToSelect(e), e);
    }

    protected void startDrag(ZMouseEvent e) {
        super.startDrag(e);
        if (this.shouldStartMarqueeSelection(e)) {
            this.startMarqueeSelection(e);
            this.getMouseFilter().acceptAllEventTypes();
        } else {
            this.getMouseFilter().rejectAllEventTypes();
            this.getMouseFilter().setAcceptsMousePressed(true);
        }
    }

    protected void dragInScreenCoords(ZMouseEvent e, Dimension2D aScreenDelta) {
        this.modifyMarqueeSelection(e, aScreenDelta);
    }

    protected void endDrag(ZMouseEvent e) {
        super.endDrag(e);
        this.endMarqueeSelection(e);
    }

    protected void makeSelection(ZNode aNode, ZMouseEvent e) {
        if (this.isOptionSelection(e)) {
            if (aNode == null) {
                return;
            }
            if (ZSelectionManager.isSelected(aNode)) {
                ZSelectionManager.unselect(aNode);
            } else {
                ZSelectionManager.select(aNode);
            }
        } else if (!ZSelectionManager.isSelected(aNode)) {
            this.unselectAll();
            ZSelectionManager.select(aNode);
        }
    }

    protected ZNode getNodeToSelect(ZMouseEvent e) {
        if (e.getPath().getObject() == null) {
            return null;
        }
        return e.getNode();
    }

    protected void unselectAll() {
        ZSelectionManager.unselectAll(this.getTopCamera());
    }

    protected void startMarqueeSelection(ZMouseEvent e) {
        ZRectangle aRectangle = (ZRectangle)this.getMarqueeVisualComponent();
        Point2D.Double aPoint = new Point2D.Double(e.getX(), e.getY());
        e.getPath().screenToGlobal(aPoint);
        this.getMarqueeLayer().globalToLocal(aPoint);
        aRectangle.setRect(((Point2D)aPoint).getX(), ((Point2D)aPoint).getY(), 0.0, 0.0);
    }

    protected void modifyMarqueeSelection(ZMouseEvent e, Dimension2D aScreenDelta) {
        ZNode each;
        ZBounds aBounds = this.getResizedMarqueeBounds(e, aScreenDelta);
        this.setMarqueeBounds(aBounds);
        Collection aNewNewMarqueeSelection = this.getNewMarqueeSelection(aBounds);
        ArrayList aNewNewMarqueeSelectionCopy = new ArrayList(aNewNewMarqueeSelection);
        aNewNewMarqueeSelectionCopy.removeAll(this.getLastMarqueeSelection());
        Iterator i = aNewNewMarqueeSelectionCopy.iterator();
        while (i.hasNext()) {
            each = (ZNode)i.next();
            if (this.isOptionSelection(e) && ZSelectionManager.isSelected(each)) {
                ZSelectionManager.unselect(each);
                continue;
            }
            ZSelectionManager.select(each);
        }
        this.getLastMarqueeSelection().removeAll(aNewNewMarqueeSelection);
        i = this.getLastMarqueeSelection().iterator();
        while (i.hasNext()) {
            each = (ZNode)i.next();
            if (this.isOptionSelection(e) && !ZSelectionManager.isSelected(each)) {
                ZSelectionManager.select(each);
                continue;
            }
            ZSelectionManager.unselect(each);
        }
        this.setLastMarqueeSelection(aNewNewMarqueeSelection);
    }

    protected void endMarqueeSelection(ZMouseEvent e) {
        this.setMarqueeLeaf(null);
        this.setLastMarqueeSelection(null);
    }

    protected boolean shouldStartMarqueeSelection(ZMouseEvent e) {
        return this.getNodeToSelect(e) == null;
    }

    protected ZBounds getResizedMarqueeBounds(ZMouseEvent e, Dimension2D aScreenDelta) {
        ZSceneGraphPath aPath = e.getPath();
        ZBounds aNewMarqueeBounds = new ZBounds();
        aNewMarqueeBounds.setFrameFromDiagonal(this.getDragStartScreenPoint(), this.getCurrentScreenPoint());
        aPath.screenToGlobal(aNewMarqueeBounds);
        this.getMarqueeLayer().globalToLocal(aNewMarqueeBounds);
        return aNewMarqueeBounds;
    }

    protected Collection getNewMarqueeSelection(ZBounds aBounds) {
        ZMagBoundsFindFilter aFilter = new ZMagBoundsFindFilter(aBounds, this.getInteractionCamera().getMagnification());
        return this.getTopCamera().findNodes(aFilter);
    }

    protected Collection getLastMarqueeSelection() {
        if (this.fLastMarqueeSelection == null) {
            this.setLastMarqueeSelection(new ArrayList());
        }
        return this.fLastMarqueeSelection;
    }

    protected void setLastMarqueeSelection(Collection aCollection) {
        this.fLastMarqueeSelection = aCollection;
    }

    public ZGroup getMarqueeLayer() {
        return this.fMarqueeLayer;
    }

    public void setMarqueeLayer(ZGroup aGroup) {
        this.fMarqueeLayer = aGroup;
    }

    public ZVisualLeaf getMarqueeLeaf() {
        if (this.fMarqueeLeaf == null) {
            ZVisualLeaf aLeaf = new ZVisualLeaf();
            aLeaf.setPickable(false);
            aLeaf.setFindable(false);
            this.setMarqueeLeaf(aLeaf);
        }
        return this.fMarqueeLeaf;
    }

    public void setMarqueeLeaf(ZVisualLeaf aMarquee) {
        if (this.fMarqueeLeaf != null) {
            this.getMarqueeLayer().removeChild(this.fMarqueeLeaf);
            this.fMarquee = null;
        }
        this.fMarqueeLeaf = aMarquee;
        if (this.fMarqueeLeaf != null) {
            this.getMarqueeLayer().addChild(this.fMarqueeLeaf);
        }
    }

    public ZVisualComponent getMarqueeVisualComponent() {
        if (this.fMarquee == null) {
            ZRectangle aRectangle = new ZRectangle();
            aRectangle.setFillPaint(null);
            aRectangle.setStroke(new BasicStroke(0.0f));
            this.setMarqueeVisualComponent(aRectangle);
        }
        return this.fMarquee;
    }

    public void setMarqueeVisualComponent(ZVisualComponent aMarquee) {
        if (this.fMarquee != null) {
            this.getMarqueeLeaf().removeVisualComponent(this.fMarquee);
        }
        this.fMarquee = aMarquee;
        if (this.fMarquee != null) {
            this.getMarqueeLeaf().setVisualComponent(this.fMarquee);
        }
    }

    public void setMarqueeBounds(ZBounds aBounds) {
        ZRectangle aMarqee = (ZRectangle)this.getMarqueeVisualComponent();
        aMarqee.setRect(aBounds);
    }

    protected boolean isOptionSelection(ZMouseEvent e) {
        return e.isShiftDown();
    }

    public void setActive(boolean active) {
        if (this.isActive() && !active) {
            this.unselectAll();
        }
        super.setActive(active);
    }
}

