/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.event;

import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZVisualComponent;
import edu.umd.cs.jazz.ZVisualGroup;
import edu.umd.cs.jazz.ZVisualLeaf;
import edu.umd.cs.jazz.component.ZSwing;
import edu.umd.cs.jazz.event.ZEventHandler;
import edu.umd.cs.jazz.event.ZMouseEvent;
import edu.umd.cs.jazz.event.ZMouseListener;
import edu.umd.cs.jazz.event.ZMouseMotionListener;
import edu.umd.cs.jazz.util.ZCanvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;

public class ZSwingEventHandler
implements ZEventHandler,
ZMouseListener,
ZMouseMotionListener {
    protected ZNode listenNode = null;
    protected boolean active = false;
    Component prevComponent = null;
    Component cursorComponent = null;
    Point2D prevPoint = null;
    Point2D prevOff = null;
    ZSwing focusZSwingLeft = null;
    ZNode focusNodeLeft = null;
    Component focusComponentLeft = null;
    int focusOffXLeft = 0;
    int focusOffYLeft = 0;
    ZSwing focusZSwingMiddle = null;
    ZNode focusNodeMiddle = null;
    Component focusComponentMiddle = null;
    int focusOffXMiddle = 0;
    int focusOffYMiddle = 0;
    ZSwing focusZSwingRight = null;
    ZNode focusNodeRight = null;
    Component focusComponentRight = null;
    int focusOffXRight = 0;
    int focusOffYRight = 0;
    ZCanvas canvas;

    public ZSwingEventHandler(ZCanvas canvas, ZNode node) {
        this.canvas = canvas;
        this.listenNode = node;
    }

    public ZSwingEventHandler(ZCanvas canvas) {
        this.canvas = canvas;
    }

    public void setActive(boolean active) {
        if (this.active && !active) {
            if (this.listenNode != null) {
                this.active = false;
                this.listenNode.removeMouseListener(this);
                this.listenNode.removeMouseMotionListener(this);
            }
        } else if (!this.active && active && this.listenNode != null) {
            this.active = true;
            this.listenNode.addMouseListener(this);
            this.listenNode.addMouseMotionListener(this);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void mousePressed(ZMouseEvent e1) {
        this.dispatchEvent(e1);
    }

    public void mouseReleased(ZMouseEvent e1) {
        this.dispatchEvent(e1);
    }

    public void mouseClicked(ZMouseEvent e1) {
        this.dispatchEvent(e1);
    }

    public void mouseExited(ZMouseEvent e1) {
        this.dispatchEvent(e1);
    }

    public void mouseEntered(ZMouseEvent e1) {
        this.dispatchEvent(e1);
    }

    public void mouseMoved(ZMouseEvent e1) {
        this.dispatchEvent(e1);
    }

    public void mouseDragged(ZMouseEvent e1) {
        this.dispatchEvent(e1);
    }

    Component findComponentAt(Component c, int x, int y) {
        if (!c.contains(x, y)) {
            return null;
        }
        if (c instanceof Container) {
            Container contain = (Container)c;
            int ncomponents = contain.getComponentCount();
            Component[] component = contain.getComponents();
            int i = 0;
            while (i < ncomponents) {
                Component comp = component[i];
                if (comp != null) {
                    Point p = comp.getLocation();
                    if ((comp = comp instanceof Container ? this.findComponentAt(comp, x - (int)p.getX(), y - (int)p.getY()) : comp.getComponentAt(x - (int)p.getX(), y - (int)p.getY())) != null && comp.isShowing()) {
                        return comp;
                    }
                }
                ++i;
            }
        }
        return c;
    }

    void dispatchEvent(ZMouseEvent e1) {
        ZMouseEvent e2;
        MouseEvent e_temp;
        ZNode grabNode = null;
        Component comp = null;
        Point2D pt = null;
        ZNode currentNode = e1.getPath().getNode();
        int offX = 0;
        int offY = 0;
        if (currentNode instanceof ZVisualLeaf || currentNode instanceof ZVisualGroup) {
            ZVisualComponent vc = null;
            ZNode visualNode = currentNode;
            if (visualNode instanceof ZVisualLeaf) {
                if (e1.getPath().getObject() instanceof ZVisualComponent && ((ZVisualLeaf)visualNode).indexOf((ZVisualComponent)e1.getPath().getObject()) != -1) {
                    vc = (ZVisualComponent)e1.getPath().getObject();
                }
            } else if (e1.getPath().getObject() == ((ZVisualGroup)visualNode).getFrontVisualComponent()) {
                vc = ((ZVisualGroup)visualNode).getFrontVisualComponent();
            } else if (e1.getPath().getObject() == ((ZVisualGroup)visualNode).getBackVisualComponent()) {
                vc = ((ZVisualGroup)visualNode).getBackVisualComponent();
            }
            if (vc instanceof ZSwing) {
                ZSwing swing = (ZSwing)vc;
                grabNode = visualNode;
                if (grabNode.isDescendentOf(this.canvas.getRoot())) {
                    pt = new Point2D.Double(e1.getX(), e1.getY());
                    e1.getPath().getTopCamera().cameraToLocal(pt, grabNode);
                    this.prevPoint = (Point2D)pt.clone();
                    comp = this.findComponentAt(swing.getComponent(), (int)pt.getX(), (int)pt.getY());
                    if (comp != null && comp != swing.getComponent()) {
                        Component c = comp;
                        while (c != swing.getComponent()) {
                            offX = (int)((double)offX + c.getLocation().getX());
                            offY = (int)((double)offY + c.getLocation().getY());
                            c = c.getParent();
                        }
                    }
                    if (comp != null && e1.getID() == 501) {
                        if (SwingUtilities.isLeftMouseButton(e1)) {
                            this.focusZSwingLeft = swing;
                            this.focusComponentLeft = comp;
                            this.focusNodeLeft = visualNode;
                            this.focusOffXLeft = offX;
                            this.focusOffYLeft = offY;
                        } else if (SwingUtilities.isMiddleMouseButton(e1)) {
                            this.focusZSwingMiddle = swing;
                            this.focusComponentMiddle = comp;
                            this.focusNodeMiddle = visualNode;
                            this.focusOffXMiddle = offX;
                            this.focusOffYMiddle = offY;
                        } else if (SwingUtilities.isRightMouseButton(e1)) {
                            this.focusZSwingRight = swing;
                            this.focusComponentRight = comp;
                            this.focusNodeRight = visualNode;
                            this.focusOffXRight = offX;
                            this.focusOffYRight = offY;
                        }
                    }
                }
            }
        }
        if (e1.getID() == 506 || e1.getID() == 502) {
            if (SwingUtilities.isLeftMouseButton(e1) && this.focusComponentLeft != null) {
                if (this.focusNodeLeft.isDescendentOf(this.canvas.getRoot())) {
                    pt = new Point2D.Double(e1.getX(), e1.getY());
                    e1.getPath().getTopCamera().cameraToLocal(pt, this.focusNodeLeft);
                    e_temp = new MouseEvent(this.focusComponentLeft, e1.getID(), e1.getWhen(), e1.getModifiers(), (int)pt.getX() - this.focusOffXLeft, (int)pt.getY() - this.focusOffYLeft, e1.getClickCount(), e1.isPopupTrigger());
                    e2 = ZMouseEvent.createMouseEvent(e_temp.getID(), e_temp, e1.getPath(), e1.getPath());
                    this.focusComponentLeft.dispatchEvent(e2);
                } else {
                    this.focusComponentLeft.dispatchEvent(e1);
                }
                this.focusZSwingLeft.repaint();
                e1.consume();
                if (e1.getID() == 502) {
                    this.focusComponentLeft = null;
                    this.focusNodeLeft = null;
                }
            }
            if (SwingUtilities.isMiddleMouseButton(e1) && this.focusComponentMiddle != null) {
                if (this.focusNodeMiddle.isDescendentOf(this.canvas.getRoot())) {
                    pt = new Point2D.Double(e1.getX(), e1.getY());
                    e1.getPath().getTopCamera().cameraToLocal(pt, this.focusNodeMiddle);
                    e_temp = new MouseEvent(this.focusComponentMiddle, e1.getID(), e1.getWhen(), e1.getModifiers(), (int)pt.getX() - this.focusOffXMiddle, (int)pt.getY() - this.focusOffYMiddle, e1.getClickCount(), e1.isPopupTrigger());
                    e2 = ZMouseEvent.createMouseEvent(e_temp.getID(), e_temp, e1.getPath(), e1.getPath());
                    this.focusComponentMiddle.dispatchEvent(e2);
                } else {
                    this.focusComponentMiddle.dispatchEvent(e1);
                }
                this.focusZSwingMiddle.repaint();
                e1.consume();
                if (e1.getID() == 502) {
                    this.focusComponentMiddle = null;
                    this.focusNodeMiddle = null;
                }
            }
            if (SwingUtilities.isRightMouseButton(e1) && this.focusComponentRight != null) {
                if (this.focusNodeRight.isDescendentOf(this.canvas.getRoot())) {
                    pt = new Point2D.Double(e1.getX(), e1.getY());
                    e1.getPath().getTopCamera().cameraToLocal(pt, this.focusNodeRight);
                    e_temp = new MouseEvent(this.focusComponentRight, e1.getID(), e1.getWhen(), e1.getModifiers(), (int)pt.getX() - this.focusOffXRight, (int)pt.getY() - this.focusOffYRight, e1.getClickCount(), e1.isPopupTrigger());
                    e2 = ZMouseEvent.createMouseEvent(e_temp.getID(), e_temp, e1.getPath(), e1.getPath());
                    this.focusComponentRight.dispatchEvent(e2);
                } else {
                    this.focusComponentRight.dispatchEvent(e1);
                }
                this.focusZSwingRight.repaint();
                e1.consume();
                if (e1.getID() == 502) {
                    this.focusComponentRight = null;
                    this.focusNodeRight = null;
                }
            }
        } else if ((e1.getID() == 501 || e1.getID() == 500 || e1.getID() == 503) && comp != null) {
            e_temp = new MouseEvent(comp, e1.getID(), e1.getWhen(), e1.getModifiers(), (int)pt.getX() - offX, (int)pt.getY() - offY, e1.getClickCount(), e1.isPopupTrigger());
            e2 = ZMouseEvent.createMouseEvent(e_temp.getID(), e_temp, e1.getPath(), e1.getPath());
            comp.dispatchEvent(e2);
            e1.consume();
        }
        if (this.prevComponent != null) {
            if (comp == null || e1.getID() == 505) {
                e_temp = new MouseEvent(this.prevComponent, 505, e1.getWhen(), 0, (int)this.prevPoint.getX() - (int)this.prevOff.getX(), (int)this.prevPoint.getY() - (int)this.prevOff.getY(), e1.getClickCount(), e1.isPopupTrigger());
                e2 = ZMouseEvent.createMouseEvent(e_temp.getID(), e_temp, e1.getPath(), e1.getPath());
                this.prevComponent.dispatchEvent(e2);
                this.prevComponent = null;
                if (e1.getID() == 505) {
                    e1.consume();
                }
            } else if (this.prevComponent != comp) {
                e_temp = new MouseEvent(this.prevComponent, 505, e1.getWhen(), 0, (int)this.prevPoint.getX() - (int)this.prevOff.getX(), (int)this.prevPoint.getY() - (int)this.prevOff.getY(), e1.getClickCount(), e1.isPopupTrigger());
                e2 = ZMouseEvent.createMouseEvent(e_temp.getID(), e_temp, e1.getPath(), e1.getPath());
                this.prevComponent.dispatchEvent(e2);
                e_temp = new MouseEvent(comp, 504, e1.getWhen(), 0, (int)this.prevPoint.getX() - offX, (int)this.prevPoint.getY() - offY, e1.getClickCount(), e1.isPopupTrigger());
                e2 = ZMouseEvent.createMouseEvent(e_temp.getID(), e_temp, e1.getPath(), e1.getPath());
                comp.dispatchEvent(e2);
            }
        } else if (comp != null) {
            e_temp = new MouseEvent(comp, 504, e1.getWhen(), 0, (int)this.prevPoint.getX() - offX, (int)this.prevPoint.getY() - offY, e1.getClickCount(), e1.isPopupTrigger());
            e2 = ZMouseEvent.createMouseEvent(e_temp.getID(), e_temp, e1.getPath(), e1.getPath());
            comp.dispatchEvent(e2);
        }
        if (comp != this.cursorComponent && this.focusNodeLeft == null && this.focusNodeMiddle == null && this.focusNodeRight == null) {
            if (comp != null) {
                this.cursorComponent = comp;
                this.canvas.setCursor(comp.getCursor(), false);
            } else {
                this.cursorComponent = null;
                this.canvas.resetCursor();
            }
        }
        this.prevComponent = comp;
        if (comp != null) {
            this.prevOff = new Point2D.Double(offX, offY);
        }
    }
}

