/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.io;

import edu.umd.cs.jazz.io.ParseException;
import edu.umd.cs.jazz.io.ZExtendedInputStream;
import edu.umd.cs.jazz.io.ZInternalParser;
import edu.umd.cs.jazz.io.ZStreamPreprocessor;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;

public class ZParser
implements Serializable {
    protected static ZInternalParser internalParser = null;
    private static final String[][] stringTranslations = new String[][]{{"\\\\", "\\"}, {"\\n", "\n"}, {"\\\"", "\""}, {"\\r", "\n"}, {"\\t", "\t"}};

    public static String translateJavaToJazz(String s) {
        int i = 0;
        while (i < stringTranslations.length) {
            String key = stringTranslations[i][1];
            String val = stringTranslations[i][0];
            int prevHit = 0;
            int hit = 0;
            while ((hit = s.indexOf(key, prevHit)) != -1) {
                s = s.substring(0, hit) + val + s.substring(hit + key.length());
                prevHit = hit + val.length();
            }
            ++i;
        }
        return s;
    }

    public static String translateJazzToJava(String s) {
        int i = 0;
        while (i < s.length() - 1) {
            if (s.charAt(i) == '\\') {
                int j = 0;
                while (j < stringTranslations.length) {
                    String key = stringTranslations[j][0];
                    String val = stringTranslations[j][1];
                    if (s.charAt(i + 1) == key.charAt(1)) {
                        s = s.substring(0, i) + val + s.substring(i + key.length());
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return s;
    }

    public synchronized Object parse(InputStream stream) throws ParseException {
        ZExtendedInputStream dataStream = new ZExtendedInputStream(stream);
        ZStreamPreprocessor pp = new ZStreamPreprocessor(dataStream);
        InputStream parseStream = pp.preprocessStream();
        if (internalParser == null) {
            internalParser = new ZInternalParser(parseStream);
        } else {
            ZInternalParser.ReInit(parseStream);
        }
        internalParser.createObjectTable();
        internalParser.setDataStream(dataStream);
        return ZInternalParser.Scene(internalParser);
    }

    public static void main(String[] args) {
        try {
            FileInputStream data = new FileInputStream("test6.jazz");
            ZParser parser = new ZParser();
            Object result = parser.parse(data);
            System.out.println("Jazz File ZParser:  Jazz file parsed successfully.");
            System.out.println(result);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println("Jazz File ZParser:  Encountered errors during parse.");
        }
    }
}

