/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.util;

import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZTransformGroup;
import edu.umd.cs.jazz.util.ZBounds;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;

public class ZLayout
implements Serializable {
    public static void distribute(ZNode[] nodes, ArrayList coordinates) {
        ZLayout.distribute(nodes, coordinates, -1.0, false);
    }

    public static void distribute(ZNode[] nodes, ArrayList coordinates, boolean exact, boolean closedPath) {
        if (nodes.length == 0 || coordinates.isEmpty()) {
            return;
        }
        double pathLength = ZLayout.pathLength(coordinates);
        double totalDim = 0.0;
        int numNodes = 0;
        int i = 0;
        while (i < nodes.length) {
            ZNode node = nodes[i].editor().getTop();
            ZBounds bounds = node.getBounds();
            totalDim += (((RectangularShape)bounds).getWidth() + ((RectangularShape)bounds).getHeight()) / 2.0;
            ++numNodes;
            ++i;
        }
        if (pathLength == 0.0) {
            ZLayout.distribute(nodes, coordinates, 0.0, -1.0, false, closedPath);
        } else {
            double space = closedPath ? (pathLength - totalDim) / (double)numNodes : (pathLength - totalDim) / (double)(numNodes - 1);
            ZLayout.distribute(nodes, coordinates, space, -1.0, exact, closedPath);
        }
    }

    public static void distribute(ZNode[] nodes, ArrayList coordinates, double tolerance, boolean closedPath) {
        if (nodes.length == 0 || coordinates.isEmpty()) {
            return;
        }
        double pathLength = ZLayout.pathLength(coordinates);
        double totalDim = 0.0;
        int numNodes = 0;
        int i = 0;
        while (i < nodes.length) {
            ZNode node = nodes[i].editor().getTop();
            ZBounds bounds = node.getBounds();
            totalDim += (((RectangularShape)bounds).getWidth() + ((RectangularShape)bounds).getHeight()) / 2.0;
            ++numNodes;
            ++i;
        }
        if (pathLength == 0.0) {
            ZLayout.distribute(nodes, coordinates, 0.0, -1.0, false, closedPath);
        } else {
            double space = closedPath ? (pathLength - totalDim) / (double)numNodes : (pathLength - totalDim) / (double)(numNodes - 1);
            ZLayout.distribute(nodes, coordinates, space, tolerance, true, closedPath);
        }
    }

    public static void distribute(ZNode[] nodes, ArrayList coordinates, double space, double tolerance, boolean exact, boolean closedPath) {
        double curY;
        double curX;
        double DEFAULT_TOLERANCE = 0.1f;
        boolean done = false;
        double currentError = -1.0;
        Point2D.Double halfDim = new Point2D.Double();
        if (nodes.length == 0 || coordinates.isEmpty()) {
            return;
        }
        if (!(tolerance > 0.0) || !(tolerance <= 100.0)) {
            tolerance = 0.1f;
        }
        tolerance /= 100.0;
        double pathLength = ZLayout.pathLength(coordinates);
        int numCoords = coordinates.size();
        int numNodes = nodes.length;
        double closingLength = 0.0;
        if (closedPath) {
            Point2D.Double dir = new Point2D.Double(1.0, 1.0);
            Point2D entranceP = (Point2D)((Point2D)coordinates.get(coordinates.size() - 1)).clone();
            ZNode firstNode = nodes[0].editor().getTop();
            ZBounds bounds = firstNode.getBounds();
            double halfWidth = ((RectangularShape)bounds).getWidth() / 2.0;
            double halfHeight = ((RectangularShape)bounds).getHeight() / 2.0;
            curX = entranceP.getX();
            curY = entranceP.getY();
            ZLayout.normalizeList(dir);
            Point2D.Double curP = new Point2D.Double(curX, curY);
            ((Point2D)halfDim).setLocation(halfWidth, halfHeight);
            closingLength = ZLayout.computeDimensionTranslation(halfDim, curP, new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0), dir, coordinates, false);
        }
        while (!done) {
            double pathLengthInNodes = 0.0;
            Point2D.Double dir = new Point2D.Double(1.0, 1.0);
            int index = 0;
            ArrayList coords = (ArrayList)coordinates.clone();
            Point2D entranceP = (Point2D)((Point2D)coords.get(0)).clone();
            double remainderX = 0.0;
            double remainderY = 0.0;
            curX = 0.0;
            curY = 0.0;
            boolean determined = false;
            double centerX = 0.0;
            double centerY = 0.0;
            coords.remove(0);
            ZLayout.normalizeList(dir);
            if (closedPath) {
                determined = true;
                centerX = entranceP.getX();
                centerY = entranceP.getY();
            }
            index = 0;
            while (index < nodes.length) {
                Point2D.Double remainderP;
                Point2D.Double curP;
                ZNode node = nodes[index].editor().getTop();
                ZBounds bounds = node.getBounds();
                double halfWidth = bounds.getWidth() / 2.0;
                double halfHeight = bounds.getHeight() / 2.0;
                double entranceX = entranceP.getX();
                double entranceY = entranceP.getY();
                curX = entranceX;
                curY = entranceY;
                if (!determined) {
                    Point2D.Double centerP = new Point2D.Double(centerX, centerY);
                    ((Point2D)halfDim).setLocation(halfWidth, halfHeight);
                    curP = new Point2D.Double(curX, curY);
                    remainderP = new Point2D.Double(remainderX, remainderY);
                    pathLengthInNodes += ZLayout.computeDimensionTranslation(halfDim, curP, remainderP, centerP, dir, coords, true);
                    curX = ((Point2D)curP).getX();
                    curY = ((Point2D)curP).getY();
                    remainderX = ((Point2D)remainderP).getX();
                    remainderY = ((Point2D)remainderP).getY();
                    centerX = ((Point2D)centerP).getX();
                    centerY = ((Point2D)centerP).getY();
                }
                determined = false;
                curX = centerX;
                curY = centerY;
                ZTransformGroup transform = node.editor().getTransformGroup();
                Point2D.Double newLocalCenter = new Point2D.Double(centerX, centerY);
                Point2D curLocalCenter = bounds.getCenter2D();
                AffineTransform tmpTransform = transform.getInverseTransform();
                tmpTransform.setTransform(tmpTransform.getScaleX(), tmpTransform.getShearX(), tmpTransform.getShearY(), tmpTransform.getScaleY(), 0.0, 0.0);
                tmpTransform.transform(newLocalCenter, newLocalCenter);
                tmpTransform.transform(curLocalCenter, curLocalCenter);
                Point2D.Double translation = new Point2D.Double(((Point2D)newLocalCenter).getX() - curLocalCenter.getX(), ((Point2D)newLocalCenter).getY() - curLocalCenter.getY());
                transform.translate(((Point2D)translation).getX(), ((Point2D)translation).getY());
                double boundaryX = 0.0;
                double boundaryY = 0.0;
                Point2D.Double boundaryP = new Point2D.Double(boundaryX, boundaryY);
                ((Point2D)halfDim).setLocation(halfWidth, halfHeight);
                curP = new Point2D.Double(curX, curY);
                remainderP = new Point2D.Double(remainderX, remainderY);
                pathLengthInNodes += ZLayout.computeDimensionTranslation(halfDim, curP, remainderP, boundaryP, dir, coords, true);
                curX = ((Point2D)curP).getX();
                curY = ((Point2D)curP).getY();
                remainderX = ((Point2D)remainderP).getX();
                remainderY = ((Point2D)remainderP).getY();
                boundaryX = ((Point2D)boundaryP).getX();
                boundaryY = ((Point2D)boundaryP).getY();
                curX = boundaryX;
                curY = boundaryY;
                boolean spaced = false;
                double spaceSoFar = 0.0;
                curP = new Point2D.Double(curX, curY);
                remainderP = new Point2D.Double(remainderX + curX, remainderY + curY);
                if (remainderX != 0.0 || remainderY != 0.0) {
                    if (remainderP.distance(curP) > space) {
                        entranceP.setLocation(curX + space * ((Point2D)dir).getX(), curY + space * ((Point2D)dir).getY());
                        spaced = true;
                        remainderX -= entranceP.getX() - curX;
                        remainderY -= entranceP.getY() - curY;
                    } else {
                        spaceSoFar = remainderP.distance(curP);
                        curP.setLocation(remainderP);
                        remainderX = 0.0;
                        remainderY = 0.0;
                    }
                }
                while (!spaced) {
                    if (!coords.isEmpty()) {
                        Point2D newP = (Point2D)((Point2D)coords.get(0)).clone();
                        double newX = newP.getX();
                        double newY = newP.getY();
                        coords.remove(0);
                        ((Point2D)dir).setLocation(newX - ((Point2D)curP).getX(), newY - ((Point2D)curP).getY());
                        ZLayout.normalizeList(dir);
                        if (newP.distance(curP) + spaceSoFar > space) {
                            entranceP.setLocation(((Point2D)curP).getX() + (space - spaceSoFar) * ((Point2D)dir).getX(), ((Point2D)curP).getY() + (space - spaceSoFar) * ((Point2D)dir).getY());
                            spaced = true;
                            remainderX = newP.getX() - entranceP.getX();
                            remainderY = newP.getY() - entranceP.getY();
                            continue;
                        }
                        spaceSoFar = newP.distance(curP) + spaceSoFar;
                        ((Point2D)curP).setLocation(newX, newY);
                        continue;
                    }
                    entranceP.setLocation(((Point2D)curP).getX() + (space - spaceSoFar) * ((Point2D)dir).getX(), ((Point2D)curP).getY() + (space - spaceSoFar) * ((Point2D)dir).getY());
                    spaced = true;
                }
                ++index;
            }
            if (exact) {
                double length = closedPath ? pathLengthInNodes + (double)numNodes * space : (numNodes != 1 ? (pathLengthInNodes += closingLength) + (double)(numNodes - 1) * space : pathLength);
                if (Math.abs((length - pathLength) / pathLength) < tolerance) {
                    done = true;
                } else {
                    space = closedPath ? (pathLength - pathLengthInNodes) / (double)numNodes : (numNodes != 1 ? (pathLength - pathLengthInNodes) / (double)(numNodes - 1) : pathLength - pathLengthInNodes);
                    if (space < 0.0) {
                        done = true;
                    }
                    if (pathLength == 0.0) {
                        done = true;
                    }
                }
                if (currentError != -1.0 && currentError <= Math.abs(length - pathLength)) {
                    done = true;
                }
                currentError = Math.abs(length - pathLength);
                continue;
            }
            done = true;
        }
    }

    protected static double computeDimensionTranslation(Point2D dim, Point2D currentP, Point2D remainderP, Point2D finishedP, Point2D dir, ArrayList coordinates, boolean ascending) {
        boolean finished = false;
        double width = dim.getX();
        double height = dim.getY();
        double currentX = currentP.getX();
        double currentY = currentP.getY();
        double remainderX = remainderP.getX();
        double remainderY = remainderP.getY();
        double finishedX = finishedP.getX();
        double finishedY = finishedP.getY();
        double pathSoFarX = 0.0;
        double pathSoFarY = 0.0;
        double pathLengthInNodes = 0.0;
        int ArrayListPosition = ascending ? coordinates.size() : coordinates.size() - 2;
        if (remainderX != 0.0 || remainderY != 0.0) {
            if (Math.abs(remainderX) > width || Math.abs(remainderY) > height) {
                if (Double.isNaN(width / Math.abs(dir.getX())) || Double.isNaN(height / Math.abs(dir.getY()))) {
                    if (Double.isNaN(width / Math.abs(dir.getX()))) {
                        finishedX = currentX + height * (dir.getX() / dir.getY()) * (dir.getY() / Math.abs(dir.getY()));
                        finishedY = currentY + height * (dir.getY() / Math.abs(dir.getY()));
                    } else {
                        finishedX = currentX + width * (dir.getX() / Math.abs(dir.getX()));
                        finishedY = currentY + width * (dir.getY() / dir.getX()) * (dir.getX() / Math.abs(dir.getX()));
                    }
                } else if (width / Math.abs(dir.getX()) < height / Math.abs(dir.getY())) {
                    finishedX = currentX + width * (dir.getX() / Math.abs(dir.getX()));
                    finishedY = currentY + width * (dir.getY() / dir.getX()) * (dir.getX() / Math.abs(dir.getX()));
                } else {
                    finishedX = currentX + height * (dir.getX() / dir.getY()) * (dir.getY() / Math.abs(dir.getY()));
                    finishedY = currentY + height * (dir.getY() / Math.abs(dir.getY()));
                }
                finished = true;
                remainderX -= finishedX - currentX;
                remainderY -= finishedY - currentY;
                pathLengthInNodes += Point2D.distance(0.0, 0.0, finishedX - currentX, finishedY - currentY);
            } else {
                pathSoFarX = remainderX;
                pathSoFarY = remainderY;
                currentX += remainderX;
                currentY += remainderY;
                pathLengthInNodes += Point2D.distance(0.0, 0.0, remainderX, remainderY);
                remainderX = 0.0;
                remainderY = 0.0;
            }
        }
        while (!finished) {
            if (!coordinates.isEmpty() && ArrayListPosition >= 0) {
                Point2D newP = null;
                if (ascending) {
                    newP = (Point2D)((Point2D)coordinates.get(0)).clone();
                    coordinates.remove(0);
                } else {
                    newP = (Point2D)((Point2D)coordinates.get(ArrayListPosition)).clone();
                    --ArrayListPosition;
                }
                double newX = newP.getX();
                double newY = newP.getY();
                dir.setLocation(newX - currentX, newY - currentY);
                ZLayout.normalizeList(dir);
                double curDistX = newX - currentX;
                double curDistY = newY - currentY;
                if (Math.abs(curDistX + pathSoFarX) > width || Math.abs(curDistY + pathSoFarY) > height) {
                    if (Double.isNaN(width / Math.abs(dir.getX()) - pathSoFarX / dir.getX()) || Double.isNaN(height / Math.abs(dir.getY()) - pathSoFarY / dir.getY())) {
                        if (Double.isNaN(width / Math.abs(dir.getX()) - pathSoFarX / dir.getX())) {
                            if (Math.abs(pathSoFarY / dir.getY()) == pathSoFarY / dir.getY()) {
                                finishedX = currentX + (height - Math.abs(pathSoFarY)) * (dir.getX() / dir.getY()) * (dir.getY() / Math.abs(dir.getY()));
                                finishedY = currentY + (height - Math.abs(pathSoFarY)) * (dir.getY() / Math.abs(dir.getY()));
                            } else {
                                finishedX = currentX + (height + Math.abs(pathSoFarY)) * (dir.getX() / dir.getY()) * (dir.getY() / Math.abs(dir.getY()));
                                finishedY = currentY + (height + Math.abs(pathSoFarY)) * (dir.getY() / Math.abs(dir.getY()));
                            }
                        } else if (Math.abs(pathSoFarX / dir.getX()) == pathSoFarX / dir.getX()) {
                            finishedX = currentX + (width - Math.abs(pathSoFarX)) * (dir.getX() / Math.abs(dir.getX()));
                            finishedY = currentY + (width - Math.abs(pathSoFarX)) * (dir.getY() / dir.getX()) * (dir.getX() / Math.abs(dir.getX()));
                        } else {
                            finishedX = currentX + (width + Math.abs(pathSoFarX)) * (dir.getX() / Math.abs(dir.getX()));
                            finishedY = currentY + (width + Math.abs(pathSoFarX)) * (dir.getY() / dir.getX()) * (dir.getX() / Math.abs(dir.getX()));
                        }
                    } else if (width / Math.abs(dir.getX()) - pathSoFarX / dir.getX() < height / Math.abs(dir.getY()) - pathSoFarY / dir.getY()) {
                        if (Math.abs(pathSoFarX / dir.getX()) == pathSoFarX / dir.getX()) {
                            finishedX = currentX + (width - Math.abs(pathSoFarX)) * (dir.getX() / Math.abs(dir.getX()));
                            finishedY = currentY + (width - Math.abs(pathSoFarX)) * (dir.getY() / dir.getX()) * (dir.getX() / Math.abs(dir.getX()));
                        } else {
                            finishedX = currentX + (width + Math.abs(pathSoFarX)) * (dir.getX() / Math.abs(dir.getX()));
                            finishedY = currentY + (width + Math.abs(pathSoFarX)) * (dir.getY() / dir.getX()) * (dir.getX() / Math.abs(dir.getX()));
                        }
                    } else if (Math.abs(pathSoFarY / dir.getY()) == pathSoFarY / dir.getY()) {
                        finishedX = currentX + (height - Math.abs(pathSoFarY)) * (dir.getX() / dir.getY()) * (dir.getY() / Math.abs(dir.getY()));
                        finishedY = currentY + (height - Math.abs(pathSoFarY)) * (dir.getY() / Math.abs(dir.getY()));
                    } else {
                        finishedX = currentX + (height + Math.abs(pathSoFarY)) * (dir.getX() / dir.getY()) * (dir.getY() / Math.abs(dir.getY()));
                        finishedY = currentY + (height + Math.abs(pathSoFarY)) * (dir.getY() / Math.abs(dir.getY()));
                    }
                    finished = true;
                    remainderX = newX - finishedX;
                    remainderY = newY - finishedY;
                    pathLengthInNodes += Point2D.distance(0.0, 0.0, finishedX - currentX, finishedY - currentY);
                    continue;
                }
                pathSoFarX += curDistX;
                pathSoFarY += curDistY;
                currentX += curDistX;
                currentY += curDistY;
                pathLengthInNodes += Point2D.distance(0.0, 0.0, curDistX, curDistY);
                continue;
            }
            if (Double.isNaN(width / Math.abs(dir.getX()) - pathSoFarX / dir.getX()) || Double.isNaN(height / Math.abs(dir.getY()) - pathSoFarY / dir.getY())) {
                if (Double.isNaN(width / Math.abs(dir.getX()) - pathSoFarX / dir.getX())) {
                    if (Math.abs(pathSoFarY / dir.getY()) == pathSoFarY / dir.getY()) {
                        finishedX = currentX + (height - Math.abs(pathSoFarY)) * (dir.getX() / dir.getY()) * (dir.getY() / Math.abs(dir.getY()));
                        finishedY = currentY + (height - Math.abs(pathSoFarY)) * (dir.getY() / Math.abs(dir.getY()));
                    } else {
                        finishedX = currentX + (height + Math.abs(pathSoFarY)) * (dir.getX() / dir.getY()) * (dir.getY() / Math.abs(dir.getY()));
                        finishedY = currentY + (height + Math.abs(pathSoFarY)) * (dir.getY() / Math.abs(dir.getY()));
                    }
                } else if (Math.abs(pathSoFarX / dir.getX()) == pathSoFarX / dir.getX()) {
                    finishedX = currentX + (width - Math.abs(pathSoFarX)) * (dir.getX() / Math.abs(dir.getX()));
                    finishedY = currentY + (width - Math.abs(pathSoFarX)) * (dir.getY() / dir.getX()) * (dir.getX() / Math.abs(dir.getX()));
                } else {
                    finishedX = currentX + (width + Math.abs(pathSoFarX)) * (dir.getX() / Math.abs(dir.getX()));
                    finishedY = currentY + (width + Math.abs(pathSoFarX)) * (dir.getY() / dir.getX()) * (dir.getX() / Math.abs(dir.getX()));
                }
            } else if (width / Math.abs(dir.getX()) - pathSoFarX / dir.getX() < height / Math.abs(dir.getY()) - pathSoFarY / dir.getY()) {
                if (Math.abs(pathSoFarX / dir.getX()) == pathSoFarX / dir.getX()) {
                    finishedX = currentX + (width - Math.abs(pathSoFarX)) * (dir.getX() / Math.abs(dir.getX()));
                    finishedY = currentY + (width - Math.abs(pathSoFarX)) * (dir.getY() / dir.getX()) * (dir.getX() / Math.abs(dir.getX()));
                } else {
                    finishedX = currentX + (width + Math.abs(pathSoFarX)) * (dir.getX() / Math.abs(dir.getX()));
                    finishedY = currentY + (width + Math.abs(pathSoFarX)) * (dir.getY() / dir.getX()) * (dir.getX() / Math.abs(dir.getX()));
                }
            } else if (Math.abs(pathSoFarY / dir.getY()) == pathSoFarY / dir.getY()) {
                finishedX = currentX + (height - Math.abs(pathSoFarY)) * (dir.getX() / dir.getY()) * (dir.getY() / Math.abs(dir.getY()));
                finishedY = currentY + (height - Math.abs(pathSoFarY)) * (dir.getY() / Math.abs(dir.getY()));
            } else {
                finishedX = currentX + (height + Math.abs(pathSoFarY)) * (dir.getX() / dir.getY()) * (dir.getY() / Math.abs(dir.getY()));
                finishedY = currentY + (height + Math.abs(pathSoFarY)) * (dir.getY() / Math.abs(dir.getY()));
            }
            finished = true;
            pathLengthInNodes += Point2D.distance(0.0, 0.0, finishedX - currentX, finishedY - currentY);
        }
        currentP.setLocation(currentX, currentY);
        remainderP.setLocation(remainderX, remainderY);
        finishedP.setLocation(finishedX, finishedY);
        return pathLengthInNodes;
    }

    protected static double pathLength(ArrayList coords) {
        double len = 0.0;
        if (coords.size() > 1) {
            int i = 0;
            while (i < coords.size() - 1) {
                len += ((Point2D)coords.get(i)).distance((Point2D)coords.get(i + 1));
                ++i;
            }
        }
        return len;
    }

    protected static void normalizeList(Point2D p) {
        double len = p.distance(0.0, 0.0);
        if (len != 0.0) {
            p.setLocation(p.getX() / len, p.getY() / len);
        } else {
            p.setLocation(1.0 / Point2D.distance(0.0, 0.0, 1.0, 1.0), 1.0 / Point2D.distance(0.0, 0.0, 1.0, 1.0));
        }
    }
}

