/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.util;

import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.ZLayerGroup;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZSceneGraphObject;
import edu.umd.cs.jazz.ZTransformable;
import edu.umd.cs.jazz.ZVisualComponent;
import edu.umd.cs.jazz.io.ZObjectOutputStream;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZList;
import edu.umd.cs.jazz.util.ZNullList;
import edu.umd.cs.jazz.util.ZProperty;
import edu.umd.cs.jazz.util.ZRenderContext;
import edu.umd.cs.jazz.util.ZSceneGraphPath;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;

public abstract class ZListImpl
extends AbstractList
implements ZList,
Serializable {
    public static ZNullList NullList = new ZNullList();
    protected int size;

    public ZListImpl() {
        this(10);
    }

    public ZListImpl(int capacity) {
        this.setElementData(this.createElementData(capacity));
    }

    public void add(int index, Object element) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.getElementData(), index, this.getElementData(), index + 1, this.size - index);
        this.getElementData()[index] = element;
        ++this.size;
    }

    public boolean add(Object o) {
        this.ensureCapacity(this.size + 1);
        this.getElementData()[this.size++] = o;
        return true;
    }

    public boolean addAll(int index, Collection c) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        int numNew = c.size();
        this.ensureCapacity(this.size + numNew);
        int numMoved = this.size - index;
        if (numMoved > 0) {
            System.arraycopy(this.getElementData(), index, this.getElementData(), index + numNew, numMoved);
        }
        Iterator e = c.iterator();
        Object[] elementData = this.getElementData();
        int i = 0;
        while (i < numNew) {
            elementData[index++] = e.next();
            ++i;
        }
        this.size += numNew;
        return numNew != 0;
    }

    public boolean addAll(Collection c) {
        return this.addAll(this.size, c);
    }

    public void clear() {
        ++this.modCount;
        Object[] elementData = this.getElementData();
        int i = 0;
        while (i < this.size) {
            elementData[i] = null;
            ++i;
        }
        this.size = 0;
    }

    /*
     * WARNING - void declaration
     */
    public Object clone() {
        try {
            void e;
            ZListImpl v = (ZListImpl)super.clone();
            v.setElementData(this.createElementData(this.size));
            System.arraycopy(this.getElementData(), 0, v.getElementData(), 0, this.size);
            v.modCount = 0;
            return e;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean contains(Object elem) {
        return this.indexOf(elem) >= 0;
    }

    public abstract Object[] createElementData(int var1);

    public void ensureCapacity(int minCapacity) {
        ++this.modCount;
        int oldCapacity = this.getElementData().length;
        if (minCapacity > oldCapacity) {
            Object[] oldData = this.getElementData();
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.setElementData(this.createElementData(newCapacity));
            System.arraycopy(oldData, 0, this.getElementData(), 0, this.size);
        }
    }

    public Object get(int index) {
        return this.getElementData()[index];
    }

    public abstract Object[] getElementData();

    public int indexOf(Object elem) {
        Object[] elementData = this.getElementData();
        if (elem == null) {
            int i = 0;
            while (i < this.size) {
                if (elementData[i] == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                if (elem.equals(elementData[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isNull() {
        return false;
    }

    public int lastIndexOf(Object elem) {
        Object[] elementData = this.getElementData();
        if (elem == null) {
            int i = this.size - 1;
            while (i >= 0) {
                if (elementData[i] == null) {
                    return i;
                }
                --i;
            }
        } else {
            int i = this.size - 1;
            while (i >= 0) {
                if (elem.equals(elementData[i])) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public void moveElementToIndex(Object elem, int newIndex) {
        int oldIndex = this.indexOf(elem);
        this.remove(oldIndex);
        this.add(newIndex, elem);
    }

    public void pop() {
        this.getElementData()[this.size - 1] = null;
        --this.size;
    }

    public void pop(Object element) {
        Object[] elementData = this.getElementData();
        int i = this.size - 1;
        while (i >= 0) {
            if (elementData[i] == element) {
                this.size = i;
                return;
            }
            --i;
        }
        throw new IllegalArgumentException(element + " is not in list.");
    }

    private void rangeCheck(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int arrayLength = s.readInt();
        this.setElementData(this.createElementData(arrayLength));
        Object[] elementData = this.getElementData();
        int i = 0;
        while (i < this.size) {
            elementData[i] = s.readObject();
            ++i;
        }
    }

    public Object remove(int index) {
        this.rangeCheck(index);
        ++this.modCount;
        Object oldValue = this.getElementData()[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.getElementData(), index + 1, this.getElementData(), index, numMoved);
        }
        this.getElementData()[--this.size] = null;
        return oldValue;
    }

    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        int numMoved = this.size - toIndex;
        System.arraycopy(this.getElementData(), toIndex, this.getElementData(), fromIndex, numMoved);
        int newSize = this.size - (toIndex - fromIndex);
        Object[] elementData = this.getElementData();
        while (this.size != newSize) {
            elementData[--this.size] = null;
        }
    }

    public boolean replaceWith(Object oldElement, Object newElement) {
        Object[] elementData = this.getElementData();
        int i = 0;
        while (i < this.size) {
            if (elementData[i] == oldElement) {
                elementData[i] = newElement;
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object set(int index, Object element) {
        this.rangeCheck(index);
        Object oldValue = this.getElementData()[index];
        this.getElementData()[index] = element;
        return oldValue;
    }

    public abstract void setElementData(Object[] var1);

    public void setSize(int aSize) {
        this.size = aSize;
    }

    public int size() {
        return this.size;
    }

    public Object[] toArray() {
        Object[] result = this.createElementData(this.size);
        System.arraycopy(this.getElementData(), 0, result, 0, this.size);
        return result;
    }

    public Object[] toArray(Object[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.getElementData(), 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    public void trimToSize() {
        ++this.modCount;
        int oldCapacity = this.getElementData().length;
        if (this.size < oldCapacity) {
            Object[] oldData = this.getElementData();
            this.setElementData(this.createElementData(this.size));
            System.arraycopy(oldData, 0, this.getElementData(), 0, this.size);
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Object[] elementData = this.getElementData();
        if (elementData == null) {
            s.writeInt(0);
        } else {
            s.writeInt(this.size);
        }
        int i = 0;
        while (i < this.size) {
            s.writeObject(elementData[i]);
            ++i;
        }
    }

    public void writeObject(String name, ZObjectOutputStream out) throws IOException {
        this.trimToSize();
        out.writeState("List", name, this);
    }

    public void writeObjectd(String name, ZObjectOutputStream out) throws IOException {
        this.trimToSize();
        out.writeState("List", name, this);
    }

    public static class ZTransformableListImpl
    extends ZListImpl
    implements ZList.ZTransformableList {
        private transient ZTransformable[] transformables;

        public ZTransformableListImpl(int capacity) {
            super(capacity);
        }

        public Object[] getElementData() {
            return this.transformables;
        }

        public Object[] createElementData(int capacity) {
            return new ZTransformable[capacity];
        }

        public void setElementData(Object[] data) {
            this.transformables = (ZTransformable[])data;
        }

        public ZTransformable[] getTransformablesReference() {
            return this.transformables;
        }

        public AffineTransform collectiveCatTransformUntil(ZCamera camera) {
            AffineTransform tmpTransform = new AffineTransform();
            AffineTransform catTransform = new AffineTransform();
            int i = 0;
            while (i < this.size) {
                if (this.transformables[i] == camera) break;
                double[] matrix = new double[6];
                this.transformables[i].getMatrix(matrix);
                catTransform.setTransform(matrix[0], matrix[1], matrix[2], matrix[3], matrix[4], matrix[5]);
                tmpTransform.concatenate(catTransform);
                ++i;
            }
            return tmpTransform;
        }
    }

    public static class ZObjectListImpl
    extends ZListImpl {
        private transient Object[] objects;

        public ZObjectListImpl(int capacity) {
            super(capacity);
        }

        public Object[] getElementData() {
            return this.objects;
        }

        public Object[] createElementData(int capacity) {
            return new Object[capacity];
        }

        public void setElementData(Object[] data) {
            this.objects = data;
        }
    }

    public static class ZSceneGraphObjectListImpl
    extends ZListImpl
    implements ZList.ZSceneGraphObjectList {
        private transient ZSceneGraphObject[] sceneGraphObjects;

        public ZSceneGraphObjectListImpl(int capacity) {
            super(capacity);
        }

        public Object[] getElementData() {
            return this.sceneGraphObjects;
        }

        public Object[] createElementData(int capacity) {
            return new ZSceneGraphObject[capacity];
        }

        public void setElementData(Object[] data) {
            this.sceneGraphObjects = (ZSceneGraphObject[])data;
        }

        public ZSceneGraphObject[] getSceneGraphObjectsReference() {
            return this.sceneGraphObjects;
        }
    }

    public static class ZBoundsListImpl
    extends ZListImpl
    implements ZList.ZBoundsList {
        private transient ZBounds[] bounds;

        public ZBoundsListImpl(int capacity) {
            super(capacity);
        }

        public Object[] getElementData() {
            return this.bounds;
        }

        public Object[] createElementData(int capacity) {
            return new ZBounds[capacity];
        }

        public void setElementData(Object[] data) {
            this.bounds = (ZBounds[])data;
        }

        public ZBounds[] getBoundsReference() {
            return this.bounds;
        }
    }

    public static class ZLayerGroupListImpl
    extends ZListImpl
    implements ZList.ZLayerGroupList {
        private transient ZLayerGroup[] layers;

        public ZLayerGroupListImpl(int capacity) {
            super(capacity);
        }

        public Object[] getElementData() {
            return this.layers;
        }

        public Object[] createElementData(int capacity) {
            return new ZLayerGroup[capacity];
        }

        public void setElementData(Object[] data) {
            this.layers = (ZLayerGroup[])data;
        }

        public ZLayerGroup[] getLayersReference() {
            return this.layers;
        }
    }

    public static class ZVisualComponentListImpl
    extends ZListImpl
    implements ZList.ZVisualComponentList {
        private transient ZVisualComponent[] visualComponents;

        public ZVisualComponentListImpl(int capacity) {
            super(capacity);
        }

        public Object[] getElementData() {
            return this.visualComponents;
        }

        public Object[] createElementData(int capacity) {
            return new ZVisualComponent[capacity];
        }

        public void setElementData(Object[] data) {
            this.visualComponents = (ZVisualComponent[])data;
        }

        public ZVisualComponent[] getVisualComponentsReference() {
            return this.visualComponents;
        }

        public ZBounds collectiveBoundsReference(ZBounds bounds) {
            int i = 0;
            while (i < this.size) {
                bounds.add(this.visualComponents[i].getBoundsReference());
                ++i;
            }
            return bounds;
        }

        public ZSceneGraphObject collectivePick(Rectangle2D rect, ZSceneGraphPath path) {
            int i = this.size - 1;
            while (i >= 0) {
                if (this.visualComponents[i].pick(rect, path)) {
                    return this.visualComponents[i];
                }
                --i;
            }
            return null;
        }

        public boolean collectiveHasVolatileBounds() {
            int i = 0;
            while (i < this.size) {
                if (this.visualComponents[i].getVolatileBounds()) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    public static class ZCameraListImpl
    extends ZListImpl
    implements ZList.ZCameraList {
        private transient ZCamera[] cameras;

        public ZCameraListImpl(int capacity) {
            super(capacity);
        }

        public Object[] getElementData() {
            return this.cameras;
        }

        public Object[] createElementData(int capacity) {
            return new ZCamera[capacity];
        }

        public void setElementData(Object[] data) {
            this.cameras = (ZCamera[])data;
        }

        public ZCamera[] getCamerasReference() {
            return this.cameras;
        }
    }

    public static class ZPropertyListImpl
    extends ZListImpl
    implements ZList.ZPropertyList {
        private transient ZProperty[] properties;

        public ZPropertyListImpl(int capacity) {
            super(capacity);
        }

        public Object[] getElementData() {
            return this.properties;
        }

        public Object[] createElementData(int capacity) {
            return new ZProperty[capacity];
        }

        public void setElementData(Object[] data) {
            this.properties = (ZProperty[])data;
        }

        public ZProperty[] getPropertiesReference() {
            return this.properties;
        }

        public Object getMatchingProperty(Object key) {
            int i = 0;
            while (i < this.size) {
                if (this.properties[i].getKey().equals(key)) {
                    return this.properties[i].getValue();
                }
                ++i;
            }
            return null;
        }

        public int indexOfPropertyWithKey(Object key) {
            int i = 0;
            while (i < this.size) {
                if (this.properties[i].getKey().equals(key)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }

    public static class ZNodeListImpl
    extends ZListImpl
    implements ZList.ZNodeList {
        private transient ZNode[] nodes;

        public ZNodeListImpl(int capacity) {
            super(capacity);
        }

        public Object[] getElementData() {
            return this.nodes;
        }

        public ZNode[] getNodesReference() {
            return this.nodes;
        }

        public Object[] createElementData(int capacity) {
            return new ZNode[capacity];
        }

        public void setElementData(Object[] data) {
            this.nodes = (ZNode[])data;
        }

        public ZBounds collectiveBoundsReference(ZBounds bounds) {
            int i = 0;
            while (i < this.size) {
                bounds.add(this.nodes[i].getBoundsReference());
                ++i;
            }
            return bounds;
        }

        public void collectiveRender(ZRenderContext renderContext, ZBounds visibleBounds) {
            int i = 0;
            while (i < this.size) {
                if (visibleBounds.intersects(this.nodes[i].getBoundsReference())) {
                    this.nodes[i].render(renderContext);
                }
                ++i;
            }
        }

        public boolean collectiveHasVolatileBounds() {
            int i = 0;
            while (i < this.size) {
                if (this.nodes[i].getVolatileBounds()) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public ZSceneGraphObject collectivePick(Rectangle2D rect, ZSceneGraphPath path) {
            int i = this.size - 1;
            while (i >= 0) {
                if (this.nodes[i].getBoundsReference().intersects(rect) && this.nodes[i].pick(rect, path)) {
                    return this.nodes[i];
                }
                --i;
            }
            return null;
        }

        public void collectiveRepaint(ZBounds bounds) {
            if (bounds == null) {
                int i = 0;
                while (i < this.size) {
                    this.nodes[i].repaint();
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.size) {
                    this.nodes[i].repaint(bounds);
                    ++i;
                }
            }
        }
    }
}

