/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.util;

import edu.umd.cs.jazz.ZAnchorGroup;
import edu.umd.cs.jazz.ZClipGroup;
import edu.umd.cs.jazz.ZFadeGroup;
import edu.umd.cs.jazz.ZGroup;
import edu.umd.cs.jazz.ZHandleGroup;
import edu.umd.cs.jazz.ZInvisibleGroup;
import edu.umd.cs.jazz.ZLayoutGroup;
import edu.umd.cs.jazz.ZNameGroup;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZSelectionGroup;
import edu.umd.cs.jazz.ZSpatialIndexGroup;
import edu.umd.cs.jazz.ZStickyGroup;
import edu.umd.cs.jazz.ZTransformGroup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ZSceneGraphEditor
implements Serializable {
    private static HashMap editorOrderingMap;
    public static final int NAME_GROUP_ORDER = 90;
    public static final int INVISIBLE_GROUP_ORDER = 80;
    public static final int LAYOUT_GROUP_ORDER = 70;
    public static final int ANCHOR_GROUP_ORDER = 60;
    public static final int TRANSFORM_GROUP_ORDER = 50;
    public static final int STICKY_GROUP_ORDER = 40;
    public static final int SELECTION_GROUP_ORDER = 30;
    public static final int CLIP_GROUP_ORDER = 20;
    public static final int FADE_GROUP_ORDER = 10;
    public static final int HANDLE_GROUP_ORDER = 9;
    public static final int SPATIAL_INDEX_GROUP_ORDER = 0;
    protected ZNode editNode;
    static /* synthetic */ Class class$edu$umd$cs$jazz$ZSpatialIndexGroup;
    static /* synthetic */ Class class$edu$umd$cs$jazz$ZHandleGroup;
    static /* synthetic */ Class class$edu$umd$cs$jazz$ZFadeGroup;
    static /* synthetic */ Class class$edu$umd$cs$jazz$ZClipGroup;
    static /* synthetic */ Class class$edu$umd$cs$jazz$ZSelectionGroup;
    static /* synthetic */ Class class$edu$umd$cs$jazz$ZStickyGroup;
    static /* synthetic */ Class class$edu$umd$cs$jazz$ZTransformGroup;
    static /* synthetic */ Class class$edu$umd$cs$jazz$ZAnchorGroup;
    static /* synthetic */ Class class$edu$umd$cs$jazz$ZLayoutGroup;
    static /* synthetic */ Class class$edu$umd$cs$jazz$ZInvisibleGroup;
    static /* synthetic */ Class class$edu$umd$cs$jazz$ZNameGroup;

    public ZSceneGraphEditor(ZNode aNode) {
        while (this.isEditGroup(aNode)) {
            aNode = ((ZGroup)aNode).getChild(0);
        }
        this.editNode = aNode;
    }

    public static void setEditorOrder(Class aType, int aOrder) {
        if (editorOrderingMap == null) {
            editorOrderingMap = new HashMap();
        }
        editorOrderingMap.put(aType, new Integer(aOrder));
    }

    public ZNode getTop() {
        ZEditGroupIterator i = new ZEditGroupIterator();
        while (i.hasNext()) {
            i.next();
        }
        return i.last();
    }

    public ZNode getNode() {
        return this.editNode;
    }

    public ArrayList getGroups() {
        ArrayList<Object> result = new ArrayList<Object>();
        ZEditGroupIterator i = new ZEditGroupIterator();
        while (i.hasNext()) {
            result.add(i.next());
        }
        return result;
    }

    public Iterator editorIterator() {
        return new ZEditGroupIterator();
    }

    public ZGroup getEditGroup(Class aType) {
        ZEditGroupIterator i = new ZEditGroupIterator();
        while (i.hasNext()) {
            ZGroup each = (ZGroup)i.next();
            if (each.getClass() != aType) continue;
            return each;
        }
        ZGroup result = this.createEditGroupInstance(aType);
        this.insertEditGroup(result);
        return result;
    }

    public ZTransformGroup getTransformGroup() {
        ZTransformGroup result = null;
        ZEditGroupIterator i = new ZEditGroupIterator();
        while (i.hasNext()) {
            ZGroup each = (ZGroup)i.next();
            if (each.getClass() != (class$edu$umd$cs$jazz$ZTransformGroup == null ? ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZTransformGroup") : class$edu$umd$cs$jazz$ZTransformGroup)) continue;
            result = (ZTransformGroup)each;
            break;
        }
        if (result == null) {
            result = (ZTransformGroup)this.createEditGroupInstance(class$edu$umd$cs$jazz$ZTransformGroup == null ? (class$edu$umd$cs$jazz$ZTransformGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZTransformGroup")) : class$edu$umd$cs$jazz$ZTransformGroup);
            this.insertEditGroup(result);
            ZGroup top = this.getTop().getParent();
            if (top != null && top.editor().hasSpatialIndexGroup()) {
                ZSpatialIndexGroup indexGroup = top.editor().getSpatialIndexGroup();
                indexGroup.addListener(result);
            }
        }
        return result;
    }

    public ZHandleGroup getHandleGroup() {
        return (ZHandleGroup)this.getEditGroup(class$edu$umd$cs$jazz$ZHandleGroup == null ? (class$edu$umd$cs$jazz$ZHandleGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZHandleGroup")) : class$edu$umd$cs$jazz$ZHandleGroup);
    }

    public ZFadeGroup getFadeGroup() {
        return (ZFadeGroup)this.getEditGroup(class$edu$umd$cs$jazz$ZFadeGroup == null ? (class$edu$umd$cs$jazz$ZFadeGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZFadeGroup")) : class$edu$umd$cs$jazz$ZFadeGroup);
    }

    public ZStickyGroup getStickyGroup() {
        return (ZStickyGroup)this.getEditGroup(class$edu$umd$cs$jazz$ZStickyGroup == null ? (class$edu$umd$cs$jazz$ZStickyGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZStickyGroup")) : class$edu$umd$cs$jazz$ZStickyGroup);
    }

    public ZSelectionGroup getSelectionGroup() {
        return (ZSelectionGroup)this.getEditGroup(class$edu$umd$cs$jazz$ZSelectionGroup == null ? (class$edu$umd$cs$jazz$ZSelectionGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZSelectionGroup")) : class$edu$umd$cs$jazz$ZSelectionGroup);
    }

    public ZAnchorGroup getAnchorGroup() {
        return (ZAnchorGroup)this.getEditGroup(class$edu$umd$cs$jazz$ZAnchorGroup == null ? (class$edu$umd$cs$jazz$ZAnchorGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZAnchorGroup")) : class$edu$umd$cs$jazz$ZAnchorGroup);
    }

    public ZLayoutGroup getLayoutGroup() {
        return (ZLayoutGroup)this.getEditGroup(class$edu$umd$cs$jazz$ZLayoutGroup == null ? (class$edu$umd$cs$jazz$ZLayoutGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZLayoutGroup")) : class$edu$umd$cs$jazz$ZLayoutGroup);
    }

    public ZNameGroup getNameGroup() {
        return (ZNameGroup)this.getEditGroup(class$edu$umd$cs$jazz$ZNameGroup == null ? (class$edu$umd$cs$jazz$ZNameGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZNameGroup")) : class$edu$umd$cs$jazz$ZNameGroup);
    }

    public ZInvisibleGroup getInvisibleGroup() {
        return (ZInvisibleGroup)this.getEditGroup(class$edu$umd$cs$jazz$ZInvisibleGroup == null ? (class$edu$umd$cs$jazz$ZInvisibleGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZInvisibleGroup")) : class$edu$umd$cs$jazz$ZInvisibleGroup);
    }

    public ZSpatialIndexGroup getSpatialIndexGroup() {
        return (ZSpatialIndexGroup)this.getEditGroup(class$edu$umd$cs$jazz$ZSpatialIndexGroup == null ? (class$edu$umd$cs$jazz$ZSpatialIndexGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZSpatialIndexGroup")) : class$edu$umd$cs$jazz$ZSpatialIndexGroup);
    }

    public ZClipGroup getClipGroup() {
        return (ZClipGroup)this.getEditGroup(class$edu$umd$cs$jazz$ZClipGroup == null ? (class$edu$umd$cs$jazz$ZClipGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZClipGroup")) : class$edu$umd$cs$jazz$ZClipGroup);
    }

    public boolean hasEditGroup(Class aType) {
        ZEditGroupIterator i = new ZEditGroupIterator();
        while (i.hasNext()) {
            ZGroup each = (ZGroup)i.next();
            if (each.getClass() != aType) continue;
            return true;
        }
        return false;
    }

    public boolean hasTransformGroup() {
        return this.hasEditGroup(class$edu$umd$cs$jazz$ZTransformGroup == null ? (class$edu$umd$cs$jazz$ZTransformGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZTransformGroup")) : class$edu$umd$cs$jazz$ZTransformGroup);
    }

    public boolean hasHandleGroup() {
        return this.hasEditGroup(class$edu$umd$cs$jazz$ZHandleGroup == null ? (class$edu$umd$cs$jazz$ZHandleGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZHandleGroup")) : class$edu$umd$cs$jazz$ZHandleGroup);
    }

    public boolean hasFadeGroup() {
        return this.hasEditGroup(class$edu$umd$cs$jazz$ZFadeGroup == null ? (class$edu$umd$cs$jazz$ZFadeGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZFadeGroup")) : class$edu$umd$cs$jazz$ZFadeGroup);
    }

    public boolean hasStickyGroup() {
        return this.hasEditGroup(class$edu$umd$cs$jazz$ZStickyGroup == null ? (class$edu$umd$cs$jazz$ZStickyGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZStickyGroup")) : class$edu$umd$cs$jazz$ZStickyGroup);
    }

    public boolean hasSelectionGroup() {
        return this.hasEditGroup(class$edu$umd$cs$jazz$ZSelectionGroup == null ? (class$edu$umd$cs$jazz$ZSelectionGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZSelectionGroup")) : class$edu$umd$cs$jazz$ZSelectionGroup);
    }

    public boolean hasAnchorGroup() {
        return this.hasEditGroup(class$edu$umd$cs$jazz$ZAnchorGroup == null ? (class$edu$umd$cs$jazz$ZAnchorGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZAnchorGroup")) : class$edu$umd$cs$jazz$ZAnchorGroup);
    }

    public boolean hasLayoutGroup() {
        return this.hasEditGroup(class$edu$umd$cs$jazz$ZLayoutGroup == null ? (class$edu$umd$cs$jazz$ZLayoutGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZLayoutGroup")) : class$edu$umd$cs$jazz$ZLayoutGroup);
    }

    public boolean hasNameGroup() {
        return this.hasEditGroup(class$edu$umd$cs$jazz$ZNameGroup == null ? (class$edu$umd$cs$jazz$ZNameGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZNameGroup")) : class$edu$umd$cs$jazz$ZNameGroup);
    }

    public boolean hasInvisibleGroup() {
        return this.hasEditGroup(class$edu$umd$cs$jazz$ZInvisibleGroup == null ? (class$edu$umd$cs$jazz$ZInvisibleGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZInvisibleGroup")) : class$edu$umd$cs$jazz$ZInvisibleGroup);
    }

    public boolean hasSpatialIndexGroup() {
        return this.hasEditGroup(class$edu$umd$cs$jazz$ZSpatialIndexGroup == null ? (class$edu$umd$cs$jazz$ZSpatialIndexGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZSpatialIndexGroup")) : class$edu$umd$cs$jazz$ZSpatialIndexGroup);
    }

    public boolean hasClipGroup() {
        return this.hasEditGroup(class$edu$umd$cs$jazz$ZClipGroup == null ? (class$edu$umd$cs$jazz$ZClipGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZClipGroup")) : class$edu$umd$cs$jazz$ZClipGroup);
    }

    public boolean removeEditGroup(Class aType) {
        ZEditGroupIterator i = new ZEditGroupIterator();
        while (i.hasNext()) {
            ZGroup each = (ZGroup)i.next();
            if (each.getClass() != aType) continue;
            i.remove();
            return true;
        }
        return false;
    }

    public boolean removeTransformGroup() {
        return this.removeEditGroup(class$edu$umd$cs$jazz$ZTransformGroup == null ? (class$edu$umd$cs$jazz$ZTransformGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZTransformGroup")) : class$edu$umd$cs$jazz$ZTransformGroup);
    }

    public boolean removeHandleGroup() {
        return this.removeEditGroup(class$edu$umd$cs$jazz$ZHandleGroup == null ? (class$edu$umd$cs$jazz$ZHandleGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZHandleGroup")) : class$edu$umd$cs$jazz$ZHandleGroup);
    }

    public boolean removeFadeGroup() {
        return this.removeEditGroup(class$edu$umd$cs$jazz$ZFadeGroup == null ? (class$edu$umd$cs$jazz$ZFadeGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZFadeGroup")) : class$edu$umd$cs$jazz$ZFadeGroup);
    }

    public boolean removeStickyGroup() {
        return this.removeEditGroup(class$edu$umd$cs$jazz$ZStickyGroup == null ? (class$edu$umd$cs$jazz$ZStickyGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZStickyGroup")) : class$edu$umd$cs$jazz$ZStickyGroup);
    }

    public boolean removeSelectionGroup() {
        return this.removeEditGroup(class$edu$umd$cs$jazz$ZSelectionGroup == null ? (class$edu$umd$cs$jazz$ZSelectionGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZSelectionGroup")) : class$edu$umd$cs$jazz$ZSelectionGroup);
    }

    public boolean removeAnchorGroup() {
        return this.removeEditGroup(class$edu$umd$cs$jazz$ZAnchorGroup == null ? (class$edu$umd$cs$jazz$ZAnchorGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZAnchorGroup")) : class$edu$umd$cs$jazz$ZAnchorGroup);
    }

    public boolean removeLayoutGroup() {
        return this.removeEditGroup(class$edu$umd$cs$jazz$ZLayoutGroup == null ? (class$edu$umd$cs$jazz$ZLayoutGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZLayoutGroup")) : class$edu$umd$cs$jazz$ZLayoutGroup);
    }

    public boolean removeNameGroup() {
        return this.removeEditGroup(class$edu$umd$cs$jazz$ZNameGroup == null ? (class$edu$umd$cs$jazz$ZNameGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZNameGroup")) : class$edu$umd$cs$jazz$ZNameGroup);
    }

    public boolean removeInvisibleGroup() {
        return this.removeEditGroup(class$edu$umd$cs$jazz$ZInvisibleGroup == null ? (class$edu$umd$cs$jazz$ZInvisibleGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZInvisibleGroup")) : class$edu$umd$cs$jazz$ZInvisibleGroup);
    }

    public boolean removeClipGroup() {
        return this.removeEditGroup(class$edu$umd$cs$jazz$ZClipGroup == null ? (class$edu$umd$cs$jazz$ZClipGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZClipGroup")) : class$edu$umd$cs$jazz$ZClipGroup);
    }

    public boolean removeSpatialIndexGroup() {
        ZSpatialIndexGroup indexGroup = null;
        ZEditGroupIterator i = new ZEditGroupIterator();
        while (i.hasNext()) {
            ZGroup each = (ZGroup)i.next();
            if (each.getClass() != (class$edu$umd$cs$jazz$ZSpatialIndexGroup == null ? ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZSpatialIndexGroup") : class$edu$umd$cs$jazz$ZSpatialIndexGroup)) continue;
            indexGroup = (ZSpatialIndexGroup)each;
            break;
        }
        if (indexGroup == null) {
            return false;
        }
        ZGroup g = null;
        Iterator iter = this.editorIterator();
        while (iter.hasNext()) {
            g = (ZGroup)iter.next();
            if (g.getClass() != (class$edu$umd$cs$jazz$ZSpatialIndexGroup == null ? ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZSpatialIndexGroup") : class$edu$umd$cs$jazz$ZSpatialIndexGroup)) continue;
            ZSpatialIndexGroup spatialIndexGroup = (ZSpatialIndexGroup)g;
            spatialIndexGroup.unregisterAllListeners();
        }
        return this.removeEditGroup(class$edu$umd$cs$jazz$ZSpatialIndexGroup == null ? (class$edu$umd$cs$jazz$ZSpatialIndexGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZSpatialIndexGroup")) : class$edu$umd$cs$jazz$ZSpatialIndexGroup);
    }

    protected boolean isEditGroup(ZNode aNode) {
        if (aNode == null) {
            return false;
        }
        return aNode instanceof ZGroup && ((ZGroup)aNode).hasOneChild() && ((ZGroup)aNode).getNumChildren() == 1;
    }

    protected void insertEditGroup(ZGroup aGroup) {
        if (this.hasEditGroup(aGroup.getClass())) {
            return;
        }
        ZNode aChild = null;
        int order = this.getOrderFor(aGroup.getClass());
        ZEditGroupIterator i = new ZEditGroupIterator();
        while (i.hasNext()) {
            ZGroup each = (ZGroup)i.next();
            if (this.getOrderFor(each.getClass()) >= order) break;
            aChild = each;
        }
        if (aChild == null) {
            aChild = this.editNode;
        }
        aGroup.insertAbove(aChild);
    }

    protected int getOrderFor(Class aType) {
        Integer anInteger = (Integer)editorOrderingMap.get(aType);
        if (anInteger == null) {
            return Integer.MAX_VALUE;
        }
        return anInteger;
    }

    protected ZGroup createEditGroupInstance(Class aType) {
        ZGroup result = null;
        try {
            result = (ZGroup)aType.newInstance();
            result.setHasOneChild(true);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        NAME_GROUP_ORDER = 90;
        INVISIBLE_GROUP_ORDER = 80;
        LAYOUT_GROUP_ORDER = 70;
        ANCHOR_GROUP_ORDER = 60;
        TRANSFORM_GROUP_ORDER = 50;
        STICKY_GROUP_ORDER = 40;
        SELECTION_GROUP_ORDER = 30;
        CLIP_GROUP_ORDER = 20;
        FADE_GROUP_ORDER = 10;
        HANDLE_GROUP_ORDER = 9;
        SPATIAL_INDEX_GROUP_ORDER = 0;
        ZSceneGraphEditor.setEditorOrder(class$edu$umd$cs$jazz$ZSpatialIndexGroup == null ? (class$edu$umd$cs$jazz$ZSpatialIndexGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZSpatialIndexGroup")) : class$edu$umd$cs$jazz$ZSpatialIndexGroup, 0);
        ZSceneGraphEditor.setEditorOrder(class$edu$umd$cs$jazz$ZHandleGroup == null ? (class$edu$umd$cs$jazz$ZHandleGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZHandleGroup")) : class$edu$umd$cs$jazz$ZHandleGroup, 9);
        ZSceneGraphEditor.setEditorOrder(class$edu$umd$cs$jazz$ZFadeGroup == null ? (class$edu$umd$cs$jazz$ZFadeGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZFadeGroup")) : class$edu$umd$cs$jazz$ZFadeGroup, 10);
        ZSceneGraphEditor.setEditorOrder(class$edu$umd$cs$jazz$ZClipGroup == null ? (class$edu$umd$cs$jazz$ZClipGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZClipGroup")) : class$edu$umd$cs$jazz$ZClipGroup, 20);
        ZSceneGraphEditor.setEditorOrder(class$edu$umd$cs$jazz$ZSelectionGroup == null ? (class$edu$umd$cs$jazz$ZSelectionGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZSelectionGroup")) : class$edu$umd$cs$jazz$ZSelectionGroup, 30);
        ZSceneGraphEditor.setEditorOrder(class$edu$umd$cs$jazz$ZStickyGroup == null ? (class$edu$umd$cs$jazz$ZStickyGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZStickyGroup")) : class$edu$umd$cs$jazz$ZStickyGroup, 40);
        ZSceneGraphEditor.setEditorOrder(class$edu$umd$cs$jazz$ZTransformGroup == null ? (class$edu$umd$cs$jazz$ZTransformGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZTransformGroup")) : class$edu$umd$cs$jazz$ZTransformGroup, 50);
        ZSceneGraphEditor.setEditorOrder(class$edu$umd$cs$jazz$ZAnchorGroup == null ? (class$edu$umd$cs$jazz$ZAnchorGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZAnchorGroup")) : class$edu$umd$cs$jazz$ZAnchorGroup, 60);
        ZSceneGraphEditor.setEditorOrder(class$edu$umd$cs$jazz$ZLayoutGroup == null ? (class$edu$umd$cs$jazz$ZLayoutGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZLayoutGroup")) : class$edu$umd$cs$jazz$ZLayoutGroup, 70);
        ZSceneGraphEditor.setEditorOrder(class$edu$umd$cs$jazz$ZInvisibleGroup == null ? (class$edu$umd$cs$jazz$ZInvisibleGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZInvisibleGroup")) : class$edu$umd$cs$jazz$ZInvisibleGroup, 80);
        ZSceneGraphEditor.setEditorOrder(class$edu$umd$cs$jazz$ZNameGroup == null ? (class$edu$umd$cs$jazz$ZNameGroup = ZSceneGraphEditor.class$("edu.umd.cs.jazz.ZNameGroup")) : class$edu$umd$cs$jazz$ZNameGroup, 90);
    }

    public class ZEditGroupIterator
    implements Iterator {
        protected ZNode currentEditor;

        public ZEditGroupIterator() {
            this.currentEditor = ZSceneGraphEditor.this.editNode;
        }

        public boolean hasNext() {
            return ZSceneGraphEditor.this.isEditGroup(this.currentEditor.getParent());
        }

        public Object next() {
            this.currentEditor = this.currentEditor.getParent();
            return this.currentEditor;
        }

        public void remove() {
            this.currentEditor.extract();
        }

        public ZNode last() {
            return this.currentEditor;
        }
    }
}

