/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.util;

import edu.umd.cs.jazz.ZGroup;
import edu.umd.cs.jazz.ZNameGroup;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZRoot;
import edu.umd.cs.jazz.ZSceneGraphObject;
import edu.umd.cs.jazz.ZVisualGroup;
import edu.umd.cs.jazz.ZVisualLeaf;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ZSceneGraphTreeModel
implements TreeModel {
    private ArrayList treeModelListeners = new ArrayList();
    private TreePart root;
    private HashMap table = new HashMap();
    private TreePart nullTreePart = new TreePart(null);

    TreePart getTreePart(ZSceneGraphObject obj) {
        if (obj == null) {
            return this.nullTreePart;
        }
        TreePart tp = (TreePart)this.table.get(obj);
        if (tp == null) {
            tp = new TreePart(obj);
            this.table.put(obj, tp);
        }
        return tp;
    }

    TreePath getTreePath(ZNode object) {
        ArrayList<TreePart> list = new ArrayList<TreePart>();
        while (object != null) {
            list.add(this.getTreePart(object));
            object = object.getParent();
        }
        Object[] path = new Object[list.size()];
        int i = 0;
        while (i < path.length) {
            path[i] = list.get(path.length - i - 1);
            ++i;
        }
        return new TreePath(path);
    }

    public ZSceneGraphTreeModel(ZRoot root) {
        this.root = this.getTreePart(root);
    }

    void fireTreeStructureChanged() {
        int len = this.treeModelListeners.size();
        TreeModelEvent e = new TreeModelEvent((Object)this, new Object[]{this.root});
        int i = 0;
        while (i < len) {
            ((TreeModelListener)this.treeModelListeners.get(i)).treeStructureChanged(e);
            ++i;
        }
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.add(l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.remove(l);
    }

    public Object getChild(Object parent, int index) {
        return ((TreePart)parent).getChild(index);
    }

    public int getChildCount(Object parent) {
        return ((TreePart)parent).getChildCount();
    }

    public int getIndexOfChild(Object parent, Object child) {
        return ((TreePart)parent).getIndexOfChild((TreePart)child);
    }

    public Object getRoot() {
        return this.root;
    }

    public ZSceneGraphObject getJazzObject(Object object) {
        if (object instanceof TreePart) {
            return ((TreePart)object).obj;
        }
        return null;
    }

    public boolean isLeaf(Object obj) {
        return ((TreePart)obj).isLeaf();
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        System.out.println("*** valueForPathChanged : " + path + " --> " + newValue);
    }

    class TreePart {
        ZSceneGraphObject obj;

        TreePart(ZSceneGraphObject obj) {
            this.obj = obj;
        }

        TreePart getChild(int index) {
            ZVisualLeaf vl;
            if (this.obj instanceof ZVisualGroup) {
                ZVisualGroup vg = (ZVisualGroup)this.obj;
                if (vg.getBackVisualComponent() != null) {
                    if (index == 0) {
                        return ZSceneGraphTreeModel.this.getTreePart(vg.getBackVisualComponent());
                    }
                    --index;
                }
                if (vg.getFrontVisualComponent() != null) {
                    if (index == 0) {
                        return ZSceneGraphTreeModel.this.getTreePart(vg.getFrontVisualComponent());
                    }
                    --index;
                }
            }
            if (this.obj instanceof ZGroup) {
                ZGroup g = (ZGroup)this.obj;
                if (index >= 0 && index < g.getNumChildren()) {
                    return ZSceneGraphTreeModel.this.getTreePart(g.getChild(index));
                }
            }
            if (this.obj instanceof ZVisualLeaf && index < (vl = (ZVisualLeaf)this.obj).getNumVisualComponents()) {
                return ZSceneGraphTreeModel.this.getTreePart(vl.getVisualComponent(index));
            }
            return null;
        }

        int getChildCount() {
            int count = 0;
            if (this.obj instanceof ZGroup) {
                count = ((ZGroup)this.obj).getNumChildren();
            }
            if (this.obj instanceof ZVisualLeaf) {
                count += ((ZVisualLeaf)this.obj).getNumVisualComponents();
            }
            if (this.obj instanceof ZVisualGroup) {
                ZVisualGroup vg = (ZVisualGroup)this.obj;
                if (vg.getBackVisualComponent() != null) {
                    ++count;
                }
                if (vg.getFrontVisualComponent() != null) {
                    ++count;
                }
            }
            return count;
        }

        int getIndexOfChild(TreePart child) {
            int offs = 0;
            ZSceneGraphObject childNode = child.obj;
            if (this.obj instanceof ZVisualGroup) {
                ZVisualGroup vg = (ZVisualGroup)this.obj;
                if (vg.getFrontVisualComponent() != null) {
                    if (childNode == vg.getBackVisualComponent()) {
                        return 0;
                    }
                    ++offs;
                }
                if (vg.getFrontVisualComponent() != null) {
                    if (childNode == vg.getFrontVisualComponent()) {
                        return offs;
                    }
                    ++offs;
                }
            }
            if (this.obj instanceof ZGroup) {
                ZGroup g = (ZGroup)this.obj;
                int i = 0;
                while (i < g.getNumChildren()) {
                    if (g.getChild(i) == childNode) {
                        return i + offs;
                    }
                    ++i;
                }
            }
            if (this.obj instanceof ZVisualLeaf && ((ZVisualLeaf)this.obj).getFirstVisualComponent() == childNode) {
                return 0;
            }
            return -1;
        }

        boolean isLeaf() {
            return !(this.obj instanceof ZGroup) && !(this.obj instanceof ZVisualLeaf);
        }

        public String toString() {
            if (this.obj == null) {
                return "Empty";
            }
            if (this.obj instanceof ZVisualLeaf) {
                ZVisualLeaf lf = (ZVisualLeaf)this.obj;
                String name = "ZVisualLeaf [";
                int i = 0;
                while (i < lf.getNumVisualComponents()) {
                    if (i > 0) {
                        name = name + ", ";
                    }
                    TreePart tp = ZSceneGraphTreeModel.this.getTreePart(((ZVisualLeaf)this.obj).getVisualComponent(i));
                    name = name + tp.toString();
                    ++i;
                }
                name = name + "]";
                return name;
            }
            if (this.obj instanceof ZNameGroup) {
                String name = "ZNameGroup";
                ZNameGroup nameGroup = (ZNameGroup)this.obj;
                if (nameGroup.getName() != null) {
                    name = name + " [";
                    name = name + ((ZNameGroup)this.obj).getName();
                    name = name + "]";
                }
                return name;
            }
            String name = this.obj.getClass().getName();
            int dot = name.lastIndexOf(46);
            return dot > 0 ? name.substring(dot + 1) : name;
        }
    }
}

