/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.util;

import edu.umd.cs.jazz.util.ZScrollPaneLayout;
import edu.umd.cs.jazz.util.ZViewport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.plaf.ScrollPaneUI;

public class ZScrollPane
extends JScrollPane {
    protected ZNullAction nullAction = null;
    protected boolean disableKeyActions = false;

    public ZScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
        super(view, vsbPolicy, hsbPolicy);
        ZScrollPaneLayout.UIResource layout = new ZScrollPaneLayout.UIResource();
        this.setLayout(layout);
        layout.syncWithScrollPane(this);
    }

    public ZScrollPane(Component view) {
        this(view, 20, 30);
    }

    public ZScrollPane(int vsbPolicy, int hsbPolicy) {
        this(null, vsbPolicy, hsbPolicy);
    }

    public ZScrollPane() {
        this(null, 20, 30);
    }

    public void setKeyActionsDisabled(boolean disable) {
        if (disable && this.disableKeyActions != disable) {
            this.disableKeyActions = disable;
            this.disableKeyActions();
        } else if (!disable && this.disableKeyActions != disable) {
            this.disableKeyActions = disable;
            this.installCustomKeyActions();
        }
    }

    public void setUI(ScrollPaneUI ui) {
        super.setUI(ui);
        if (!this.disableKeyActions) {
            this.installCustomKeyActions();
        } else {
            this.disableKeyActions();
        }
    }

    protected void installCustomKeyActions() {
        ActionMap map = this.getActionMap();
        map.put("scrollUp", new ZScrollAction("scrollUp", 1, -1, true));
        map.put("scrollDown", new ZScrollAction("scrollDown", 1, 1, true));
        map.put("scrollLeft", new ZScrollAction("scrollLeft", 0, -1, true));
        map.put("scrollRight", new ZScrollAction("ScrollRight", 0, 1, true));
        map.put("unitScrollRight", new ZScrollAction("UnitScrollRight", 0, 1, false));
        map.put("unitScrollLeft", new ZScrollAction("UnitScrollLeft", 0, -1, false));
        map.put("unitScrollUp", new ZScrollAction("UnitScrollUp", 1, -1, false));
        map.put("unitScrollDown", new ZScrollAction("UnitScrollDown", 1, 1, false));
        map.put("scrollEnd", new ZScrollEndAction("ScrollEnd"));
        map.put("scrollHome", new ZScrollHomeAction("ScrollHome"));
    }

    protected void disableKeyActions() {
        ActionMap map = this.getActionMap();
        if (this.nullAction == null) {
            this.nullAction = new ZNullAction();
        }
        map.put("scrollUp", this.nullAction);
        map.put("scrollDown", this.nullAction);
        map.put("scrollLeft", this.nullAction);
        map.put("scrollRight", this.nullAction);
        map.put("unitScrollRight", this.nullAction);
        map.put("unitScrollLeft", this.nullAction);
        map.put("unitScrollUp", this.nullAction);
        map.put("unitScrollDown", this.nullAction);
        map.put("scrollEnd", this.nullAction);
        map.put("scrollHome", this.nullAction);
    }

    protected JViewport createViewport() {
        return new ZViewport();
    }

    protected static class ZNullAction
    extends AbstractAction {
        protected ZNullAction() {
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    protected static class ZScrollEndAction
    extends AbstractAction {
        protected ZScrollEndAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            Component view;
            JViewport vp;
            JScrollPane scrollpane = (JScrollPane)e.getSource();
            if ((scrollpane.getVerticalScrollBar().isShowing() || scrollpane.getHorizontalScrollBar().isShowing()) && (vp = scrollpane.getViewport()) != null && (view = vp.getView()) != null) {
                Rectangle visRect = vp.getViewRect();
                Dimension size = vp.getViewSize();
                vp.setViewPosition(new Point(size.width - visRect.width, size.height - visRect.height));
            }
        }
    }

    private static class ZScrollHomeAction
    extends AbstractAction {
        protected ZScrollHomeAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            Component view;
            JViewport vp;
            JScrollPane scrollpane = (JScrollPane)e.getSource();
            if ((scrollpane.getVerticalScrollBar().isShowing() || scrollpane.getHorizontalScrollBar().isShowing()) && (vp = scrollpane.getViewport()) != null && (view = vp.getView()) != null) {
                vp.setViewPosition(new Point(0, 0));
            }
        }
    }

    protected static class ZScrollAction
    extends AbstractAction {
        protected int orientation;
        protected int direction;
        private boolean block;

        protected ZScrollAction(String name, int orientation, int direction, boolean block) {
            super(name);
            this.orientation = orientation;
            this.direction = direction;
            this.block = block;
        }

        public void actionPerformed(ActionEvent e) {
            Component view;
            JViewport vp;
            JScrollPane scrollpane = (JScrollPane)e.getSource();
            if ((this.orientation == 1 && scrollpane.getVerticalScrollBar().isShowing() || this.orientation == 0 && scrollpane.getHorizontalScrollBar().isShowing()) && (vp = scrollpane.getViewport()) != null && (view = vp.getView()) != null) {
                Rectangle visRect = vp.getViewRect();
                Dimension vSize = vp.getViewSize();
                int amount = view instanceof Scrollable ? (this.block ? ((Scrollable)((Object)view)).getScrollableBlockIncrement(visRect, this.orientation, this.direction) : ((Scrollable)((Object)view)).getScrollableUnitIncrement(visRect, this.orientation, this.direction)) : (this.block ? (this.orientation == 1 ? visRect.height : visRect.width) : 10);
                if (this.orientation == 1) {
                    visRect.y += amount * this.direction;
                    if (visRect.y + visRect.height > vSize.height) {
                        visRect.y = Math.max(0, vSize.height - visRect.height);
                    } else if (visRect.y < 0) {
                        visRect.y = 0;
                    }
                } else {
                    visRect.x += amount * this.direction;
                    if (visRect.x + visRect.width > vSize.width) {
                        visRect.x = Math.max(0, vSize.width - visRect.width);
                    } else if (visRect.x < 0) {
                        visRect.x = 0;
                    }
                }
                vp.setViewPosition(visRect.getLocation());
            }
        }
    }
}

