/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.util;

import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZCanvas;
import edu.umd.cs.jazz.util.ZDefaultScrollDirector;
import edu.umd.cs.jazz.util.ZScrollDirector;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JViewport;
import javax.swing.ViewportLayout;

public class ZViewport
extends JViewport {
    ZScrollDirector scrollDirector;

    public ZViewport() {
        this.setScrollDirector(this.createScrollDirector());
    }

    protected LayoutManager createLayoutManager() {
        return new ZViewportLayout();
    }

    protected ZScrollDirector createScrollDirector() {
        return new ZDefaultScrollDirector();
    }

    public void setScrollDirector(ZScrollDirector scrollDirector) {
        if (this.scrollDirector != null) {
            this.scrollDirector.unInstall();
        }
        this.scrollDirector = scrollDirector;
        if (scrollDirector != null) {
            this.scrollDirector.install(this, (ZCanvas)this.getView());
        }
    }

    public ZScrollDirector getScrollDirector() {
        return this.scrollDirector;
    }

    public void setView(Component view) {
        if (!(view instanceof ZCanvas)) {
            throw new UnsupportedOperationException("ZViewport only supports ZCanvas");
        }
        super.setView(view);
        if (this.scrollDirector != null) {
            this.scrollDirector.install(this, (ZCanvas)view);
        }
    }

    public void setViewPosition(Point p) {
        if (this.getView() == null) {
            return;
        }
        double oldX = 0.0;
        double oldY = 0.0;
        double x = p.x;
        double y = p.y;
        Point vp = this.getViewPosition();
        if (vp != null) {
            oldX = ((Point2D)vp).getX();
            oldY = ((Point2D)vp).getY();
        }
        double newX = x;
        double newY = y;
        if (oldX != newX || oldY != newY) {
            this.scrollUnderway = true;
            this.scrollDirector.setViewPosition(newX, newY);
            this.fireStateChanged();
        }
    }

    public Point getViewPosition() {
        if (this.scrollDirector != null) {
            Dimension extent = this.getExtentSize();
            return this.scrollDirector.getViewPosition(new ZBounds(0.0, 0.0, extent.getWidth(), extent.getHeight()));
        }
        return null;
    }

    public Dimension getViewSize() {
        Dimension extent = this.getExtentSize();
        return this.scrollDirector.getViewSize(new ZBounds(0.0, 0.0, extent.getWidth(), extent.getHeight()));
    }

    public Dimension getViewSize(Rectangle2D r) {
        return this.scrollDirector.getViewSize(r);
    }

    public void fireStateChanged() {
        super.fireStateChanged();
    }

    public static class ZViewportLayout
    extends ViewportLayout {
        public void layoutContainer(Container parent) {
            JViewport vp = (JViewport)parent;
            Component view = vp.getView();
            if (view == null) {
                return;
            }
            Dimension extentSize = vp.getSize();
            vp.setViewSize(extentSize);
        }
    }
}

