/*
 * Decompiled with CFR 0.152.
 */
package info.cqs.remotefs.sftp;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import info.cqs.remotefs.RemoteFS;
import info.cqs.remotefs.RemoteFSException;
import info.cqs.remotefs.RemoteFSProgressMonitor;
import info.cqs.remotefs.RemoteFile;
import info.cqs.remotefs.sftp.SftpFile;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Msg;

public class SftpAdapter
implements RemoteFS {
    private int port = 22;
    private boolean passiveMode;
    private boolean forceUTF8;
    private boolean connected;
    private Session session = null;
    private ChannelSftp channelSftp = null;
    private SftpProgressMonitor monitor = null;
    private int bytesTransferred = 0;

    public SftpAdapter() {
        if (Config.getConfig().isDebugMode()) {
            JSch.setLogger((Logger)new MyLogger());
        }
    }

    public void setPort(int port) throws RemoteFSException {
        this.port = port;
    }

    public int getPort() throws RemoteFSException {
        return this.port;
    }

    public void setForceUTF8(boolean force) throws RemoteFSException {
        this.forceUTF8 = force;
    }

    public boolean isForceUTF8() throws RemoteFSException {
        return this.forceUTF8;
    }

    public void setPassiveMode(boolean mode) throws RemoteFSException {
        this.passiveMode = mode;
    }

    public boolean isPassiveMode() throws RemoteFSException {
        return this.passiveMode;
    }

    public String getDirectory() throws RemoteFSException, IOException {
        try {
            return this.channelSftp.pwd();
        }
        catch (Exception e) {
            throw new RemoteFSException(e);
        }
    }

    public void setDirectory(String directory) throws RemoteFSException, IOException {
        try {
            this.channelSftp.cd(this.toUTF8(directory));
        }
        catch (SftpException e) {
            throw new RemoteFSException(e);
        }
    }

    public void toParentDirectory() throws RemoteFSException, IOException {
        try {
            this.channelSftp.cd("..");
        }
        catch (SftpException e) {
            throw new RemoteFSException(e);
        }
    }

    public void createDirectory(String name) throws IOException, RemoteFSException {
        try {
            this.channelSftp.mkdir(this.toUTF8(name));
        }
        catch (SftpException e) {
            throw new RemoteFSException(e);
        }
    }

    public void removeDirectory(String name) throws IOException, RemoteFSException {
        try {
            this.channelSftp.rmdir(this.toUTF8(name));
        }
        catch (SftpException e) {
            throw new RemoteFSException(e);
        }
    }

    public void connect(String server, String user, String password) throws IOException, RemoteFSException {
        if (!this.connected) {
            JSch jsch = new JSch();
            try {
                if (password.length() > 0) {
                    JSch.setConfig((String)"PreferredAuthentications", (String)"password,keyboard-interactive");
                } else {
                    JSch.setConfig((String)"PreferredAuthentications", (String)"keyboard-interactive,password");
                }
                this.session = jsch.getSession(user, server, this.port);
                MyUserInfo ui = new MyUserInfo(password);
                this.session.setUserInfo((UserInfo)ui);
                this.session.connect();
                Channel channel = this.session.openChannel("sftp");
                channel.connect();
                this.channelSftp = (ChannelSftp)channel;
                try {
                    this.channelSftp.setFilenameEncoding(this.forceUTF8 ? "UTF-8" : "ISO-8859-1");
                }
                catch (SftpException ex) {
                    // empty catch block
                }
                this.connected = true;
            }
            catch (Exception e) {
                throw new RemoteFSException(e);
            }
        }
    }

    public void abortConnect() {
        this.session.disconnect();
    }

    public void disconnect() throws IOException, RemoteFSException {
        if (!this.connected) {
            throw new RemoteFSException("Not connected to remote server");
        }
        this.connected = false;
        this.session.disconnect();
    }

    public boolean isConnected() throws RemoteFSException {
        return this.connected;
    }

    public RemoteFile[] getFiles() throws IOException, RemoteFSException {
        return this.getFiles(".");
    }

    public RemoteFile[] getFiles(String dir) throws IOException, RemoteFSException {
        try {
            if (dir.equals("")) {
                dir = ".";
            }
            dir = this.toUTF8(dir);
            Vector ls = this.channelSftp.ls(dir);
            RemoteFile[] files = new SftpFile[ls.size()];
            for (int i = 0; i < ls.size(); ++i) {
                ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)ls.get(i);
                files[i] = new SftpFile(entry, this);
            }
            return files;
        }
        catch (SftpException e) {
            throw new RemoteFSException(e);
        }
    }

    public void putFile(File file) throws IOException, RemoteFSException {
        this.putFile(file, ".");
    }

    public void putFile(File file, String path) throws IOException, RemoteFSException {
        this.bytesTransferred = 0;
        path = this.toUTF8(path);
        int mode = 0;
        FileInputStream in = new FileInputStream(file);
        try {
            if (this.monitor != null) {
                this.channelSftp.put((InputStream)in, path, this.monitor, mode);
            } else {
                this.channelSftp.put((InputStream)in, path, mode);
            }
        }
        catch (SftpException e) {
            throw new RemoteFSException(e);
        }
        finally {
            in.close();
        }
    }

    public void put(InputStream in, String path) throws IOException, RemoteFSException {
        this.bytesTransferred = 0;
        path = this.toUTF8(path);
        int mode = 0;
        try {
            if (this.monitor != null) {
                this.channelSftp.put(in, path, this.monitor, mode);
            } else {
                this.channelSftp.put(in, path, mode);
            }
        }
        catch (SftpException e) {
            throw new RemoteFSException(e);
        }
    }

    public void getUnmonitored(String path, OutputStream out) throws IOException, RemoteFSException {
        this.bytesTransferred = 0;
        path = this.toUTF8(path);
        try {
            this.channelSftp.get(path, out);
        }
        catch (SftpException e) {
            throw new RemoteFSException(e);
        }
    }

    public void get(String path, OutputStream out) throws IOException, RemoteFSException {
        this.bytesTransferred = 0;
        path = this.toUTF8(path);
        try {
            if (this.monitor != null) {
                this.channelSftp.get(path, out, this.monitor);
            } else {
                this.channelSftp.get(path, out);
            }
        }
        catch (SftpException e) {
            throw new RemoteFSException(e);
        }
    }

    public void removeFile(String filename) throws IOException, RemoteFSException {
        try {
            this.channelSftp.rm(this.toUTF8(filename));
        }
        catch (SftpException e) {
            throw new RemoteFSException(e);
        }
    }

    public void setProgressMonitor(final RemoteFSProgressMonitor monitor) {
        this.monitor = new SftpProgressMonitor(){

            public void init(int int0, String string, String string2, long long3) {
                SftpAdapter.this.bytesTransferred = 0;
            }

            public boolean count(long long0) {
                SftpAdapter.this.bytesTransferred = (int)((long)SftpAdapter.this.bytesTransferred + long0);
                monitor.bytesTransferred(SftpAdapter.this.bytesTransferred);
                return true;
            }

            public void end() {
            }
        };
    }

    public void rename(String from, String to) throws RemoteFSException, IOException {
        try {
            this.channelSftp.rename(this.toUTF8(from), this.toUTF8(to));
        }
        catch (SftpException e) {
            throw new RemoteFSException(e);
        }
    }

    static String showPasswordInputDialog(Component parent, String message, String title, String initialValue) {
        final JPasswordField jpf = new JPasswordField();
        if (initialValue != null) {
            jpf.setText(initialValue);
        }
        JPanel messagePanel = new JPanel();
        messagePanel.setLayout(new RiverLayout());
        messagePanel.add(new JLabel(message));
        messagePanel.add("br hfill", jpf);
        JOptionPane pane = new JOptionPane(messagePanel, 1, 2, null, null, null);
        JDialog dialog = pane.createDialog(parent, title);
        dialog.addWindowFocusListener(new WindowAdapter(){

            public void windowGainedFocus(WindowEvent e) {
                jpf.requestFocusInWindow();
            }
        });
        dialog.setVisible(true);
        Object val = pane.getValue();
        if (val instanceof Integer && (Integer)val == 0) {
            return new String(jpf.getPassword());
        }
        return null;
    }

    String toUTF8(String s) {
        return s;
    }

    String fromUTF8(String s) {
        return s;
    }

    public boolean exists(String path) throws IOException, RemoteFSException {
        try {
            return this.channelSftp.stat(this.toUTF8(path)) != null;
        }
        catch (SftpException e) {
            return false;
        }
    }

    public boolean existsDirectory(String path) throws IOException, RemoteFSException {
        return this.exists(path);
    }

    public static class MyLogger
    implements Logger {
        static HashMap name = new HashMap();

        public boolean isEnabled(int level) {
            return true;
        }

        public void log(int level, String message) {
            System.err.print(name.get(new Integer(level)));
            System.err.println(message);
        }

        static {
            name.put(new Integer(0), "DEBUG: ");
            name.put(new Integer(1), "INFO: ");
            name.put(new Integer(2), "WARN: ");
            name.put(new Integer(3), "ERROR: ");
            name.put(new Integer(4), "FATAL: ");
        }
    }

    public static class MyUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        private String passwd;
        final GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        private Container panel;

        public MyUserInfo(String password) {
            this.passwd = password;
        }

        public String getPassword() {
            String password;
            if (this.passwd.length() == 0 && (password = SftpAdapter.showPasswordInputDialog(null, Msg.get("publish.enterPasswordInfo"), Msg.get("publish.connect"), null)) != null) {
                this.passwd = password;
            }
            return this.passwd;
        }

        public boolean promptYesNo(String str) {
            return true;
        }

        public String getPassphrase() {
            return null;
        }

        public boolean promptPassphrase(String message) {
            return true;
        }

        public boolean promptPassword(String message) {
            return true;
        }

        public void showMessage(String message) {
            JOptionPane.showMessageDialog(null, message);
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            if (prompt.length == 1 && this.passwd.length() != 0) {
                return new String[]{this.passwd};
            }
            this.panel = new JPanel();
            this.panel.setLayout(new GridBagLayout());
            this.gbc.weightx = 1.0;
            this.gbc.gridwidth = 0;
            this.gbc.gridx = 0;
            this.panel.add((Component)new JLabel(instruction), this.gbc);
            ++this.gbc.gridy;
            this.gbc.gridwidth = -1;
            JTextField[] texts = new JTextField[prompt.length];
            for (int i = 0; i < prompt.length; ++i) {
                this.gbc.fill = 0;
                this.gbc.gridx = 0;
                this.gbc.weightx = 1.0;
                this.panel.add((Component)new JLabel(prompt[i]), this.gbc);
                this.gbc.gridx = 1;
                this.gbc.fill = 2;
                this.gbc.weighty = 1.0;
                texts[i] = echo[i] ? new JTextField(20) : new JPasswordField(20);
                this.panel.add((Component)texts[i], this.gbc);
                ++this.gbc.gridy;
            }
            if (JOptionPane.showConfirmDialog(null, this.panel, destination + ": " + name, 2, 3) == 0) {
                String[] response = new String[prompt.length];
                for (int i = 0; i < prompt.length; ++i) {
                    response[i] = texts[i].getText();
                }
                return response;
            }
            return null;
        }
    }
}

