/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordList {
    private List<String> list;
    private Map<String, String> words = new TreeMap<String, String>();

    public synchronized List<String> getList() {
        if (this.list == null) {
            this.list = new ArrayList<String>(this.words.keySet());
        }
        return this.list;
    }

    public synchronized boolean add(String word) {
        boolean changed;
        boolean bl = changed = this.words.put(word.toLowerCase(), word) != null;
        if (changed) {
            this.list = null;
        }
        return changed;
    }

    public synchronized boolean addAll(Collection<String> words) {
        boolean changed = false;
        for (String word : words) {
            if (this.words.put(word.toLowerCase(), word) == null) continue;
            changed = true;
        }
        if (changed) {
            this.list = null;
        }
        return changed;
    }

    public String get(String key) {
        return this.words.get(key);
    }

    public void clear() {
        this.words.clear();
        this.list = null;
    }
}

