/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component.buttonbar;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.SystemColor;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicButtonUI;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.util.Platform;

class JAlbumButtonUI
extends BasicButtonUI {
    private static Color blueishBackgroundOver;
    private static Color blueishBorderOver;
    private static Color blueishBackgroundSelected;
    private static Color blueishBorderSelected;

    public void installUI(JComponent c) {
        super.installUI(c);
        AbstractButton button = (AbstractButton)c;
        if (!Platform.isMac() || !JAlbum.isUsingSystemLAF()) {
            button.setRolloverEnabled(true);
        }
        button.setBorder(BorderFactory.createEmptyBorder(4, 2, 2, 2));
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension preferred = super.getPreferredSize(c);
        return new Dimension(preferred.width < 59 ? 59 : preferred.width, preferred.height);
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton button = (AbstractButton)c;
        if (button.getModel().isRollover() || button.getModel().isArmed() || button.getModel().isSelected()) {
            Color oldColor = g.getColor();
            boolean isMac = Platform.isMac();
            if (button.getModel().isSelected() || isMac) {
                g.setColor(blueishBorderSelected);
            } else {
                g.setColor(blueishBorderOver);
            }
            g.drawRect(0, 0, c.getWidth() - 1, c.getHeight() - 1);
            if (button.getModel().isSelected() || isMac) {
                g.setColor(blueishBackgroundSelected);
            } else {
                g.setColor(blueishBackgroundOver);
            }
            g.fillRect(1, 0, c.getWidth() - 2, c.getHeight());
            g.setColor(oldColor);
        }
        super.paint(g, c);
    }

    static {
        if (Platform.isMac()) {
            blueishBackgroundSelected = Color.decode("#dddddd");
            blueishBorderSelected = Color.decode("#b9b9b9");
        } else {
            int r = SystemColor.textHighlight.getRed();
            int g = SystemColor.textHighlight.getGreen();
            int b = SystemColor.textHighlight.getBlue();
            blueishBorderSelected = SystemColor.textHighlight;
            blueishBackgroundSelected = new Color(r, g, b, 70);
            blueishBorderOver = new Color(r, g, b, 100);
            blueishBackgroundOver = new Color(r, g, b, 20);
        }
    }
}

