/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component.errorreporting;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.text.JTextComponent;
import se.datadosen.component.StateMonitor;
import se.datadosen.component.errorreporting.Failable;

public class ErrorReporter {
    private LinkedHashMap<String, JComponent> failables = new LinkedHashMap();
    private HashMap<Component, Popup> popupMap = new HashMap();
    PopupFactory popupFactory = PopupFactory.getSharedInstance();

    public ErrorReporter(Object classToMonitor) {
        try {
            for (Field f : classToMonitor.getClass().getDeclaredFields()) {
                JComponent existing;
                f.setAccessible(true);
                Failable failable = f.getAnnotation(Failable.class);
                if (failable == null || !JComponent.class.isAssignableFrom(f.getType()) || (existing = this.failables.put(failable.value(), (JComponent)f.get(classToMonitor))) == null) continue;
                throw new RuntimeException("Failable \"" + failable.value() + "\" specified more than once");
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void putFailed(String key, String message) {
        JComponent c = this.failables.get(key);
        if (c != null) {
            this.showToolTip(c, message);
        }
    }

    public Component getFailable(String key) {
        return this.failables.get(key);
    }

    private void showToolTip(JComponent component, String tip) {
        Point p = component.getLocationOnScreen();
        this.showToolTip(component, tip, p.x + component.getWidth(), p.y);
    }

    private void showToolTip(final JComponent component, String tip, int x, int y) {
        this.reset(component);
        JToolTip tooltip = component.createToolTip();
        tooltip.setTipText(tip);
        tooltip.setBackground(new Color(255, 130, 130));
        Popup newPopup = this.popupFactory.getPopup(component, tooltip, x, y);
        newPopup.show();
        this.popupMap.put(component, newPopup);
        StateMonitor sm = new StateMonitor(){

            public void onChange() {
                ErrorReporter.this.reset(component);
            }
        };
        if (component instanceof JTextComponent) {
            sm.add((JTextComponent)component);
        } else if (component instanceof JComboBox) {
            sm.add((JComboBox)component);
        } else if (component instanceof JCheckBox) {
            sm.add((JCheckBox)component);
        } else if (component instanceof JRadioButton) {
            sm.add((JRadioButton)component);
        } else if (component instanceof JSpinner) {
            sm.add((JSpinner)component);
        }
        tooltip.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ErrorReporter.this.reset(component);
            }
        });
    }

    public void reset(Component c) {
        Popup popup = this.popupMap.remove(c);
        if (popup != null) {
            popup.hide();
        }
    }

    public void resetAll() {
        for (Popup popup : this.popupMap.values()) {
            popup.hide();
        }
        this.popupMap.clear();
    }
}

