/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import se.datadosen.component.JSmartTextArea;
import se.datadosen.explorer.JEditPanel;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.Tracer;
import se.datadosen.util.Debug;
import se.datadosen.util.Platform;

public class JCommentPanel
extends JPanel {
    private JSmallTextArea comment = new JSmallTextArea(3, 40);
    private JScrollPane scrollPane = new JScrollPane(this.comment);
    private Border originalScrollBorder;
    private Border emptyScrollBorder;
    private AlbumObject ao;
    JEditPanel editPanel;
    Action previousImage = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            JCommentPanel.this.editPanel.previousImageAction.actionPerformed(e);
        }
    };
    Action nextImage = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            JCommentPanel.this.editPanel.nextImageAction.actionPerformed(e);
        }
    };

    public JCommentPanel(JEditPanel editPanel) {
        this.editPanel = editPanel;
        this.init();
    }

    public void setFocusable(boolean focusable) {
        this.comment.setFocusable(focusable);
    }

    public void setAlbumObject(AlbumObject ao) {
        this.save();
        this.ao = ao;
        if (ao == null) {
            return;
        }
        this.comment.setText(ao.getComment());
        this.comment.setCaretPosition(0);
    }

    public void componentShown() {
        this.requestFocusInWindow();
    }

    private void init() {
        this.setBackground(SystemColor.text);
        this.setOpaque(true);
        this.setLayout(new BorderLayout());
        this.comment.setFocusTraversalKeys(0, null);
        this.comment.setFocusTraversalKeys(1, null);
        this.comment.registerKeyboardAction(this.previousImage, KeyStroke.getKeyStroke(33, 0), 0);
        this.comment.registerKeyboardAction(this.nextImage, KeyStroke.getKeyStroke(34, 0), 0);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setOpaque(false);
        this.originalScrollBorder = this.scrollPane.getBorder();
        if (this.originalScrollBorder != null) {
            Insets in = this.originalScrollBorder.getBorderInsets(this.scrollPane);
            this.emptyScrollBorder = BorderFactory.createEmptyBorder(in.top, in.left, in.bottom, in.right);
            this.scrollPane.setBorder(this.emptyScrollBorder);
        }
        this.add((Component)this.scrollPane, "Center");
        FocusListener fl = new FocusListener(){

            public void focusGained(FocusEvent e) {
                JCommentPanel.this.scrollPane.setBorder(JCommentPanel.this.originalScrollBorder);
                JCommentPanel.this.repaint();
            }

            public void focusLost(FocusEvent e) {
                JCommentPanel.this.scrollPane.setBorder(JCommentPanel.this.emptyScrollBorder);
                JCommentPanel.this.repaint();
                JCommentPanel.this.save();
            }
        };
        this.comment.addFocusListener(fl);
    }

    void save() {
        if (this.ao == null) {
            return;
        }
        try {
            if (!this.comment.getText().equals(this.ao.getComment())) {
                Tracer.getInstance().trace("caption edited", "location:edit");
                this.ao.setComment(this.comment.getText());
            }
        }
        catch (IOException ex) {
            Debug.showErrorDialog(this, ex);
        }
    }

    private static Component emptyArea(int size) {
        return Box.createRigidArea(new Dimension(size, size));
    }

    public static class JSmallTextArea
    extends JSmartTextArea {
        public JSmallTextArea() {
            this.init();
        }

        public JSmallTextArea(int rows, int columns) {
            super(rows, columns);
            this.init();
        }

        private void init() {
            JTextField dummyField = new JTextField();
            this.setFont(dummyField.getFont());
            if (Platform.isMac()) {
                this.setFont(this.getFont().deriveFont(this.getFont().getSize2D() - 2.0f));
            }
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
        }

        public void setText(String text) {
            super.setText(text);
            this.repaint();
        }

        public void paintComponent(Graphics g2d) {
            Graphics2D g = (Graphics2D)g2d;
            super.paintComponent(g);
            if (this.getText().equals("") && !this.hasFocus()) {
                g.setColor(Color.gray);
                FontMetrics fm = g.getFontMetrics();
                Map hints = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
                if (hints != null) {
                    g.setRenderingHints(hints);
                }
                String s = Msg.get("edit.commentPrompt");
                Rectangle2D rect = fm.getStringBounds(s, g);
                LineMetrics lm = fm.getLineMetrics(s, g);
                g.drawString(s, (int)((double)this.getWidth() - rect.getWidth()) / 2, (int)((double)lm.getAscent() + ((double)this.getHeight() - rect.getHeight()) / 2.0));
            }
        }
    }
}

