/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.io;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import se.datadosen.io.CachedFileSupport;

public class CachedFile
extends File {
    private Boolean directory;
    private Long lastMod;
    private Long length;
    private Boolean exists;
    private boolean cacheing = true;
    private static Boolean _atleastJava7;

    public CachedFile(File parent, String child) {
        super(parent, child);
    }

    public CachedFile(String parent, String child) {
        super(parent, child);
    }

    public CachedFile(String pathname) {
        super(pathname);
    }

    public CachedFile(File f) {
        super(f.getParentFile(), f.getName());
    }

    CachedFile(File f, boolean directory, long lastMod, long length) {
        super(f.getParentFile(), f.getName());
        this.directory = directory;
        this.lastMod = lastMod;
        this.length = length;
        this.exists = true;
    }

    public boolean isCacheing() {
        return this.cacheing;
    }

    public void setCacheing(boolean cacheing) {
        this.cacheing = cacheing;
    }

    public boolean isDirectory() {
        if (this.directory == null) {
            this.directory = super.isDirectory();
        }
        return this.directory;
    }

    public long lastModified() {
        if (!this.cacheing) {
            return super.lastModified();
        }
        if (this.lastMod == null) {
            this.lastMod = super.lastModified();
        }
        return this.lastMod;
    }

    public boolean setLastModified(long time) {
        boolean ok = super.setLastModified(time);
        if (ok) {
            this.lastMod = time;
        }
        return ok;
    }

    public long length() {
        if (!this.cacheing) {
            return super.length();
        }
        if (this.length == null) {
            this.length = super.length();
        }
        return this.length;
    }

    public boolean exists() {
        if (!this.cacheing) {
            return super.exists();
        }
        if (this.exists == null) {
            this.exists = super.exists();
        }
        return this.exists;
    }

    public File toFile() {
        return new File(this.getParentFile(), this.getName());
    }

    public CachedFile[] listFiles() {
        return CachedFile.listFiles(this);
    }

    public CachedFile[] listFiles(FileFilter filter) {
        return CachedFile.listFiles(this, filter);
    }

    public static CachedFile[] listFiles(File file) {
        return CachedFile.listFiles(file, null);
    }

    private File[] standardListFiles() {
        return super.listFiles();
    }

    private static boolean isAtleastJava7() {
        if (_atleastJava7 == null) {
            _atleastJava7 = System.getProperty("java.specification.version").compareTo("1.7") >= 0;
        }
        return _atleastJava7;
    }

    public static CachedFile[] listFiles(File file, FileFilter filter) {
        File[] files;
        if (CachedFile.isAtleastJava7()) {
            try {
                return CachedFile.filter(CachedFileSupport.listFiles(file), filter);
            }
            catch (IOException ex) {
                return null;
            }
        }
        File[] fileArray = files = file instanceof CachedFile ? ((CachedFile)file).standardListFiles() : file.listFiles();
        if (files == null) {
            return null;
        }
        for (int i = 0; i < files.length; ++i) {
            files[i] = new CachedFile(files[i]);
        }
        return CachedFile.filter(files, filter);
    }

    private static CachedFile[] filter(File[] allFiles, FileFilter filter) {
        if (allFiles == null) {
            return null;
        }
        if (filter == null && allFiles instanceof CachedFile[]) {
            return (CachedFile[])allFiles;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (File f : allFiles) {
            if (filter != null && !filter.accept(f)) continue;
            files.add(f);
        }
        return files.toArray(new CachedFile[files.size()]);
    }
}

