/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import se.datadosen.io.ChainedDirectory;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.MiniConfig;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.SkinProperties;
import se.datadosen.util.IO;
import se.datadosen.util.StringUtil;
import se.datadosen.util.annotations.Unbound;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config
implements Serializable {
    static final String ILLEGAL_CHARACTERS = "#$%&*\"\\/:;?=|";
    private static Config theConfig;
    public File progDir;
    public File skinsDir;
    public ChainedDirectory chainedSkinsDir;
    ChainedDirectory chainedExtDir;
    ChainedDirectory chainedPluginsDir;
    ChainedDirectory chainedToolsDir;
    public File pluginsDir;
    public String language = "default";
    private String lookAndFeel;
    private String webHostListUrl = "http://jalbum.net/web-hosts.xml";
    private boolean cleanOutputFiles = true;
    private boolean synchronizeOutputDirectory = true;
    private boolean cacheThumbnails = true;
    private AfterPublishBehavior afterPublishing = AfterPublishBehavior.openPublishingSuccessfulPage;
    private boolean showInfoBarInPreview = false;
    private boolean encryptManifest = false;
    private String manifestPassword;
    private boolean zipstreaming = true;
    private boolean debugMode;
    private String myAlbumsLocation;
    private boolean showTipOfTheDay = true;
    private int traceVersion = 3;
    private boolean includeHiResImagesDefault = true;
    private LabelType labelType = LabelType.caption;
    private FileAddMethod fileAddMethod = FileAddMethod.ASK;
    private String illegalCharacters = "#$%&*\"\\/:;?=|";
    private boolean rememberCopiedFiles = true;
    private boolean writeXmp = true;
    private int maxSimultaneousTransfers = 8;
    private boolean compatibilityMode = false;
    private boolean useNativeFileDialogs = true;
    private boolean unifyColorModel = true;
    private boolean videoSupported = true;
    private Set<String> supportedVideoFormats;
    private int dividerLocation = 0;
    private boolean allowFlashPreview = true;
    private ProjectOrdering projectOrdering = ProjectOrdering.projectsByUse;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    private Config() {
        this.progDir = new File("").getAbsoluteFile();
        this.newProgDir();
        if (!this.skinsDir.exists() || !this.pluginsDir.exists()) {
            URL url;
            File classPath;
            String instDirName = System.getProperty("jalbum.installation.dir");
            this.progDir = instDirName != null ? new File(instDirName) : ((classPath = new File(System.getProperty("java.class.path"))).exists() ? classPath.getParentFile().getAbsoluteFile() : ((url = JAlbum.class.getResource("../../../")) != null ? new File(url.getFile()).getParentFile() : new File("")));
            this.newProgDir();
        }
        this.setLookAndFeel(System.getProperty("swing.defaultlaf") == null ? UIManager.getSystemLookAndFeelClassName() : System.getProperty("swing.defaultlaf"));
        this.updateChainedDirs();
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(name, listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(name, listener);
    }

    private void updateChainedDirs() {
        this.chainedSkinsDir = new ChainedDirectory(this.skinsDir);
        this.chainedExtDir = new ChainedDirectory(new File(this.progDir, "ext"));
        this.chainedPluginsDir = new ChainedDirectory(new File(this.progDir, "plugins"));
        this.chainedToolsDir = new ChainedDirectory(new File(this.progDir, "tools"));
        File configDir = MiniConfig.getMiniConfig().configDir;
        if (configDir != null) {
            this.chainedSkinsDir = new ChainedDirectory(new File(configDir, "skins"), this.chainedSkinsDir, new ChainedDirectory.Decider(){

                public boolean useBackgroundFile(File backgroundFile, File foregroundFile) {
                    SkinProperties bgProps = new SkinProperties(backgroundFile);
                    SkinProperties fgProps = new SkinProperties(foregroundFile);
                    return bgProps.getVersion().compareTo(fgProps.getVersion()) > 0;
                }
            });
            this.chainedExtDir = new ChainedDirectory(new File(configDir, "ext"), this.chainedExtDir);
            this.chainedPluginsDir = new ChainedDirectory(new File(configDir, "plugins"), this.chainedPluginsDir);
            this.chainedToolsDir = new ChainedDirectory(new File(configDir, "tools"), this.chainedToolsDir);
        }
    }

    public static Config getConfig() {
        if (theConfig == null) {
            theConfig = new Config();
        }
        return theConfig;
    }

    public static File getConfigFile(String newName, String oldName) {
        File oldFile = new File(System.getProperty("user.home"), oldName);
        File newFile = new File(MiniConfig.getMiniConfig().configDir, newName);
        MiniConfig.getMiniConfig().configDir.mkdir();
        try {
            if (!newFile.exists() && oldFile.exists()) {
                IO.copyFile(oldFile, newFile, false);
                System.out.println("Config file " + newFile + " migrated from old location " + oldFile);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return newFile;
    }

    public void setProgramDirectory(File progDir) {
        this.progDir = progDir;
        this.newProgDir();
        this.updateChainedDirs();
    }

    public void setProgramDirectory(String progDir) {
        this.setProgramDirectory(new File(progDir));
    }

    public void setSkinsDirectory(File skinsDir) {
        this.skinsDir = skinsDir;
        this.chainedSkinsDir = new ChainedDirectory(skinsDir);
    }

    public void setSkinsDirectory(String skinsDir) {
        this.setSkinsDirectory(new File(skinsDir));
    }

    public String getLanguage() {
        return this.language;
    }

    @Unbound
    public String getInterpretedLanguage() {
        return this.language.equals("default") ? System.getProperty("user.language") : this.language;
    }

    public void setLanguage(String language) {
        String oldLanguage = this.language;
        this.language = language;
        if (!language.equals("default")) {
            Locale.setDefault(new Locale(language, System.getProperty("user.country")));
        } else {
            Locale.setDefault(new Locale(System.getProperty("user.language"), System.getProperty("user.country")));
        }
        Msg.reloadBundle();
        this.changeSupport.firePropertyChange("language", oldLanguage, language);
    }

    private void newProgDir() {
        this.skinsDir = new File(this.progDir, "skins");
        this.pluginsDir = new File(this.progDir, "plugins");
    }

    public String getLookAndFeel() {
        return this.lookAndFeel;
    }

    public void setLookAndFeel(String lookAndFeel) {
        String old = this.lookAndFeel;
        this.lookAndFeel = lookAndFeel;
        this.changeSupport.firePropertyChange("lookAndFeel", old, lookAndFeel);
    }

    public String getWebHostListUrl() {
        return this.webHostListUrl;
    }

    public void setWebHostListUrl(String webHostListUrl) {
        this.webHostListUrl = webHostListUrl;
    }

    public boolean isCleanOutputFiles() {
        return this.cleanOutputFiles;
    }

    public void setCleanOutputFiles(boolean clean) {
        this.cleanOutputFiles = clean;
    }

    public boolean isSynchronizeOutputDirectory() {
        return this.synchronizeOutputDirectory;
    }

    public void setSynchronizeOutputDirectory(boolean synchronizeOutputDirectory) {
        this.synchronizeOutputDirectory = synchronizeOutputDirectory;
    }

    public boolean isCacheThumbnails() {
        return this.cacheThumbnails;
    }

    public void setCacheThumbnails(boolean cacheThumbnails) {
        this.cacheThumbnails = cacheThumbnails;
    }

    public AfterPublishBehavior getAfterPublishing() {
        return this.afterPublishing;
    }

    public void setAfterPublishing(AfterPublishBehavior afterPublishing) {
        this.afterPublishing = afterPublishing;
    }

    public boolean isShowInfoBarInPreview() {
        return this.showInfoBarInPreview;
    }

    public void setShowInfoBarInPreview(boolean showInfoBarInPreview) {
        this.showInfoBarInPreview = showInfoBarInPreview;
    }

    public boolean isEncryptManifest() {
        return this.encryptManifest;
    }

    public void setEncryptManifest(boolean encryptManifest) {
        this.encryptManifest = encryptManifest;
    }

    public String getManifestPassword() {
        return this.manifestPassword;
    }

    public void setManifestPassword(String manifestPassword) {
        this.manifestPassword = manifestPassword;
    }

    public boolean isZipstreaming() {
        return this.zipstreaming;
    }

    public void setZipstreaming(boolean zipstreaming) {
        this.zipstreaming = zipstreaming;
    }

    public boolean isDebugMode() {
        return Boolean.valueOf(System.getProperty("debugMode", "" + this.debugMode));
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
        JAlbum.logger.setLevel(debugMode ? Level.FINE : Level.INFO);
    }

    public String getMyAlbumsLocation() {
        if (this.myAlbumsLocation == null || this.myAlbumsLocation.length() == 0 || new File(this.myAlbumsLocation).getParentFile() != null && !new File(this.myAlbumsLocation).getParentFile().exists()) {
            File userHome = FileSystemView.getFileSystemView().getDefaultDirectory();
            File myAlbums = new File(userHome, Msg.get("newproject.myAlbumsDirectory"));
            this.setMyAlbumsLocation(myAlbums.getAbsolutePath());
        }
        return this.myAlbumsLocation;
    }

    public void setMyAlbumsLocation(String myAlbumsLocation) {
        String oldMyAlbumsLocation = this.myAlbumsLocation;
        this.myAlbumsLocation = myAlbumsLocation;
        this.changeSupport.firePropertyChange("myAlbumsLocation", oldMyAlbumsLocation, myAlbumsLocation);
    }

    public boolean isShowTipOfTheDay() {
        return this.showTipOfTheDay;
    }

    public void setShowTipOfTheDay(boolean showTipOfTheDay) {
        this.showTipOfTheDay = showTipOfTheDay;
    }

    public LabelType getLabelType() {
        return this.labelType;
    }

    public void setLabelType(LabelType labelType) {
        LabelType oldType = this.labelType;
        this.labelType = labelType;
        this.changeSupport.firePropertyChange("labelType", (Object)oldType, (Object)labelType);
    }

    public FileAddMethod getFileAddMethod() {
        return this.fileAddMethod;
    }

    public void setFileAddMethod(FileAddMethod fileAddMethod) {
        this.fileAddMethod = fileAddMethod;
    }

    public boolean isIncludeHiResImagesDefault() {
        return this.includeHiResImagesDefault;
    }

    public void setIncludeHiResImagesDefault(boolean includeHiResImagesDefault) {
        this.includeHiResImagesDefault = includeHiResImagesDefault;
    }

    public String getIllegalCharacters() {
        return this.illegalCharacters;
    }

    public void setIllegalCharacters(String illegalCharacters) {
        this.illegalCharacters = illegalCharacters;
    }

    public boolean isRememberCopiedFiles() {
        return this.rememberCopiedFiles;
    }

    public void setRememberCopiedFiles(boolean rememberCopiedFiles) {
        this.rememberCopiedFiles = rememberCopiedFiles;
    }

    public boolean isWriteXmp() {
        return this.writeXmp;
    }

    public void setWriteXmp(boolean writeXmp) {
        this.writeXmp = writeXmp;
    }

    public String getHttpProxyHost() {
        return System.getProperty("http.proxyHost");
    }

    public void setHttpProxyHost(String httpProxyHost) {
        if (httpProxyHost.length() > 0 || this.getHttpProxyHost() != null) {
            System.setProperty("http.proxyHost", httpProxyHost);
        }
    }

    public String getHttpProxyPort() {
        return System.getProperty("http.proxyPort");
    }

    public void setHttpProxyPort(String httpProxyPort) {
        if (httpProxyPort.length() > 0 || this.getHttpProxyPort() != null) {
            System.setProperty("http.proxyPort", httpProxyPort);
        }
    }

    public int getMaxSimultaneousTransfers() {
        return this.maxSimultaneousTransfers;
    }

    public void setMaxSimultaneousTransfers(int maxSimultaneousTransfers) {
        this.maxSimultaneousTransfers = maxSimultaneousTransfers;
    }

    public boolean isCompatibilityMode() {
        return this.compatibilityMode;
    }

    public void setCompatibilityMode(boolean compatibilityMode) {
        this.compatibilityMode = compatibilityMode;
    }

    public boolean isUseNativeFileDialogs() {
        return this.useNativeFileDialogs;
    }

    public void setUseNativeFileDialogs(boolean useNativeFileDialogs) {
        this.useNativeFileDialogs = useNativeFileDialogs;
    }

    public boolean isUnifyColorModel() {
        return this.unifyColorModel;
    }

    public void setUnifyColorModel(boolean unifyColorModel) {
        this.unifyColorModel = unifyColorModel;
    }

    @Unbound
    public boolean isVideoSupport() {
        return this.videoSupported;
    }

    public boolean isVideoSupported() {
        return this.videoSupported;
    }

    public void setVideoSupported(boolean videoSupported) {
        boolean oldVideoSupport = this.videoSupported;
        this.videoSupported = videoSupported;
        this.changeSupport.firePropertyChange("videoSupported", oldVideoSupport, videoSupported);
    }

    public Set<String> getSupportedVideoFormats() {
        if (this.supportedVideoFormats == null) {
            this.supportedVideoFormats = StringUtil.stringToSet("g722, a64, ismv, mxf_d10, g729, iv8, 3gp, mpegtsraw, mts, mt2s, wc3movie, shn, vqf, webm, ipod, ogg, smjpeg, rpl, idcin, ffm, xa, rawvideo, rtsp, roq, wmv, mpeg, mpg, sox, sol, iss, gsm, f64be, wv, mov, bit, asf, mpeg1video, m4v, mjpeg, dxa, dv, s24be, mpjpeg, smoothstreaming, 3g2, dirac, pmp, ea, lxf, u32be, dfa, flic, lavfi, pva, apc, bethsoftvid, u16be, ea_cdata, null, mm, asf_stream, dvd, u16le, wtv, nc, tty, vc1test, smush, nut, nuv, s32le, ivf, mtv, u24le, jv, bink, rso, segment, mulaw, vmd, rcv, s32be, f32le, mlp, mpeg2video, dsicin, tmv, spdif, u8, siff, avi, mpegvideo, anm, g723_1, sdp, psp, yuv4mpegpipe, xmv, s16le, 4xm, qcp, rtp, tiertexseq, ingenient, nsv, svcd, cdxl, f32be, image2pipe, dnxhd, h263, vcd, h261, iff, w64, flv, gxf, flac, s24le, u24be, hls,applehttp, u32le, bmv, h264, amr, latm, ipmovie, rl2, film_cpk, mgsts, rm, vc1, mpegts, wsvqa, mp4, vob, voc, mvi, mov,mp4,m4a,3gp,3g2,mj2, eac3, lmlm4, truehd, psxstr, mxf, cavsvideo, r3d, mxg, s8, txd, f4v, smk, msnwctcp, thp, paf, yop, image2, idf, filmstrip, c93, ilbc, mmf, f64le, s16be, matroska, qt");
        }
        return this.supportedVideoFormats;
    }

    public void setSupportedVideoFormats(Set<String> supportedVideoFormats) {
        this.supportedVideoFormats = supportedVideoFormats;
        if (supportedVideoFormats.isEmpty()) {
            this.supportedVideoFormats = null;
        }
    }

    public int getDividerLocation() {
        return this.dividerLocation;
    }

    public void setDividerLocation(int dividerLocation) {
        this.dividerLocation = dividerLocation;
    }

    public boolean isAllowFlashPreview() {
        return this.allowFlashPreview;
    }

    public void setAllowFlashPreview(boolean allowFlashPreview) {
        boolean oldAllowFlashPreview = this.allowFlashPreview;
        this.allowFlashPreview = allowFlashPreview;
        this.changeSupport.firePropertyChange("allowFlashPreview", oldAllowFlashPreview, allowFlashPreview);
    }

    public ProjectOrdering getProjectOrdering() {
        return this.projectOrdering;
    }

    public void setProjectOrdering(ProjectOrdering projectOrdering) {
        this.projectOrdering = projectOrdering;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProjectOrdering {
        projectsByUse,
        projectsByName,
        projectsByReverseName;


        public String toString() {
            return Msg.get("prefs." + this.name()) + ":";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AfterPublishBehavior {
        openPublishingSuccessfulPage,
        openPublishedAlbum,
        doNothing;


        public String toString() {
            return Msg.get("prefs." + this.name());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileAddMethod {
        ASK("ui.ask", 1, 0x40000000),
        COPY("ui.copy", 1, 0x40000000),
        LINK("ui.link", 0x40000000, 1);

        private int dndAction;
        private int altDndAction;
        private String nameKey;

        private FileAddMethod(String nameKey, int dndAction, int altDndAction) {
            this.nameKey = nameKey;
            this.dndAction = dndAction;
            this.altDndAction = altDndAction;
        }

        public String toString() {
            return Msg.get(this.nameKey);
        }

        public int getAction() {
            return this.dndAction;
        }

        public int getAltAction() {
            return this.altDndAction;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LabelType {
        fileName("ui.fileName"),
        title("edit.titleLabel"),
        caption("ui.caption"),
        keywords("edit.keywords");

        private String nameKey;

        private LabelType(String nameKey) {
            this.nameKey = nameKey;
        }

        public String toString() {
            return Msg.get(this.nameKey);
        }
    }
}

